/*
 * Decompiled with CFR 0.152.
 */
package com.thizthizzydizzy.treefeller;

import com.thizthizzydizzy.treefeller.Message;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;

public abstract class TreeFellerCommand {
    public final String command;
    private final String permission;
    private final TreeFellerCommand[] subcommands;

    public TreeFellerCommand(String command, TreeFellerCommand ... subcommands) {
        this(command, command, subcommands);
    }

    public TreeFellerCommand(String command, String permission, TreeFellerCommand ... subcommands) {
        if (permission != null && permission.isEmpty()) {
            permission = null;
        }
        if (permission != null && !permission.startsWith("treefeller.")) {
            permission = "treefeller." + permission;
        }
        this.command = command;
        this.permission = permission;
        this.subcommands = subcommands;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args, String[] fullArgs) {
        if (!this.hasPermission(sender)) {
            Message.getMessage("no-permission").send(sender, new Object[0]);
            return true;
        }
        if (args.length < 1) {
            return this.run(sender, command, label, fullArgs);
        }
        for (TreeFellerCommand cmd : this.subcommands) {
            if (!args[0].equals(cmd.command)) continue;
            return cmd.onCommand(sender, command, label, this.trim(args, 1), fullArgs);
        }
        sender.sendMessage("Usage: /treefeller " + this.getFullUsage());
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String label, String[] args) {
        ArrayList<String> strs = new ArrayList<String>();
        if (!this.hasPermission(sender)) {
            return strs;
        }
        if (args.length == 1) {
            for (TreeFellerCommand cmd : this.subcommands) {
                if (!cmd.command.substring(0, cmd.command.length() - 1).startsWith(args[0]) || !cmd.hasPermission(sender)) continue;
                strs.add(cmd.command);
            }
        }
        if (args.length > 1) {
            for (TreeFellerCommand cmd : this.subcommands) {
                if (!args[0].equals(cmd.command)) continue;
                return cmd.onTabComplete(sender, command, label, this.trim(args, 1));
            }
        }
        return strs;
    }

    protected abstract boolean run(CommandSender var1, Command var2, String var3, String[] var4);

    public String[] trim(String[] data, int beginning) {
        if (data == null) {
            return null;
        }
        String[] newData = new String[Math.max(0, data.length - beginning)];
        for (int i = 0; i < newData.length; ++i) {
            newData[i] = data[i + beginning];
        }
        return newData;
    }

    public boolean hasPermission(CommandSender sender) {
        if (this.permission == null) {
            return true;
        }
        return sender.hasPermission(this.permission);
    }

    protected String getUsage() {
        return this.command;
    }

    protected String getFullUsage() {
        String usage = this.command;
        if (this.subcommands.length > 0) {
            String subUsage = "";
            for (TreeFellerCommand cmd : this.subcommands) {
                subUsage = subUsage + "|" + cmd.getFullUsage();
            }
            usage = usage + " [" + subUsage.substring(1) + "]";
        }
        return usage;
    }
}

