/*
 * Decompiled with CFR 0.152.
 */
package com.thizthizzydizzy.treefeller;

import com.thizthizzydizzy.treefeller.Cascade;
import com.thizthizzydizzy.treefeller.CommandTreeFeller;
import com.thizthizzydizzy.treefeller.Cooldown;
import com.thizthizzydizzy.treefeller.DebugResult;
import com.thizthizzydizzy.treefeller.DetectedTree;
import com.thizthizzydizzy.treefeller.DirectionalFallBehavior;
import com.thizthizzydizzy.treefeller.Effect;
import com.thizthizzydizzy.treefeller.FallingTreeBlock;
import com.thizthizzydizzy.treefeller.FellBehavior;
import com.thizthizzydizzy.treefeller.Message;
import com.thizthizzydizzy.treefeller.Modifier;
import com.thizthizzydizzy.treefeller.NaturalFall;
import com.thizthizzydizzy.treefeller.Option;
import com.thizthizzydizzy.treefeller.Sapling;
import com.thizthizzydizzy.treefeller.Tool;
import com.thizthizzydizzy.treefeller.Tree;
import com.thizthizzydizzy.treefeller.TreeFellerEventListener;
import com.thizthizzydizzy.treefeller.compat.TestResult;
import com.thizthizzydizzy.treefeller.compat.TreeFellerCompat;
import com.thizthizzydizzy.treefeller.decoration.DecorationDetector;
import com.thizthizzydizzy.treefeller.menu.MenuTreesConfiguration;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.UUID;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.EntityEffect;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.type.Leaves;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.permissions.Permission;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class TreeFeller
extends JavaPlugin {
    public static ArrayList<Tool> tools = new ArrayList();
    public static ArrayList<Tree> trees = new ArrayList();
    public static ArrayList<Effect> effects = new ArrayList();
    public static HashMap<UUID, Cooldown> cooldowns = new HashMap();
    public static HashMap<Player, MenuTreesConfiguration> detectingTrees = new HashMap();
    public HashSet<UUID> toggledPlayers = new HashSet();
    public ArrayList<FallingTreeBlock> fallingBlocks = new ArrayList();
    public ArrayList<Sapling> saplings = new ArrayList();
    public boolean debug = false;
    ArrayList<NaturalFall> naturalFalls = new ArrayList();
    ArrayList<Cascade> pendingCascades = new ArrayList();
    private static final HashMap<Material, int[]> exp = new HashMap();
    public final ArrayList<String> patrons = new ArrayList();
    private BukkitTask cascadeTask;
    public boolean cascading;
    private int debugIndent;
    BukkitTask saplingHandler;

    public TreeFeller() {
        this.patrons.add("Thalzamar");
        this.patrons.add("Mstk");
        this.patrons.add("ZathrusWriter");
        this.cascading = false;
        this.debugIndent = 0;
    }

    public void fellTree(BlockBreakEvent event) {
        if (this.fellTree(event.getBlock(), event.getPlayer())) {
            event.setCancelled(true);
        }
    }

    public boolean fellTree(Block block, Player player) {
        return this.fellTree(block, player.getInventory().getItemInMainHand(), player);
    }

    public boolean fellTree(Block block, ItemStack axe, Player player) {
        return this.fellTree(block, player, axe);
    }

    public boolean fellTree(Block block, Player player, ItemStack axe) {
        return this.fellTree(block, player, axe, true) != null;
    }

    public ArrayList<ItemStack> fellTree(final Block block, final Player player, final ItemStack axe, final boolean dropItems) {
        int total;
        ItemMeta meta = axe.hasItemMeta() ? axe.getItemMeta() : null;
        boolean unbreakable = meta != null && meta.isUnbreakable();
        final DetectedTree detectedTree = this.detectTree(block, player, axe, testTree -> {
            Tool tool = testTree.tool;
            Tree tree = testTree.tree;
            int durability = axe.getType().getMaxDurability() - axe.getDurability();
            if (Option.STACKED_TOOLS.get(testTree.tool, testTree.tree).booleanValue()) {
                durability += axe.getType().getMaxDurability() * (axe.getAmount() - 1);
            }
            int durabilityCost = TreeFeller.getTotal(testTree.trunk);
            if (Option.DAMAGE_MULT.globalValue != null) {
                durabilityCost = (int)((double)durabilityCost * (Double)Option.DAMAGE_MULT.globalValue);
            }
            if (Option.DAMAGE_MULT.treeValues.containsKey(tree)) {
                durabilityCost = (int)((double)durabilityCost * (Double)Option.DAMAGE_MULT.treeValues.get(tree));
            }
            if (Option.DAMAGE_MULT.toolValues.containsKey(tool)) {
                durabilityCost = (int)((double)durabilityCost * (Double)Option.DAMAGE_MULT.toolValues.get(tool));
            }
            if (Option.RESPECT_UNBREAKING.get(tool, tree).booleanValue() && (durabilityCost /= axe.getEnchantmentLevel(Enchantment.DURABILITY) + 1) < 1) {
                ++durabilityCost;
            }
            if (Option.RESPECT_UNBREAKABLE.get(tool, tree).booleanValue() && unbreakable) {
                durabilityCost = 0;
            }
            if (axe.getType().getMaxDurability() == 0) {
                durabilityCost = 0;
            }
            if (player != null && player.getGameMode() == GameMode.CREATIVE) {
                durabilityCost = 0;
            }
            if (durabilityCost > durability && Option.ALLOW_PARTIAL_TOOL.get(tool, tree).booleanValue()) {
                this.debug(player, "partial-tool", false, new Object[0]);
                durabilityCost = durability;
            }
            if (Option.PREVENT_BREAKAGE.get(tool, tree).booleanValue()) {
                if (durabilityCost == durability) {
                    this.debug(player, false, false, "prevent-breakage", new Object[0]);
                    return null;
                }
                this.debug(player, false, true, "prevent-breakage-success", new Object[0]);
            }
            if (durabilityCost > durability) {
                if (!Option.ALLOW_PARTIAL.get(tool, tree).booleanValue()) {
                    this.debug(player, false, false, "durability-low", durability, durabilityCost);
                    return null;
                }
                this.debug(player, "partial", false, new Object[0]);
            }
            return true;
        });
        if (detectedTree == null) {
            return null;
        }
        final Tool tool = detectedTree.tool;
        final Tree tree = detectedTree.tree;
        int durability = axe.getType().getMaxDurability() - axe.getDurability();
        if (Option.STACKED_TOOLS.get(detectedTree.tool, detectedTree.tree).booleanValue()) {
            durability += axe.getType().getMaxDurability() * (axe.getAmount() - 1);
        }
        int durabilityCost = total = TreeFeller.getTotal(detectedTree.trunk);
        if (Option.DAMAGE_MULT.globalValue != null) {
            durabilityCost = (int)((double)durabilityCost * (Double)Option.DAMAGE_MULT.globalValue);
        }
        if (Option.DAMAGE_MULT.treeValues.containsKey(tree)) {
            durabilityCost = (int)((double)durabilityCost * (Double)Option.DAMAGE_MULT.treeValues.get(tree));
        }
        if (Option.DAMAGE_MULT.toolValues.containsKey(tool)) {
            durabilityCost = (int)((double)durabilityCost * (Double)Option.DAMAGE_MULT.toolValues.get(tool));
        }
        if (Option.RESPECT_UNBREAKING.get(tool, tree).booleanValue() && (durabilityCost /= axe.getEnchantmentLevel(Enchantment.DURABILITY) + 1) < 1) {
            ++durabilityCost;
        }
        if (Option.RESPECT_UNBREAKABLE.get(tool, tree).booleanValue() && unbreakable) {
            durabilityCost = 0;
        }
        if (durabilityCost > durability && Option.ALLOW_PARTIAL_TOOL.get(tool, tree).booleanValue()) {
            durabilityCost = durability;
        }
        if (durabilityCost > durability && Option.ALLOW_PARTIAL.get(tool, tree).booleanValue()) {
            durabilityCost = total = durability;
        }
        if (axe.getType().getMaxDurability() == 0) {
            durabilityCost = 0;
        }
        if (player != null && player.getGameMode() == GameMode.CREATIVE) {
            durabilityCost = 0;
        }
        this.debug(player, true, true, "success", new Object[0]);
        TreeFellerCompat.fellTree(this, block, player, axe, tool, tree, detectedTree.trunk);
        if (Option.LEAVE_STUMP.get(tool, tree).booleanValue()) {
            for (int i : detectedTree.trunk.keySet()) {
                Iterator<Block> it = detectedTree.trunk.get(i).iterator();
                while (it.hasNext()) {
                    Block b = it.next();
                    if (b.getY() >= block.getY()) continue;
                    it.remove();
                }
            }
        }
        int lower = block.getY();
        for (Block b : this.toList(detectedTree.trunk)) {
            if (b.getY() >= lower) continue;
            lower = b.getY();
        }
        final int lowest = lower;
        if (player != null && player.getGameMode() != GameMode.CREATIVE && player.getGameMode() != GameMode.SPECTATOR) {
            int logCount = 0;
            int leafCount = 0;
            for (int i : detectedTree.trunk.keySet()) {
                logCount += detectedTree.trunk.get(i).size();
            }
            for (int i : detectedTree.leaves.keySet()) {
                leafCount += detectedTree.leaves.get(i).size();
            }
            double consumeFood = Option.CONSUMED_FOOD_BASE.get(tool, tree) + Option.CONSUMED_FOOD_LOGS.get(tool, tree) * (double)logCount + Option.CONSUMED_FOOD_LEAVES.get(tool, tree) * (double)leafCount;
            double consumeHealth = Option.CONSUMED_HEALTH_BASE.get(tool, tree) + Option.CONSUMED_HEALTH_LOGS.get(tool, tree) * (double)logCount + Option.CONSUMED_HEALTH_LEAVES.get(tool, tree) * (double)leafCount;
            if (consumeFood > 0.0) {
                float satCost = (float)Math.min((double)player.getSaturation(), consumeFood);
                int foodCost = (int)(consumeFood - (double)satCost);
                player.setSaturation(Math.max(0.0f, player.getSaturation() - satCost));
                player.setFoodLevel(Math.max(0, player.getFoodLevel() - foodCost));
            }
            if (consumeFood < 0.0) {
                int foodBonus = Math.min((int)(-consumeFood), 20 - player.getFoodLevel());
                player.setFoodLevel(player.getFoodLevel() + foodBonus);
                player.setSaturation((float)((double)player.getSaturation() + (-consumeFood - (double)foodBonus)));
            }
            if (consumeHealth > 0.0) {
                player.damage(consumeHealth);
            }
            if (consumeHealth < 0.0) {
                player.setHealth(Math.min(player.getMaxHealth(), Math.max(0.0, player.getHealth() - consumeHealth)));
            }
            if (axe.getType().getMaxDurability() > 0) {
                if (Option.STACKED_TOOLS.get(tool, tree).booleanValue()) {
                    int amt = axe.getAmount();
                    while (durabilityCost > axe.getType().getMaxDurability() - axe.getDurability()) {
                        --amt;
                        durabilityCost -= axe.getType().getMaxDurability();
                    }
                    this.playToolBreakEffect(tool, tree, axe, player, block);
                    axe.setAmount(amt);
                }
                if (durability == durabilityCost) {
                    this.playToolBreakEffect(tool, tree, axe, player, block);
                }
                axe.setDurability((short)(axe.getDurability() + durabilityCost));
                if (durability == durabilityCost) {
                    axe.setAmount(0);
                }
            }
        }
        ArrayList<ItemStack> droppedItems = new ArrayList<ItemStack>();
        int t = total;
        final long seed = new Random().nextLong();
        ArrayList<Integer> distances = new ArrayList<Integer>(detectedTree.trunk.keySet());
        Collections.sort(distances);
        this.saplings.addAll(detectedTree.saplings);
        if (Option.CUTTING_ANIMATION.get(tool, tree).booleanValue()) {
            int delay = 0;
            int ttl = t;
            int tTL = t;
            int Ttl = 0;
            for (final int i : distances) {
                final int TTL = tTL - Ttl;
                delay += Option.ANIM_DELAY.get(tool, tree).intValue();
                for (Block b : detectedTree.trunk.get(i)) {
                    if (ttl <= 0) break;
                    for (Block leaf : this.toList(this.getBlocksWithLeafCheck(tree.trunk, tree.leaves, b, Option.LEAF_BREAK_RANGE.get(tool, tree), Option.DIAGONAL_LEAVES.get(tool, tree), Option.PLAYER_LEAVES.get(tool, tree), Option.IGNORE_LEAF_DATA.get(tool, tree), Option.FORCE_DISTANCE_CHECK.get(tool, tree)))) {
                        droppedItems.addAll(this.getDrops(leaf, tool, tree, axe, new int[1]));
                        for (Block d : detectedTree.getDecorations(leaf)) {
                            droppedItems.addAll(this.getDrops(d, tool, tree, axe, new int[1]));
                        }
                    }
                    droppedItems.addAll(this.getDrops(b, tool, tree, axe, new int[1]));
                    for (Block d : detectedTree.getDecorations(b)) {
                        droppedItems.addAll(this.getDrops(d, tool, tree, axe, new int[1]));
                    }
                    --ttl;
                }
                new BukkitRunnable(){

                    public void run() {
                        int tTl = TTL;
                        for (Block b : detectedTree.trunk.get(i)) {
                            if (tTl <= 0) break;
                            for (Block leaf : TreeFeller.this.toList(TreeFeller.this.getBlocksWithLeafCheck(tree.trunk, tree.leaves, b, Option.LEAF_BREAK_RANGE.get(tool, tree), Option.DIAGONAL_LEAVES.get(tool, tree), Option.PLAYER_LEAVES.get(tool, tree), Option.IGNORE_LEAF_DATA.get(tool, tree), Option.FORCE_DISTANCE_CHECK.get(tool, tree)))) {
                                TreeFeller.this.breakBlock(detectedTree, dropItems, tree, tool, axe, leaf, block, lowest, player, seed, true);
                                for (Block d : detectedTree.getDecorations(leaf)) {
                                    TreeFeller.this.breakBlock(detectedTree, dropItems, tree, tool, axe, d, block, lowest, player, seed, true);
                                }
                            }
                            TreeFeller.this.breakBlock(detectedTree, dropItems, tree, tool, axe, b, block, lowest, player, seed, false);
                            for (Block d : detectedTree.getDecorations(b)) {
                                TreeFeller.this.breakBlock(detectedTree, dropItems, tree, tool, axe, d, block, lowest, player, seed, false);
                            }
                            --tTl;
                        }
                        TreeFeller.this.processNaturalFalls();
                    }
                }.runTaskLater((Plugin)this, (long)delay);
                Ttl += detectedTree.trunk.get(i).size();
            }
            Integer maxSaplings = Option.MAX_SAPLINGS.get(tool, tree);
            if (maxSaplings != null && maxSaplings >= 1 && Option.SPAWN_SAPLINGS.get(tool, tree) == 2) {
                new BukkitRunnable(){

                    public void run() {
                        for (Sapling s : detectedTree.saplings) {
                            s.place(null);
                        }
                    }
                }.runTaskLater((Plugin)this, (long)(delay + 1));
            }
        } else {
            Iterator<Object> delay = distances.iterator();
            block11: while (delay.hasNext()) {
                int i = delay.next();
                for (Block b : detectedTree.trunk.get(i)) {
                    if (total <= 0) continue block11;
                    for (Block leaf : this.toList(this.getBlocksWithLeafCheck(tree.trunk, tree.leaves, b, Option.LEAF_BREAK_RANGE.get(tool, tree), Option.DIAGONAL_LEAVES.get(tool, tree), Option.PLAYER_LEAVES.get(tool, tree), Option.IGNORE_LEAF_DATA.get(tool, tree), Option.FORCE_DISTANCE_CHECK.get(tool, tree)))) {
                        this.breakBlock(detectedTree, dropItems, tree, tool, axe, leaf, block, lowest, player, seed, true);
                        for (Block d : detectedTree.getDecorations(leaf)) {
                            this.breakBlock(detectedTree, dropItems, tree, tool, axe, d, block, lowest, player, seed, true);
                        }
                    }
                    this.breakBlock(detectedTree, dropItems, tree, tool, axe, b, block, lowest, player, seed, false);
                    for (Block d : detectedTree.getDecorations(b)) {
                        this.breakBlock(detectedTree, dropItems, tree, tool, axe, d, block, lowest, player, seed, false);
                    }
                    --total;
                }
            }
            if (Option.SPAWN_SAPLINGS.get(tool, tree) == 2) {
                for (Sapling s : detectedTree.saplings) {
                    s.place(null);
                }
            }
            this.processNaturalFalls();
        }
        if (player != null) {
            long time = System.currentTimeMillis();
            Cooldown cooldown = cooldowns.get(player.getUniqueId());
            if (cooldown == null) {
                cooldown = new Cooldown();
            }
            cooldown.globalCooldown = time;
            cooldown.treeCooldowns.put(tree, time);
            cooldown.toolCooldowns.put(tool, time);
            cooldowns.put(player.getUniqueId(), cooldown);
        }
        for (Effect e : Option.EFFECTS.get(tool, tree)) {
            if (e.location != Effect.EffectLocation.TOOL) continue;
            Random random = new Random();
            if (!(random.nextDouble() < e.chance)) continue;
            e.play(block);
        }
        this.createSaplingHandler();
        return droppedItems;
    }

    public DetectedTree detectTree(Block block, Player player, ItemStack axe) {
        return this.detectTree(block, player, axe, t -> true);
    }

    public DetectedTree detectTree(Block block, Player player, ItemStack axe, Function<DetectedTree, Boolean> checkFunc) {
        if (player != null && player.getGameMode() == GameMode.SPECTATOR) {
            return null;
        }
        this.debugIndent = 0;
        Material material = block.getType();
        block0: for (Tree tree : trees) {
            if (!tree.trunk.contains(material)) {
                Block b;
                HashSet<Material> roots = Option.ROOTS.getValue(tree);
                if (roots == null || !roots.contains(material) || (b = this.getNearest(block, tree.trunk, roots, Option.ROOT_DISTANCE.get(null, tree), true, Option.PLAYER_LEAVES.get(null, tree))) == null) continue;
                return this.detectTree(b, player, axe, checkFunc);
            }
            block1: for (Tool tool : tools) {
                Object decor;
                Object result;
                Block b22;
                if (player != null && !this.isToggledOn(player)) {
                    this.debug(player, true, false, "toggle", new Object[0]);
                    return null;
                }
                this.debug(player, "checking", false, trees.indexOf(tree), tools.indexOf(tool));
                if (axe != null && tool.material != Material.AIR && axe.getType() != tool.material) continue;
                for (Option o3 : Option.options) {
                    DebugResult result2 = o3.check(this, tool, tree, block, player, axe);
                    if (result2 == null) continue;
                    this.debug(player, false, result2);
                    if (result2.isSuccess()) continue;
                    continue block1;
                }
                int scanDistance = Option.SCAN_DISTANCE.get(tool, tree);
                Integer maxBlocks = Option.MAX_LOGS.get(tool, tree);
                HashMap<Integer, ArrayList<Block>> blocks = TreeFeller.getBlocks(tree.trunk, block, scanDistance, maxBlocks == null ? Integer.MAX_VALUE : maxBlocks * 2, true, false, false);
                for (Option option : Option.options) {
                    DebugResult result3 = option.checkTrunk(this, tool, tree, blocks, block);
                    if (result3 == null) continue;
                    this.debug(player, false, result3);
                    if (result3.isSuccess()) continue;
                    continue block1;
                }
                int minY = block.getY();
                for (int i : blocks.keySet()) {
                    for (Block b22 : blocks.get(i)) {
                        minY = Math.min(minY, b22.getY());
                    }
                }
                ArrayList<Integer> arrayList = new ArrayList<Integer>(blocks.keySet());
                Collections.sort(arrayList);
                int leaves = 0;
                HashMap<Integer, ArrayList<Block>> allLeaves = new HashMap<Integer, ArrayList<Block>>();
                b22 = arrayList.iterator();
                while (b22.hasNext()) {
                    int i = (Integer)b22.next();
                    for (Block block2 : blocks.get(i)) {
                        HashMap<Integer, ArrayList<Block>> someLeaves = this.getBlocksWithLeafCheck(tree.trunk, tree.leaves, block2, Option.LEAF_DETECT_RANGE.get(tool, tree), Option.DIAGONAL_LEAVES.get(tool, tree), Option.PLAYER_LEAVES.get(tool, tree), Option.IGNORE_LEAF_DATA.get(tool, tree), Option.FORCE_DISTANCE_CHECK.get(tool, tree));
                        leaves += this.toList(someLeaves).size();
                        for (int in : someLeaves.keySet()) {
                            if (allLeaves.containsKey(in)) {
                                allLeaves.get(in).addAll((Collection<Block>)someLeaves.get(in));
                                continue;
                            }
                            allLeaves.put(in, someLeaves.get(in));
                        }
                    }
                }
                ArrayList<Block> everything = new ArrayList<Block>();
                everything.addAll(this.toList(blocks));
                everything.addAll(this.toList(allLeaves));
                TestResult res = TreeFellerCompat.test(this, player, everything);
                if (res != null) {
                    this.debug(player, false, false, "protected", res.plugin, res.block.getX(), res.block.getY(), res.block.getZ());
                    continue block0;
                }
                for (Option option : Option.options) {
                    result = option.checkTree(this, tool, tree, blocks, leaves);
                    if (result == null) continue;
                    this.debug(player, false, (DebugResult)result);
                    if (((DebugResult)result).isSuccess()) continue;
                    continue block1;
                }
                HashMap<Block, ArrayList<Block>> decorations = new HashMap<Block, ArrayList<Block>>();
                for (Block b4 : everything) {
                    decor = new ArrayList<Block>();
                    for (DecorationDetector detector : Option.DECORATIONS.get(tool, tree)) {
                        detector.detect(b4, (ArrayList<Block>)decor);
                    }
                    if (((ArrayList)decor).isEmpty()) continue;
                    decorations.put(b4, (ArrayList<Block>)decor);
                }
                DetectedTree detectedTree = new DetectedTree(tool, tree, blocks, allLeaves, decorations);
                result = checkFunc.apply(detectedTree);
                if (result == null) continue;
                if (Objects.equals(result, false)) continue block0;
                this.debug(player, true, true, "success", new Object[0]);
                if (Option.LEAVE_STUMP.get(tool, tree).booleanValue()) {
                    decor = blocks.keySet().iterator();
                    while (decor.hasNext()) {
                        int i = (Integer)decor.next();
                        for (Block b5 : blocks.get(i)) {
                            if (b5.getY() >= block.getY()) continue;
                            detectedTree.stump.add(b5);
                        }
                    }
                }
                HashMap<Block, Integer> possibleSaplings = new HashMap<Block, Integer>();
                if (Option.SAPLING.get(tool, tree) != null && Option.REPLANT_SAPLINGS.get(tool, tree).booleanValue()) {
                    ArrayList<Block> logs = this.toList(blocks);
                    for (Block log : logs) {
                        if (!Option.GRASS.get(tool, tree).contains(log.getRelative(0, -1, 0).getType())) continue;
                        possibleSaplings.put(log, -1);
                    }
                    for (Block b : possibleSaplings.keySet()) {
                        int above = -1;
                        Block b1 = b;
                        while (tree.trunk.contains(b1.getType())) {
                            ++above;
                            b1 = b1.getRelative(0, 1, 0);
                        }
                        possibleSaplings.put(b, above);
                    }
                    Integer maxSaplings = Option.MAX_SAPLINGS.get(tool, tree);
                    if (maxSaplings != null) {
                        block17: while (possibleSaplings.size() > maxSaplings) {
                            ArrayList ints = new ArrayList(possibleSaplings.values());
                            Collections.sort(ints);
                            int i = (Integer)ints.get(0);
                            for (Block b6 : possibleSaplings.keySet()) {
                                if ((Integer)possibleSaplings.get(b6) != i) continue;
                                possibleSaplings.remove(b6);
                                continue block17;
                            }
                        }
                    }
                    for (Block b7 : possibleSaplings.keySet()) {
                        detectedTree.addSapling(this, (Player)(Option.USE_INVENTORY_SAPLINGS.get(tool, tree) != false ? player : null), b7, Option.SAPLING.get(tool, tree));
                    }
                }
                return detectedTree;
            }
        }
        return null;
    }

    private static HashMap<Integer, ArrayList<Block>> getBlocks(Collection<Material> materialTypes, Block startingBlock, int maxDistance, int maxBlocks, boolean diagonal, boolean playerLeaves, boolean ignoreLeafData) {
        return TreeFeller.getBlocks(materialTypes, startingBlock, maxDistance, maxBlocks, diagonal, playerLeaves, ignoreLeafData, false);
    }

    private static HashMap<Integer, ArrayList<Block>> getBlocks(Collection<Material> materialTypes, Block startingBlock, int maxDistance, int maxBlocks, boolean diagonal, boolean playerLeaves, boolean ignoreLeafData, boolean invertLeafDirection) {
        HashMap<Integer, ArrayList<Block>> results = new HashMap<Integer, ArrayList<Block>>();
        int total = 0;
        ArrayList<Block> zero = new ArrayList<Block>();
        if (materialTypes.contains(startingBlock.getType())) {
            zero.add(startingBlock);
        }
        results.put(0, zero);
        total += zero.size();
        for (int i = 0; i < maxDistance; ++i) {
            ArrayList<Block> layer = new ArrayList<Block>();
            ArrayList<Block> lastLayer = new ArrayList<Block>((Collection)results.get(i));
            if (i == 0 && lastLayer.isEmpty()) {
                lastLayer.add(startingBlock);
            }
            for (Block block : lastLayer) {
                if (diagonal) {
                    for (int x = -1; x <= 1; ++x) {
                        for (int y = -1; y <= 1; ++y) {
                            for (int z = -1; z <= 1; ++z) {
                                Block newBlock;
                                if (x == 0 && y == 0 && z == 0 || !materialTypes.contains((newBlock = block.getRelative(x, y, z)).getType()) || lastLayer.contains(newBlock) || i > 0 && results.get(i - 1).contains(newBlock) || layer.contains(newBlock)) continue;
                                if (newBlock.getBlockData() instanceof Leaves) {
                                    Leaves newLeaf = (Leaves)newBlock.getBlockData();
                                    if (!playerLeaves && newLeaf.isPersistent()) continue;
                                    if (!ignoreLeafData && block.getBlockData() instanceof Leaves) {
                                        Leaves oldLeaf = (Leaves)block.getBlockData();
                                        if (invertLeafDirection ? newLeaf.getDistance() >= oldLeaf.getDistance() : newLeaf.getDistance() <= oldLeaf.getDistance()) continue;
                                    }
                                }
                                layer.add(newBlock);
                            }
                        }
                    }
                    continue;
                }
                for (int j = 0; j < 6; ++j) {
                    int x = 0;
                    int y = 0;
                    int z = 0;
                    switch (j) {
                        case 0: {
                            x = -1;
                            break;
                        }
                        case 1: {
                            x = 1;
                            break;
                        }
                        case 2: {
                            y = -1;
                            break;
                        }
                        case 3: {
                            y = 1;
                            break;
                        }
                        case 4: {
                            z = -1;
                            break;
                        }
                        case 5: {
                            z = 1;
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("How did this happen?");
                        }
                    }
                    Block newBlock = block.getRelative(x, y, z);
                    if (!materialTypes.contains(newBlock.getType()) || lastLayer.contains(newBlock) || i > 0 && results.get(i - 1).contains(newBlock) || layer.contains(newBlock)) continue;
                    if (newBlock.getState().getBlockData() instanceof Leaves) {
                        Leaves newLeaf = (Leaves)newBlock.getBlockData();
                        if (!playerLeaves && newLeaf.isPersistent()) continue;
                        if (!ignoreLeafData && block.getBlockData() instanceof Leaves) {
                            Leaves oldLeaf = (Leaves)block.getBlockData();
                            if (invertLeafDirection ? newLeaf.getDistance() >= oldLeaf.getDistance() : newLeaf.getDistance() <= oldLeaf.getDistance()) continue;
                        }
                    }
                    layer.add(newBlock);
                }
            }
            if (layer.isEmpty()) break;
            results.put(i + 1, layer);
            if ((total += layer.size()) <= maxBlocks) continue;
            return results;
        }
        return results;
    }

    private HashMap<Integer, ArrayList<Block>> getBlocksWithLeafCheck(ArrayList<Material> trunk, ArrayList<Material> leaves, Block startingBlock, int maxDistance, boolean diagonal, boolean playerLeaves, boolean ignoreLeafData, boolean forceDistanceCheck) {
        HashMap<Integer, ArrayList<Block>> blocks = TreeFeller.getBlocks(leaves, startingBlock, maxDistance, Integer.MAX_VALUE, diagonal, playerLeaves, ignoreLeafData);
        if (forceDistanceCheck) {
            this.leafCheck(blocks, trunk, leaves, diagonal, playerLeaves, ignoreLeafData);
        }
        return blocks;
    }

    private static int getTotal(HashMap<Integer, ArrayList<Block>> blocks) {
        int total = 0;
        for (int i : blocks.keySet()) {
            total += blocks.get(i).size();
        }
        return total;
    }

    private ArrayList<Block> toList(HashMap<Integer, ArrayList<Block>> blocks) {
        ArrayList<Block> list = new ArrayList<Block>();
        for (int i : blocks.keySet()) {
            list.addAll((Collection<Block>)blocks.get(i));
        }
        return list;
    }

    private Block getNearest(Block from, ArrayList<Material> to, Collection<Material> materialTypes, int max, boolean diagonal, boolean playerLeaves) {
        materialTypes.add(from.getType());
        materialTypes.addAll(to);
        for (int d = 0; d < max; ++d) {
            for (Block b : this.toList(TreeFeller.getBlocks(materialTypes, from, d, Integer.MAX_VALUE, diagonal, playerLeaves, true))) {
                if (!to.contains(b.getType())) continue;
                return b;
            }
        }
        return null;
    }

    private int distance(Block from, ArrayList<Material> to, ArrayList<Material> materialTypes, int max, boolean diagonal, boolean playerLeaves) {
        materialTypes.add(from.getType());
        materialTypes.addAll(to);
        for (int d = 0; d < max; ++d) {
            for (Block b : this.toList(TreeFeller.getBlocks(materialTypes, from, d, Integer.MAX_VALUE, diagonal, playerLeaves, true))) {
                if (!to.contains(b.getType())) continue;
                return d;
            }
        }
        return max;
    }

    public void onEnable() {
        PluginDescriptionFile pdfFile = this.getDescription();
        Logger logger = this.getLogger();
        PluginManager pm = this.getServer().getPluginManager();
        pm.registerEvents((Listener)new TreeFellerEventListener(this), (Plugin)this);
        this.saveDefaultConfig();
        this.getConfig().options().copyDefaults(true);
        try {
            pm.addPermission(new Permission("treefeller.help"));
            pm.addPermission(new Permission("treefeller.toggle"));
            pm.addPermission(new Permission("treefeller.reload"));
            pm.addPermission(new Permission("treefeller.debug"));
            pm.addPermission(new Permission("treefeller.config"));
        }
        catch (IllegalArgumentException ex) {
            logger.log(Level.WARNING, "Failed to add permissions! Did you reload the plugin? (If you just want to reload the config, use /treefeller reload)");
        }
        this.getCommand("treefeller").setExecutor((CommandExecutor)new CommandTreeFeller(this));
        logger.log(Level.INFO, "{0} has been enabled! (Version {1}) by ThizThizzyDizzy", new Object[]{pdfFile.getName(), pdfFile.getVersion()});
        this.reload();
        new BukkitRunnable(){

            public void run() {
                TreeFeller.this.refreshPatronsList();
            }
        }.runTaskAsynchronously((Plugin)this);
    }

    public void onDisable() {
        PluginDescriptionFile pdfFile = this.getDescription();
        Logger logger = this.getLogger();
        logger.log(Level.INFO, "{0} has been disabled! (Version {1}) by ThizThizzyDizzy", new Object[]{pdfFile.getName(), pdfFile.getVersion()});
    }

    public static Particle getParticle(String string) {
        Particle p = null;
        try {
            p = Particle.valueOf((String)string.toUpperCase().replace(" ", "-").replace("-", "_"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (p != null) {
            return p;
        }
        switch (string.toLowerCase().replace("_", " ").replace("-", " ")) {
            case "block": {
                return Particle.BLOCK_DUST;
            }
            case "enchanted hit": {
                return Particle.CRIT_MAGIC;
            }
            case "dripping lava": {
                return Particle.DRIP_LAVA;
            }
            case "dripping water": {
                return Particle.DRIP_WATER;
            }
            case "enchant": {
                return Particle.ENCHANTMENT_TABLE;
            }
            case "explosion emitter": {
                return Particle.EXPLOSION_HUGE;
            }
            case "explode": {
                return Particle.EXPLOSION_LARGE;
            }
            case "poof": {
                return Particle.EXPLOSION_NORMAL;
            }
            case "firework": {
                return Particle.FIREWORKS_SPARK;
            }
            case "item": {
                return Particle.ITEM_CRACK;
            }
            case "elder guardian": {
                return Particle.MOB_APPEARANCE;
            }
            case "dust": {
                return Particle.REDSTONE;
            }
            case "item slime": {
                return Particle.SLIME;
            }
            case "large smoke": {
                return Particle.SMOKE_LARGE;
            }
            case "smoke": {
                return Particle.SMOKE_NORMAL;
            }
            case "item snowball": {
                return Particle.SNOWBALL;
            }
            case "effect": {
                return Particle.SPELL;
            }
            case "instant effect": {
                return Particle.SPELL_INSTANT;
            }
            case "entity effect": {
                return Particle.SPELL_MOB;
            }
            case "mob spell ambient": 
            case "ambient entity effect": {
                return Particle.SPELL_MOB_AMBIENT;
            }
            case "witch": {
                return Particle.SPELL_WITCH;
            }
            case "underwater": {
                return Particle.SUSPENDED;
            }
            case "totem of undying": {
                return Particle.TOTEM;
            }
            case "mycelium": {
                return Particle.TOWN_AURA;
            }
            case "angry villager": {
                return Particle.VILLAGER_ANGRY;
            }
            case "happy villager": {
                return Particle.VILLAGER_HAPPY;
            }
            case "bubble": {
                return Particle.WATER_BUBBLE;
            }
            case "rain": {
                return Particle.WATER_DROP;
            }
            case "splash": {
                return Particle.WATER_SPLASH;
            }
            case "fishing": {
                return Particle.WATER_WAKE;
            }
        }
        return null;
    }

    public void reload() {
        this.reload(null);
    }

    public void reload(CommandSender source) {
        ArrayList effects;
        Logger logger;
        block50: {
            logger = this.getLogger();
            trees.clear();
            tools.clear();
            TreeFeller.effects.clear();
            this.saplings.clear();
            if (this.saplingHandler != null) {
                this.saplingHandler.cancel();
            }
            this.saplingHandler = null;
            this.fallingBlocks.clear();
            cooldowns.clear();
            effects = null;
            try {
                effects = new ArrayList(this.getConfig().getList("effects"));
            }
            catch (NullPointerException ex) {
                if (this.getConfig().get("effects") == null) break block50;
                this.log(logger, source, Level.WARNING, "Failed to load effects!", new Object[0]);
            }
        }
        if (effects != null) {
            for (Object object : effects) {
                if (object instanceof LinkedHashMap) {
                    LinkedHashMap map = (LinkedHashMap)object;
                    if (!map.containsKey("name") || !(map.get("name") instanceof String)) {
                        this.log(logger, source, Level.WARNING, "Cannot find effect name! Skipping...", new Object[0]);
                        continue;
                    }
                    String name = (String)map.get("name");
                    String typ = (String)map.get("type");
                    Effect.EffectType type = Effect.EffectType.valueOf(typ.toUpperCase().trim());
                    if (type == null) {
                        this.log(logger, source, Level.WARNING, "Invalid effect type: {0}! Skipping...", typ);
                        continue;
                    }
                    String loc = (String)map.get("location");
                    Effect.EffectLocation location = Effect.EffectLocation.valueOf(loc.toUpperCase().trim());
                    if (location == null) {
                        this.log(logger, source, Level.WARNING, "Invalid effect location: {0}! Skipping...", loc);
                        continue;
                    }
                    double chance = 1.0;
                    if (map.containsKey("chance")) {
                        chance = ((Number)map.get("chance")).doubleValue();
                    }
                    Effect effect = type.loadEffect(name, location, chance, map);
                    if (Option.STARTUP_LOGS.isTrue()) {
                        effect.print(logger);
                    }
                    TreeFeller.effects.add(effect);
                    continue;
                }
                if (object instanceof String) {
                    Material m = Material.matchMaterial((String)((String)object));
                    if (m == null) {
                        this.log(logger, source, Level.WARNING, "Unknown material: {0}; Skipping...", object);
                    }
                    Tool tool = new Tool(m);
                    if (Option.STARTUP_LOGS.isTrue()) {
                        tool.print(logger);
                    }
                    tools.add(tool);
                    continue;
                }
                this.log(logger, source, Level.INFO, "Unknown tool declaration: {0} | {1}", object.getClass().getName(), object.toString());
            }
        }
        TreeFellerCompat.init(null);
        for (Option option : Option.options) {
            if (!option.global) continue;
            option.setValue(option.loadFromConfig(this.getConfig()));
        }
        TreeFellerCompat.init(this);
        for (Message message : Message.messages) {
            message.load(this.getConfig());
        }
        if (Option.STARTUP_LOGS.isTrue()) {
            this.log(logger, source, Level.INFO, "Server version: {0}", Bukkit.getServer().getBukkitVersion());
            this.log(logger, source, Level.INFO, "Loaded global values:", new Object[0]);
            for (Option option : Option.options) {
                Object value = option.getValue();
                if (value == null) continue;
                this.log(logger, source, Level.INFO, "- {0}: {1}", option.name, option.makeReadable(value));
            }
        }
        ArrayList trees = new ArrayList(this.getConfig().getList("trees"));
        for (Object o : trees) {
            Object t;
            ArrayList<Material> leaves;
            ArrayList<Material> trunk;
            if (o instanceof ArrayList) {
                Object l;
                trunk = new ArrayList<Material>();
                leaves = new ArrayList<Material>();
                if (((ArrayList)o).get(0) instanceof String) {
                    t = Material.matchMaterial((String)((String)((ArrayList)o).get(0)));
                    if (t != null) {
                        trunk.add((Material)t);
                    }
                } else {
                    for (Object obj : (ArrayList)((ArrayList)o).get(0)) {
                        Material t2;
                        if (!(obj instanceof String) || (t2 = Material.matchMaterial((String)((String)obj))) == null) continue;
                        trunk.add(t2);
                    }
                }
                if (((ArrayList)o).get(1) instanceof String) {
                    Material l2 = Material.matchMaterial((String)((String)((ArrayList)o).get(1)));
                    if (l2 != null) {
                        leaves.add(l2);
                    }
                } else {
                    for (Object obj : (ArrayList)((ArrayList)o).get(1)) {
                        if (!(obj instanceof String) || (l = Material.matchMaterial((String)((String)obj))) == null) continue;
                        leaves.add((Material)l);
                    }
                }
                if (trunk.isEmpty() || leaves.isEmpty()) {
                    this.log(logger, source, Level.WARNING, "Cannot load tree: {0}", o);
                    continue;
                }
                Tree tree = new Tree(trunk, leaves);
                if (((ArrayList)o).size() > 2) {
                    LinkedHashMap map = (LinkedHashMap)((ArrayList)o).get(2);
                    l = map.keySet().iterator();
                    while (l.hasNext()) {
                        Object key = l.next();
                        if (!(key instanceof String)) {
                            this.log(logger, source, Level.WARNING, "invalid tree option: {0}", key);
                            continue;
                        }
                        String s = ((String)key).toLowerCase().replace("-", "").replace("_", "").replace(" ", "");
                        boolean found = false;
                        for (Option option : Option.options) {
                            if (!option.tree || !option.getLocalName().equals(s)) continue;
                            found = true;
                            option.setValue(tree, option.load(map.get(key)));
                        }
                        if (found) continue;
                        this.log(logger, source, Level.WARNING, "Found unknown tree option: {0}", key);
                    }
                }
                if (Option.STARTUP_LOGS.isTrue()) {
                    tree.print(logger);
                }
                TreeFeller.trees.add(tree);
                continue;
            }
            if (o instanceof String) {
                trunk = new ArrayList();
                leaves = new ArrayList();
                t = Material.matchMaterial((String)((String)o));
                Material l = Material.matchMaterial((String)((String)o).replace("STRIPPED_", "").replace("LOG", "LEAVES").replace("WOOD", "LEAVES"));
                if (t != null) {
                    trunk.add((Material)t);
                }
                if (l != null) {
                    leaves.add(l);
                }
                if (trunk.isEmpty() || leaves.isEmpty()) {
                    this.log(logger, source, Level.WARNING, "Cannot load tree: {0}", o);
                    continue;
                }
                Tree tree = new Tree(trunk, leaves);
                if (Option.STARTUP_LOGS.isTrue()) {
                    tree.print(logger);
                }
                TreeFeller.trees.add(tree);
                continue;
            }
            this.log(logger, source, Level.WARNING, "Cannot load tree: {0}", o);
        }
        ArrayList arrayList = new ArrayList(this.getConfig().getList("tools"));
        for (Object o : arrayList) {
            if (o instanceof LinkedHashMap) {
                LinkedHashMap map = (LinkedHashMap)o;
                if (!map.containsKey("type") || !(map.get("type") instanceof String)) {
                    this.log(logger, source, Level.WARNING, "Cannot find tool material! Skipping...", new Object[0]);
                    continue;
                }
                String typ = (String)map.get("type");
                Material type = Material.matchMaterial((String)typ.trim());
                if (type == null) {
                    this.log(logger, source, Level.WARNING, "Unknown tool material: {0}! Skipping...", map.get("type"));
                    continue;
                }
                Tool tool = new Tool(type);
                for (Object key : map.keySet()) {
                    if (key.equals("type")) continue;
                    if (!(key instanceof String)) {
                        this.log(logger, source, Level.WARNING, "Unknown tool property: {0}; Skipping...", key);
                        continue;
                    }
                    String s = ((String)key).toLowerCase().replace("-", "").replace("_", "").replace(" ", "");
                    boolean found = false;
                    for (Option option : Option.options) {
                        if (!option.tool || !option.getLocalName().equals(s)) continue;
                        found = true;
                        option.setValue(tool, option.load(map.get(key)));
                    }
                    if (found) continue;
                    this.log(logger, source, Level.WARNING, "Found unknown tool option: {0}", key);
                }
                if (Option.STARTUP_LOGS.isTrue()) {
                    tool.print(logger);
                }
                tools.add(tool);
                continue;
            }
            if (o instanceof String) {
                Material m = Material.matchMaterial((String)((String)o));
                if (m == null) {
                    this.log(logger, source, Level.WARNING, "Unknown material: {0}; Skipping...", o);
                }
                Tool tool = new Tool(m);
                if (Option.STARTUP_LOGS.isTrue()) {
                    tool.print(logger);
                }
                tools.add(tool);
                continue;
            }
            this.log(logger, source, Level.INFO, "Unknown tool declaration: {0} | {1}", o.getClass().getName(), o.toString());
        }
        TreeFellerCompat.reload();
    }

    private void breakBlock(DetectedTree detectedTree, boolean dropItems, Tree tree, Tool tool, ItemStack axe, Block block, Block origin, int lowest, Player player, long seed, boolean isLeaves) {
        FellBehavior behavior;
        ArrayList<Material> overridables = new ArrayList<Material>((Collection)Option.OVERRIDABLES.get(tool, tree));
        ArrayList<Effect> effects = new ArrayList<Effect>();
        Effect.EffectLocation type = Effect.EffectLocation.DECORATION;
        if (tree.leaves.contains(block.getType())) {
            type = Effect.EffectLocation.LEAVES;
        }
        if (tree.trunk.contains(block.getType())) {
            type = Effect.EffectLocation.LOGS;
        }
        if (Option.CASCADE.get(tool, tree).booleanValue()) {
            this.cascade(detectedTree, dropItems, tree, tool, axe, block, player);
        }
        for (Effect e : Option.EFFECTS.get(tool, tree)) {
            if (e.location == Effect.EffectLocation.TREE) {
                effects.add(e);
            }
            if (type != e.location) continue;
            effects.add(e);
        }
        FellBehavior fellBehavior = behavior = isLeaves ? Option.LEAF_BEHAVIOR.get(tool, tree) : Option.LOG_BEHAVIOR.get(tool, tree);
        if (type == Effect.EffectLocation.DECORATION) {
            behavior = behavior.getDecorationBehavior();
        }
        double directionalFallVelocity = Option.DIRECTIONAL_FALL_VELOCITY.get(tool, tree);
        double verticalFallVelocity = Option.VERTICAL_FALL_VELOCITY.get(tool, tree);
        double explosiveFallVelocity = Option.EXPLOSIVE_FALL_VELOCITY.get(tool, tree);
        double randomFallVelocity = Option.RANDOM_FALL_VELOCITY.get(tool, tree);
        boolean rotate = Option.ROTATE_LOGS.get(tool, tree);
        DirectionalFallBehavior directionalFallBehavior = Option.DIRECTIONAL_FALL_BEHAVIOR.get(tool, tree);
        boolean lockCardinal = Option.LOCK_FALL_CARDINAL.get(tool, tree);
        HashMap<Material, Material> conversions = Option.BLOCK_CONVERSIONS.get(tool, tree);
        if (conversions.containsKey(block.getType())) {
            BlockState state = block.getState();
            TreeFellerCompat.removeBlock(this, player, block);
            block.setType(conversions.get(block.getType()));
            TreeFellerCompat.addBlock(this, player, block, state);
        } else {
            ArrayList<Modifier> modifiers = new ArrayList<Modifier>();
            if (behavior == FellBehavior.FALL || behavior == FellBehavior.FALL_HURT || behavior == FellBehavior.NATURAL) {
                TreeFellerCompat.removeBlock(this, player, block);
            } else {
                TreeFellerCompat.breakBlock(this, tree, tool, player, axe, block, modifiers);
            }
            behavior.breakBlock(detectedTree, this, dropItems, tree, tool, axe, block, origin, lowest, player, seed, modifiers, directionalFallBehavior, lockCardinal, directionalFallVelocity, rotate, overridables, randomFallVelocity, explosiveFallVelocity, verticalFallVelocity);
        }
        Random rand = new Random();
        for (Effect e : effects) {
            if (!(rand.nextDouble() < e.chance)) continue;
            e.play(block);
        }
    }

    private void cascade(DetectedTree detectedTree, boolean dropItems, Tree tree, Tool tool, ItemStack axe, Block block, Player player) {
        this.pendingCascades.add(new Cascade(detectedTree, dropItems, tree, tool, axe, block, player));
        if (this.cascadeTask == null) {
            this.cascadeTask = new BukkitRunnable(){

                public void run() {
                    int maxChecks = Option.CASCADE_CHECK_LIMIT.getValue();
                    int maxCascades = Option.PARALLEL_CASCADE_LIMIT.getValue();
                    int checks = 0;
                    int cascades = 0;
                    while (checks < maxChecks && cascades < maxCascades && !TreeFeller.this.pendingCascades.isEmpty()) {
                        BlockFace[] directions;
                        ++checks;
                        Cascade cascade = TreeFeller.this.pendingCascades.remove(0);
                        ArrayList<Tree> trees = Option.CASCADE_TREES.get(cascade.tool, cascade.tree);
                        if (trees == null) {
                            trees = new ArrayList();
                            trees.add(cascade.tree);
                        }
                        HashSet<Material> allLeaves = new HashSet<Material>();
                        HashSet<Material> allTrunks = new HashSet<Material>();
                        int maxRange = 0;
                        boolean diagonal = false;
                        boolean player = false;
                        boolean ignoreData = false;
                        for (Tree tree : trees) {
                            allLeaves.addAll(tree.leaves);
                            allTrunks.addAll(tree.trunk);
                            int range = Option.LEAF_DETECT_RANGE.get(cascade.tool, tree);
                            if (range > maxRange) {
                                maxRange = range;
                            }
                            if (Option.DIAGONAL_LEAVES.get(cascade.tool, tree).booleanValue()) {
                                diagonal = true;
                            }
                            if (Option.PLAYER_LEAVES.get(cascade.tool, cascade.tree).booleanValue()) {
                                player = true;
                            }
                            if (!Option.IGNORE_LEAF_DATA.get(cascade.tool, cascade.tree).booleanValue()) continue;
                            ignoreData = true;
                        }
                        HashSet prevTrunks = new HashSet(TreeFeller.this.toList(cascade.detectedTree.trunk));
                        HashSet prevLeaves = new HashSet(TreeFeller.this.toList(cascade.detectedTree.leaves));
                        for (BlockFace dir : directions = new BlockFace[]{BlockFace.NORTH, BlockFace.EAST, BlockFace.SOUTH, BlockFace.WEST, BlockFace.UP, BlockFace.DOWN}) {
                            Block start = cascade.block.getRelative(dir);
                            if (prevLeaves.contains(start) || prevTrunks.contains(start)) continue;
                            ArrayList detectedLeaves = TreeFeller.this.toList(TreeFeller.getBlocks(new ArrayList(allLeaves), start, maxRange, 64, diagonal, player, ignoreData, true));
                            HashSet trunks = new HashSet();
                            for (Block b : detectedLeaves) {
                                if (prevLeaves.contains(b)) continue;
                                for (BlockFace direction : directions) {
                                    Block bl = b.getRelative(direction);
                                    if (!allTrunks.contains(bl.getType()) || prevTrunks.contains(bl) || TreeFeller.this.tryCascade(bl, cascade.player, cascade.axe, cascade.dropItems) == null) continue;
                                    ++cascades;
                                }
                            }
                        }
                    }
                    if (TreeFeller.this.pendingCascades.isEmpty()) {
                        TreeFeller.this.cascadeTask.cancel();
                        TreeFeller.this.cascadeTask = null;
                    }
                }
            }.runTaskTimer((Plugin)this, 1L, 1L);
        }
    }

    public ArrayList<ItemStack> tryCascade(Block block, Player player, ItemStack axe, boolean dropItems) {
        this.cascading = true;
        ArrayList<ItemStack> ret = this.fellTree(block, player, axe, dropItems);
        this.cascading = false;
        return ret;
    }

    int randbetween(int[] minmax) {
        return this.randbetween(minmax[0], minmax[1]);
    }

    int randbetween(int min, int max) {
        return new Random().nextInt(max - min + 1) + min;
    }

    Collection<? extends ItemStack> getDropsWithBonus(Block block, Tool tool, Tree tree, ItemStack axe, int[] xp, List<Modifier> modifiers) {
        if (xp.length != 1) {
            throw new IllegalArgumentException("xp must be an array of size 1!");
        }
        ArrayList<? extends ItemStack> drops = new ArrayList<ItemStack>();
        double dropChance = tree.trunk.contains(block.getType()) ? Option.LOG_DROP_CHANCE.get(tool, tree) : Option.LEAF_DROP_CHANCE.get(tool, tree);
        for (Modifier mod : modifiers) {
            dropChance = mod.apply(dropChance, tree, block);
        }
        int numDrops = 0;
        while (dropChance >= 1.0) {
            dropChance -= 1.0;
            ++numDrops;
        }
        if (dropChance > 0.0) {
            Random random = new Random();
            if (random.nextDouble() < dropChance) {
                ++numDrops;
            }
        }
        if (numDrops > 0) {
            for (int i = 0; i < numDrops; ++i) {
                int[] blockXP = new int[1];
                drops.addAll(this.getDrops(block, tool, tree, axe, blockXP));
                xp[0] = xp[0] + blockXP[0];
            }
        }
        return drops;
    }

    Collection<? extends ItemStack> getDrops(Block block, Tool tool, Tree tree, ItemStack axe, int[] xp) {
        ArrayList drop;
        boolean silk;
        boolean fortune;
        if (xp.length != 1) {
            throw new IllegalArgumentException("blockXP must be an array of length 1!");
        }
        if (exp.containsKey(block.getType())) {
            xp[0] = xp[0] + this.randbetween(exp.get(block.getType()));
        }
        ArrayList drops = new ArrayList();
        if (tree.trunk.contains(block.getType())) {
            fortune = Option.LOG_FORTUNE.get(tool, tree);
            silk = Option.LOG_SILK_TOUCH.get(tool, tree);
        } else {
            fortune = Option.LEAF_FORTUNE.get(tool, tree);
            silk = Option.LEAF_SILK_TOUCH.get(tool, tree);
        }
        Material type = block.getType();
        if (silk && axe.containsEnchantment(Enchantment.SILK_TOUCH) && (drop = new ArrayList(block.getDrops(axe))).size() == 1 && ((ItemStack)drop.get(0)).getType() == block.getType()) {
            drops.addAll(drop);
            return drops;
        }
        if (fortune && !axe.containsEnchantment(Enchantment.SILK_TOUCH)) {
            drops.addAll(block.getDrops(axe));
        } else {
            drops.addAll(block.getDrops());
        }
        HashMap<Material, Material> conversions = Option.DROP_CONVERSIONS.get(tool, tree);
        if (!conversions.isEmpty()) {
            for (ItemStack s : drops) {
                if (!conversions.containsKey(s.getType())) continue;
                s.setType(conversions.get(s.getType()));
            }
        }
        return drops;
    }

    private void leafCheck(HashMap<Integer, ArrayList<Block>> someLeaves, ArrayList<Material> trunk, ArrayList<Material> leaves, Boolean diagonal, Boolean playerLeaves, Boolean ignoreLeafData) {
        int i;
        if (ignoreLeafData.booleanValue()) {
            return;
        }
        ArrayList<Integer> ints = new ArrayList<Integer>();
        ints.addAll(someLeaves.keySet());
        Collections.sort(ints);
        int done = -1;
        for (i = 0; i < ints.size(); ++i) {
            int d = (Integer)ints.get(i);
            Iterator<Block> it = someLeaves.get(d).iterator();
            while (it.hasNext()) {
                Block leaf = it.next();
                if (this.distance(leaf, trunk, leaves, d, diagonal, playerLeaves) >= d) continue;
                it.remove();
            }
            if (i <= 0 || !someLeaves.get(d).isEmpty()) continue;
            done = i;
            break;
        }
        if (done > -1) {
            for (i = done; i < ints.size(); ++i) {
                someLeaves.remove(ints.get(i));
            }
        }
    }

    ArrayList<ItemStack> getDrops(Material m, Tool tool, Tree tree, ItemStack axe, Block location, int[] xp, List<Modifier> modifiers) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        if (!m.isBlock()) {
            return drops;
        }
        Block block = this.findAir(location);
        if (block == null) {
            drops.add(new ItemStack(m));
            return drops;
        }
        block.setType(m);
        drops.addAll(this.getDropsWithBonus(block, tool, tree, axe, xp, modifiers));
        block.setType(Material.AIR);
        return drops;
    }

    private Block findAir(Block location) {
        if (location.getType() == Material.AIR) {
            return location;
        }
        for (int x = -8; x <= 8; ++x) {
            for (int y = 255; y > 0; --y) {
                for (int z = -1; z <= 8; ++z) {
                    Block b = location.getWorld().getBlockAt(x, y, z);
                    if (b.getType() != Material.AIR) continue;
                    return b;
                }
            }
        }
        this.getLogger().log(Level.SEVERE, "Could not find any nearby air blocks to simulate drops!");
        return null;
    }

    private void processNaturalFalls() {
        for (NaturalFall fall : this.naturalFalls) {
            fall.fall(this);
        }
        this.naturalFalls.clear();
    }

    private void debug(Player player, String text, boolean indent, Object ... vars) {
        Message message = Message.getMessage(text);
        if (message != null) {
            message.send(player, vars);
            text = message.getDebugText();
        }
        for (int i = 0; i < vars.length; ++i) {
            text = text.replace("{" + i + "}", vars[i].toString());
        }
        if (!this.debug) {
            return;
        }
        if (indent) {
            ++this.debugIndent;
        }
        text = "[TreeFeller] " + this.getDebugIndent() + " " + text;
        this.getLogger().log(Level.INFO, text);
        if (player != null) {
            player.sendMessage(text);
        }
    }

    private void debug(Player player, boolean critical, DebugResult result) {
        Message message = Message.getMessage(result.message + result.type.suffix);
        if (message != null) {
            message.send(player, result.args);
            if (!this.debug) {
                return;
            }
            String text = message.getDebugText();
            for (int i = 0; i < result.args.length; ++i) {
                text = text.replace("{" + i + "}", result.args[i].toString());
            }
            if ((critical || !result.isSuccess()) && this.debugIndent > 0) {
                --this.debugIndent;
            }
            String icon = result.isSuccess() ? (critical ? ChatColor.DARK_GREEN : ChatColor.GREEN) + "O" : (critical ? ChatColor.DARK_RED : ChatColor.RED) + "X";
            text = "[TreeFeller] " + this.getDebugIndent(1) + icon + ChatColor.RESET + " " + text;
            this.getLogger().log(Level.INFO, text);
            if (player != null) {
                player.sendMessage(text);
            }
        }
    }

    private void debug(Player player, boolean critical, boolean success, String text, Object ... vars) {
        Message message = Message.getMessage(text);
        if (message != null) {
            message.send(player, vars);
            text = message.getDebugText();
        }
        for (int i = 0; i < vars.length; ++i) {
            text = text.replace("{" + i + "}", vars[i].toString());
        }
        if (!this.debug) {
            return;
        }
        if ((critical || !success) && this.debugIndent > 0) {
            --this.debugIndent;
        }
        String icon = success ? (critical ? ChatColor.DARK_GREEN : ChatColor.GREEN) + "O" : (critical ? ChatColor.DARK_RED : ChatColor.RED) + "X";
        text = "[TreeFeller] " + this.getDebugIndent(1) + icon + ChatColor.RESET + " " + text;
        this.getLogger().log(Level.INFO, text);
        if (player != null) {
            player.sendMessage(text);
        }
    }

    private String getDebugIndent() {
        return this.getDebugIndent(0);
    }

    private String getDebugIndent(int end) {
        String indent = "";
        for (int i = 0; i < this.debugIndent - end + 1; ++i) {
            indent = indent + "-";
        }
        return indent;
    }

    void dropExp(World world, Location location, int xp) {
        while (xp > 2477) {
            this.dropExpOrb(world, location, 2477);
            xp -= 2477;
        }
        while (xp > 1237) {
            this.dropExpOrb(world, location, 1237);
            xp -= 1237;
        }
        while (xp > 617) {
            this.dropExpOrb(world, location, 617);
            xp -= 617;
        }
        while (xp > 307) {
            this.dropExpOrb(world, location, 307);
            xp -= 307;
        }
        while (xp > 149) {
            this.dropExpOrb(world, location, 149);
            xp -= 149;
        }
        while (xp > 73) {
            this.dropExpOrb(world, location, 73);
            xp -= 73;
        }
        while (xp > 37) {
            this.dropExpOrb(world, location, 37);
            xp -= 37;
        }
        while (xp > 17) {
            this.dropExpOrb(world, location, 17);
            xp -= 17;
        }
        while (xp > 7) {
            this.dropExpOrb(world, location, 7);
            xp -= 7;
        }
        while (xp > 3) {
            this.dropExpOrb(world, location, 3);
            xp -= 3;
        }
        while (xp > 1) {
            this.dropExpOrb(world, location, 1);
            --xp;
        }
    }

    public void dropExpOrb(World world, Location location, int xp) {
        ExperienceOrb orb = (ExperienceOrb)world.spawnEntity(location, EntityType.EXPERIENCE_ORB);
        orb.setExperience(orb.getExperience() + xp);
    }

    public static Tree detect(Block clickedBlock, Player player) {
        int numLeaves;
        ArrayList<Material> allLogs = new ArrayList<Material>();
        allLogs.add(Material.OAK_LOG);
        allLogs.add(Material.BIRCH_LOG);
        allLogs.add(Material.SPRUCE_LOG);
        allLogs.add(Material.DARK_OAK_LOG);
        allLogs.add(Material.ACACIA_LOG);
        allLogs.add(Material.JUNGLE_LOG);
        allLogs.add(Material.WARPED_STEM);
        allLogs.add(Material.CRIMSON_STEM);
        allLogs.add(Material.OAK_WOOD);
        allLogs.add(Material.BIRCH_WOOD);
        allLogs.add(Material.SPRUCE_WOOD);
        allLogs.add(Material.DARK_OAK_WOOD);
        allLogs.add(Material.ACACIA_WOOD);
        allLogs.add(Material.JUNGLE_WOOD);
        allLogs.add(Material.WARPED_HYPHAE);
        allLogs.add(Material.CRIMSON_HYPHAE);
        allLogs.add(Material.MUSHROOM_STEM);
        HashMap<Integer, ArrayList<Block>> trunk = TreeFeller.getBlocks(allLogs, clickedBlock, Option.SCAN_DISTANCE.getValue(), Integer.MAX_VALUE, true, true, true);
        HashSet<Material> logs = new HashSet<Material>();
        for (int i : trunk.keySet()) {
            for (Block b : trunk.get(i)) {
                logs.add(b.getType());
            }
        }
        if (logs.isEmpty()) {
            player.sendMessage(ChatColor.RED + "Failed to detect tree trunk");
            return null;
        }
        ArrayList<Material> allLeaves = new ArrayList<Material>();
        allLeaves.add(Material.OAK_LEAVES);
        allLeaves.add(Material.BIRCH_LEAVES);
        allLeaves.add(Material.SPRUCE_LEAVES);
        allLeaves.add(Material.DARK_OAK_LEAVES);
        allLeaves.add(Material.ACACIA_LEAVES);
        allLeaves.add(Material.JUNGLE_LEAVES);
        allLeaves.add(Material.WARPED_WART_BLOCK);
        allLeaves.add(Material.NETHER_WART_BLOCK);
        allLeaves.add(Material.SHROOMLIGHT);
        allLeaves.add(Material.RED_MUSHROOM_BLOCK);
        allLeaves.add(Material.BROWN_MUSHROOM_BLOCK);
        ArrayList<Material> allBlocks = new ArrayList<Material>(logs);
        allBlocks.addAll(allLeaves);
        HashMap<Integer, ArrayList<Block>> properLeaves = TreeFeller.getBlocks(allBlocks, clickedBlock, Option.SCAN_DISTANCE.getValue(), Integer.MAX_VALUE, false, false, false);
        int proper = TreeFeller.getTotal(properLeaves);
        HashMap<Integer, ArrayList<Block>> badLeaves = TreeFeller.getBlocks(allBlocks, clickedBlock, Option.SCAN_DISTANCE.getValue(), Integer.MAX_VALUE, false, true, true);
        int bad = TreeFeller.getTotal(badLeaves);
        HashMap<Integer, ArrayList<Block>> terribleLeaves = TreeFeller.getBlocks(allBlocks, clickedBlock, Option.SCAN_DISTANCE.getValue(), Integer.MAX_VALUE, true, true, true);
        int terrible = TreeFeller.getTotal(terribleLeaves);
        int numLogs = TreeFeller.getTotal(trunk);
        HashSet<Material> leaves = new HashSet<Material>();
        boolean diagonalLeaves = false;
        boolean playerLeaves = false;
        boolean ignoreLeafData = false;
        if (terrible > bad || terrible > proper) {
            numLeaves = terrible - numLogs;
            for (int i : terribleLeaves.keySet()) {
                for (Block b : terribleLeaves.get(i)) {
                    leaves.add(b.getType());
                }
            }
            ignoreLeafData = true;
            playerLeaves = true;
            diagonalLeaves = true;
        } else if (bad > proper) {
            numLeaves = bad - numLogs;
            for (int i : badLeaves.keySet()) {
                for (Block b : badLeaves.get(i)) {
                    leaves.add(b.getType());
                }
            }
            ignoreLeafData = true;
            playerLeaves = true;
        } else {
            numLeaves = proper - numLogs;
            for (int i : properLeaves.keySet()) {
                for (Block b : properLeaves.get(i)) {
                    leaves.add(b.getType());
                }
            }
        }
        leaves.removeAll(logs);
        Tree tree = new Tree(new ArrayList<Material>(logs), new ArrayList<Material>(leaves));
        if (numLogs < Option.REQUIRED_LOGS.getValue()) {
            Option.REQUIRED_LOGS.treeValues.put(tree, numLogs / 4);
        }
        if (numLogs > Option.MAX_LOGS.getValue()) {
            Option.MAX_LOGS.treeValues.put(tree, numLogs * 2);
        }
        if (numLeaves < Option.REQUIRED_LEAVES.getValue()) {
            Option.REQUIRED_LEAVES.treeValues.put(tree, numLeaves / 4);
        }
        if (diagonalLeaves || Objects.equals(Option.DIAGONAL_LEAVES.getValue(), true)) {
            Option.DIAGONAL_LEAVES.treeValues.put(tree, diagonalLeaves);
        }
        if (playerLeaves || Objects.equals(Option.PLAYER_LEAVES.getValue(), true)) {
            Option.PLAYER_LEAVES.treeValues.put(tree, playerLeaves);
        }
        if (ignoreLeafData || Objects.equals(Option.IGNORE_LEAF_DATA.getValue(), true)) {
            Option.IGNORE_LEAF_DATA.treeValues.put(tree, ignoreLeafData);
        }
        ArrayList<Integer> distances = new ArrayList<Integer>(trunk.keySet());
        Collections.sort(distances);
        int theLeafRange = 0;
        int lastCount = 0;
        int leafRange = 1;
        while (leafRange < Option.SCAN_DISTANCE.getValue()) {
            HashSet allDaLeaves = new HashSet();
            for (int i : distances) {
                for (Block b : trunk.get(i)) {
                    HashMap<Integer, ArrayList<Block>> someLeaves = TreeFeller.getBlocks(tree.leaves, b, leafRange, Integer.MAX_VALUE, diagonalLeaves, playerLeaves, ignoreLeafData);
                    for (int in : someLeaves.keySet()) {
                        allDaLeaves.addAll(someLeaves.get(in));
                    }
                }
            }
            if (allDaLeaves.size() == lastCount) break;
            theLeafRange = leafRange++;
            lastCount = allDaLeaves.size();
        }
        if (theLeafRange > Option.LEAF_DETECT_RANGE.getValue()) {
            Option.LEAF_DETECT_RANGE.treeValues.put(tree, theLeafRange);
        }
        return tree;
    }

    private void createSaplingHandler() {
        if (this.saplingHandler != null) {
            return;
        }
        this.saplingHandler = new BukkitRunnable(){

            public void run() {
                Iterator<Sapling> it = TreeFeller.this.saplings.iterator();
                while (it.hasNext()) {
                    Sapling sapling = it.next();
                    sapling.tick();
                    if (!sapling.isDead()) continue;
                    it.remove();
                }
                if (TreeFeller.this.saplings.isEmpty()) {
                    TreeFeller.this.saplingHandler = null;
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)this, 0L, 1L);
    }

    public void dropItem(DetectedTree detectedTree, Player player, Item item) {
        ItemStack stack = item.getItemStack();
        if (Option.USE_TREE_SAPLINGS.get(detectedTree.tool, detectedTree.tree).booleanValue()) {
            for (Sapling sapling : this.saplings) {
                if (sapling.detectedTree != detectedTree || !sapling.tryPlace(stack) || stack.getAmount() != 0) continue;
                item.remove();
                return;
            }
        }
        item.setItemStack(stack);
        TreeFellerCompat.dropItem(this, player, item);
    }

    public boolean isToggledOn(Player player) {
        boolean inverted = Option.DEFAULT_ENABLED.isTrue();
        boolean toggled = this.toggledPlayers.contains(player.getUniqueId());
        return inverted ? !toggled : toggled;
    }

    public void toggle(Player player) {
        boolean on = this.isToggledOn(player);
        this.toggle(player, !on);
    }

    public void toggle(Player player, boolean state) {
        boolean inverted = Option.DEFAULT_ENABLED.isTrue();
        boolean shouldBeToggled = inverted ? !state : state;
        UUID uuid = player.getUniqueId();
        if (this.toggledPlayers.contains(uuid)) {
            if (!shouldBeToggled) {
                this.toggledPlayers.remove(uuid);
            }
        } else if (shouldBeToggled) {
            this.toggledPlayers.add(uuid);
        }
        Message.getMessage("toggle-" + (state ? "on" : "off")).send(player, new Object[0]);
    }

    private void refreshPatronsList() {
        try {
            File file = new File(this.getDataFolder(), "patrons.txt");
            file.delete();
            TreeFeller.downloadFile("https://raw.githubusercontent.com/ThizThizzyDizzy/nc-reactor-generator/overhaul/patrons.txt", file.getAbsoluteFile());
            ArrayList<String> patrons = new ArrayList<String>();
            try (BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(file)));){
                String line;
                while ((line = in.readLine()) != null) {
                    if (line.isEmpty()) continue;
                    patrons.add(line);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!patrons.isEmpty()) {
                this.patrons.clear();
                this.patrons.addAll(patrons);
            }
            file.delete();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static File downloadFile(String link, File destinationFile) {
        if (destinationFile.exists() || link == null) {
            return destinationFile;
        }
        if (destinationFile.getParentFile() != null) {
            destinationFile.getParentFile().mkdirs();
        }
        try {
            URL url = new URL(link);
            URLConnection connection = url.openConnection();
            connection.setDefaultUseCaches(false);
            if (connection instanceof HttpURLConnection) {
                ((HttpURLConnection)connection).setRequestMethod("HEAD");
                int code = ((HttpURLConnection)connection).getResponseCode();
                if (code / 100 == 3) {
                    return null;
                }
            }
            int fileSize = connection.getContentLength();
            byte[] buffer = new byte[65535];
            int unsuccessfulAttempts = 0;
            int maxUnsuccessfulAttempts = 3;
            boolean downloadFile = true;
            while (downloadFile) {
                int downloadedFileSize;
                FileOutputStream fos;
                downloadFile = false;
                URLConnection urlconnection = url.openConnection();
                if (urlconnection instanceof HttpURLConnection) {
                    urlconnection.setRequestProperty("Cache-Control", "no-cache");
                    urlconnection.connect();
                }
                String targetFile = destinationFile.getName();
                try (InputStream inputstream = TreeFeller.getRemoteInputStream(targetFile, urlconnection);){
                    int read;
                    fos = new FileOutputStream(destinationFile);
                    downloadedFileSize = 0;
                    while ((read = inputstream.read(buffer)) != -1) {
                        fos.write(buffer, 0, read);
                        downloadedFileSize += read;
                    }
                }
                fos.close();
                if (!(urlconnection instanceof HttpURLConnection) || downloadedFileSize == fileSize || fileSize <= 0) continue;
                if (++unsuccessfulAttempts < maxUnsuccessfulAttempts) {
                    downloadFile = true;
                    continue;
                }
                throw new Exception("failed to download " + targetFile);
            }
            return destinationFile;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static InputStream getRemoteInputStream(String currentFile, final URLConnection urlconnection) throws Exception {
        final InputStream[] is = new InputStream[1];
        for (int j = 0; j < 3 && is[0] == null; ++j) {
            Thread t = new Thread(){

                @Override
                public void run() {
                    try {
                        is[0] = urlconnection.getInputStream();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            };
            t.setName("FileDownloadStreamThread");
            t.start();
            int iterationCount = 0;
            while (is[0] == null && iterationCount++ < 5) {
                try {
                    t.join(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (is[0] != null) continue;
            try {
                t.interrupt();
                t.join();
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (is[0] == null) {
            throw new Exception("Unable to download " + currentFile);
        }
        return is[0];
    }

    private void playToolBreakEffect(Tool tool, Tree tree, ItemStack axe, Player player, Block block) {
        player.playEffect(EntityEffect.BREAK_EQUIPMENT_MAIN_HAND);
        for (Effect e : Option.EFFECTS.get(tool, tree)) {
            if (e.location != Effect.EffectLocation.TOOL_BREAK) continue;
            Random random = new Random();
            if (!(random.nextDouble() < e.chance)) continue;
            e.play(block);
        }
    }

    private void log(Logger logger, CommandSender source, Level level, String message, Object ... params) {
        logger.log(level, message, params);
        if (source != null) {
            ChatColor color = ChatColor.RESET;
            if (level == Level.INFO) {
                return;
            }
            if (level == Level.WARNING) {
                color = ChatColor.YELLOW;
            }
            if (level == Level.SEVERE) {
                color = ChatColor.RED;
            }
            for (int i = 0; i < params.length; ++i) {
                message = message.replace("{" + i + "}", Objects.toString(params[i]));
            }
            source.sendMessage("[TreeFeller] " + color + message);
        }
    }

    static {
        exp.put(Material.COAL_ORE, new int[]{0, 2});
        exp.put(Material.NETHER_GOLD_ORE, new int[]{0, 1});
        exp.put(Material.DIAMOND_ORE, new int[]{3, 7});
        exp.put(Material.EMERALD_ORE, new int[]{3, 7});
        exp.put(Material.LAPIS_ORE, new int[]{2, 5});
        exp.put(Material.NETHER_QUARTZ_ORE, new int[]{2, 5});
        exp.put(Material.REDSTONE_ORE, new int[]{1, 5});
        exp.put(Material.SPAWNER, new int[]{15, 43});
    }
}

