/*
 * Decompiled with CFR 0.152.
 */
package com.thizthizzydizzy.treefeller;

import com.thizthizzydizzy.treefeller.Option;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.Material;

public class Tree {
    public final ArrayList<Material> trunk;
    public final ArrayList<Material> leaves;

    public Tree(ArrayList<Material> trunk, ArrayList<Material> leaves) {
        this.trunk = trunk;
        this.leaves = leaves;
    }

    public void print(Logger logger) {
        String trunks = "";
        for (Material m : this.trunk) {
            trunks = trunks + m + ", ";
        }
        if (!trunks.isEmpty()) {
            trunks = trunks.substring(0, trunks.length() - 2);
        }
        String leaveses = "";
        for (Material m : this.leaves) {
            leaveses = leaveses + m + ", ";
        }
        if (!leaveses.isEmpty()) {
            leaveses = leaveses.substring(0, leaveses.length() - 2);
        }
        logger.log(Level.INFO, "Loaded Tree!");
        logger.log(Level.INFO, "- Trunk: {0}", trunks);
        logger.log(Level.INFO, "- Leaves: {0}", leaveses);
        for (Option option : Option.options) {
            Object value = option.getValue(this);
            if (value == null) continue;
            logger.log(Level.INFO, "- {0}: {1}", new Object[]{option.name, option.makeReadable(value)});
        }
    }

    public Material getDisplayMaterial() {
        if (this.trunk.isEmpty()) {
            if (this.leaves.isEmpty()) {
                return Material.BEDROCK;
            }
            return this.leaves.get(0);
        }
        return this.trunk.get(0);
    }

    public String writeToConfig() {
        String str = "[" + this.trunk.toString() + ", " + this.leaves.toString();
        String options = "";
        for (Option o : Option.options) {
            if (o.getValue(this) == null) continue;
            options = options + ", " + o.getGlobalName() + ": " + o.writeToConfig(this);
        }
        if (!options.isEmpty()) {
            str = str + ", {" + options.substring(2) + "}";
        }
        return str + "]";
    }
}

