/*
 * Decompiled with CFR 0.152.
 */
package com.thizthizzydizzy.treefeller;

import com.thizthizzydizzy.treefeller.DetectedTree;
import com.thizthizzydizzy.treefeller.TreeFeller;
import com.thizthizzydizzy.treefeller.compat.TreeFellerCompat;
import java.util.ArrayList;
import java.util.HashSet;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;

public class Sapling {
    public final boolean spawn;
    private final TreeFeller treefeller;
    public final DetectedTree detectedTree;
    private final Player player;
    public final Block block;
    private final HashSet<Material> materials;
    private final int timeout;
    private int timer;
    private boolean placed = false;

    public Sapling(TreeFeller treefeller, DetectedTree detectedTree, Player player, Block block, HashSet<Material> materials, boolean spawn, int timeout) {
        this.treefeller = treefeller;
        this.detectedTree = detectedTree;
        this.player = player;
        this.block = block;
        this.materials = materials;
        this.spawn = spawn;
        this.timeout = timeout;
    }

    public boolean isDead() {
        if (this.materials.contains(this.block.getType())) {
            this.placed = true;
        }
        return this.placed || this.timer > this.timeout;
    }

    public void tick() {
        ++this.timer;
        if (this.player != null) {
            ItemStack content;
            PlayerInventory inv = this.player.getInventory();
            ItemStack[] contents = inv.getContents();
            for (int i = 0; i < contents.length && !this.tryPlace(content = contents[i]); ++i) {
            }
        }
        if (this.timer == this.timeout && this.spawn) {
            this.place(null);
        }
    }

    public boolean canPlace() {
        if (this.isDead()) {
            return false;
        }
        return this.block.getType() == Material.AIR;
    }

    public boolean place(Material material) {
        if (!this.canPlace()) {
            return false;
        }
        this.placed = true;
        if (material == null) {
            material = new ArrayList<Material>(this.materials).get(0);
        }
        BlockState was = this.block.getState();
        this.block.setType(material);
        TreeFellerCompat.addBlock(this.treefeller, this.player, this.block, was);
        return true;
    }

    public boolean tryPlace(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        if (this.materials.contains(stack.getType()) && this.place(stack.getType())) {
            stack.setAmount(stack.getAmount() - 1);
            return true;
        }
        return false;
    }
}

