/*
 * Decompiled with CFR 0.152.
 */
package com.thizthizzydizzy.treefeller;

import com.thizthizzydizzy.treefeller.Option;
import com.thizthizzydizzy.treefeller.Tool;
import com.thizthizzydizzy.treefeller.Tree;
import com.thizthizzydizzy.treefeller.menu.MenuGlobalConfiguration;
import com.thizthizzydizzy.treefeller.menu.MenuToolConfiguration;
import com.thizthizzydizzy.treefeller.menu.MenuTreeConfiguration;
import com.thizthizzydizzy.treefeller.menu.modify.MenuModifyBoolean;
import java.util.Objects;

public abstract class OptionBoolean
extends Option<Boolean> {
    public OptionBoolean(String name, boolean global, boolean tool, boolean tree, Boolean defaultValue) {
        super(name, global, tool, tree, defaultValue);
    }

    public OptionBoolean(String name, boolean global, boolean tool, boolean tree, Boolean defaultValue, Object defaultConfigValue) {
        super(name, global, tool, tree, defaultValue, defaultConfigValue);
    }

    @Override
    public Boolean load(Object o) {
        if (o instanceof String) {
            Boolean.valueOf((String)o);
        }
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        if (o instanceof Number) {
            return ((Number)o).intValue() >= 1;
        }
        return null;
    }

    @Override
    public Boolean get(Tool tool, Tree tree) {
        if (this.toolValues.containsKey(tool) || this.treeValues.containsKey(tree)) {
            return Objects.equals(this.toolValues.get(tool), true) || Objects.equals(this.treeValues.get(tree), true);
        }
        return Objects.equals(this.globalValue, true) || Objects.equals(this.toolValues.get(tool), true) || Objects.equals(this.treeValues.get(tree), true);
    }

    @Override
    public void setValue(Boolean value) {
        if (value == null) {
            value = (Boolean)this.defaultValue;
        }
        super.setValue(value);
    }

    public boolean isTrue() {
        return Objects.equals(this.getValue(), true);
    }

    @Override
    public void openGlobalModifyMenu(MenuGlobalConfiguration parent) {
        parent.open(new MenuModifyBoolean(parent, parent.plugin, parent.player, this.name, false, (Boolean)this.globalValue, value -> {
            this.globalValue = value;
        }));
    }

    @Override
    public void openToolModifyMenu(MenuToolConfiguration parent, Tool tool) {
        parent.open(new MenuModifyBoolean(parent, parent.plugin, parent.player, this.name, true, (Boolean)this.toolValues.get(tool), value -> {
            if (value == null) {
                this.toolValues.remove(tool);
            } else {
                this.toolValues.put(tool, value);
            }
        }));
    }

    @Override
    public void openTreeModifyMenu(MenuTreeConfiguration parent, Tree tree) {
        parent.open(new MenuModifyBoolean(parent, parent.plugin, parent.player, this.name, true, (Boolean)this.treeValues.get(tree), value -> {
            if (value == null) {
                this.treeValues.remove(tree);
            } else {
                this.treeValues.put(tree, value);
            }
        }));
    }
}

