/*
 * Decompiled with CFR 0.152.
 */
package com.thizthizzydizzy.treefeller;

import com.thizthizzydizzy.simplegui.ItemBuilder;
import com.thizthizzydizzy.treefeller.Cooldown;
import com.thizthizzydizzy.treefeller.DebugResult;
import com.thizthizzydizzy.treefeller.DirectionalFallBehavior;
import com.thizthizzydizzy.treefeller.Effect;
import com.thizthizzydizzy.treefeller.FellBehavior;
import com.thizthizzydizzy.treefeller.OptionBoolean;
import com.thizthizzydizzy.treefeller.Tool;
import com.thizthizzydizzy.treefeller.Tree;
import com.thizthizzydizzy.treefeller.TreeFeller;
import com.thizthizzydizzy.treefeller.decoration.AdjacentDecorationDetector;
import com.thizthizzydizzy.treefeller.decoration.DecorationDetector;
import com.thizthizzydizzy.treefeller.menu.MenuGlobalConfiguration;
import com.thizthizzydizzy.treefeller.menu.MenuToolConfiguration;
import com.thizthizzydizzy.treefeller.menu.MenuTreeConfiguration;
import com.thizthizzydizzy.treefeller.menu.modify.MenuModifyDouble;
import com.thizthizzydizzy.treefeller.menu.modify.MenuModifyEnchantmentMap;
import com.thizthizzydizzy.treefeller.menu.modify.MenuModifyEnumSet;
import com.thizthizzydizzy.treefeller.menu.modify.MenuModifyFloat;
import com.thizthizzydizzy.treefeller.menu.modify.MenuModifyInteger;
import com.thizthizzydizzy.treefeller.menu.modify.MenuModifyMaterialMaterialMap;
import com.thizthizzydizzy.treefeller.menu.modify.MenuModifyMaterialSet;
import com.thizthizzydizzy.treefeller.menu.modify.MenuModifyShort;
import com.thizthizzydizzy.treefeller.menu.modify.MenuModifyStringList;
import com.thizthizzydizzy.treefeller.menu.modify.MenuModifyStringSet;
import com.thizthizzydizzy.treefeller.menu.modify.special.MenuModifyDirectionalFallBehavior;
import com.thizthizzydizzy.treefeller.menu.modify.special.MenuModifyEffectList;
import com.thizthizzydizzy.treefeller.menu.modify.special.MenuModifyFellBehavior;
import com.thizthizzydizzy.treefeller.menu.modify.special.MenuModifySpawnSaplings;
import com.thizthizzydizzy.treefeller.menu.modify.special.MenuModifyTreeSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.bukkit.Axis;
import org.bukkit.ChatColor;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Orientable;
import org.bukkit.configuration.MemorySection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public abstract class Option<E> {
    private static final HashSet<Material> defaultOverridables = new HashSet();
    private static final HashSet<Material> defaultGrasses = new HashSet();
    private static final HashMap<Material, Material> defaultDropConversions = new HashMap();
    private static final HashMap<Material, Material> defaultBlockConversions = new HashMap();
    public static ArrayList<Option> options;
    public static OptionBoolean STARTUP_LOGS;
    public static OptionBoolean DEFAULT_ENABLED;
    public static Option<Integer> SCAN_DISTANCE;
    public static Option<Integer> LEAF_DETECT_RANGE;
    public static Option<Integer> LEAF_BREAK_RANGE;
    public static Option<Integer> REQUIRED_LOGS;
    public static Option<Integer> REQUIRED_LEAVES;
    public static Option<Integer> MAX_LOGS;
    public static Option<Integer> MAX_HEIGHT;
    public static OptionBoolean ALLOW_PARTIAL;
    public static OptionBoolean ALLOW_PARTIAL_TOOL;
    public static OptionBoolean PLAYER_LEAVES;
    public static OptionBoolean DIAGONAL_LEAVES;
    public static OptionBoolean IGNORE_LEAF_DATA;
    public static OptionBoolean REQUIRE_CROSS_SECTION;
    public static OptionBoolean FORCE_DISTANCE_CHECK;
    public static Option<ArrayList<DecorationDetector>> DECORATIONS;
    public static Option<HashSet<Material>> BANNED_LOGS;
    public static Option<HashSet<Material>> BANNED_LEAVES;
    public static Option<Integer> MAX_HORIZONTAL_TRUNK_PILLAR_LENGTH;
    public static Option<Integer> MAX_TRUNKS;
    public static Option<Double> MIN_HEIGHT_RATIO;
    public static Option<Double> MAX_HEIGHT_RATIO;
    public static Option<Double> MIN_VERTICAL_LOG_RATIO;
    public static Option<Double> MAX_VERTICAL_LOG_RATIO;
    public static OptionBoolean CUTTING_ANIMATION;
    public static Option<Integer> ANIM_DELAY;
    public static OptionBoolean REPLANT_SAPLINGS;
    public static OptionBoolean USE_TREE_SAPLINGS;
    public static OptionBoolean USE_INVENTORY_SAPLINGS;
    public static Option<Integer> SPAWN_SAPLINGS;
    public static Option<HashSet<Material>> SAPLING;
    public static Option<Integer> SAPLING_TIMEOUT;
    public static Option<Integer> MAX_SAPLINGS;
    public static Option<HashSet<Material>> GRASS;
    public static Option<HashSet<Material>> ROOTS;
    public static Option<Integer> ROOT_DISTANCE;
    public static Option<FellBehavior> LOG_BEHAVIOR;
    public static Option<FellBehavior> LEAF_BEHAVIOR;
    public static Option<Float> FALL_HURT_AMOUNT;
    public static Option<Integer> FALL_HURT_MAX;
    public static Option<DirectionalFallBehavior> DIRECTIONAL_FALL_BEHAVIOR;
    public static Option<HashSet<Material>> OVERRIDABLES;
    public static OptionBoolean LOCK_FALL_CARDINAL;
    public static Option<Double> DIRECTIONAL_FALL_VELOCITY;
    public static Option<Double> VERTICAL_FALL_VELOCITY;
    public static Option<Double> EXPLOSIVE_FALL_VELOCITY;
    public static Option<Double> RANDOM_FALL_VELOCITY;
    public static Option<Integer> FALL_DELAY;
    public static OptionBoolean RESPECT_UNBREAKING;
    public static OptionBoolean RESPECT_UNBREAKABLE;
    public static Option<Double> DAMAGE_MULT;
    public static OptionBoolean STACKED_TOOLS;
    public static OptionBoolean LEAF_FORTUNE;
    public static OptionBoolean LEAF_SILK_TOUCH;
    public static OptionBoolean LOG_FORTUNE;
    public static OptionBoolean LOG_SILK_TOUCH;
    public static OptionBoolean LEAVE_STUMP;
    public static OptionBoolean ROTATE_LOGS;
    public static Option<HashMap<Material, Material>> DROP_CONVERSIONS;
    public static Option<HashMap<Material, Material>> BLOCK_CONVERSIONS;
    public static Option<Double> LEAF_DROP_CHANCE;
    public static Option<Double> LOG_DROP_CHANCE;
    public static Option<ArrayList<Effect>> EFFECTS;
    public static Option<Double> CONSUMED_FOOD_BASE;
    public static Option<Double> CONSUMED_FOOD_LOGS;
    public static Option<Double> CONSUMED_FOOD_LEAVES;
    public static Option<Double> CONSUMED_HEALTH_BASE;
    public static Option<Double> CONSUMED_HEALTH_LOGS;
    public static Option<Double> CONSUMED_HEALTH_LEAVES;
    public static Option<HashMap<Enchantment, Integer>> REQUIRED_ENCHANTMENTS;
    public static Option<HashMap<Enchantment, Integer>> BANNED_ENCHANTMENTS;
    public static Option<Short> MIN_DURABILITY;
    public static Option<Short> MAX_DURABILITY;
    public static Option<Float> MIN_DURABILITY_PERCENT;
    public static Option<Float> MAX_DURABILITY_PERCENT;
    public static OptionBoolean PREVENT_BREAKAGE;
    public static Option<ArrayList<String>> REQUIRED_LORE;
    public static Option<String> REQUIRED_NAME;
    public static Option<HashSet<String>> REQUIRED_PERMISSIONS;
    public static Option<Integer> MIN_TIME;
    public static Option<Integer> MAX_TIME;
    public static Option<Integer> MIN_PHASE;
    public static Option<Integer> MAX_PHASE;
    public static Option<Integer> MIN_FOOD;
    public static Option<Integer> MAX_FOOD;
    public static Option<Double> MIN_HEALTH;
    public static Option<Double> MAX_HEALTH;
    public static Option<Integer> CUSTOM_MODEL_DATA;
    public static Option<ArrayList<Tree>> ALLOWED_TREES;
    public static OptionBoolean ENABLE_ADVENTURE;
    public static OptionBoolean ENABLE_SURVIVAL;
    public static OptionBoolean ENABLE_CREATIVE;
    public static OptionBoolean WITH_SNEAK;
    public static OptionBoolean WITHOUT_SNEAK;
    public static Option<HashSet<String>> WORLDS;
    public static OptionBoolean WORLD_BLACKLIST;
    public static Option<Integer> COOLDOWN;
    public static OptionBoolean CASCADE;
    public static Option<Integer> PARALLEL_CASCADE_LIMIT;
    public static Option<Integer> CASCADE_CHECK_LIMIT;
    public static Option<ArrayList<Tree>> CASCADE_TREES;
    protected final String name;
    public final boolean global;
    public final boolean tool;
    public final boolean tree;
    public final E defaultValue;
    public E globalValue;
    public HashMap<Tool, E> toolValues = new HashMap();
    public HashMap<Tree, E> treeValues = new HashMap();
    private final Object defaultConfigValue;

    protected Option(String name, boolean global, boolean tool, boolean tree, E defaultValue) {
        this(name, global, tool, tree, defaultValue, defaultValue);
    }

    protected Option(String name, boolean global, boolean tool, boolean tree, E defaultValue, Object defaultConfigValue) {
        this.name = name;
        this.global = global;
        this.tool = tool;
        this.tree = tree;
        this.defaultValue = defaultValue;
        options.add(this);
        this.defaultConfigValue = defaultConfigValue;
    }

    public String getFriendlyName() {
        return this.name;
    }

    public ArrayList<String> getDescription(boolean ingame) {
        ArrayList<String> description = new ArrayList<String>();
        String s = this.getDesc(ingame);
        if (s == null) {
            return description;
        }
        if (s.contains("\n")) {
            for (String str : s.split("\n")) {
                description.add(str);
            }
        } else {
            description.add(s);
        }
        return description;
    }

    public abstract String getDesc(boolean var1);

    public String getGlobalName() {
        return this.name.replace(" ", "-").toLowerCase();
    }

    public String getLocalName() {
        return this.name.replace(" ", "").toLowerCase();
    }

    public abstract E load(Object var1);

    public E loadFromConfig(FileConfiguration config) {
        return this.load(config.get(this.getGlobalName()));
    }

    public static HashSet<Material> loadMaterialSet(Object o) {
        if (o instanceof Iterable) {
            HashSet<Material> materials = new HashSet<Material>();
            for (Object ob : (Iterable)o) {
                HashSet<Material> newMaterials = Option.loadMaterialSet(ob);
                if (newMaterials == null) continue;
                materials.addAll(newMaterials);
            }
            return materials;
        }
        HashSet<Material> materials = new HashSet<Material>();
        Material m = Option.loadMaterial(o);
        if (m == null) {
            return null;
        }
        materials.add(m);
        return materials;
    }

    public static Material loadMaterial(Object o) {
        if (o instanceof Material) {
            return (Material)o;
        }
        if (o instanceof String) {
            return Material.matchMaterial((String)((String)o));
        }
        return null;
    }

    public ArrayList<E> loadList(Object o) {
        if (o instanceof Iterable) {
            ArrayList<E> list = new ArrayList<E>();
            for (Object ob : (Iterable)o) {
                E item = this.load(ob);
                if (item == null) continue;
                list.add(item);
            }
            return list;
        }
        return null;
    }

    public static String loadString(Object o) {
        if (o == null) {
            return null;
        }
        return o.toString();
    }

    public static Integer loadInt(Object o) {
        if (o instanceof Number) {
            return ((Number)o).intValue();
        }
        if (o instanceof String) {
            try {
                return Integer.parseInt((String)o);
            }
            catch (NumberFormatException ex) {
                return null;
            }
        }
        return null;
    }

    public static Short loadShort(Object o) {
        if (o instanceof Number) {
            return ((Number)o).shortValue();
        }
        if (o instanceof String) {
            try {
                return Short.parseShort((String)o);
            }
            catch (NumberFormatException ex) {
                return null;
            }
        }
        return null;
    }

    public static Long loadLong(Object o) {
        if (o instanceof Number) {
            return ((Number)o).longValue();
        }
        if (o instanceof String) {
            try {
                return Long.parseLong((String)o);
            }
            catch (NumberFormatException ex) {
                return null;
            }
        }
        return null;
    }

    public static Float loadFloat(Object o) {
        if (o instanceof Number) {
            return Float.valueOf(((Number)o).floatValue());
        }
        if (o instanceof String) {
            try {
                return Float.valueOf(Float.parseFloat((String)o));
            }
            catch (NumberFormatException ex) {
                return null;
            }
        }
        return null;
    }

    public static Double loadDouble(Object o) {
        if (o instanceof Number) {
            return ((Number)o).doubleValue();
        }
        if (o instanceof String) {
            try {
                return Double.parseDouble((String)o);
            }
            catch (NumberFormatException ex) {
                return null;
            }
        }
        return null;
    }

    protected String makeReadable(E value) {
        return value.toString();
    }

    public void setValue(E value) {
        this.globalValue = value;
    }

    public void setValue(Tree tree, E value) {
        this.treeValues.put(tree, value);
    }

    public void setValue(Tool tool, E value) {
        this.toolValues.put(tool, value);
    }

    public E getValue() {
        return this.globalValue;
    }

    public E getValue(Tree tree) {
        return this.treeValues.get(tree);
    }

    public E getValue(Tool tool) {
        return this.toolValues.get(tool);
    }

    public final DebugResult check(TreeFeller plugin, Tool tool, Tree tree, Block block, Player player, ItemStack axe) {
        if (this.globalValue == null && !this.treeValues.containsKey(tree) && !this.toolValues.containsKey(tool)) {
            return null;
        }
        return this.doCheck(plugin, tool, tree, block, player, axe);
    }

    public final DebugResult checkTrunk(TreeFeller plugin, Tool tool, Tree tree, HashMap<Integer, ArrayList<Block>> blocks, Block block) {
        if (this.globalValue == null && !this.treeValues.containsKey(tree) && !this.toolValues.containsKey(tool)) {
            return null;
        }
        return this.doCheckTrunk(plugin, tool, tree, blocks, block);
    }

    public final DebugResult checkTree(TreeFeller plugin, Tool tool, Tree tree, HashMap<Integer, ArrayList<Block>> blocks, int leaves) {
        if (this.globalValue == null && !this.treeValues.containsKey(tree) && !this.toolValues.containsKey(tool)) {
            return null;
        }
        return this.doCheckTree(plugin, tool, tree, blocks, leaves);
    }

    protected DebugResult doCheck(TreeFeller plugin, Tool tool, Tree tree, Block block, Player player, ItemStack axe) {
        return null;
    }

    protected DebugResult doCheckTrunk(TreeFeller plugin, Tool tool, Tree tree, HashMap<Integer, ArrayList<Block>> blocks, Block block) {
        return null;
    }

    protected DebugResult doCheckTree(TreeFeller plugin, Tool tool, Tree tree, HashMap<Integer, ArrayList<Block>> blocks, int leaves) {
        return null;
    }

    private static Enchantment getEnchantment(String string) {
        switch (string.toLowerCase().replaceAll("_", " ")) {
            case "power": 
            case "arrow damage": {
                return Enchantment.ARROW_DAMAGE;
            }
            case "flame": 
            case "arrow fire": {
                return Enchantment.ARROW_FIRE;
            }
            case "arrow infinite": 
            case "infinity": {
                return Enchantment.ARROW_INFINITE;
            }
            case "arrow knockback": 
            case "punch": {
                return Enchantment.ARROW_KNOCKBACK;
            }
            case "binding": 
            case "binding curse": 
            case "curse of binding": {
                return Enchantment.BINDING_CURSE;
            }
            case "channeling": {
                return Enchantment.CHANNELING;
            }
            case "sharpness": 
            case "damage all": {
                return Enchantment.DAMAGE_ALL;
            }
            case "damage arthropods": 
            case "bane of arthropods": {
                return Enchantment.DAMAGE_ARTHROPODS;
            }
            case "damage undead": 
            case "smite": {
                return Enchantment.DAMAGE_UNDEAD;
            }
            case "depth strider": {
                return Enchantment.DEPTH_STRIDER;
            }
            case "efficiency": 
            case "dig speed": {
                return Enchantment.DIG_SPEED;
            }
            case "durability": 
            case "unbreaking": {
                return Enchantment.DURABILITY;
            }
            case "fire aspect": {
                return Enchantment.FIRE_ASPECT;
            }
            case "frost walker": {
                return Enchantment.FROST_WALKER;
            }
            case "impaling": {
                return Enchantment.IMPALING;
            }
            case "knockback": {
                return Enchantment.KNOCKBACK;
            }
            case "fortune": 
            case "loot bonus blocks": {
                return Enchantment.LOOT_BONUS_BLOCKS;
            }
            case "looting": 
            case "loot bonus mobs": {
                return Enchantment.LOOT_BONUS_MOBS;
            }
            case "loyalty": {
                return Enchantment.LOYALTY;
            }
            case "luck": 
            case "luck of the sea": {
                return Enchantment.LUCK;
            }
            case "lure": {
                return Enchantment.LURE;
            }
            case "mending": {
                return Enchantment.MENDING;
            }
            case "oxygen": 
            case "respiration": {
                return Enchantment.OXYGEN;
            }
            case "protection environmental": 
            case "protection": {
                return Enchantment.PROTECTION_ENVIRONMENTAL;
            }
            case "protection explosions": 
            case "blast protection": {
                return Enchantment.PROTECTION_EXPLOSIONS;
            }
            case "protection fall": 
            case "feather falling": 
            case "feather fall": {
                return Enchantment.PROTECTION_FALL;
            }
            case "protection fire": 
            case "fire protection": {
                return Enchantment.PROTECTION_FIRE;
            }
            case "protection projectile": 
            case "projectile protection": {
                return Enchantment.PROTECTION_PROJECTILE;
            }
            case "riptide": {
                return Enchantment.RIPTIDE;
            }
            case "silk touch": {
                return Enchantment.SILK_TOUCH;
            }
            case "sweeping": 
            case "sweeping edge": {
                return Enchantment.SWEEPING_EDGE;
            }
            case "thorns": {
                return Enchantment.THORNS;
            }
            case "vanishing": 
            case "vanishing curse": 
            case "curse of vanishing": {
                return Enchantment.VANISHING_CURSE;
            }
            case "water worker": 
            case "aqua affinity": {
                return Enchantment.WATER_WORKER;
            }
        }
        if (string.contains(":")) {
            String[] strs = string.split("\\:");
            return Enchantment.getByKey((NamespacedKey)new NamespacedKey(strs[0], strs[1]));
        }
        return Enchantment.getByName((String)string);
    }

    public E get(Tool tool, Tree tree) {
        if (this.toolValues.containsKey(tool)) {
            return this.toolValues.get(tool);
        }
        if (this.treeValues.containsKey(tree)) {
            return this.treeValues.get(tree);
        }
        return this.globalValue;
    }

    private static int getTotal(HashMap<Integer, ArrayList<Block>> blocks) {
        int total = 0;
        for (int i : blocks.keySet()) {
            total += blocks.get(i).size();
        }
        return total;
    }

    public String getDefaultConfigValue() {
        if (this.defaultConfigValue == null) {
            return null;
        }
        if (this.defaultConfigValue instanceof HashSet) {
            HashSet hs = (HashSet)this.defaultConfigValue;
            String str = "";
            ArrayList<String> lst = new ArrayList<String>();
            for (Object o : hs) {
                lst.add(Objects.toString(o));
            }
            Collections.sort(lst);
            for (String s : lst) {
                str = str + "\n    - " + s;
            }
            return str;
        }
        return this.defaultConfigValue.toString();
    }

    public boolean hasDebugText() {
        return this.getGlobalDebugText() != null || this.getToolDebugText() != null || this.getTreeDebugText() != null || this.getSuccessDebugText() != null;
    }

    public String[] getDebugText() {
        return new String[]{null, null, null, null};
    }

    public String getGlobalDebugText() {
        return this.getDebugText()[0];
    }

    public String getToolDebugText() {
        return this.getDebugText()[1];
    }

    public String getTreeDebugText() {
        return this.getDebugText()[2];
    }

    public String getSuccessDebugText() {
        return this.getDebugText()[3];
    }

    public static String[] generateDebugText(String globalWith$, String success) {
        return new String[]{globalWith$.replace("$", ""), globalWith$.replace("$", " for tool"), globalWith$.replace("$", " for tree"), success};
    }

    public static String[] generateDebugText(String global, String tool, String tree, String success) {
        return new String[]{global, tool, tree, success};
    }

    public abstract ItemBuilder getConfigurationDisplayItem(E var1);

    public ItemBuilder getConfigurationDisplayItem() {
        return this.getConfigurationDisplayItem(this.getValue());
    }

    public ItemBuilder getConfigurationDisplayItem(Tool tool) {
        return this.getConfigurationDisplayItem(this.getValue(tool));
    }

    public ItemBuilder getConfigurationDisplayItem(Tree tree) {
        return this.getConfigurationDisplayItem(this.getValue(tree));
    }

    public abstract void openGlobalModifyMenu(MenuGlobalConfiguration var1);

    public abstract void openToolModifyMenu(MenuToolConfiguration var1, Tool var2);

    public abstract void openTreeModifyMenu(MenuTreeConfiguration var1, Tree var2);

    public String writeToConfig(E value) {
        return value == null ? "" : value.toString();
    }

    public String writeToConfig() {
        return this.writeToConfig(this.getValue());
    }

    public String writeToConfig(Tool tool) {
        return this.writeToConfig(this.getValue(tool));
    }

    public String writeToConfig(Tree tree) {
        return this.writeToConfig(this.getValue(tree));
    }

    private static int findMaxWidth(Object[] objs) {
        int len = 0;
        for (Object o : objs) {
            len = Math.max(len, Objects.toString(o).length());
        }
        return len;
    }

    private static String normalize(String name, int width) {
        while (name.length() < width) {
            name = name + " ";
        }
        return name;
    }

    static {
        defaultOverridables.add(Material.GRASS);
        defaultOverridables.add(Material.AIR);
        defaultOverridables.add(Material.CAVE_AIR);
        defaultOverridables.add(Material.WATER);
        defaultOverridables.add(Material.TALL_GRASS);
        defaultOverridables.add(Material.SEAGRASS);
        defaultOverridables.add(Material.TALL_SEAGRASS);
        defaultOverridables.add(Material.FERN);
        defaultOverridables.add(Material.LARGE_FERN);
        defaultGrasses.add(Material.GRASS_BLOCK);
        defaultGrasses.add(Material.DIRT);
        defaultGrasses.add(Material.PODZOL);
        Material rootedDirt = Material.matchMaterial((String)"ROOTED_DIRT");
        if (rootedDirt != null) {
            defaultGrasses.add(rootedDirt);
        }
        defaultDropConversions.put(Material.OAK_WOOD, Material.OAK_LOG);
        defaultDropConversions.put(Material.BIRCH_WOOD, Material.BIRCH_LOG);
        defaultDropConversions.put(Material.SPRUCE_WOOD, Material.SPRUCE_LOG);
        defaultDropConversions.put(Material.JUNGLE_WOOD, Material.JUNGLE_LOG);
        defaultDropConversions.put(Material.ACACIA_WOOD, Material.ACACIA_LOG);
        defaultDropConversions.put(Material.DARK_OAK_WOOD, Material.DARK_OAK_LOG);
        defaultDropConversions.put(Material.CRIMSON_HYPHAE, Material.CRIMSON_STEM);
        defaultDropConversions.put(Material.WARPED_HYPHAE, Material.WARPED_STEM);
        Material roots = Material.matchMaterial((String)"MUDDY_MANGROVE_ROOTS");
        Material mud = Material.matchMaterial((String)"MUD");
        if (roots != null) {
            defaultBlockConversions.put(roots, mud);
        }
        options = new ArrayList();
        STARTUP_LOGS = new OptionBoolean("Startup Logs", true, false, false, true){

            @Override
            public String getDesc(boolean ingame) {
                return "If set to false, the tree feller will not list all its settings in the console on startup";
            }

            @Override
            public ItemBuilder getConfigurationDisplayItem(Boolean value) {
                ItemBuilder builder = new ItemBuilder(Material.OAK_LOG);
                if (Objects.equals(value, true)) {
                    builder.enchant(Enchantment.BINDING_CURSE, 1);
                    builder.addFlag(ItemFlag.HIDE_ENCHANTS);
                }
                return new ItemBuilder(Material.OAK_LOG);
            }
        };
        DEFAULT_ENABLED = new OptionBoolean("Default Enabled", true, false, false, true, (Object)true){

            @Override
            public String getDesc(boolean ingame) {
                return "If set to false, the tree feller will be toggled off for each player by default (as with /treefeller toggle)" + (ingame ? "\nOnly takes effect on reload/restart" : "");
            }

            @Override
            public ItemBuilder getConfigurationDisplayItem(Boolean value) {
                return new ItemBuilder(Objects.equals(value, true) ? Material.GREEN_CONCRETE : Material.RED_CONCRETE);
            }
        };
        SCAN_DISTANCE = new Option<Integer>("Scan Distance", true, true, false, Integer.valueOf(256)){

            @Override
            public Integer load(Object o) {
                return 3.loadInt(o);
            }

            @Override
            public String getDesc(boolean ingame) {
                return "How far should the plugin scan for logs? (If a tree is larger, only the part within this distance will be felled)";
            }

            @Override
            public ItemBuilder getConfigurationDisplayItem(Integer value) {
                return new ItemBuilder(Material.RAIL).setCount(value);
            }

            @Override
            public void openGlobalModifyMenu(MenuGlobalConfiguration parent) {
                parent.open(new MenuModifyInteger(parent, parent.plugin, parent.player, this.name, 0, Integer.MAX_VALUE, false, (Integer)this.globalValue, value -> {
                    this.globalValue = value;
                }));
            }

            @Override
            public void openToolModifyMenu(MenuToolConfiguration parent, Tool tool) {
                parent.open(new MenuModifyInteger(parent, parent.plugin, parent.player, this.name, 0, Integer.MAX_VALUE, true, (Integer)this.toolValues.get(tool), value -> {
                    if (value == null) {
                        this.toolValues.remove(tool);
                    } else {
                        this.toolValues.put(tool, value);
                    }
                }));
            }

            @Override
            public void openTreeModifyMenu(MenuTreeConfiguration parent, Tree tree) {
                parent.open(new MenuModifyInteger(parent, parent.plugin, parent.player, this.name, 0, Integer.MAX_VALUE, true, (Integer)this.treeValues.get(tree), value -> {
                    if (value == null) {
                        this.treeValues.remove(tree);
                    } else {
                        this.treeValues.put(tree, value);
                    }
                }));
            }
        };
        LEAF_DETECT_RANGE = new Option<Integer>("Leaf Detect Range", true, true, true, Integer.valueOf(6)){

            @Override
            public Integer load(Object o) {
                return 4.loadInt(o);
            }

            @Override
            public String getDesc(boolean ingame) {
                return "How far away from logs should leaf blocks be detected?";
            }

            @Override
            public ItemBuilder getConfigurationDisplayItem(Integer value) {
                return new ItemBuilder(Material.OAK_LEAVES).setCount(value);
            }

            @Override
            public void openGlobalModifyMenu(MenuGlobalConfiguration parent) {
                parent.open(new MenuModifyInteger(parent, parent.plugin, parent.player, this.name, 0, Integer.MAX_VALUE, false, (Integer)this.globalValue, value -> {
                    this.globalValue = value;
                }));
            }

            @Override
            public void openToolModifyMenu(MenuToolConfiguration parent, Tool tool) {
                parent.open(new MenuModifyInteger(parent, parent.plugin, parent.player, this.name, 0, Integer.MAX_VALUE, true, (Integer)this.toolValues.get(tool), value -> {
                    if (value == null) {
                        this.toolValues.remove(tool);
                    } else {
                        this.toolValues.put(tool, value);
                    }
                }));
            }

            @Override
            public void openTreeModifyMenu(MenuTreeConfiguration parent, Tree tree) {
                parent.open(new MenuModifyInteger(parent, parent.plugin, parent.player, this.name, 0, Integer.MAX_VALUE, true, (Integer)this.treeValues.get(tree), value -> {
                    if (value == null) {
                        this.treeValues.remove(tree);
                    } else {
                        this.treeValues.put(tree, value);
                    }
                }));
            }
        };
        LEAF_BREAK_RANGE = new Option<Integer>("Leaf Break Range", true, true, true, Integer.valueOf(6)){

            @Override
            public Integer load(Object o) {
                return 5.loadInt(o);
            }

            @Override
            public String getDesc(boolean ingame) {
                return "How far away from logs should leaf blocks be destroyed? (set to 0 to prevent leaves from being destroyed) (Values over 6 are useless for vanilla trees, as these leaves would naturally decay anyway)";
            }

            @Override
            public ItemBuilder getConfigurationDisplayItem(Integer value) {
                return new ItemBuilder(Material.OAK_LEAVES).setCount(value);
            }

            @Override
            public void openGlobalModifyMenu(MenuGlobalConfiguration parent) {
                parent.open(new MenuModifyInteger(parent, parent.plugin, parent.player, this.name, 0, Integer.MAX_VALUE, false, (Integer)this.globalValue, value -> {
                    this.globalValue = value;
                }));
            }

            @Override
            public void openToolModifyMenu(MenuToolConfiguration parent, Tool tool) {
                parent.open(new MenuModifyInteger(parent, parent.plugin, parent.player, this.name, 0, Integer.MAX_VALUE, true, (Integer)this.toolValues.get(tool), value -> {
                    if (value == null) {
                        this.toolValues.remove(tool);
                    } else {
                        this.toolValues.put(tool, value);
                    }
                }));
            }

            @Override
            public void openTreeModifyMenu(MenuTreeConfiguration parent, Tree tree) {
                parent.open(new MenuModifyInteger(parent, parent.plugin, parent.player, this.name, 0, Integer.MAX_VALUE, true, (Integer)this.treeValues.get(tree), value -> {
                    if (value == null) {
                        this.treeValues.remove(tree);
                    } else {
                        this.treeValues.put(tree, value);
                    }
                }));
            }
        };
        REQUIRED_LOGS = new Option<Integer>("Required Logs", true, true, true, Integer.valueOf(4)){

            @Override
            public Integer load(Object o) {
                return 6.loadInt(o);
            }

            @Override
            public DebugResult doCheckTrunk(TreeFeller plugin, Tool tool, Tree tree, HashMap<Integer, ArrayList<Block>> blocks, Block block) {
                int total = Option.getTotal(blocks);
                if (this.toolValues.get(tool) == null && this.treeValues.get(tree) == null && this.globalValue != null && total < (Integer)this.globalValue) {
                    return new DebugResult(this, DebugResult.Type.GLOBAL, total, this.globalValue);
                }
                if (this.toolValues.get(tool) != null && total < (Integer)this.toolValues.get(tool)) {
                    return new DebugResult(this, DebugResult.Type.TOOL, total, this.toolValues.get(tool));
                }
                if (this.treeValues.get(tree) != null && total < (Integer)this.treeValues.get(tree)) {
                    return new DebugResult(this, DebugResult.Type.TREE, total, this.treeValues.get(tree));
                }
                return new DebugResult(this, DebugResult.Type.SUCCESS, total);
            }

            @Override
            public String getDesc(boolean ingame) {
                return "How many logs should be required for logs to be counted as a tree?";
            }

            @Override
            public String[] getDebugText() {
                return 6.generateDebugText("Tree has too few logs$: {0}<{1}", "Tree has enough logs");
            }

            @Override
            public ItemBuilder getConfigurationDisplayItem(Integer value) {
                return new ItemBuilder(Material.OAK_LOG).setCount(value);
            }

            @Override
            public void openGlobalModifyMenu(MenuGlobalConfiguration parent) {
                parent.open(new MenuModifyInteger(parent, parent.plugin, parent.player, this.name, 0, Integer.MAX_VALUE, false, (Integer)this.globalValue, value -> {
                    this.globalValue = value;
                }));
            }

            @Override
            public void openToolModifyMenu(MenuToolConfiguration parent, Tool tool) {
                parent.open(new MenuModifyInteger(parent, parent.plugin, parent.player, this.name, 0, Integer.MAX_VALUE, true, (Integer)this.toolValues.get(tool), value -> {
                    if (value == null) {
                        this.toolValues.remove(tool);
                    } else {
                        this.toolValues.put(tool, value);
                    }
                }));
            }

            @Override
            public void openTreeModifyMenu(MenuTreeConfiguration parent, Tree tree) {
                parent.open(new MenuModifyInteger(parent, parent.plugin, parent.player, this.name, 0, Integer.MAX_VALUE, true, (Integer)this.treeValues.get(tree), value -> {
                    if (value == null) {
                        this.treeValues.remove(tree);
                    } else {
                        this.treeValues.put(tree, value);
                    }
                }));
            }
        };
        REQUIRED_LEAVES = new Option<Integer>("Required Leaves", true, true, true, Integer.valueOf(10)){

            @Override
            public Integer load(Object o) {
                return 7.loadInt(o);
            }

            @Override
            public DebugResult doCheckTree(TreeFeller plugin, Tool tool, Tree tree, HashMap<Integer, ArrayList<Block>> blocks, int leaves) {
                if (this.toolValues.get(tool) == null && this.treeValues.get(tree) == null && this.globalValue != null && leaves < (Integer)this.globalValue) {
                    return new DebugResult(this, DebugResult.Type.GLOBAL, leaves, this.globalValue);
                }
                if (this.toolValues.get(tool) != null && leaves < (Integer)this.toolValues.get(tool)) {
                    return new DebugResult(this, DebugResult.Type.TOOL, leaves, this.toolValues.get(tool));
                }
                if (this.treeValues.get(tree) != null && leaves < (Integer)this.treeValues.get(tree)) {
                    return new DebugResult(this, DebugResult.Type.TREE, leaves, this.treeValues.get(tree));
                }
                return new DebugResult(this, DebugResult.Type.SUCCESS, leaves);
            }

            @Override
            public String getDesc(boolean ingame) {
                return "How many leaves should be required for logs to be counted as a tree?";
            }

            @Override
            public String[] getDebugText() {
                return 7.generateDebugText("Tree has too few leaves$: {0}<{1}", "Tree has enough leaves");
            }

            @Override
            public ItemBuilder getConfigurationDisplayItem(Integer value) {
                return new ItemBuilder(Material.OAK_LEAVES).setCount(value);
            }

            @Override
            public void openGlobalModifyMenu(MenuGlobalConfiguration parent) {
                parent.open(new MenuModifyInteger(parent, parent.plugin, parent.player, this.name, 0, Integer.MAX_VALUE, false, (Integer)this.globalValue, value -> {
                    this.globalValue = value;
                }));
            }

            @Override
            public void openToolModifyMenu(MenuToolConfiguration parent, Tool tool) {
                parent.open(new MenuModifyInteger(parent, parent.plugin, parent.player, this.name, 0, Integer.MAX_VALUE, true, (Integer)this.toolValues.get(tool), value -> {
                    if (value == null) {
                        this.toolValues.remove(tool);
                    } else {
                        this.toolValues.put(tool, value);
                    }
                }));
            }

            @Override
            public void openTreeModifyMenu(MenuTreeConfiguration parent, Tree tree) {
                parent.open(new MenuModifyInteger(parent, parent.plugin, parent.player, this.name, 0, Integer.MAX_VALUE, true, (Integer)this.treeValues.get(tree), value -> {
                    if (value == null) {
                        this.treeValues.remove(tree);
                    } else {
                        this.treeValues.put(tree, value);
                    }
                }));
            }
        };
        MAX_LOGS = new Option<Integer>("Max Logs", true, true, true, Integer.valueOf(250)){

            @Override
            public Integer load(Object o) {
                return 8.loadInt(o);
            }

            @Override
            public DebugResult doCheckTrunk(TreeFeller plugin, Tool tool, Tree tree, HashMap<Integer, ArrayList<Block>> blocks, Block block) {
                int total = Option.getTotal(blocks);
                if (this.toolValues.get(tool) == null && this.treeValues.get(tree) == null && this.globalValue != null && total > (Integer)this.globalValue) {
                    return new DebugResult(this, DebugResult.Type.GLOBAL, total, this.globalValue);
                }
                if (this.toolValues.get(tool) != null && total > (Integer)this.toolValues.get(tool)) {
                    return new DebugResult(this, DebugResult.Type.TOOL, total, this.toolValues.get(tool));
                }
                if (this.treeValues.get(tree) != null && total > (Integer)this.treeValues.get(tree)) {
                    return new DebugResult(this, DebugResult.Type.TREE, total, this.treeValues.get(tree));
                }
                return new DebugResult(this, DebugResult.Type.SUCCESS, total);
            }

            @Override
            public String getDesc(boolean ingame) {
                return "What is the maximum number of logs that a tree may have and still be counted as a tree?";
            }

            @Override
            public String[] getDebugText() {
                return 8.generateDebugText("Tree has too many logs$: {0}>{1}", "Tree has few enough logs");
            }

            @Override
            public ItemBuilder getConfigurationDisplayItem(Integer value) {
                return new ItemBuilder(Material.OAK_LOG).setCount(value);
            }

            @Override
            public void openGlobalModifyMenu(MenuGlobalConfiguration parent) {
                parent.open(new MenuModifyInteger(parent, parent.plugin, parent.player, this.name, 0, Integer.MAX_VALUE, false, (Integer)this.globalValue, value -> {
                    this.globalValue = value;
                }));
            }

            @Override
            public void openToolModifyMenu(MenuToolConfiguration parent, Tool tool) {
                parent.open(new MenuModifyInteger(parent, parent.plugin, parent.player, this.name, 0, Integer.MAX_VALUE, true, (Integer)this.toolValues.get(tool), value -> {
                    if (value == null) {
                        this.toolValues.remove(tool);
                    } else {
                        this.toolValues.put(tool, value);
                    }
                }));
            }

            @Override
            public void openTreeModifyMenu(MenuTreeConfiguration parent, Tree tree) {
                parent.open(new MenuModifyInteger(parent, parent.plugin, parent.player, this.name, 0, Integer.MAX_VALUE, true, (Integer)this.treeValues.get(tree), value -> {
                    if (value == null) {
                        this.treeValues.remove(tree);
                    } else {
                        this.treeValues.put(tree, value);
                    }
                }));
            }

            @Override
            public Integer get(Tool tool, Tree tree) {
                Integer val = null;
                if (this.getValue(tool) == null && this.getValue(tree) == null && this.getValue() != null) {
                    val = Math.min(val == null ? Integer.MAX_VALUE : val, (Integer)this.getValue());
                }
                if (this.getValue(tool) != null) {
                    val = Math.min(val == null ? Integer.MAX_VALUE : val, (Integer)this.getValue(tool));
                }
                if (this.getValue(tree) != null) {
                    val = Math.min(val == null ? Integer.MAX_VALUE : val, (Integer)this.getValue(tree));
                }
                return val;
            }
        };
        MAX_HEIGHT = new Option<Integer>("Max Height", true, true, true, Integer.valueOf(5)){

            @Override
            public Integer load(Object o) {
                return 9.loadInt(o);
            }

            @Override
            public DebugResult doCheckTrunk(TreeFeller plugin, Tool tool, Tree tree, HashMap<Integer, ArrayList<Block>> blocks, Block block) {
                int i2;
                if (plugin.cascading) {
                    return new DebugResult(this, DebugResult.Type.SUCCESS, new Object[0]);
                }
                int minY = block.getY();
                for (int i2 : blocks.keySet()) {
                    for (Block b : blocks.get(i2)) {
                        minY = Math.min(minY, b.getY());
                    }
                }
                int h = block.getY() - minY + 1;
                if (this.toolValues.get(tool) == null && this.treeValues.get(tree) == null && this.globalValue != null && h > (Integer)this.globalValue) {
                    i2 = h - (Integer)this.globalValue;
                    return new DebugResult(this, DebugResult.Type.GLOBAL, i2, h, this.globalValue);
                }
                if (this.toolValues.containsKey(tool) && h > (Integer)this.toolValues.get(tool)) {
                    i2 = h - (Integer)this.toolValues.get(tool);
                    return new DebugResult(this, DebugResult.Type.TOOL, i2, h, this.toolValues.get(tool));
                }
                if (this.treeValues.containsKey(tree) && h > (Integer)this.treeValues.get(tree)) {
                    i2 = h - (Integer)this.treeValues.get(tree);
                    return new DebugResult(this, DebugResult.Type.TREE, i2, h, this.treeValues.get(tree));
                }
                return new DebugResult(this, DebugResult.Type.SUCCESS, new Object[0]);
            }

            @Override
            public String getDesc(boolean ingame) {
                return "How far from the bottom can you cut down a tree? (Prevents you from cutting it down from the top) 1 = bottom block";
            }

            @Override
            public String[] getDebugText() {
                return 9.generateDebugText("Tree was cut {0} blocks too high$", "Tree was cut low enough");
            }

            @Override
            public ItemBuilder getConfigurationDisplayItem(Integer value) {
                return new ItemBuilder(Material.LADDER).setCount(value);
            }

            @Override
            public void openGlobalModifyMenu(MenuGlobalConfiguration parent) {
                parent.open(new MenuModifyInteger(parent, parent.plugin, parent.player, this.name, 1, Integer.MAX_VALUE, false, (Integer)this.globalValue, value -> {
                    this.globalValue = value;
                }));
            }

            @Override
            public void openToolModifyMenu(MenuToolConfiguration parent, Tool tool) {
                parent.open(new MenuModifyInteger(parent, parent.plugin, parent.player, this.name, 1, Integer.MAX_VALUE, true, (Integer)this.toolValues.get(tool), value -> {
                    if (value == null) {
                        this.toolValues.remove(tool);
                    } else {
                        this.toolValues.put(tool, value);
                    }
                }));
            }

            @Override
            public void openTreeModifyMenu(MenuTreeConfiguration parent, Tree tree) {
                parent.open(new MenuModifyInteger(parent, parent.plugin, parent.player, this.name, 1, Integer.MAX_VALUE, true, (Integer)this.treeValues.get(tree), value -> {
                    if (value == null) {
                        this.treeValues.remove(tree);
                    } else {
                        this.treeValues.put(tree, value);
                    }
                }));
            }
        };
        ALLOW_PARTIAL = new OptionBoolean("Allow Partial", true, true, true, false){

            @Override
            public String getDesc(boolean ingame) {
                return "Should trees be able to be partially cut down if the tool has insufficient durability? It cannot be guaranteed what part of the tree will be cut down!\nThis will have no effect if allow-partial-tool is enabled.";
            }

            @Override
            public ItemBuilder getConfigurationDisplayItem(Boolean value) {
                return new ItemBuilder(Material.STICK);
            }
        };
        ALLOW_PARTIAL_TOOL = new OptionBoolean("Allow Partial Tool", true, true, true, false){

            @Override
            public String getDesc(boolean ingame) {
                return "Should a tool be able to fully cut down a tree, even if it has insufficient durability?\n(This may cause unexpected behavior when combined with prevent-breakage)";
            }

            @Override
            public ItemBuilder getConfigurationDisplayItem(Boolean value) {
                return new ItemBuilder(Material.WOODEN_AXE);
            }
        };
        PLAYER_LEAVES = new OptionBoolean("Player Leaves", true, true, true, false){

            @Override
            public String getDesc(boolean ingame) {
                return "Should leaves placed by players be cut down also? (Only works with _LEAVES materials)";
            }

            @Override
            public ItemBuilder getConfigurationDisplayItem(Boolean value) {
                return new ItemBuilder(Material.OAK_LEAVES);
            }
        };
        DIAGONAL_LEAVES = new OptionBoolean("Diagonal Leaves", true, false, true, false){

            @Override
            public String getDesc(boolean ingame) {
                return "If set to true, leaves will be detected diagonally; May require ignore-leaf-data to work properly";
            }

            @Override
            public ItemBuilder getConfigurationDisplayItem(Boolean value) {
                return new ItemBuilder(Material.OAK_LEAVES);
            }
        };
        IGNORE_LEAF_DATA = new OptionBoolean("Ignore Leaf Data", true, false, true, false){

            @Override
            public String getDesc(boolean ingame) {
                return "If set to true, leaves' blockdata will be ignored. This should only be set if custom trees' leaves are not being destroyed when they should.";
            }

            @Override
            public ItemBuilder getConfigurationDisplayItem(Boolean value) {
                return new ItemBuilder(Material.OAK_LEAVES);
            }
        };
        REQUIRE_CROSS_SECTION = new OptionBoolean("Require Cross Section", true, true, true, false){

            @Override
            public DebugResult doCheckTrunk(TreeFeller plugin, Tool tool, Tree tree, HashMap<Integer, ArrayList<Block>> blocks, Block block) {
                if (this.toolValues.get(tool) == null && this.treeValues.get(tree) == null && Objects.equals(this.globalValue, true) || Objects.equals(this.toolValues.get(tool), true) || Objects.equals(this.treeValues.get(tree), true)) {
                    for (int x = -1; x <= 1; ++x) {
                        for (int z = -1; z <= 1; ++z) {
                            if (x == 0 && z == 0 || !tree.trunk.contains(block.getRelative(x, 0, z).getType())) continue;
                            if (this.toolValues.get(tool) == null && this.treeValues.get(tree) == null && Objects.equals(this.globalValue, true)) {
                                return new DebugResult(this, DebugResult.Type.GLOBAL, block.getX() + x, block.getY() + " " + block.getZ() + z);
                            }
                            if (Objects.equals(this.toolValues.get(tool), true)) {
                                return new DebugResult(this, DebugResult.Type.TOOL, block.getX() + x, block.getY() + " " + block.getZ() + z);
                            }
                            if (!Objects.equals(this.treeValues.get(tree), true)) continue;
                            return new DebugResult(this, DebugResult.Type.TREE, block.getX() + x, block.getY() + " " + block.getZ() + z);
                        }
                    }
                }
                return new DebugResult(this, DebugResult.Type.SUCCESS, new Object[0]);
            }

            @Override
            public String getDesc(boolean ingame) {
                return "Should trees larger than 1x1 require an entire horizontal cross-section to be mined before the tree fells? (Works for up to 2x2 trees)";
            }

            @Override
            public String[] getDebugText() {
                return 15.generateDebugText("A full cross-section has not been cut$ at ({0}, {1}, {2})", "A full cross-section has been cut");
            }

            @Override
            public ItemBuilder getConfigurationDisplayItem(Boolean value) {
                return new ItemBuilder(Material.DARK_OAK_LOG);
            }
        };
        FORCE_DISTANCE_CHECK = new OptionBoolean("Force Distance Check", true, false, true, false){

            @Override
            public String getDesc(boolean ingame) {
                return "If set to true, all non-leaf-block leaves will be distance-checked to make sure they belong to the tree being felled (ex. mushrooms or nether 'tree' leaves)\nWARNING: THIS CAN CAUSE SIGNIFICANT LAG";
            }

            @Override
            public ItemBuilder getConfigurationDisplayItem(Boolean value) {
                return new ItemBuilder(Material.DETECTOR_RAIL);
            }
        };
        DECORATIONS = new Option<ArrayList<DecorationDetector>>("Decorations", true, true, true, DecorationDetector.detectors, (Object)"\n    - snow\n    - vines\n    - cocoa\n    - weeping vines\n    - moss"){

            @Override
            public ArrayList<DecorationDetector> load(Object o) {
                if (o instanceof Iterable) {
                    ArrayList<DecorationDetector> decor = new ArrayList<DecorationDetector>();
                    for (Object ob : (Iterable)o) {
                        Object newDecor = this.load(ob);
                        if (newDecor == null) continue;
                        decor.addAll((Collection<DecorationDetector>)newDecor);
                    }
                    return decor;
                }
                if (o instanceof DecorationDetector) {
                    ArrayList<DecorationDetector> decor = new ArrayList<DecorationDetector>();
                    decor.add((DecorationDetector)o);
                    return decor;
                }
                if (o instanceof String) {
                    Material m;
                    ArrayList<DecorationDetector> decor = new ArrayList<DecorationDetector>();
                    for (DecorationDetector dec : DecorationDetector.detectors) {
                        if (!dec.name.equalsIgnoreCase((String)o)) continue;
                        decor.add(dec);
                    }
                    if (decor.isEmpty() && (m = Material.matchMaterial((String)((String)o))) != null && m.isBlock()) {
                        decor.add(new AdjacentDecorationDetector(m.getKey().toString(), m, BlockFace.UP, BlockFace.DOWN, BlockFace.NORTH, BlockFace.SOUTH, BlockFace.EAST, BlockFace.WEST));
                    }
                    return decor;
                }
                return null;
            }

            @Override
            public String getDesc(boolean ingame) {
                String bi = "";
                for (DecorationDetector det : DecorationDetector.detectors) {
                    bi = bi + "\n    - " + det.name;
                }
                return "Which decorations should be removed when felling? (ex. snow, vines)" + (ingame ? "\nValid options:" + bi : "");
            }

            @Override
            public ItemBuilder getConfigurationDisplayItem(ArrayList<DecorationDetector> value) {
                return new ItemBuilder(Material.SNOW);
            }

            @Override
            public void openGlobalModifyMenu(MenuGlobalConfiguration parent) {
                parent.open(new MenuModifyEnumSet<DecorationDetector>(parent, parent.plugin, parent.player, this.name, "Decorations", true, (Collection)this.globalValue, DecorationDetector.getDetectors(), DecorationDetector.getMaterials(), value -> {
                    this.globalValue = new ArrayList(value);
                }));
            }

            @Override
            public void openToolModifyMenu(MenuToolConfiguration parent, Tool tool) {
                parent.open(new MenuModifyEnumSet<DecorationDetector>(parent, parent.plugin, parent.player, this.name, "Decorations", true, (Collection)this.toolValues.get(tool), DecorationDetector.getDetectors(), DecorationDetector.getMaterials(), value -> {
                    if (value == null) {
                        this.toolValues.remove(tool);
                    } else {
                        this.toolValues.put(tool, new ArrayList(value));
                    }
                }));
            }

            @Override
            public void openTreeModifyMenu(MenuTreeConfiguration parent, Tree tree) {
                parent.open(new MenuModifyEnumSet<DecorationDetector>(parent, parent.plugin, parent.player, this.name, "Decorations", true, (Collection)this.treeValues.get(tree), DecorationDetector.getDetectors(), DecorationDetector.getMaterials(), value -> {
                    if (value == null) {
                        this.treeValues.remove(tree);
                    } else {
                        this.treeValues.put(tree, new ArrayList(value));
                    }
                }));
            }

            @Override
            public String writeToConfig(ArrayList<DecorationDetector> value) {
                ArrayList<String> strs = new ArrayList<String>();
                for (DecorationDetector dec : value) {
                    strs.add(dec.name);
                }
                return strs.toString();
            }

            @Override
            public ArrayList<DecorationDetector> get(Tool tool, Tree tree) {
                HashSet allofem = new HashSet();
                if (this.globalValue != null) {
                    allofem.addAll((Collection)this.globalValue);
                }
                if (this.toolValues.containsKey(tool)) {
                    allofem.addAll((Collection)this.toolValues.get(tool));
                }
                if (this.treeValues.containsKey(tree)) {
                    allofem.addAll((Collection)this.treeValues.get(tree));
                }
                return new ArrayList<DecorationDetector>(allofem);
            }
        };
        BANNED_LOGS = new Option<HashSet<Material>>("Banned Logs", true, true, true, new HashSet()){

            @Override
            public String getDesc(boolean ingame) {
                return "Which trunk blocks should prevent a tree from being felled? (Intended to help prevent player structures from being cut down)\n(For this to work, these must also be included in the tree trunk materials)\nEx. planks/glass";
            }

            @Override
            public HashSet<Material> load(Object o) {
                return 18.loadMaterialSet(o);
            }

            @Override
            public ItemBuilder getConfigurationDisplayItem(HashSet<Material> value) {
                return new ItemBuilder(Material.OAK_PLANKS);
            }

            @Override
            public void openGlobalModifyMenu(MenuGlobalConfiguration parent) {
                parent.open(new MenuModifyMaterialSet(parent, parent.plugin, parent.player, this.name, true, "block", (HashSet)this.globalValue, material -> material.isBlock(), value -> {
                    this.globalValue = value;
                }));
            }

            @Override
            public void openToolModifyMenu(MenuToolConfiguration parent, Tool tool) {
                parent.open(new MenuModifyMaterialSet(parent, parent.plugin, parent.player, this.name, true, "block", (HashSet)this.toolValues.get(tool), material -> material.isBlock(), value -> {
                    if (value == null) {
                        this.toolValues.remove(tool);
                    } else {
                        this.toolValues.put(tool, value);
                    }
                }));
            }

            @Override
            public void openTreeModifyMenu(MenuTreeConfiguration parent, Tree tree) {
                parent.open(new MenuModifyMaterialSet(parent, parent.plugin, parent.player, this.name, true, "block", (HashSet)this.treeValues.get(tree), material -> material.isBlock(), value -> {
                    if (value == null) {
                        this.treeValues.remove(tree);
                    } else {
                        this.treeValues.put(tree, value);
                    }
                }));
            }

            @Override
            protected DebugResult doCheckTrunk(TreeFeller plugin, Tool tool, Tree tree, HashMap<Integer, ArrayList<Block>> blocks, Block block) {
                for (ArrayList<Block> blox : blocks.values()) {
                    for (Block blok : blox) {
                        Material mat = blok.getType();
                        if (this.toolValues.get(tool) == null && this.treeValues.get(tree) == null && this.globalValue != null && ((HashSet)this.globalValue).contains(mat)) {
                            return new DebugResult(this, DebugResult.Type.GLOBAL, mat);
                        }
                        if (this.toolValues.get(tool) != null && ((HashSet)this.toolValues.get(tool)).contains(mat)) {
                            return new DebugResult(this, DebugResult.Type.TOOL, mat);
                        }
                        if (this.treeValues.get(tree) == null || !((HashSet)this.treeValues.get(tree)).contains(mat)) continue;
                        return new DebugResult(this, DebugResult.Type.TREE, mat);
                    }
                }
                return new DebugResult(this, DebugResult.Type.SUCCESS, new Object[0]);
            }

            @Override
            public String[] getDebugText() {
                return 18.generateDebugText("Tree contains banned log$: {0}", "Tree does not contain any banned logs");
            }
        };
        BANNED_LEAVES = new Option<HashSet<Material>>("Banned Leaves", true, true, true, new HashSet()){

            @Override
            public String getDesc(boolean ingame) {
                return "Which blocks should prevent a tree from being felled? (Intended to help prevent player structures from being cut down)\n(For this to work, these must also be included in the tree leaf materials)\nEx. planks or glass";
            }

            @Override
            public HashSet<Material> load(Object o) {
                return 19.loadMaterialSet(o);
            }

            @Override
            public ItemBuilder getConfigurationDisplayItem(HashSet<Material> value) {
                return new ItemBuilder(Material.OAK_PLANKS);
            }

            @Override
            public void openGlobalModifyMenu(MenuGlobalConfiguration parent) {
                parent.open(new MenuModifyMaterialSet(parent, parent.plugin, parent.player, this.name, true, "block", (HashSet)this.globalValue, material -> material.isBlock(), value -> {
                    this.globalValue = value;
                }));
            }

            @Override
            public void openToolModifyMenu(MenuToolConfiguration parent, Tool tool) {
                parent.open(new MenuModifyMaterialSet(parent, parent.plugin, parent.player, this.name, true, "block", (HashSet)this.toolValues.get(tool), material -> material.isBlock(), value -> {
                    if (value == null) {
                        this.toolValues.remove(tool);
                    } else {
                        this.toolValues.put(tool, value);
                    }
                }));
            }

            @Override
            public void openTreeModifyMenu(MenuTreeConfiguration parent, Tree tree) {
                parent.open(new MenuModifyMaterialSet(parent, parent.plugin, parent.player, this.name, true, "block", (HashSet)this.treeValues.get(tree), material -> material.isBlock(), value -> {
                    if (value == null) {
                        this.treeValues.remove(tree);
                    } else {
                        this.treeValues.put(tree, value);
                    }
                }));
            }

            @Override
            protected DebugResult doCheckTree(TreeFeller plugin, Tool tool, Tree tree, HashMap<Integer, ArrayList<Block>> blocks, int leaves) {
                for (ArrayList<Block> blox : blocks.values()) {
                    for (Block blok : blox) {
                        Material mat = blok.getType();
                        if (this.toolValues.get(tool) == null && this.treeValues.get(tree) == null && this.globalValue != null && ((HashSet)this.globalValue).contains(mat)) {
                            return new DebugResult(this, DebugResult.Type.GLOBAL, mat);
                        }
                        if (this.toolValues.get(tool) != null && ((HashSet)this.toolValues.get(tool)).contains(mat)) {
                            return new DebugResult(this, DebugResult.Type.TOOL, mat);
                        }
                        if (this.treeValues.get(tree) == null || !((HashSet)this.treeValues.get(tree)).contains(mat)) continue;
                        return new DebugResult(this, DebugResult.Type.TREE, mat);
                    }
                }
                return new DebugResult(this, DebugResult.Type.SUCCESS, new Object[0]);
            }

            @Override
            public String[] getDebugText() {
                return 19.generateDebugText("Tree contains banned leaf$: {0}", "Tree does not contain any banned leaves");
            }
        };
        MAX_HORIZONTAL_TRUNK_PILLAR_LENGTH = new Option<Integer>("Max Horizontal Trunk Pillar Length", true, true, true, Integer.valueOf(6)){

            @Override
            public String getDesc(boolean ingame) {
                return "What is the maximum number of trunk blocks that may be in a horizontal line?\n(This is to help detect structures with long horizontal pillars of logs)";
            }

            @Override
            public Integer load(Object o) {
                return 20.loadInt(o);
            }

            @Override
            public ItemBuilder getConfigurationDisplayItem(Integer value) {
                return new ItemBuilder(Material.SCAFFOLDING);
            }

            @Override
            public void openGlobalModifyMenu(MenuGlobalConfiguration parent) {
                parent.open(new MenuModifyInteger(parent, parent.plugin, parent.player, this.name, 1, Integer.MAX_VALUE, true, (Integer)this.globalValue, value -> {
                    this.globalValue = value;
                }));
            }

            @Override
            public void openToolModifyMenu(MenuToolConfiguration parent, Tool tool) {
                parent.open(new MenuModifyInteger(parent, parent.plugin, parent.player, this.name, 1, Integer.MAX_VALUE, true, (Integer)this.toolValues.get(tool), value -> {
                    if (value == null) {
                        this.toolValues.remove(tool);
                    } else {
                        this.toolValues.put(tool, value);
                    }
                }));
            }

            @Override
            public void openTreeModifyMenu(MenuTreeConfiguration parent, Tree tree) {
                parent.open(new MenuModifyInteger(parent, parent.plugin, parent.player, this.name, 1, Integer.MAX_VALUE, true, (Integer)this.treeValues.get(tree), value -> {
                    if (value == null) {
                        this.treeValues.remove(tree);
                    } else {
                        this.treeValues.put(tree, value);
                    }
                }));
            }

            @Override
            protected DebugResult doCheckTrunk(TreeFeller plugin, Tool tool, Tree tree, HashMap<Integer, ArrayList<Block>> blocks, Block block) {
                int actual = 0;
                ArrayList<Block> trunk = new ArrayList<Block>();
                for (ArrayList<Block> blox : blocks.values()) {
                    trunk.addAll(blox);
                }
                ArrayList xAxis = new ArrayList(trunk);
                while (!xAxis.isEmpty()) {
                    boolean stillPartOfTheTree;
                    Object b = (Block)xAxis.get(0);
                    block2: do {
                        stillPartOfTheTree = false;
                        Block previous = b.getRelative(-1, 0, 0);
                        for (Object checking : xAxis) {
                            if (checking.getX() != previous.getX() || checking.getY() != previous.getY() || checking.getZ() != previous.getZ()) continue;
                            b = checking;
                            stillPartOfTheTree = true;
                            continue block2;
                        }
                    } while (stillPartOfTheTree);
                    ArrayList<Block> line = new ArrayList<Block>();
                    block4: do {
                        Object checking;
                        line.add((Block)b);
                        stillPartOfTheTree = false;
                        Block next = b.getRelative(1, 0, 0);
                        checking = xAxis.iterator();
                        while (checking.hasNext()) {
                            Block checking2 = (Block)checking.next();
                            if (checking2.getX() != next.getX() || checking2.getY() != next.getY() || checking2.getZ() != next.getZ()) continue;
                            b = checking2;
                            stillPartOfTheTree = true;
                            continue block4;
                        }
                    } while (stillPartOfTheTree);
                    actual = Math.max(actual, line.size());
                    xAxis.removeAll(line);
                }
                ArrayList zAxis = new ArrayList(trunk);
                while (!zAxis.isEmpty()) {
                    boolean stillPartOfTheTree;
                    Block b = (Block)zAxis.get(0);
                    block7: do {
                        stillPartOfTheTree = false;
                        Block previous = b.getRelative(0, 0, -1);
                        for (Block checking2 : zAxis) {
                            if (checking2.getX() != previous.getX() || checking2.getY() != previous.getY() || checking2.getZ() != previous.getZ()) continue;
                            b = checking2;
                            stillPartOfTheTree = true;
                            continue block7;
                        }
                    } while (stillPartOfTheTree);
                    ArrayList<Block> line = new ArrayList<Block>();
                    block9: do {
                        line.add(b);
                        stillPartOfTheTree = false;
                        Block next = b.getRelative(0, 0, 1);
                        for (Block checking : zAxis) {
                            if (checking.getX() != next.getX() || checking.getY() != next.getY() || checking.getZ() != next.getZ()) continue;
                            b = checking;
                            stillPartOfTheTree = true;
                            continue block9;
                        }
                    } while (stillPartOfTheTree);
                    actual = Math.max(actual, line.size());
                    zAxis.removeAll(line);
                }
                if (this.toolValues.get(tool) == null && this.treeValues.get(tree) == null && this.globalValue != null && actual > (Integer)this.globalValue) {
                    return new DebugResult(this, DebugResult.Type.GLOBAL, actual, this.globalValue);
                }
                if (this.treeValues.containsKey(tree) && actual > (Integer)this.treeValues.get(tree)) {
                    return new DebugResult(this, DebugResult.Type.TREE, actual, this.treeValues.get(tree));
                }
                if (this.toolValues.containsKey(tool) && actual > (Integer)this.toolValues.get(tool)) {
                    return new DebugResult(this, DebugResult.Type.TOOL, actual, this.toolValues.get(tool));
                }
                return new DebugResult(this, DebugResult.Type.SUCCESS, new Object[0]);
            }

            @Override
            public String[] getDebugText() {
                return 20.generateDebugText("Found a horizontal trunk pillar that was too long$! {0}>{1}", "No excessive horizontal trunk pillars found");
            }
        };
        MAX_TRUNKS = new Option<Integer>("Max Trunks", true, true, true, null){

            @Override
            public String getDesc(boolean ingame) {
                return "What is the maximum number of trunks a tree may have?\nNote that the trunks are counted at the level at which the tree is cut; not at the base of the tree\nSimilarly to leave-stump, this may include low-hanging leaves";
            }

            @Override
            public Integer load(Object o) {
                return 21.loadInt(o);
            }

            @Override
            public ItemBuilder getConfigurationDisplayItem(Integer value) {
                return new ItemBuilder(Material.TRIDENT);
            }

            @Override
            public void openGlobalModifyMenu(MenuGlobalConfiguration parent) {
                parent.open(new MenuModifyInteger(parent, parent.plugin, parent.player, this.name, 1, Integer.MAX_VALUE, true, (Integer)this.globalValue, value -> {
                    this.globalValue = value;
                }));
            }

            @Override
            public void openToolModifyMenu(MenuToolConfiguration parent, Tool tool) {
                parent.open(new MenuModifyInteger(parent, parent.plugin, parent.player, this.name, 1, Integer.MAX_VALUE, true, (Integer)this.toolValues.get(tool), value -> {
                    if (value == null) {
                        this.toolValues.remove(tool);
                    } else {
                        this.toolValues.put(tool, value);
                    }
                }));
            }

            @Override
            public void openTreeModifyMenu(MenuTreeConfiguration parent, Tree tree) {
                parent.open(new MenuModifyInteger(parent, parent.plugin, parent.player, this.name, 1, Integer.MAX_VALUE, true, (Integer)this.treeValues.get(tree), value -> {
                    if (value == null) {
                        this.treeValues.remove(tree);
                    } else {
                        this.treeValues.put(tree, value);
                    }
                }));
            }

            @Override
            protected DebugResult doCheckTrunk(TreeFeller plugin, Tool tool, Tree tree, HashMap<Integer, ArrayList<Block>> blocks, Block block) {
                int value = 0;
                ArrayList<Block> trunkSlice = new ArrayList<Block>();
                for (ArrayList<Block> blox : blocks.values()) {
                    for (Block b : blox) {
                        if (b.getY() != block.getY()) continue;
                        trunkSlice.add(b);
                    }
                }
                while (!trunkSlice.isEmpty()) {
                    ArrayList<Block> trunk = this.getTrunkBit(trunkSlice, (Block)trunkSlice.get(0), true);
                    trunkSlice.removeAll(trunk);
                    ++value;
                }
                if (this.toolValues.get(tool) == null && this.treeValues.get(tree) == null && this.globalValue != null && value > (Integer)this.globalValue) {
                    return new DebugResult(this, DebugResult.Type.GLOBAL, value, this.globalValue);
                }
                if (this.treeValues.containsKey(tree) && value > (Integer)this.treeValues.get(tree)) {
                    return new DebugResult(this, DebugResult.Type.TREE, value, this.treeValues.get(tree));
                }
                if (this.toolValues.containsKey(tool) && value > (Integer)this.toolValues.get(tool)) {
                    return new DebugResult(this, DebugResult.Type.TOOL, value, this.toolValues.get(tool));
                }
                return new DebugResult(this, DebugResult.Type.SUCCESS, new Object[0]);
            }

            @Override
            public String[] getDebugText() {
                return 21.generateDebugText("Tree has too many trunks$! {0}>{1}", "Trunk count is valid");
            }

            private ArrayList<Block> getTrunkBit(ArrayList<Block> theWholeTrunkSlice, Block startingBlock, boolean diagonal) {
                HashMap results = new HashMap();
                ArrayList<Block> zero = new ArrayList<Block>();
                zero.add(startingBlock);
                results.put(0, zero);
                int i = -1;
                while (true) {
                    ArrayList<Block> layer = new ArrayList<Block>();
                    ArrayList<Block> lastLayer = new ArrayList<Block>((Collection)results.get(++i));
                    if (i == 0 && lastLayer.isEmpty()) {
                        lastLayer.add(startingBlock);
                    }
                    for (Block block : lastLayer) {
                        if (diagonal) {
                            for (int x = -1; x <= 1; ++x) {
                                for (int z = -1; z <= 1; ++z) {
                                    if (x == 0 && z == 0) continue;
                                    Block newBlock = block.getRelative(x, 0, z);
                                    boolean yep = false;
                                    for (Block checking : theWholeTrunkSlice) {
                                        if (checking.getX() != newBlock.getX() || checking.getY() != newBlock.getY() || checking.getZ() != newBlock.getZ()) continue;
                                        yep = true;
                                        newBlock = checking;
                                        break;
                                    }
                                    if (!yep || lastLayer.contains(newBlock) || i > 0 && ((ArrayList)results.get(i - 1)).contains(newBlock) || layer.contains(newBlock)) continue;
                                    layer.add(newBlock);
                                }
                            }
                            continue;
                        }
                        for (int j = 0; j < 4; ++j) {
                            int x = 0;
                            int z = 0;
                            switch (j) {
                                case 0: {
                                    x = -1;
                                    break;
                                }
                                case 1: {
                                    x = 1;
                                    break;
                                }
                                case 2: {
                                    z = -1;
                                    break;
                                }
                                case 3: {
                                    z = 1;
                                    break;
                                }
                                default: {
                                    throw new IllegalArgumentException("How did this happen?");
                                }
                            }
                            Block newBlock = block.getRelative(x, 0, z);
                            boolean yep = false;
                            for (Block checking : theWholeTrunkSlice) {
                                if (checking.getX() != newBlock.getX() || checking.getY() != newBlock.getY() || checking.getZ() != newBlock.getZ()) continue;
                                yep = true;
                                newBlock = checking;
                                break;
                            }
                            if (!yep || lastLayer.contains(newBlock) || i > 0 && ((ArrayList)results.get(i - 1)).contains(newBlock) || layer.contains(newBlock)) continue;
                            layer.add(newBlock);
                        }
                    }
                    if (layer.isEmpty()) break;
                    results.put(i + 1, layer);
                }
                ArrayList<Block> properResults = new ArrayList<Block>();
                for (ArrayList blox : results.values()) {
                    properResults.addAll(blox);
                }
                return properResults;
            }
        };
        MIN_HEIGHT_RATIO = new Option<Double>("Min Height Ratio", true, true, true, null){

            @Override
            public String getDesc(boolean ingame) {
                return "What is the minimum ratio of height to width that a tree may have?";
            }

            @Override
            public Double load(Object o) {
                return 22.loadDouble(o);
            }

            @Override
            public ItemBuilder getConfigurationDisplayItem(Double value) {
                return new ItemBuilder(Material.LADDER);
            }

            @Override
            public void openGlobalModifyMenu(MenuGlobalConfiguration parent) {
                parent.open(new MenuModifyDouble(parent, parent.plugin, parent.player, this.name, 0.0, 2.147483647E9, true, (Double)this.globalValue, value -> {
                    this.globalValue = value;
                }));
            }

            @Override
            public void openToolModifyMenu(MenuToolConfiguration parent, Tool tool) {
                parent.open(new MenuModifyDouble(parent, parent.plugin, parent.player, this.name, 0.0, 2.147483647E9, true, (Double)this.toolValues.get(tool), value -> {
                    if (value == null) {
                        this.toolValues.remove(tool);
                    } else {
                        this.toolValues.put(tool, value);
                    }
                }));
            }

            @Override
            public void openTreeModifyMenu(MenuTreeConfiguration parent, Tree tree) {
                parent.open(new MenuModifyDouble(parent, parent.plugin, parent.player, this.name, 0.0, 2.147483647E9, true, (Double)this.treeValues.get(tree), value -> {
                    if (value == null) {
                        this.treeValues.remove(tree);
                    } else {
                        this.treeValues.put(tree, value);
                    }
                }));
            }

            @Override
            protected DebugResult doCheckTree(TreeFeller plugin, Tool tool, Tree tree, HashMap<Integer, ArrayList<Block>> blocks, int leaves) {
                int minX = Integer.MAX_VALUE;
                int minY = Integer.MAX_VALUE;
                int minZ = Integer.MAX_VALUE;
                int maxX = Integer.MIN_VALUE;
                int maxY = Integer.MIN_VALUE;
                int maxZ = Integer.MIN_VALUE;
                for (ArrayList<Block> blox : blocks.values()) {
                    for (Block block : blox) {
                        minX = Math.min(minX, block.getX());
                        minY = Math.min(minY, block.getY());
                        minZ = Math.min(minZ, block.getZ());
                        maxX = Math.max(maxX, block.getX());
                        maxY = Math.max(maxY, block.getY());
                        maxZ = Math.max(maxZ, block.getZ());
                    }
                }
                int width = Math.max(maxX - minX, maxZ - minZ);
                int height = maxY - minY;
                double value = (double)height / (double)width;
                if (this.toolValues.get(tool) == null && this.treeValues.get(tree) == null && this.globalValue != null && value < (Double)this.globalValue) {
                    return new DebugResult(this, DebugResult.Type.GLOBAL, value, this.globalValue);
                }
                if (this.treeValues.containsKey(tree) && value < (Double)this.treeValues.get(tree)) {
                    return new DebugResult(this, DebugResult.Type.TREE, value, this.treeValues.get(tree));
                }
                if (this.toolValues.containsKey(tool) && value < (Double)this.toolValues.get(tool)) {
                    return new DebugResult(this, DebugResult.Type.TOOL, value, this.toolValues.get(tool));
                }
                return new DebugResult(this, DebugResult.Type.SUCCESS, new Object[0]);
            }

            @Override
            public String[] getDebugText() {
                return 22.generateDebugText("Tree height ratio is too low$! {0}<{1}", "Tree height ratio is above minimum");
            }
        };
        MAX_HEIGHT_RATIO = new Option<Double>("Max Height Ratio", true, true, true, null){

            @Override
            public String getDesc(boolean ingame) {
                return "What is the maximum ratio of height to width that a tree may have?";
            }

            @Override
            public Double load(Object o) {
                return 23.loadDouble(o);
            }

            @Override
            public ItemBuilder getConfigurationDisplayItem(Double value) {
                return new ItemBuilder(Material.LADDER);
            }

            @Override
            public void openGlobalModifyMenu(MenuGlobalConfiguration parent) {
                parent.open(new MenuModifyDouble(parent, parent.plugin, parent.player, this.name, 0.0, 2.147483647E9, true, (Double)this.globalValue, value -> {
                    this.globalValue = value;
                }));
            }

            @Override
            public void openToolModifyMenu(MenuToolConfiguration parent, Tool tool) {
                parent.open(new MenuModifyDouble(parent, parent.plugin, parent.player, this.name, 0.0, 2.147483647E9, true, (Double)this.toolValues.get(tool), value -> {
                    if (value == null) {
                        this.toolValues.remove(tool);
                    } else {
                        this.toolValues.put(tool, value);
                    }
                }));
            }

            @Override
            public void openTreeModifyMenu(MenuTreeConfiguration parent, Tree tree) {
                parent.open(new MenuModifyDouble(parent, parent.plugin, parent.player, this.name, 0.0, 2.147483647E9, true, (Double)this.treeValues.get(tree), value -> {
                    if (value == null) {
                        this.treeValues.remove(tree);
                    } else {
                        this.treeValues.put(tree, value);
                    }
                }));
            }

            @Override
            protected DebugResult doCheckTree(TreeFeller plugin, Tool tool, Tree tree, HashMap<Integer, ArrayList<Block>> blocks, int leaves) {
                int minX = Integer.MAX_VALUE;
                int minY = Integer.MAX_VALUE;
                int minZ = Integer.MAX_VALUE;
                int maxX = Integer.MIN_VALUE;
                int maxY = Integer.MIN_VALUE;
                int maxZ = Integer.MIN_VALUE;
                for (ArrayList<Block> blox : blocks.values()) {
                    for (Block block : blox) {
                        minX = Math.min(minX, block.getX());
                        minY = Math.min(minY, block.getY());
                        minZ = Math.min(minZ, block.getZ());
                        maxX = Math.max(maxX, block.getX());
                        maxY = Math.max(maxY, block.getY());
                        maxZ = Math.max(maxZ, block.getZ());
                    }
                }
                int width = Math.max(maxX - minX, maxZ - minZ);
                int height = maxY - minY;
                double value = (double)height / (double)width;
                if (this.toolValues.get(tool) == null && this.treeValues.get(tree) == null && this.globalValue != null && value > (Double)this.globalValue) {
                    return new DebugResult(this, DebugResult.Type.GLOBAL, value, this.globalValue);
                }
                if (this.treeValues.containsKey(tree) && value > (Double)this.treeValues.get(tree)) {
                    return new DebugResult(this, DebugResult.Type.TREE, value, this.treeValues.get(tree));
                }
                if (this.toolValues.containsKey(tool) && value > (Double)this.toolValues.get(tool)) {
                    return new DebugResult(this, DebugResult.Type.TOOL, value, this.toolValues.get(tool));
                }
                return new DebugResult(this, DebugResult.Type.SUCCESS, new Object[0]);
            }

            @Override
            public String[] getDebugText() {
                return 23.generateDebugText("Tree height ratio is too high$! {0}>{1}", "Tree height ratio is below maximum");
            }
        };
        MIN_VERTICAL_LOG_RATIO = new Option<Double>("Min Vertical Log Ratio", true, true, true, Double.valueOf(0.5)){

            @Override
            public String getDesc(boolean ingame) {
                return "What is the minimum ratio of vertical to horizontal logs that a tree may have?";
            }

            @Override
            public Double load(Object o) {
                return 24.loadDouble(o);
            }

            @Override
            public ItemBuilder getConfigurationDisplayItem(Double value) {
                return new ItemBuilder(Material.ACACIA_LOG);
            }

            @Override
            public void openGlobalModifyMenu(MenuGlobalConfiguration parent) {
                parent.open(new MenuModifyDouble(parent, parent.plugin, parent.player, this.name, 0.0, 2.147483647E9, true, (Double)this.globalValue, value -> {
                    this.globalValue = value;
                }));
            }

            @Override
            public void openToolModifyMenu(MenuToolConfiguration parent, Tool tool) {
                parent.open(new MenuModifyDouble(parent, parent.plugin, parent.player, this.name, 0.0, 2.147483647E9, true, (Double)this.toolValues.get(tool), value -> {
                    if (value == null) {
                        this.toolValues.remove(tool);
                    } else {
                        this.toolValues.put(tool, value);
                    }
                }));
            }

            @Override
            public void openTreeModifyMenu(MenuTreeConfiguration parent, Tree tree) {
                parent.open(new MenuModifyDouble(parent, parent.plugin, parent.player, this.name, 0.0, 2.147483647E9, true, (Double)this.treeValues.get(tree), value -> {
                    if (value == null) {
                        this.treeValues.remove(tree);
                    } else {
                        this.treeValues.put(tree, value);
                    }
                }));
            }

            @Override
            protected DebugResult doCheckTrunk(TreeFeller plugin, Tool tool, Tree tree, HashMap<Integer, ArrayList<Block>> blocks, Block block) {
                int horizontal = 0;
                int vertical = 0;
                for (ArrayList<Block> blox : blocks.values()) {
                    for (Block blok : blox) {
                        BlockData data = blok.getBlockData();
                        if (!(data instanceof Orientable)) continue;
                        if (((Orientable)data).getAxis() == Axis.Y) {
                            ++vertical;
                            continue;
                        }
                        ++horizontal;
                    }
                }
                double value = (double)vertical / (double)horizontal;
                if (this.toolValues.get(tool) == null && this.treeValues.get(tree) == null && this.globalValue != null && value < (Double)this.globalValue) {
                    return new DebugResult(this, DebugResult.Type.GLOBAL, value, this.globalValue);
                }
                if (this.treeValues.containsKey(tree) && value < (Double)this.treeValues.get(tree)) {
                    return new DebugResult(this, DebugResult.Type.TREE, value, this.treeValues.get(tree));
                }
                if (this.toolValues.containsKey(tool) && value < (Double)this.toolValues.get(tool)) {
                    return new DebugResult(this, DebugResult.Type.TOOL, value, this.toolValues.get(tool));
                }
                return new DebugResult(this, DebugResult.Type.SUCCESS, new Object[0]);
            }

            @Override
            public String[] getDebugText() {
                return 24.generateDebugText("Tree vertical log ratio is too low$! {0}<{1}", "Tree vertical log ratio is above minimum");
            }
        };
        MAX_VERTICAL_LOG_RATIO = new Option<Double>("Max Vertical Log Ratio", true, true, true, null){

            @Override
            public String getDesc(boolean ingame) {
                return "What is the maximum ratio of vertical to horizontal logs that a tree may have?";
            }

            @Override
            public Double load(Object o) {
                return 25.loadDouble(o);
            }

            @Override
            public ItemBuilder getConfigurationDisplayItem(Double value) {
                return new ItemBuilder(Material.ACACIA_LOG);
            }

            @Override
            public void openGlobalModifyMenu(MenuGlobalConfiguration parent) {
                parent.open(new MenuModifyDouble(parent, parent.plugin, parent.player, this.name, 0.0, 2.147483647E9, true, (Double)this.globalValue, value -> {
                    this.globalValue = value;
                }));
            }

            @Override
            public void openToolModifyMenu(MenuToolConfiguration parent, Tool tool) {
                parent.open(new MenuModifyDouble(parent, parent.plugin, parent.player, this.name, 0.0, 2.147483647E9, true, (Double)this.toolValues.get(tool), value -> {
                    if (value == null) {
                        this.toolValues.remove(tool);
                    } else {
                        this.toolValues.put(tool, value);
                    }
                }));
            }

            @Override
            public void openTreeModifyMenu(MenuTreeConfiguration parent, Tree tree) {
                parent.open(new MenuModifyDouble(parent, parent.plugin, parent.player, this.name, 0.0, 2.147483647E9, true, (Double)this.treeValues.get(tree), value -> {
                    if (value == null) {
                        this.treeValues.remove(tree);
                    } else {
                        this.treeValues.put(tree, value);
                    }
                }));
            }

            @Override
            protected DebugResult doCheckTrunk(TreeFeller plugin, Tool tool, Tree tree, HashMap<Integer, ArrayList<Block>> blocks, Block block) {
                int horizontal = 0;
                int vertical = 0;
                for (ArrayList<Block> blox : blocks.values()) {
                    for (Block blok : blox) {
                        BlockData data = blok.getBlockData();
                        if (!(data instanceof Orientable)) continue;
                        if (((Orientable)data).getAxis() == Axis.Y) {
                            ++vertical;
                            continue;
                        }
                        ++horizontal;
                    }
                }
                double value = (double)vertical / (double)horizontal;
                if (this.toolValues.get(tool) == null && this.treeValues.get(tree) == null && this.globalValue != null && value > (Double)this.globalValue) {
                    return new DebugResult(this, DebugResult.Type.GLOBAL, value, this.globalValue);
                }
                if (this.treeValues.containsKey(tree) && value > (Double)this.treeValues.get(tree)) {
                    return new DebugResult(this, DebugResult.Type.TREE, value, this.treeValues.get(tree));
                }
                if (this.toolValues.containsKey(tool) && value > (Double)this.toolValues.get(tool)) {
                    return new DebugResult(this, DebugResult.Type.TOOL, value, this.toolValues.get(tool));
                }
                return new DebugResult(this, DebugResult.Type.SUCCESS, new Object[0]);
            }

            @Override
            public String[] getDebugText() {
                return 25.generateDebugText("Tree vertical log ratio is too high$! {0}>{1}", "Tree vertical log ratio is below maximum");
            }
        };
        CUTTING_ANIMATION = new OptionBoolean("Cutting Animation", true, true, true, false){

            @Override
            public String getDesc(boolean ingame) {
                return "Should the tree cut down with an animation?";
            }

            @Override
            public ItemBuilder getConfigurationDisplayItem(Boolean value) {
                return new ItemBuilder(Material.GOLDEN_AXE);
            }
        };
        ANIM_DELAY = new Option<Integer>("Anim Delay", true, true, true, Integer.valueOf(1)){

            @Override
            public Integer load(Object o) {
                return 27.loadInt(o);
            }

            @Override
            public String getDesc(boolean ingame) {
                return "Animation delay, in ticks";
            }

            @Override
            public ItemBuilder getConfigurationDisplayItem(Integer value) {
                return new ItemBuilder(Material.CLOCK).setCount(value);
            }

            @Override
            public void openGlobalModifyMenu(MenuGlobalConfiguration parent) {
                parent.open(new MenuModifyInteger(parent, parent.plugin, parent.player, this.name, 1, Integer.MAX_VALUE, false, (Integer)this.globalValue, value -> {
                    this.globalValue = value;
                }));
            }

            @Override
            public void openToolModifyMenu(MenuToolConfiguration parent, Tool tool) {
                parent.open(new MenuModifyInteger(parent, parent.plugin, parent.player, this.name, 1, Integer.MAX_VALUE, true, (Integer)this.toolValues.get(tool), value -> {
                    if (value == null) {
                        this.toolValues.remove(tool);
                    } else {
                        this.toolValues.put(tool, value);
                    }
                }));
            }

            @Override
            public void openTreeModifyMenu(MenuTreeConfiguration parent, Tree tree) {
                parent.open(new MenuModifyInteger(parent, parent.plugin, parent.player, this.name, 1, Integer.MAX_VALUE, true, (Integer)this.treeValues.get(tree), value -> {
                    if (value == null) {
                        this.treeValues.remove(tree);
                    } else {
                        this.treeValues.put(tree, value);
                    }
                }));
            }
        };
        REPLANT_SAPLINGS = new OptionBoolean("Replant Saplings", true, true, true, false){

            @Override
            public String getDesc(boolean ingame) {
                return "Should saplings be replanted?";
            }

            @Override
            public ItemBuilder getConfigurationDisplayItem(Boolean value) {
                return new ItemBuilder(Material.OAK_SAPLING);
            }
        };
        USE_TREE_SAPLINGS = new OptionBoolean("Use Tree Saplings", true, true, true, true){

            @Override
            public String getDesc(boolean ingame) {
                return "Should saplings dropped by the tree's leaves be used to replant trees?";
            }

            @Override
            public ItemBuilder getConfigurationDisplayItem(Boolean value) {
                return new ItemBuilder(Material.OAK_LEAVES);
            }
        };
        USE_INVENTORY_SAPLINGS = new OptionBoolean("Use Inventory Saplings", true, true, true, false){

            @Override
            public String getDesc(boolean ingame) {
                return "Should saplings be taken from the player's inventory to replant trees?";
            }

            @Override
            public ItemBuilder getConfigurationDisplayItem(Boolean value) {
                return new ItemBuilder(Material.CHEST);
            }
        };
        SPAWN_SAPLINGS = new Option<Integer>("Spawn Saplings", true, true, true, Integer.valueOf(0)){

            @Override
            public Integer load(Object o) {
                return 31.loadInt(o);
            }

            @Override
            public Integer get(Tool tool, Tree tree) {
                if (this.toolValues.containsKey(tool) || this.treeValues.containsKey(tree)) {
                    Integer tl = this.toolValues.getOrDefault(tool, 0);
                    Integer tr = this.treeValues.getOrDefault(tree, 0);
                    return Math.max(tl, tr);
                }
                return (Integer)this.globalValue;
            }

            @Override
            public String getDesc(boolean ingame) {
                return "Should saplings be spawned?\n0 = No, only replant if the leaves drop saplings\n1 = Yes, but only if the leaves do not drop enough\n2 = Yes, always spawn new saplings";
            }

            @Override
            public ItemBuilder getConfigurationDisplayItem(Integer value) {
                return new ItemBuilder(Material.OAK_SAPLING);
            }

            @Override
            public void openGlobalModifyMenu(MenuGlobalConfiguration parent) {
                parent.open(new MenuModifySpawnSaplings(parent, parent.plugin, parent.player, false, (Integer)this.globalValue, value -> {
                    this.globalValue = value;
                }));
            }

            @Override
            public void openToolModifyMenu(MenuToolConfiguration parent, Tool tool) {
                parent.open(new MenuModifySpawnSaplings(parent, parent.plugin, parent.player, true, (Integer)this.toolValues.get(tool), value -> {
                    if (value == null) {
                        this.toolValues.remove(tool);
                    } else {
                        this.toolValues.put(tool, value);
                    }
                }));
            }

            @Override
            public void openTreeModifyMenu(MenuTreeConfiguration parent, Tree tree) {
                parent.open(new MenuModifySpawnSaplings(parent, parent.plugin, parent.player, true, (Integer)this.treeValues.get(tree), value -> {
                    if (value == null) {
                        this.treeValues.remove(tree);
                    } else {
                        this.treeValues.put(tree, value);
                    }
                }));
            }
        };
        SAPLING = new Option<HashSet<Material>>("Sapling", false, false, true, null){

            @Override
            public HashSet<Material> load(Object o) {
                return 32.loadMaterialSet(o);
            }

            @Override
            public String getDesc(boolean ingame) {
                return "If replant-saplings is enabled, this will replant the tree with this type of sapling";
            }

            @Override
            public ItemBuilder getConfigurationDisplayItem(HashSet<Material> value) {
                return new ItemBuilder(Material.OAK_SAPLING);
            }

            @Override
            public void openGlobalModifyMenu(MenuGlobalConfiguration parent) {
                parent.open(new MenuModifyMaterialSet(parent, parent.plugin, parent.player, this.name, false, "block", (HashSet)this.globalValue, material -> material.isBlock(), value -> {
                    this.globalValue = value;
                }));
            }

            @Override
            public void openToolModifyMenu(MenuToolConfiguration parent, Tool tool) {
                parent.open(new MenuModifyMaterialSet(parent, parent.plugin, parent.player, this.name, true, "block", (HashSet)this.toolValues.get(tool), material -> material.isBlock(), value -> {
                    if (value == null) {
                        this.toolValues.remove(tool);
                    } else {
                        this.toolValues.put(tool, value);
                    }
                }));
            }

            @Override
            public void openTreeModifyMenu(MenuTreeConfiguration parent, Tree tree) {
                parent.open(new MenuModifyMaterialSet(parent, parent.plugin, parent.player, this.name, true, "block", (HashSet)this.treeValues.get(tree), material -> material.isBlock(), value -> {
                    if (value == null) {
                        this.treeValues.remove(tree);
                    } else {
                        this.treeValues.put(tree, value);
                    }
                }));
            }
        };
        SAPLING_TIMEOUT = new Option<Integer>("Sapling Timeout", true, true, true, Integer.valueOf(50)){

            @Override
            public Integer load(Object o) {
                return 33.loadInt(o);
            }

            @Override
            public Integer get(Tool tool, Tree tree) {
                if (this.toolValues.containsKey(tool) || this.treeValues.containsKey(tree)) {
                    Integer tl = this.toolValues.getOrDefault(tool, 0);
                    Integer tr = this.treeValues.getOrDefault(tree, 0);
                    return Math.max(tl, tr);
                }
                return (Integer)this.globalValue;
            }

            @Override
            public String getDesc(boolean ingame) {
                return "The amount of delay a sapling may take to respawn (if spawn saplings is set to 1, saplings will be spawned only after this amount of time, but will still be immediately planted upon dropping from leaves)";
            }

            @Override
            public ItemBuilder getConfigurationDisplayItem(Integer value) {
                return new ItemBuilder(Material.CLOCK);
            }

            @Override
            public void openGlobalModifyMenu(MenuGlobalConfiguration parent) {
                parent.open(new MenuModifyInteger(parent, parent.plugin, parent.player, this.name, 0, Integer.MAX_VALUE, false, (Integer)this.globalValue, value -> {
                    this.globalValue = value;
                }));
            }

            @Override
            public void openToolModifyMenu(MenuToolConfiguration parent, Tool tool) {
                parent.open(new MenuModifyInteger(parent, parent.plugin, parent.player, this.name, 0, Integer.MAX_VALUE, true, (Integer)this.toolValues.get(tool), value -> {
                    if (value == null) {
                        this.toolValues.remove(tool);
                    } else {
                        this.toolValues.put(tool, value);
                    }
                }));
            }

            @Override
            public void openTreeModifyMenu(MenuTreeConfiguration parent, Tree tree) {
                parent.open(new MenuModifyInteger(parent, parent.plugin, parent.player, this.name, 0, Integer.MAX_VALUE, true, (Integer)this.treeValues.get(tree), value -> {
                    if (value == null) {
                        this.treeValues.remove(tree);
                    } else {
                        this.treeValues.put(tree, value);
                    }
                }));
            }
        };
        MAX_SAPLINGS = new Option<Integer>("Max Saplings", false, false, true, Integer.valueOf(1)){

            @Override
            public Integer load(Object o) {
                return 34.loadInt(o);
            }

            @Override
            public String getDesc(boolean ingame) {
                return "If replant-saplings is enabled, this will limit the number of saplings that can be replanted";
            }

            @Override
            public ItemBuilder getConfigurationDisplayItem(Integer value) {
                return new ItemBuilder(Material.OAK_SAPLING).setCount(value);
            }

            @Override
            public void openGlobalModifyMenu(MenuGlobalConfiguration parent) {
                parent.open(new MenuModifyInteger(parent, parent.plugin, parent.player, this.name, 1, Integer.MAX_VALUE, false, (Integer)this.globalValue, value -> {
                    this.globalValue = value;
                }));
            }

            @Override
            public void openToolModifyMenu(MenuToolConfiguration parent, Tool tool) {
                parent.open(new MenuModifyInteger(parent, parent.plugin, parent.player, this.name, 1, Integer.MAX_VALUE, true, (Integer)this.toolValues.get(tool), value -> {
                    if (value == null) {
                        this.toolValues.remove(tool);
                    } else {
                        this.toolValues.put(tool, value);
                    }
                }));
            }

            @Override
            public void openTreeModifyMenu(MenuTreeConfiguration parent, Tree tree) {
                parent.open(new MenuModifyInteger(parent, parent.plugin, parent.player, this.name, 1, Integer.MAX_VALUE, true, (Integer)this.treeValues.get(tree), value -> {
                    if (value == null) {
                        this.treeValues.remove(tree);
                    } else {
                        this.treeValues.put(tree, value);
                    }
                }));
            }
        };
        GRASS = new Option<HashSet<Material>>("Grass", true, false, true, defaultGrasses){

            @Override
            public HashSet<Material> load(Object o) {
                return 35.loadMaterialSet(o);
            }

            @Override
            public String getDesc(boolean ingame) {
                return "What blocks can saplings be planted on?";
            }

            @Override
            public ItemBuilder getConfigurationDisplayItem(HashSet<Material> value) {
                return new ItemBuilder(Material.GRASS_BLOCK);
            }

            @Override
            public void openGlobalModifyMenu(MenuGlobalConfiguration parent) {
                parent.open(new MenuModifyMaterialSet(parent, parent.plugin, parent.player, this.name, false, "block", (HashSet)this.globalValue, material -> material.isBlock(), value -> {
                    this.globalValue = value;
                }));
            }

            @Override
            public void openToolModifyMenu(MenuToolConfiguration parent, Tool tool) {
                parent.open(new MenuModifyMaterialSet(parent, parent.plugin, parent.player, this.name, true, "block", (HashSet)this.toolValues.get(tool), material -> material.isBlock(), value -> {
                    if (value == null) {
                        this.toolValues.remove(tool);
                    } else {
                        this.toolValues.put(tool, value);
                    }
                }));
            }

            @Override
            public void openTreeModifyMenu(MenuTreeConfiguration parent, Tree tree) {
                parent.open(new MenuModifyMaterialSet(parent, parent.plugin, parent.player, this.name, true, "block", (HashSet)this.treeValues.get(tree), material -> material.isBlock(), value -> {
                    if (value == null) {
                        this.treeValues.remove(tree);
                    } else {
                        this.treeValues.put(tree, value);
                    }
                }));
            }
        };
        ROOTS = new Option<HashSet<Material>>("Roots", false, false, true, null){

            @Override
            public HashSet<Material> load(Object o) {
                return 36.loadMaterialSet(o);
            }

            @Override
            public String getDesc(boolean ingame) {
                return "Roots can be used to cut down a tree when you can't reach the trunk. (The nearest tree will be attempted to be cut down)";
            }

            @Override
            public ItemBuilder getConfigurationDisplayItem(HashSet<Material> value) {
                Material m = Material.matchMaterial((String)"MANGROVE_ROOTS");
                if (m == null) {
                    m = Material.OAK_WOOD;
                }
                return new ItemBuilder(m);
            }

            @Override
            public void openGlobalModifyMenu(MenuGlobalConfiguration parent) {
                parent.open(new MenuModifyMaterialSet(parent, parent.plugin, parent.player, this.name, false, "block", (HashSet)this.globalValue, material -> material.isBlock(), value -> {
                    this.globalValue = value;
                }));
            }

            @Override
            public void openToolModifyMenu(MenuToolConfiguration parent, Tool tool) {
                parent.open(new MenuModifyMaterialSet(parent, parent.plugin, parent.player, this.name, true, "block", (HashSet)this.toolValues.get(tool), material -> material.isBlock(), value -> {
                    if (value == null) {
                        this.toolValues.remove(tool);
                    } else {
                        this.toolValues.put(tool, value);
                    }
                }));
            }

            @Override
            public void openTreeModifyMenu(MenuTreeConfiguration parent, Tree tree) {
                parent.open(new MenuModifyMaterialSet(parent, parent.plugin, parent.player, this.name, true, "block", (HashSet)this.treeValues.get(tree), material -> material.isBlock(), value -> {
                    if (value == null) {
                        this.treeValues.remove(tree);
                    } else {
                        this.treeValues.put(tree, value);
                    }
                }));
            }
        };
        ROOT_DISTANCE = new Option<Integer>("Root Distance", true, false, true, Integer.valueOf(6)){

            @Override
            public Integer load(Object o) {
                return 37.loadInt(o);
            }

            @Override
            public String getDesc(boolean ingame) {
                return "How far away from the trunk can you use roots to cut down a tree?";
            }

            @Override
            public ItemBuilder getConfigurationDisplayItem(Integer value) {
                Material m = Material.matchMaterial((String)"MANGROVE_ROOTS");
                if (m == null) {
                    m = Material.OAK_WOOD;
                }
                return new ItemBuilder(m).setCount(value);
            }

            @Override
            public void openGlobalModifyMenu(MenuGlobalConfiguration parent) {
                parent.open(new MenuModifyInteger(parent, parent.plugin, parent.player, this.name, 0, Integer.MAX_VALUE, false, (Integer)this.globalValue, value -> {
                    this.globalValue = value;
                }));
            }

            @Override
            public void openToolModifyMenu(MenuToolConfiguration parent, Tool tool) {
                parent.open(new MenuModifyInteger(parent, parent.plugin, parent.player, this.name, 0, Integer.MAX_VALUE, true, (Integer)this.toolValues.get(tool), value -> {
                    if (value == null) {
                        this.toolValues.remove(tool);
                    } else {
                        this.toolValues.put(tool, value);
                    }
                }));
            }

            @Override
            public void openTreeModifyMenu(MenuTreeConfiguration parent, Tree tree) {
                parent.open(new MenuModifyInteger(parent, parent.plugin, parent.player, this.name, 0, Integer.MAX_VALUE, true, (Integer)this.treeValues.get(tree), value -> {
                    if (value == null) {
                        this.treeValues.remove(tree);
                    } else {
                        this.treeValues.put(tree, value);
                    }
                }));
            }
        };
        LOG_BEHAVIOR = new Option<FellBehavior>("Log Behavior", true, true, true, FellBehavior.BREAK){

            @Override
            public FellBehavior load(Object o) {
                if (o instanceof FellBehavior) {
                    return (FellBehavior)((Object)o);
                }
                if (o instanceof String) {
                    try {
                        return FellBehavior.valueOf((String)o);
                    }
                    catch (Exception ex) {
                        return null;
                    }
                }
                return null;
            }

            @Override
            public String getDesc(boolean ingame) {
                String s = "What felling behavior should logs have?\n";
                if (!ingame) {
                    s = s + "Valid options:\n";
                    int width = Option.findMaxWidth((Object[])FellBehavior.values());
                    for (FellBehavior behavior : FellBehavior.values()) {
                        s = s + Option.normalize(behavior.name(), width) + " " + behavior.getDescription() + "\n";
                    }
                }
                s = s + "Note that falling blocks occasionally drop as items if they land wrong";
                return s;
            }

            @Override
            public ItemBuilder getConfigurationDisplayItem(FellBehavior value) {
                return new ItemBuilder(Material.OAK_LOG);
            }

            @Override
            public void openGlobalModifyMenu(MenuGlobalConfiguration parent) {
                parent.open(new MenuModifyFellBehavior(parent, parent.plugin, parent.player, this.name, false, (FellBehavior)((Object)this.globalValue), FellBehavior.values(), value -> {
                    this.globalValue = value;
                }));
            }

            @Override
            public void openToolModifyMenu(MenuToolConfiguration parent, Tool tool) {
                parent.open(new MenuModifyFellBehavior(parent, parent.plugin, parent.player, this.name, true, (FellBehavior)((Object)this.toolValues.get(tool)), FellBehavior.values(), value -> {
                    if (value == null) {
                        this.toolValues.remove(tool);
                    } else {
                        this.toolValues.put(tool, value);
                    }
                }));
            }

            @Override
            public void openTreeModifyMenu(MenuTreeConfiguration parent, Tree tree) {
                parent.open(new MenuModifyFellBehavior(parent, parent.plugin, parent.player, this.name, true, (FellBehavior)((Object)this.treeValues.get(tree)), FellBehavior.values(), value -> {
                    if (value == null) {
                        this.treeValues.remove(tree);
                    } else {
                        this.treeValues.put(tree, value);
                    }
                }));
            }
        };
        LEAF_BEHAVIOR = new Option<FellBehavior>("Leaf Behavior", true, true, true, FellBehavior.BREAK){

            @Override
            public FellBehavior load(Object o) {
                if (o instanceof FellBehavior) {
                    return (FellBehavior)((Object)o);
                }
                if (o instanceof String) {
                    try {
                        return FellBehavior.valueOf((String)o);
                    }
                    catch (Exception ex) {
                        return null;
                    }
                }
                return null;
            }

            @Override
            public String getDesc(boolean ingame) {
                String s = "What felling behavior should leaves have?\n";
                if (!ingame) {
                    s = s + "Valid options:\n";
                    int len = Option.findMaxWidth((Object[])FellBehavior.values());
                    for (FellBehavior behavior : FellBehavior.values()) {
                        s = s + Option.normalize(behavior.name(), len) + " " + behavior.getDescription() + "\n";
                    }
                }
                s = s + "Note that falling blocks occasionally drop as items if they land wrong";
                return s;
            }

            @Override
            public ItemBuilder getConfigurationDisplayItem(FellBehavior value) {
                return new ItemBuilder(Material.OAK_LEAVES);
            }

            @Override
            public void openGlobalModifyMenu(MenuGlobalConfiguration parent) {
                parent.open(new MenuModifyFellBehavior(parent, parent.plugin, parent.player, this.name, false, (FellBehavior)((Object)this.globalValue), FellBehavior.values(), value -> {
                    this.globalValue = value;
                }));
            }

            @Override
            public void openToolModifyMenu(MenuToolConfiguration parent, Tool tool) {
                parent.open(new MenuModifyFellBehavior(parent, parent.plugin, parent.player, this.name, true, (FellBehavior)((Object)this.toolValues.get(tool)), FellBehavior.values(), value -> {
                    if (value == null) {
                        this.toolValues.remove(tool);
                    } else {
                        this.toolValues.put(tool, value);
                    }
                }));
            }

            @Override
            public void openTreeModifyMenu(MenuTreeConfiguration parent, Tree tree) {
                parent.open(new MenuModifyFellBehavior(parent, parent.plugin, parent.player, this.name, true, (FellBehavior)((Object)this.treeValues.get(tree)), FellBehavior.values(), value -> {
                    if (value == null) {
                        this.treeValues.remove(tree);
                    } else {
                        this.treeValues.put(tree, value);
                    }
                }));
            }
        };
        FALL_HURT_AMOUNT = new Option<Float>("Fall Hurt Amount", true, true, true, Float.valueOf(2.0f)){

            @Override
            public Float load(Object o) {
                return 40.loadFloat(o);
            }

            @Override
            public String getDesc(boolean ingame) {
                return "How much damage should falling blocks deal per block fallen? (Only applies to FALL_HURT fell behaviors)";
            }

            @Override
            public ItemBuilder getConfigurationDisplayItem(Float value) {
                return new ItemBuilder(Material.CHIPPED_ANVIL);
            }

            @Override
            public void openGlobalModifyMenu(MenuGlobalConfiguration parent) {
                parent.open(new MenuModifyFloat(parent, parent.plugin, parent.player, this.name, 0.0f, 2.1474836E9f, 1.0f, false, (Float)this.globalValue, value -> {
                    this.globalValue = value;
                }));
            }

            @Override
            public void openToolModifyMenu(MenuToolConfiguration parent, Tool tool) {
                parent.open(new MenuModifyFloat(parent, parent.plugin, parent.player, this.name, 0.0f, 2.1474836E9f, 1.0f, true, (Float)this.toolValues.get(tool), value -> {
                    if (value == null) {
                        this.toolValues.remove(tool);
                    } else {
                        this.toolValues.put(tool, value);
                    }
                }));
            }

            @Override
            public void openTreeModifyMenu(MenuTreeConfiguration parent, Tree tree) {
                parent.open(new MenuModifyFloat(parent, parent.plugin, parent.player, this.name, 0.0f, 2.1474836E9f, 1.0f, true, (Float)this.treeValues.get(tree), value -> {
                    if (value == null) {
                        this.treeValues.remove(tree);
                    } else {
                        this.treeValues.put(tree, value);
                    }
                }));
            }
        };
        FALL_HURT_MAX = new Option<Integer>("Fall Hurt Max", true, true, true, Integer.valueOf(40)){

            @Override
            public Integer load(Object o) {
                return 41.loadInt(o);
            }

            @Override
            public String getDesc(boolean ingame) {
                return "What is the maximum amount of damage a falling block may deal upon landing? (Only applies to FALL_HURT fell behaviors)";
            }

            @Override
            public ItemBuilder getConfigurationDisplayItem(Integer value) {
                return new ItemBuilder(Material.DAMAGED_ANVIL);
            }

            @Override
            public void openGlobalModifyMenu(MenuGlobalConfiguration parent) {
                parent.open(new MenuModifyInteger(parent, parent.plugin, parent.player, this.name, 0, Integer.MAX_VALUE, false, (Integer)this.globalValue, value -> {
                    this.globalValue = value;
                }));
            }

            @Override
            public void openToolModifyMenu(MenuToolConfiguration parent, Tool tool) {
                parent.open(new MenuModifyInteger(parent, parent.plugin, parent.player, this.name, 0, Integer.MAX_VALUE, true, (Integer)this.toolValues.get(tool), value -> {
                    if (value == null) {
                        this.toolValues.remove(tool);
                    } else {
                        this.toolValues.put(tool, value);
                    }
                }));
            }

            @Override
            public void openTreeModifyMenu(MenuTreeConfiguration parent, Tree tree) {
                parent.open(new MenuModifyInteger(parent, parent.plugin, parent.player, this.name, 0, Integer.MAX_VALUE, true, (Integer)this.treeValues.get(tree), value -> {
                    if (value == null) {
                        this.treeValues.remove(tree);
                    } else {
                        this.treeValues.put(tree, value);
                    }
                }));
            }
        };
        DIRECTIONAL_FALL_BEHAVIOR = new Option<DirectionalFallBehavior>("Directional Fall Behavior", true, true, true, DirectionalFallBehavior.RANDOM){

            @Override
            public DirectionalFallBehavior load(Object o) {
                if (o instanceof DirectionalFallBehavior) {
                    return (DirectionalFallBehavior)((Object)o);
                }
                if (o instanceof String) {
                    try {
                        return DirectionalFallBehavior.valueOf((String)o);
                    }
                    catch (Exception ex) {
                        return null;
                    }
                }
                return null;
            }

            @Override
            public String getDesc(boolean ingame) {
                String s = "Which direction should the tree fall in?\n(Only used when log or leaf behavior is set to FALL or similar)\n";
                if (!ingame) {
                    s = s + "Valid options:\n";
                    int i = Option.findMaxWidth((Object[])DirectionalFallBehavior.values());
                    for (DirectionalFallBehavior behavior : DirectionalFallBehavior.values()) {
                        s = s + Option.normalize(behavior.name(), i) + " " + behavior.getDescription() + "\n";
                    }
                }
                return s;
            }

            @Override
            public ItemBuilder getConfigurationDisplayItem(DirectionalFallBehavior value) {
                return new ItemBuilder(Material.OAK_LOG);
            }

            @Override
            public void openGlobalModifyMenu(MenuGlobalConfiguration parent) {
                parent.open(new MenuModifyDirectionalFallBehavior(parent, parent.plugin, parent.player, this.name, false, (DirectionalFallBehavior)((Object)this.globalValue), DirectionalFallBehavior.values(), value -> {
                    this.globalValue = value;
                }));
            }

            @Override
            public void openToolModifyMenu(MenuToolConfiguration parent, Tool tool) {
                parent.open(new MenuModifyDirectionalFallBehavior(parent, parent.plugin, parent.player, this.name, true, (DirectionalFallBehavior)((Object)this.toolValues.get(tool)), DirectionalFallBehavior.values(), value -> {
                    if (value == null) {
                        this.toolValues.remove(tool);
                    } else {
                        this.toolValues.put(tool, value);
                    }
                }));
            }

            @Override
            public void openTreeModifyMenu(MenuTreeConfiguration parent, Tree tree) {
                parent.open(new MenuModifyDirectionalFallBehavior(parent, parent.plugin, parent.player, this.name, true, (DirectionalFallBehavior)((Object)this.treeValues.get(tree)), DirectionalFallBehavior.values(), value -> {
                    if (value == null) {
                        this.treeValues.remove(tree);
                    } else {
                        this.treeValues.put(tree, value);
                    }
                }));
            }
        };
        OVERRIDABLES = new Option<HashSet<Material>>("Overridables", true, true, true, defaultOverridables){

            @Override
            public HashSet<Material> load(Object o) {
                return 43.loadMaterialSet(o);
            }

            @Override
            public String getDesc(boolean ingame) {
                return "This is the list of blocks that may be overridden when a tree falls onto them (e.g air, grass, water)\n(Only used for NATURAL fell behavior)";
            }

            @Override
            public ItemBuilder getConfigurationDisplayItem(HashSet<Material> value) {
                return new ItemBuilder(Material.GRASS);
            }

            @Override
            public void openGlobalModifyMenu(MenuGlobalConfiguration parent) {
                parent.open(new MenuModifyMaterialSet(parent, parent.plugin, parent.player, this.name, false, "block", (HashSet)this.globalValue, material -> material.isBlock(), value -> {
                    this.globalValue = value;
                }));
            }

            @Override
            public void openToolModifyMenu(MenuToolConfiguration parent, Tool tool) {
                parent.open(new MenuModifyMaterialSet(parent, parent.plugin, parent.player, this.name, true, "block", (HashSet)this.toolValues.get(tool), material -> material.isBlock(), value -> {
                    if (value == null) {
                        this.toolValues.remove(tool);
                    } else {
                        this.toolValues.put(tool, value);
                    }
                }));
            }

            @Override
            public void openTreeModifyMenu(MenuTreeConfiguration parent, Tree tree) {
                parent.open(new MenuModifyMaterialSet(parent, parent.plugin, parent.player, this.name, true, "block", (HashSet)this.treeValues.get(tree), material -> material.isBlock(), value -> {
                    if (value == null) {
                        this.treeValues.remove(tree);
                    } else {
                        this.treeValues.put(tree, value);
                    }
                }));
            }
        };
        LOCK_FALL_CARDINAL = new OptionBoolean("Lock Fall Cardinal", true, true, true, false){

            @Override
            public String getDesc(boolean ingame) {
                return "If set to true, trees can only fall in one of the cardinal directions (N/S/E/W)";
            }

            @Override
            public ItemBuilder getConfigurationDisplayItem(Boolean value) {
                return new ItemBuilder(Material.COMPASS);
            }
        };
        DIRECTIONAL_FALL_VELOCITY = new Option<Double>("Directional Fall Velocity", true, true, true, Double.valueOf(0.35)){

            @Override
            public Double load(Object o) {
                return 45.loadDouble(o);
            }

            @Override
            public Double get(Tool tool, Tree tree) {
                double glob = 0.0;
                if (this.toolValues.get(tool) == null || this.treeValues.get(tree) == null) {
                    glob = (Double)this.globalValue;
                }
                Double tl = this.toolValues.getOrDefault(tool, 0.0);
                Double tr = this.treeValues.getOrDefault(tree, 0.0);
                return tl + tr + glob;
            }

            @Override
            public String getDesc(boolean ingame) {
                return "How much horizontal velocity should falling trees get?\n(Only used when log or leaf behavior is set to FALL or similar)\nAll of the blocks in the tree will fall in the same direction with this velocity.";
            }

            @Override
            public ItemBuilder getConfigurationDisplayItem(Double value) {
                return new ItemBuilder(Material.OAK_LOG);
            }

            @Override
            public void openGlobalModifyMenu(MenuGlobalConfiguration parent) {
                parent.open(new MenuModifyDouble(parent, parent.plugin, parent.player, this.name, -2.147483648E9, 2.147483647E9, false, (Double)this.globalValue, value -> {
                    this.globalValue = value;
                }));
            }

            @Override
            public void openToolModifyMenu(MenuToolConfiguration parent, Tool tool) {
                parent.open(new MenuModifyDouble(parent, parent.plugin, parent.player, this.name, -2.147483648E9, 2.147483647E9, true, (Double)this.toolValues.get(tool), value -> {
                    if (value == null) {
                        this.toolValues.remove(tool);
                    } else {
                        this.toolValues.put(tool, value);
                    }
                }));
            }

            @Override
            public void openTreeModifyMenu(MenuTreeConfiguration parent, Tree tree) {
                parent.open(new MenuModifyDouble(parent, parent.plugin, parent.player, this.name, -2.147483648E9, 2.147483647E9, true, (Double)this.treeValues.get(tree), value -> {
                    if (value == null) {
                        this.treeValues.remove(tree);
                    } else {
                        this.treeValues.put(tree, value);
                    }
                }));
            }
        };
        VERTICAL_FALL_VELOCITY = new Option<Double>("Vertical Fall Velocity", true, true, true, Double.valueOf(0.05)){

            @Override
            public Double load(Object o) {
                return 46.loadDouble(o);
            }

            @Override
            public Double get(Tool tool, Tree tree) {
                double glob = 0.0;
                if (this.toolValues.get(tool) == null || this.treeValues.get(tree) == null) {
                    glob = (Double)this.globalValue;
                }
                Double tl = this.toolValues.getOrDefault(tool, 0.0);
                Double tr = this.treeValues.getOrDefault(tree, 0.0);
                return tl + tr + glob;
            }

            @Override
            public String getDesc(boolean ingame) {
                return "How much upwards velocity should falling trees get?\n(Only used when log or leaf behavior is set to FALL or similar)";
            }

            @Override
            public ItemBuilder getConfigurationDisplayItem(Double value) {
                return new ItemBuilder(Material.OAK_LOG);
            }

            @Override
            public void openGlobalModifyMenu(MenuGlobalConfiguration parent) {
                parent.open(new MenuModifyDouble(parent, parent.plugin, parent.player, this.name, -2.147483648E9, 2.147483647E9, false, (Double)this.globalValue, value -> {
                    this.globalValue = value;
                }));
            }

            @Override
            public void openToolModifyMenu(MenuToolConfiguration parent, Tool tool) {
                parent.open(new MenuModifyDouble(parent, parent.plugin, parent.player, this.name, -2.147483648E9, 2.147483647E9, true, (Double)this.toolValues.get(tool), value -> {
                    if (value == null) {
                        this.toolValues.remove(tool);
                    } else {
                        this.toolValues.put(tool, value);
                    }
                }));
            }

            @Override
            public void openTreeModifyMenu(MenuTreeConfiguration parent, Tree tree) {
                parent.open(new MenuModifyDouble(parent, parent.plugin, parent.player, this.name, -2.147483648E9, 2.147483647E9, true, (Double)this.treeValues.get(tree), value -> {
                    if (value == null) {
                        this.treeValues.remove(tree);
                    } else {
                        this.treeValues.put(tree, value);
                    }
                }));
            }
        };
        EXPLOSIVE_FALL_VELOCITY = new Option<Double>("Explosive Fall Velocity", true, true, true, Double.valueOf(0.0)){

            @Override
            public Double load(Object o) {
                return 47.loadDouble(o);
            }

            @Override
            public Double get(Tool tool, Tree tree) {
                double glob = 0.0;
                if (this.toolValues.get(tool) == null || this.treeValues.get(tree) == null) {
                    glob = (Double)this.globalValue;
                }
                Double tl = this.toolValues.getOrDefault(tool, 0.0);
                Double tr = this.treeValues.getOrDefault(tree, 0.0);
                return tl + tr + glob;
            }

            @Override
            public String getDesc(boolean ingame) {
                return "How much explosive sideways velocity should falling blocks get? Velocity is applied away from the block that was used to cut down the tree (no velocity will be applied to blocks in the exact center)\n(Only used when log or leaf behavior is set to FALL or similar)";
            }

            @Override
            public ItemBuilder getConfigurationDisplayItem(Double value) {
                return new ItemBuilder(Material.TNT);
            }

            @Override
            public void openGlobalModifyMenu(MenuGlobalConfiguration parent) {
                parent.open(new MenuModifyDouble(parent, parent.plugin, parent.player, this.name, -2.147483648E9, 2.147483647E9, false, (Double)this.globalValue, value -> {
                    this.globalValue = value;
                }));
            }

            @Override
            public void openToolModifyMenu(MenuToolConfiguration parent, Tool tool) {
                parent.open(new MenuModifyDouble(parent, parent.plugin, parent.player, this.name, -2.147483648E9, 2.147483647E9, true, (Double)this.toolValues.get(tool), value -> {
                    if (value == null) {
                        this.toolValues.remove(tool);
                    } else {
                        this.toolValues.put(tool, value);
                    }
                }));
            }

            @Override
            public void openTreeModifyMenu(MenuTreeConfiguration parent, Tree tree) {
                parent.open(new MenuModifyDouble(parent, parent.plugin, parent.player, this.name, -2.147483648E9, 2.147483647E9, true, (Double)this.treeValues.get(tree), value -> {
                    if (value == null) {
                        this.treeValues.remove(tree);
                    } else {
                        this.treeValues.put(tree, value);
                    }
                }));
            }
        };
        RANDOM_FALL_VELOCITY = new Option<Double>("Random Fall Velocity", true, true, true, Double.valueOf(0.0)){

            @Override
            public Double load(Object o) {
                return 48.loadDouble(o);
            }

            @Override
            public Double get(Tool tool, Tree tree) {
                double glob = 0.0;
                if (this.toolValues.get(tool) == null || this.treeValues.get(tree) == null) {
                    glob = (Double)this.globalValue;
                }
                Double tl = this.toolValues.getOrDefault(tool, 0.0);
                Double tr = this.treeValues.getOrDefault(tree, 0.0);
                return tl + tr + glob;
            }

            @Override
            public String getDesc(boolean ingame) {
                return "How much random sideways velocity should falling blocks get?\n(Only used when log or leaf behavior is set to FALL or similar)";
            }

            @Override
            public ItemBuilder getConfigurationDisplayItem(Double value) {
                return new ItemBuilder(Material.OAK_LOG);
            }

            @Override
            public void openGlobalModifyMenu(MenuGlobalConfiguration parent) {
                parent.open(new MenuModifyDouble(parent, parent.plugin, parent.player, this.name, -2.147483648E9, 2.147483647E9, false, (Double)this.globalValue, value -> {
                    this.globalValue = value;
                }));
            }

            @Override
            public void openToolModifyMenu(MenuToolConfiguration parent, Tool tool) {
                parent.open(new MenuModifyDouble(parent, parent.plugin, parent.player, this.name, -2.147483648E9, 2.147483647E9, true, (Double)this.toolValues.get(tool), value -> {
                    if (value == null) {
                        this.toolValues.remove(tool);
                    } else {
                        this.toolValues.put(tool, value);
                    }
                }));
            }

            @Override
            public void openTreeModifyMenu(MenuTreeConfiguration parent, Tree tree) {
                parent.open(new MenuModifyDouble(parent, parent.plugin, parent.player, this.name, -2.147483648E9, 2.147483647E9, true, (Double)this.treeValues.get(tree), value -> {
                    if (value == null) {
                        this.treeValues.remove(tree);
                    } else {
                        this.treeValues.put(tree, value);
                    }
                }));
            }
        };
        FALL_DELAY = new Option<Integer>("Fall Delay", true, true, true, Integer.valueOf(0)){

            @Override
            public Integer load(Object o) {
                return 49.loadInt(o);
            }

            @Override
            public String getDesc(boolean ingame) {
                return "An extra delay between breaking a block and spawning a falling block. (Only affects FALL behaviors)\nThis is intended as a workaround for collision issues between fall behaviors and the cutting animation";
            }

            @Override
            public ItemBuilder getConfigurationDisplayItem(Integer value) {
                return new ItemBuilder(Material.CLOCK).setCount(value).enchant(Enchantment.VANISHING_CURSE).addFlag(ItemFlag.HIDE_ENCHANTS);
            }

            @Override
            public void openGlobalModifyMenu(MenuGlobalConfiguration parent) {
                parent.open(new MenuModifyInteger(parent, parent.plugin, parent.player, this.name, 0, Integer.MAX_VALUE, false, (Integer)this.globalValue, value -> {
                    this.globalValue = value;
                }));
            }

            @Override
            public void openToolModifyMenu(MenuToolConfiguration parent, Tool tool) {
                parent.open(new MenuModifyInteger(parent, parent.plugin, parent.player, this.name, 0, Integer.MAX_VALUE, true, (Integer)this.toolValues.get(tool), value -> {
                    if (value == null) {
                        this.toolValues.remove(tool);
                    } else {
                        this.toolValues.put(tool, value);
                    }
                }));
            }

            @Override
            public void openTreeModifyMenu(MenuTreeConfiguration parent, Tree tree) {
                parent.open(new MenuModifyInteger(parent, parent.plugin, parent.player, this.name, 0, Integer.MAX_VALUE, true, (Integer)this.treeValues.get(tree), value -> {
                    if (value == null) {
                        this.treeValues.remove(tree);
                    } else {
                        this.treeValues.put(tree, value);
                    }
                }));
            }
        };
        RESPECT_UNBREAKING = new OptionBoolean("Respect Unbreaking", true, true, true, true){

            @Override
            public String getDesc(boolean ingame) {
                return "If a tool has unbreaking, should it take less damage from felling trees?";
            }

            @Override
            public ItemBuilder getConfigurationDisplayItem(Boolean value) {
                ItemBuilder builder = new ItemBuilder(Material.IRON_AXE);
                if (Objects.equals(value, true)) {
                    builder.enchant(Enchantment.DURABILITY);
                }
                return builder;
            }
        };
        RESPECT_UNBREAKABLE = new OptionBoolean("Respect Unbreakable", true, true, true, true){

            @Override
            public String getDesc(boolean ingame) {
                return "If a tool has the (vanilla) Unbreakable tag, should it take no damage from felling trees?";
            }

            @Override
            public ItemBuilder getConfigurationDisplayItem(Boolean value) {
                ItemBuilder builder = new ItemBuilder(Material.NETHERITE_AXE);
                if (Objects.equals(value, true)) {
                    builder.setUnbreakable(true);
                }
                return builder;
            }
        };
        DAMAGE_MULT = new Option<Double>("Damage Mult", true, true, true, Double.valueOf(1.0)){

            @Override
            public Double load(Object o) {
                return 52.loadDouble(o);
            }

            @Override
            public String getDesc(boolean ingame) {
                return "How much damage should tools take per log? (Multiplier)";
            }

            @Override
            public ItemBuilder getConfigurationDisplayItem(Double value) {
                return new ItemBuilder(Material.WOODEN_AXE);
            }

            @Override
            public void openGlobalModifyMenu(MenuGlobalConfiguration parent) {
                parent.open(new MenuModifyDouble(parent, parent.plugin, parent.player, this.name, 0.0, 2.147483647E9, 1.0, false, (Double)this.globalValue, value -> {
                    this.globalValue = value;
                }));
            }

            @Override
            public void openToolModifyMenu(MenuToolConfiguration parent, Tool tool) {
                parent.open(new MenuModifyDouble(parent, parent.plugin, parent.player, this.name, 0.0, 2.147483647E9, 1.0, true, (Double)this.toolValues.get(tool), value -> {
                    if (value == null) {
                        this.toolValues.remove(tool);
                    } else {
                        this.toolValues.put(tool, value);
                    }
                }));
            }

            @Override
            public void openTreeModifyMenu(MenuTreeConfiguration parent, Tree tree) {
                parent.open(new MenuModifyDouble(parent, parent.plugin, parent.player, this.name, 0.0, 2.147483647E9, 1.0, true, (Double)this.treeValues.get(tree), value -> {
                    if (value == null) {
                        this.treeValues.remove(tree);
                    } else {
                        this.treeValues.put(tree, value);
                    }
                }));
            }
        };
        STACKED_TOOLS = new OptionBoolean("Stacked Tools", true, true, false, false){

            @Override
            public String getDesc(boolean ingame) {
                return "If set to true, stacked tools will be consumed one at a time.\nThis will treat the entire stack as one tool, so prevent-breakage will not keep individual tools from breaking, only the whole stack.\nWARNING: Stacked tools are not recommended!";
            }

            @Override
            public ItemBuilder getConfigurationDisplayItem(Boolean value) {
                return new ItemBuilder(Material.DIAMOND_AXE).setCount(Objects.equals(value, true) ? 64 : 16);
            }
        };
        LEAF_FORTUNE = new OptionBoolean("Leaf Fortune", true, true, true, true){

            @Override
            public String getDesc(boolean ingame) {
                return "Should Fortune on an axe be applied to leaves?";
            }

            @Override
            public ItemBuilder getConfigurationDisplayItem(Boolean value) {
                return new ItemBuilder(Material.OAK_LEAVES).enchant(Enchantment.LOOT_BONUS_BLOCKS).addFlag(ItemFlag.HIDE_ENCHANTS);
            }
        };
        LEAF_SILK_TOUCH = new OptionBoolean("Leaf Silk Touch", true, true, true, false){

            @Override
            public String getDesc(boolean ingame) {
                return "Should Silk Touch on an axe be applied to leaves?";
            }

            @Override
            public ItemBuilder getConfigurationDisplayItem(Boolean value) {
                return new ItemBuilder(Material.OAK_LEAVES).enchant(Enchantment.SILK_TOUCH).addFlag(ItemFlag.HIDE_ENCHANTS);
            }
        };
        LOG_FORTUNE = new OptionBoolean("Log Fortune", true, true, true, true){

            @Override
            public String getDesc(boolean ingame) {
                return "Should Fortune on an axe be applied to logs?";
            }

            @Override
            public ItemBuilder getConfigurationDisplayItem(Boolean value) {
                return new ItemBuilder(Material.OAK_LOG).enchant(Enchantment.LOOT_BONUS_BLOCKS).addFlag(ItemFlag.HIDE_ENCHANTS);
            }
        };
        LOG_SILK_TOUCH = new OptionBoolean("Log Silk Touch", true, true, true, true){

            @Override
            public String getDesc(boolean ingame) {
                return "Should Silk Touch on an axe be applied to logs?";
            }

            @Override
            public ItemBuilder getConfigurationDisplayItem(Boolean value) {
                return new ItemBuilder(Material.OAK_LOG).enchant(Enchantment.SILK_TOUCH).addFlag(ItemFlag.HIDE_ENCHANTS);
            }
        };
        LEAVE_STUMP = new OptionBoolean("Leave Stump", true, true, true, false){

            @Override
            public String getDesc(boolean ingame) {
                return "When a tree is felled, should a stump be left? (The stump consists of any log blocks below the point at which the tree was felled)\nThis may cause issues with custom trees that have multiple trunks or branches that extend very low";
            }

            @Override
            public ItemBuilder getConfigurationDisplayItem(Boolean value) {
                return new ItemBuilder(Material.OAK_LOG);
            }
        };
        ROTATE_LOGS = new OptionBoolean("Rotate Logs", true, true, true, true){

            @Override
            public String getDesc(boolean ingame) {
                return "When trees fall, should the logs rotate as they fall? (This makes it look more realistic, with logs landing horizontally)\n(Only used when log or leaf behavior is set to FALL or similar)";
            }

            @Override
            public ItemBuilder getConfigurationDisplayItem(Boolean value) {
                return new ItemBuilder(Material.OAK_LOG);
            }
        };
        DROP_CONVERSIONS = new Option<HashMap<Material, Material>>("Drop Conversions", true, true, true, defaultDropConversions){

            @Override
            public String writeToConfig(HashMap<Material, Material> value) {
                String s = "";
                if (value == null) {
                    return s;
                }
                ArrayList<Material> keys = new ArrayList<Material>(value.keySet());
                Collections.sort(keys);
                for (Material m : keys) {
                    s = s + "\n    " + m.toString() + ": " + value.get(m).toString();
                }
                return s;
            }

            @Override
            public String getDefaultConfigValue() {
                return this.writeToConfig((HashMap)this.defaultValue);
            }

            @Override
            public String getDesc(boolean ingame) {
                return "A list of drops to convert into other drops when felling." + (ingame ? "" : " add entries like this:\n    oak_wood: oak_log\n    oak_fence: stick");
            }

            @Override
            public HashMap<Material, Material> get(Tool tool, Tree tree) {
                HashMap<Material, Material> conversions = new HashMap<Material, Material>();
                if (this.toolValues.get(tool) == null && this.treeValues.get(tree) == null && this.globalValue != null) {
                    conversions.putAll((Map)this.globalValue);
                }
                if (this.toolValues.containsKey(tool)) {
                    conversions.putAll((Map)this.toolValues.get(tool));
                }
                if (this.treeValues.containsKey(tree)) {
                    conversions.putAll((Map)this.treeValues.get(tree));
                }
                return conversions;
            }

            @Override
            public HashMap<Material, Material> load(Object o) {
                if (o instanceof MemorySection) {
                    MemorySection m = (MemorySection)o;
                    HashMap<Material, Material> conversions = new HashMap<Material, Material>();
                    for (String key : m.getKeys(false)) {
                        conversions.put(60.loadMaterial(key), 60.loadMaterial(m.get(key)));
                    }
                    return conversions;
                }
                if (o instanceof Map) {
                    Map m = (Map)o;
                    HashMap<Material, Material> conversions = new HashMap<Material, Material>();
                    for (Object okey : m.keySet()) {
                        if (!(okey instanceof String)) continue;
                        String key = (String)okey;
                        conversions.put(60.loadMaterial(key), 60.loadMaterial(m.get(key)));
                    }
                    return conversions;
                }
                if (o instanceof List) {
                    List l = (List)o;
                    HashMap<Material, Material> conversions = new HashMap<Material, Material>();
                    for (Object ob : l) {
                        if (!(ob instanceof MemorySection)) continue;
                        MemorySection m = (MemorySection)ob;
                        for (String key : m.getKeys(false)) {
                            conversions.put(60.loadMaterial(key), 60.loadMaterial(m.get(key)));
                        }
                    }
                    return conversions;
                }
                return null;
            }

            @Override
            public ItemBuilder getConfigurationDisplayItem(HashMap<Material, Material> value) {
                return new ItemBuilder(Material.OAK_WOOD);
            }

            @Override
            public void openGlobalModifyMenu(MenuGlobalConfiguration parent) {
                parent.open(new MenuModifyMaterialMaterialMap(parent, parent.plugin, parent.player, this.name, "item", t -> t.isItem(), "item", t -> t.isItem(), false, (HashMap)this.globalValue, value -> {
                    this.globalValue = value;
                }));
            }

            @Override
            public void openToolModifyMenu(MenuToolConfiguration parent, Tool tool) {
                parent.open(new MenuModifyMaterialMaterialMap(parent, parent.plugin, parent.player, this.name, "item", t -> t.isItem(), "item", t -> t.isItem(), true, (HashMap)this.toolValues.get(tool), value -> {
                    if (value == null) {
                        this.toolValues.remove(tool);
                    } else {
                        this.toolValues.put(tool, value);
                    }
                }));
            }

            @Override
            public void openTreeModifyMenu(MenuTreeConfiguration parent, Tree tree) {
                parent.open(new MenuModifyMaterialMaterialMap(parent, parent.plugin, parent.player, this.name, "item", t -> t.isItem(), "item", t -> t.isItem(), true, (HashMap)this.treeValues.get(tree), value -> {
                    if (value == null) {
                        this.treeValues.remove(tree);
                    } else {
                        this.treeValues.put(tree, value);
                    }
                }));
            }
        };
        BLOCK_CONVERSIONS = new Option<HashMap<Material, Material>>("Block Conversions", true, true, true, defaultBlockConversions){

            @Override
            public String writeToConfig(HashMap<Material, Material> value) {
                String s = "";
                if (value == null) {
                    return s;
                }
                ArrayList<Material> keys = new ArrayList<Material>(value.keySet());
                Collections.sort(keys);
                for (Material m : keys) {
                    s = s + "\n    " + m.toString() + ": " + value.get(m).toString();
                }
                return s;
            }

            @Override
            public String getDefaultConfigValue() {
                return this.writeToConfig((HashMap)this.defaultValue);
            }

            @Override
            public String getDesc(boolean ingame) {
                return "Blocks in this list will never be broken; they will be converted instead.";
            }

            @Override
            public HashMap<Material, Material> get(Tool tool, Tree tree) {
                HashMap<Material, Material> conversions = new HashMap<Material, Material>();
                if (this.toolValues.get(tool) == null && this.treeValues.get(tree) == null && this.globalValue != null) {
                    conversions.putAll((Map)this.globalValue);
                }
                if (this.toolValues.containsKey(tool)) {
                    conversions.putAll((Map)this.toolValues.get(tool));
                }
                if (this.treeValues.containsKey(tree)) {
                    conversions.putAll((Map)this.treeValues.get(tree));
                }
                return conversions;
            }

            @Override
            public HashMap<Material, Material> load(Object o) {
                if (o instanceof MemorySection) {
                    MemorySection m = (MemorySection)o;
                    HashMap<Material, Material> conversions = new HashMap<Material, Material>();
                    for (String key : m.getKeys(false)) {
                        conversions.put(61.loadMaterial(key), 61.loadMaterial(m.get(key)));
                    }
                    return conversions;
                }
                if (o instanceof Map) {
                    Map m = (Map)o;
                    HashMap<Material, Material> conversions = new HashMap<Material, Material>();
                    for (Object okey : m.keySet()) {
                        if (!(okey instanceof String)) continue;
                        String key = (String)okey;
                        conversions.put(61.loadMaterial(key), 61.loadMaterial(m.get(key)));
                    }
                    return conversions;
                }
                if (o instanceof List) {
                    List l = (List)o;
                    HashMap<Material, Material> conversions = new HashMap<Material, Material>();
                    for (Object ob : l) {
                        if (!(ob instanceof MemorySection)) continue;
                        MemorySection m = (MemorySection)ob;
                        for (String key : m.getKeys(false)) {
                            conversions.put(61.loadMaterial(key), 61.loadMaterial(m.get(key)));
                        }
                    }
                    return conversions;
                }
                return null;
            }

            @Override
            public ItemBuilder getConfigurationDisplayItem(HashMap<Material, Material> value) {
                return new ItemBuilder(Material.OAK_WOOD);
            }

            @Override
            public void openGlobalModifyMenu(MenuGlobalConfiguration parent) {
                parent.open(new MenuModifyMaterialMaterialMap(parent, parent.plugin, parent.player, this.name, "item", t -> t.isItem(), "item", t -> t.isItem(), false, (HashMap)this.globalValue, value -> {
                    this.globalValue = value;
                }));
            }

            @Override
            public void openToolModifyMenu(MenuToolConfiguration parent, Tool tool) {
                parent.open(new MenuModifyMaterialMaterialMap(parent, parent.plugin, parent.player, this.name, "item", t -> t.isItem(), "item", t -> t.isItem(), true, (HashMap)this.toolValues.get(tool), value -> {
                    if (value == null) {
                        this.toolValues.remove(tool);
                    } else {
                        this.toolValues.put(tool, value);
                    }
                }));
            }

            @Override
            public void openTreeModifyMenu(MenuTreeConfiguration parent, Tree tree) {
                parent.open(new MenuModifyMaterialMaterialMap(parent, parent.plugin, parent.player, this.name, "item", t -> t.isItem(), "item", t -> t.isItem(), true, (HashMap)this.treeValues.get(tree), value -> {
                    if (value == null) {
                        this.treeValues.remove(tree);
                    } else {
                        this.treeValues.put(tree, value);
                    }
                }));
            }
        };
        LEAF_DROP_CHANCE = new Option<Double>("Leaf Drop Chance", true, true, true, Double.valueOf(1.0)){

            @Override
            public Double load(Object o) {
                return 62.loadDouble(o);
            }

            @Override
            public Double get(Tool tool, Tree tree) {
                double glob = 1.0;
                if (this.toolValues.get(tool) == null || this.treeValues.get(tree) == null) {
                    glob = (Double)this.globalValue;
                }
                Double tl = this.toolValues.getOrDefault(tool, 1.0);
                Double tr = this.treeValues.getOrDefault(tree, 1.0);
                return tl * tr * glob;
            }

            @Override
            public String getDesc(boolean ingame) {
                return "How often should leaves drop items? Set this to 0.0 to stop leaves from dropping items altogether (Only works with BREAK behavior)";
            }

            @Override
            public ItemBuilder getConfigurationDisplayItem(Double value) {
                return new ItemBuilder(Material.OAK_LEAVES);
            }

            @Override
            public void openGlobalModifyMenu(MenuGlobalConfiguration parent) {
                parent.open(new MenuModifyDouble(parent, parent.plugin, parent.player, this.name, 0.0, 2.147483647E9, 1.0, false, (Double)this.globalValue, value -> {
                    this.globalValue = value;
                }));
            }

            @Override
            public void openToolModifyMenu(MenuToolConfiguration parent, Tool tool) {
                parent.open(new MenuModifyDouble(parent, parent.plugin, parent.player, this.name, 0.0, 2.147483647E9, 1.0, true, (Double)this.toolValues.get(tool), value -> {
                    if (value == null) {
                        this.toolValues.remove(tool);
                    } else {
                        this.toolValues.put(tool, value);
                    }
                }));
            }

            @Override
            public void openTreeModifyMenu(MenuTreeConfiguration parent, Tree tree) {
                parent.open(new MenuModifyDouble(parent, parent.plugin, parent.player, this.name, 0.0, 2.147483647E9, 1.0, true, (Double)this.treeValues.get(tree), value -> {
                    if (value == null) {
                        this.treeValues.remove(tree);
                    } else {
                        this.treeValues.put(tree, value);
                    }
                }));
            }
        };
        LOG_DROP_CHANCE = new Option<Double>("Log Drop Chance", true, true, true, Double.valueOf(1.0)){

            @Override
            public Double load(Object o) {
                return 63.loadDouble(o);
            }

            @Override
            public Double get(Tool tool, Tree tree) {
                double glob = 1.0;
                if (this.toolValues.get(tool) == null || this.treeValues.get(tree) == null) {
                    glob = (Double)this.globalValue;
                }
                Double tl = this.toolValues.getOrDefault(tool, 1.0);
                Double tr = this.treeValues.getOrDefault(tree, 1.0);
                return tl * tr * glob;
            }

            @Override
            public String getDesc(boolean ingame) {
                return "How often should logs drop items? Set this to 0.0 to stop logs from dropping items altogether (Only works with BREAK behavior)";
            }

            @Override
            public ItemBuilder getConfigurationDisplayItem(Double value) {
                return new ItemBuilder(Material.OAK_LOG);
            }

            @Override
            public void openGlobalModifyMenu(MenuGlobalConfiguration parent) {
                parent.open(new MenuModifyDouble(parent, parent.plugin, parent.player, this.name, 0.0, 2.147483647E9, 1.0, false, (Double)this.globalValue, value -> {
                    this.globalValue = value;
                }));
            }

            @Override
            public void openToolModifyMenu(MenuToolConfiguration parent, Tool tool) {
                parent.open(new MenuModifyDouble(parent, parent.plugin, parent.player, this.name, 0.0, 2.147483647E9, 1.0, true, (Double)this.toolValues.get(tool), value -> {
                    if (value == null) {
                        this.toolValues.remove(tool);
                    } else {
                        this.toolValues.put(tool, value);
                    }
                }));
            }

            @Override
            public void openTreeModifyMenu(MenuTreeConfiguration parent, Tree tree) {
                parent.open(new MenuModifyDouble(parent, parent.plugin, parent.player, this.name, 0.0, 2.147483647E9, 1.0, true, (Double)this.treeValues.get(tree), value -> {
                    if (value == null) {
                        this.treeValues.remove(tree);
                    } else {
                        this.treeValues.put(tree, value);
                    }
                }));
            }
        };
        EFFECTS = new Option<ArrayList<Effect>>("Effects", true, true, true, null, (Object)"\n    - ALL"){

            @Override
            public ArrayList<Effect> load(Object o) {
                if (o instanceof Iterable) {
                    ArrayList<Effect> effects = new ArrayList<Effect>();
                    for (Object ob : (Iterable)o) {
                        Object newEffects = this.load(ob);
                        if (newEffects == null) continue;
                        effects.addAll((Collection<Effect>)newEffects);
                    }
                    return effects;
                }
                if (o instanceof Effect) {
                    ArrayList<Effect> effects = new ArrayList<Effect>();
                    effects.add((Effect)o);
                    return effects;
                }
                if (o instanceof String) {
                    if (o.equals("ALL")) {
                        return new ArrayList<Effect>(TreeFeller.effects);
                    }
                    ArrayList<Effect> effects = new ArrayList<Effect>();
                    for (Effect e : TreeFeller.effects) {
                        if (!e.name.equalsIgnoreCase((String)o)) continue;
                        effects.add(e);
                    }
                    return effects;
                }
                return null;
            }

            @Override
            public ArrayList<Effect> get(Tool tool, Tree tree) {
                ArrayList<Effect> effects = new ArrayList<Effect>();
                if (this.toolValues.get(tool) == null && this.treeValues.get(tree) == null && this.globalValue != null) {
                    effects.addAll((Collection)this.globalValue);
                }
                if (this.toolValues.containsKey(tool)) {
                    effects.addAll((Collection)this.toolValues.get(tool));
                }
                if (this.treeValues.containsKey(tree)) {
                    effects.addAll((Collection)this.treeValues.get(tree));
                }
                return effects;
            }

            @Override
            public String getGlobalName() {
                return "global-effects";
            }

            @Override
            public String getDesc(boolean ingame) {
                return "Global effects are applied every time a tree is felled, regardless of tree type or tool\nuse ALL for all effects" + (ingame ? "" : "\nex:\n  - ghost sound\n  - smoke");
            }

            @Override
            public ItemBuilder getConfigurationDisplayItem(ArrayList<Effect> value) {
                return new ItemBuilder(Material.POTION).addFlag(ItemFlag.HIDE_POTION_EFFECTS);
            }

            @Override
            public void openGlobalModifyMenu(MenuGlobalConfiguration parent) {
                parent.open(new MenuModifyEffectList(parent, parent.plugin, parent.player, this.name, true, (ArrayList)this.globalValue, value -> {
                    this.globalValue = value;
                }));
            }

            @Override
            public void openToolModifyMenu(MenuToolConfiguration parent, Tool tool) {
                parent.open(new MenuModifyEffectList(parent, parent.plugin, parent.player, this.name, true, (ArrayList)this.toolValues.get(tool), value -> {
                    if (value == null) {
                        this.toolValues.remove(tool);
                    } else {
                        this.toolValues.put(tool, value);
                    }
                }));
            }

            @Override
            public void openTreeModifyMenu(MenuTreeConfiguration parent, Tree tree) {
                parent.open(new MenuModifyEffectList(parent, parent.plugin, parent.player, this.name, true, (ArrayList)this.treeValues.get(tree), value -> {
                    if (value == null) {
                        this.treeValues.remove(tree);
                    } else {
                        this.treeValues.put(tree, value);
                    }
                }));
            }
        };
        CONSUMED_FOOD_BASE = new Option<Double>("Consumed Food Base", true, true, true, Double.valueOf(0.0)){

            @Override
            public Double load(Object o) {
                return 65.loadDouble(o);
            }

            @Override
            public String getDesc(boolean ingame) {
                return "How much food should be be consumed upon felling a tree? (This is in addition to per-block settings)";
            }

            @Override
            public ItemBuilder getConfigurationDisplayItem(Double value) {
                return new ItemBuilder(Material.COOKED_CHICKEN);
            }

            @Override
            public void openGlobalModifyMenu(MenuGlobalConfiguration parent) {
                parent.open(new MenuModifyDouble(parent, parent.plugin, parent.player, this.name, -2.147483648E9, 2.147483647E9, 1.0, false, (Double)this.globalValue, value -> {
                    this.globalValue = value;
                }));
            }

            @Override
            public void openToolModifyMenu(MenuToolConfiguration parent, Tool tool) {
                parent.open(new MenuModifyDouble(parent, parent.plugin, parent.player, this.name, -2.147483648E9, 2.147483647E9, 1.0, true, (Double)this.toolValues.get(tool), value -> {
                    if (value == null) {
                        this.toolValues.remove(tool);
                    } else {
                        this.toolValues.put(tool, value);
                    }
                }));
            }

            @Override
            public void openTreeModifyMenu(MenuTreeConfiguration parent, Tree tree) {
                parent.open(new MenuModifyDouble(parent, parent.plugin, parent.player, this.name, -2.147483648E9, 2.147483647E9, 1.0, true, (Double)this.treeValues.get(tree), value -> {
                    if (value == null) {
                        this.treeValues.remove(tree);
                    } else {
                        this.treeValues.put(tree, value);
                    }
                }));
            }
        };
        CONSUMED_FOOD_LOGS = new Option<Double>("Consumed Food Logs", true, true, true, Double.valueOf(0.0)){

            @Override
            public Double load(Object o) {
                return 66.loadDouble(o);
            }

            @Override
            public String getDesc(boolean ingame) {
                return "How much food should be be consumed per block of log upon felling a tree? (This is in addition to the base setting)";
            }

            @Override
            public ItemBuilder getConfigurationDisplayItem(Double value) {
                return new ItemBuilder(Material.ACACIA_LOG);
            }

            @Override
            public void openGlobalModifyMenu(MenuGlobalConfiguration parent) {
                parent.open(new MenuModifyDouble(parent, parent.plugin, parent.player, this.name, -2.147483648E9, 2.147483647E9, 1.0, false, (Double)this.globalValue, value -> {
                    this.globalValue = value;
                }));
            }

            @Override
            public void openToolModifyMenu(MenuToolConfiguration parent, Tool tool) {
                parent.open(new MenuModifyDouble(parent, parent.plugin, parent.player, this.name, -2.147483648E9, 2.147483647E9, 1.0, true, (Double)this.toolValues.get(tool), value -> {
                    if (value == null) {
                        this.toolValues.remove(tool);
                    } else {
                        this.toolValues.put(tool, value);
                    }
                }));
            }

            @Override
            public void openTreeModifyMenu(MenuTreeConfiguration parent, Tree tree) {
                parent.open(new MenuModifyDouble(parent, parent.plugin, parent.player, this.name, -2.147483648E9, 2.147483647E9, 1.0, true, (Double)this.treeValues.get(tree), value -> {
                    if (value == null) {
                        this.treeValues.remove(tree);
                    } else {
                        this.treeValues.put(tree, value);
                    }
                }));
            }
        };
        CONSUMED_FOOD_LEAVES = new Option<Double>("Consumed Food Leaves", true, true, true, Double.valueOf(0.0)){

            @Override
            public Double load(Object o) {
                return 67.loadDouble(o);
            }

            @Override
            public String getDesc(boolean ingame) {
                return "How much food should be be consumed per block of leaves upon felling a tree? (This is in addition to the base setting)";
            }

            @Override
            public ItemBuilder getConfigurationDisplayItem(Double value) {
                return new ItemBuilder(Material.ACACIA_LEAVES);
            }

            @Override
            public void openGlobalModifyMenu(MenuGlobalConfiguration parent) {
                parent.open(new MenuModifyDouble(parent, parent.plugin, parent.player, this.name, -2.147483648E9, 2.147483647E9, 1.0, false, (Double)this.globalValue, value -> {
                    this.globalValue = value;
                }));
            }

            @Override
            public void openToolModifyMenu(MenuToolConfiguration parent, Tool tool) {
                parent.open(new MenuModifyDouble(parent, parent.plugin, parent.player, this.name, -2.147483648E9, 2.147483647E9, 1.0, true, (Double)this.toolValues.get(tool), value -> {
                    if (value == null) {
                        this.toolValues.remove(tool);
                    } else {
                        this.toolValues.put(tool, value);
                    }
                }));
            }

            @Override
            public void openTreeModifyMenu(MenuTreeConfiguration parent, Tree tree) {
                parent.open(new MenuModifyDouble(parent, parent.plugin, parent.player, this.name, -2.147483648E9, 2.147483647E9, 1.0, true, (Double)this.treeValues.get(tree), value -> {
                    if (value == null) {
                        this.treeValues.remove(tree);
                    } else {
                        this.treeValues.put(tree, value);
                    }
                }));
            }
        };
        CONSUMED_HEALTH_BASE = new Option<Double>("Consumed Health Base", true, true, true, Double.valueOf(0.0)){

            @Override
            public Double load(Object o) {
                return 68.loadDouble(o);
            }

            @Override
            public String getDesc(boolean ingame) {
                return "How much health should be be consumed upon felling a tree? (This is in addition to per-block settings)";
            }

            @Override
            public ItemBuilder getConfigurationDisplayItem(Double value) {
                return new ItemBuilder(Material.SALMON);
            }

            @Override
            public void openGlobalModifyMenu(MenuGlobalConfiguration parent) {
                parent.open(new MenuModifyDouble(parent, parent.plugin, parent.player, this.name, -2.147483648E9, 2.147483647E9, 1.0, false, (Double)this.globalValue, value -> {
                    this.globalValue = value;
                }));
            }

            @Override
            public void openToolModifyMenu(MenuToolConfiguration parent, Tool tool) {
                parent.open(new MenuModifyDouble(parent, parent.plugin, parent.player, this.name, -2.147483648E9, 2.147483647E9, 1.0, true, (Double)this.toolValues.get(tool), value -> {
                    if (value == null) {
                        this.toolValues.remove(tool);
                    } else {
                        this.toolValues.put(tool, value);
                    }
                }));
            }

            @Override
            public void openTreeModifyMenu(MenuTreeConfiguration parent, Tree tree) {
                parent.open(new MenuModifyDouble(parent, parent.plugin, parent.player, this.name, -2.147483648E9, 2.147483647E9, 1.0, true, (Double)this.treeValues.get(tree), value -> {
                    if (value == null) {
                        this.treeValues.remove(tree);
                    } else {
                        this.treeValues.put(tree, value);
                    }
                }));
            }
        };
        CONSUMED_HEALTH_LOGS = new Option<Double>("Consumed Health Logs", true, true, true, Double.valueOf(0.0)){

            @Override
            public Double load(Object o) {
                return 69.loadDouble(o);
            }

            @Override
            public String getDesc(boolean ingame) {
                return "How much health should be be consumed per block of log upon felling a tree? (This is in addition to the base setting)";
            }

            @Override
            public ItemBuilder getConfigurationDisplayItem(Double value) {
                return new ItemBuilder(Material.CRIMSON_STEM);
            }

            @Override
            public void openGlobalModifyMenu(MenuGlobalConfiguration parent) {
                parent.open(new MenuModifyDouble(parent, parent.plugin, parent.player, this.name, -2.147483648E9, 2.147483647E9, 1.0, false, (Double)this.globalValue, value -> {
                    this.globalValue = value;
                }));
            }

            @Override
            public void openToolModifyMenu(MenuToolConfiguration parent, Tool tool) {
                parent.open(new MenuModifyDouble(parent, parent.plugin, parent.player, this.name, -2.147483648E9, 2.147483647E9, 1.0, true, (Double)this.toolValues.get(tool), value -> {
                    if (value == null) {
                        this.toolValues.remove(tool);
                    } else {
                        this.toolValues.put(tool, value);
                    }
                }));
            }

            @Override
            public void openTreeModifyMenu(MenuTreeConfiguration parent, Tree tree) {
                parent.open(new MenuModifyDouble(parent, parent.plugin, parent.player, this.name, -2.147483648E9, 2.147483647E9, 1.0, true, (Double)this.treeValues.get(tree), value -> {
                    if (value == null) {
                        this.treeValues.remove(tree);
                    } else {
                        this.treeValues.put(tree, value);
                    }
                }));
            }
        };
        CONSUMED_HEALTH_LEAVES = new Option<Double>("Consumed Health Leaves", true, true, true, Double.valueOf(0.0)){

            @Override
            public Double load(Object o) {
                return 70.loadDouble(o);
            }

            @Override
            public String getDesc(boolean ingame) {
                return "How much health should be be consumed per block of leaves upon felling a tree? (This is in addition to the base setting)";
            }

            @Override
            public ItemBuilder getConfigurationDisplayItem(Double value) {
                return new ItemBuilder(Material.NETHER_WART_BLOCK);
            }

            @Override
            public void openGlobalModifyMenu(MenuGlobalConfiguration parent) {
                parent.open(new MenuModifyDouble(parent, parent.plugin, parent.player, this.name, -2.147483648E9, 2.147483647E9, 1.0, false, (Double)this.globalValue, value -> {
                    this.globalValue = value;
                }));
            }

            @Override
            public void openToolModifyMenu(MenuToolConfiguration parent, Tool tool) {
                parent.open(new MenuModifyDouble(parent, parent.plugin, parent.player, this.name, -2.147483648E9, 2.147483647E9, 1.0, true, (Double)this.toolValues.get(tool), value -> {
                    if (value == null) {
                        this.toolValues.remove(tool);
                    } else {
                        this.toolValues.put(tool, value);
                    }
                }));
            }

            @Override
            public void openTreeModifyMenu(MenuTreeConfiguration parent, Tree tree) {
                parent.open(new MenuModifyDouble(parent, parent.plugin, parent.player, this.name, -2.147483648E9, 2.147483647E9, 1.0, true, (Double)this.treeValues.get(tree), value -> {
                    if (value == null) {
                        this.treeValues.remove(tree);
                    } else {
                        this.treeValues.put(tree, value);
                    }
                }));
            }
        };
        REQUIRED_ENCHANTMENTS = new Option<HashMap<Enchantment, Integer>>("Required Enchantments", true, true, true, null){

            @Override
            public HashMap<Enchantment, Integer> load(Object o) {
                if (o instanceof MemorySection) {
                    HashMap<Enchantment, Integer> enchantments = new HashMap<Enchantment, Integer>();
                    MemorySection m = (MemorySection)o;
                    for (String key : m.getKeys(false)) {
                        Integer level;
                        Enchantment e = Option.getEnchantment(key);
                        if (e == null || (level = 71.loadInt(m.get(key))) == null) continue;
                        if (enchantments.containsKey(e)) {
                            enchantments.put(e, Math.max(enchantments.get(e), level));
                            continue;
                        }
                        enchantments.put(e, level);
                    }
                    return enchantments;
                }
                if (o instanceof Map) {
                    HashMap<Enchantment, Integer> enchantments = new HashMap<Enchantment, Integer>();
                    Map m = (Map)o;
                    for (Object obj : m.keySet()) {
                        Integer level;
                        Enchantment e = null;
                        if (obj instanceof Enchantment) {
                            e = (Enchantment)obj;
                        }
                        if (obj instanceof String) {
                            e = Option.getEnchantment((String)obj);
                        }
                        if (e == null || (level = 71.loadInt(m.get(obj))) == null) continue;
                        if (enchantments.containsKey(e)) {
                            enchantments.put(e, Math.max(enchantments.get(e), level));
                            continue;
                        }
                        enchantments.put(e, level);
                    }
                    return enchantments;
                }
                if (o instanceof List) {
                    List l = (List)o;
                    HashMap<Enchantment, Integer> enchantments = new HashMap<Enchantment, Integer>();
                    for (Object lbj : l) {
                        if (!(lbj instanceof Map)) continue;
                        Map m = (Map)lbj;
                        for (Object obj : m.keySet()) {
                            Integer level;
                            Enchantment e = null;
                            if (obj instanceof Enchantment) {
                                e = (Enchantment)obj;
                            }
                            if (obj instanceof String) {
                                e = Option.getEnchantment((String)obj);
                            }
                            if (e == null || (level = 71.loadInt(m.get(obj))) == null) continue;
                            if (enchantments.containsKey(e)) {
                                enchantments.put(e, Math.max(enchantments.get(e), level));
                                continue;
                            }
                            enchantments.put(e, level);
                        }
                    }
                    return enchantments;
                }
                return null;
            }

            @Override
            public DebugResult doCheck(TreeFeller plugin, Tool tool, Tree tree, Block block, Player player, ItemStack axe) {
                HashMap values;
                if (this.toolValues.get(tool) == null && this.treeValues.get(tree) == null && this.globalValue != null) {
                    for (Enchantment e : ((HashMap)this.globalValue).keySet()) {
                        if (axe.getEnchantmentLevel(e) >= (Integer)((HashMap)this.globalValue).get(e)) continue;
                        return new DebugResult(this, DebugResult.Type.GLOBAL, e.toString(), axe.getEnchantmentLevel(e), ((HashMap)this.globalValue).get(e));
                    }
                }
                if ((values = (HashMap)this.toolValues.get(tool)) != null) {
                    for (Enchantment e : values.keySet()) {
                        if (axe.getEnchantmentLevel(e) >= (Integer)values.get(e)) continue;
                        return new DebugResult(this, DebugResult.Type.TOOL, e.toString(), axe.getEnchantmentLevel(e), values.get(e));
                    }
                }
                if ((values = (HashMap)this.treeValues.get(tree)) != null) {
                    for (Enchantment e : values.keySet()) {
                        if (axe.getEnchantmentLevel(e) >= (Integer)values.get(e)) continue;
                        return new DebugResult(this, DebugResult.Type.TREE, e.toString(), axe.getEnchantmentLevel(e), values.get(e));
                    }
                }
                return new DebugResult(this, DebugResult.Type.SUCCESS, new Object[0]);
            }

            @Override
            public String getDesc(boolean ingame) {
                return "Tools must have these enchantments at this level or higher to fell trees" + (ingame ? "" : "\nex:\n- unbreaking: 2\n- efficiency: 5");
            }

            @Override
            public String[] getDebugText() {
                return 71.generateDebugText("Enchantment missing$: {0} ({1}<{2})", "All required enchantments met");
            }

            @Override
            public ItemBuilder getConfigurationDisplayItem(HashMap<Enchantment, Integer> value) {
                ItemBuilder builder = new ItemBuilder(Material.ENCHANTED_BOOK);
                if (value != null) {
                    for (Enchantment enchantment : value.keySet()) {
                        builder.enchant(enchantment, value.get(enchantment));
                    }
                }
                return builder;
            }

            @Override
            public void openGlobalModifyMenu(MenuGlobalConfiguration parent) {
                parent.open(new MenuModifyEnchantmentMap(parent, parent.plugin, parent.player, this.name, true, (HashMap)this.globalValue, value -> {
                    this.globalValue = value;
                }));
            }

            @Override
            public void openToolModifyMenu(MenuToolConfiguration parent, Tool tool) {
                parent.open(new MenuModifyEnchantmentMap(parent, parent.plugin, parent.player, this.name, true, (HashMap)this.toolValues.get(tool), value -> {
                    if (value == null) {
                        this.toolValues.remove(tool);
                    } else {
                        this.toolValues.put(tool, value);
                    }
                }));
            }

            @Override
            public void openTreeModifyMenu(MenuTreeConfiguration parent, Tree tree) {
                parent.open(new MenuModifyEnchantmentMap(parent, parent.plugin, parent.player, this.name, true, (HashMap)this.treeValues.get(tree), value -> {
                    if (value == null) {
                        this.treeValues.remove(tree);
                    } else {
                        this.treeValues.put(tree, value);
                    }
                }));
            }

            @Override
            public String writeToConfig(HashMap<Enchantment, Integer> value) {
                if (value == null) {
                    return "";
                }
                String s = "{";
                String str = "";
                for (Enchantment e : value.keySet()) {
                    str = str + ", " + e.getKey().getKey() + ": " + value.get(e);
                }
                if (!str.isEmpty()) {
                    s = s + str.substring(2);
                }
                return s + "}";
            }
        };
        BANNED_ENCHANTMENTS = new Option<HashMap<Enchantment, Integer>>("Banned Enchantments", true, true, true, null){

            @Override
            public HashMap<Enchantment, Integer> load(Object o) {
                if (o instanceof MemorySection) {
                    HashMap<Enchantment, Integer> enchantments = new HashMap<Enchantment, Integer>();
                    MemorySection m = (MemorySection)o;
                    for (String key : m.getKeys(false)) {
                        Integer level;
                        Enchantment e = Option.getEnchantment(key);
                        if (e == null || (level = 72.loadInt(m.get(key))) == null) continue;
                        if (enchantments.containsKey(e)) {
                            enchantments.put(e, Math.min(enchantments.get(e), level));
                            continue;
                        }
                        enchantments.put(e, level);
                    }
                    return enchantments;
                }
                if (o instanceof Map) {
                    HashMap<Enchantment, Integer> enchantments = new HashMap<Enchantment, Integer>();
                    Map m = (Map)o;
                    for (Object obj : m.keySet()) {
                        Integer level;
                        Enchantment e = null;
                        if (obj instanceof Enchantment) {
                            e = (Enchantment)obj;
                        }
                        if (obj instanceof String) {
                            e = Option.getEnchantment((String)obj);
                        }
                        if (e == null || (level = 72.loadInt(m.get(obj))) == null) continue;
                        if (enchantments.containsKey(e)) {
                            enchantments.put(e, Math.min(enchantments.get(e), level));
                            continue;
                        }
                        enchantments.put(e, level);
                    }
                    return enchantments;
                }
                if (o instanceof List) {
                    List l = (List)o;
                    HashMap<Enchantment, Integer> enchantments = new HashMap<Enchantment, Integer>();
                    for (Object lbj : l) {
                        if (!(lbj instanceof Map)) continue;
                        Map m = (Map)lbj;
                        for (Object obj : m.keySet()) {
                            Integer level;
                            Enchantment e = null;
                            if (obj instanceof Enchantment) {
                                e = (Enchantment)obj;
                            }
                            if (obj instanceof String) {
                                e = Option.getEnchantment((String)obj);
                            }
                            if (e == null || (level = 72.loadInt(m.get(obj))) == null) continue;
                            if (enchantments.containsKey(e)) {
                                enchantments.put(e, Math.min(enchantments.get(e), level));
                                continue;
                            }
                            enchantments.put(e, level);
                        }
                    }
                    return enchantments;
                }
                return null;
            }

            @Override
            public DebugResult doCheck(TreeFeller plugin, Tool tool, Tree tree, Block block, Player player, ItemStack axe) {
                HashMap values;
                if (this.toolValues.get(tool) == null && this.treeValues.get(tree) == null && this.globalValue != null) {
                    for (Enchantment e : ((HashMap)this.globalValue).keySet()) {
                        if (axe.getEnchantmentLevel(e) < (Integer)((HashMap)this.globalValue).get(e)) continue;
                        return new DebugResult(this, DebugResult.Type.GLOBAL, e.toString(), axe.getEnchantmentLevel(e), (Integer)((HashMap)this.globalValue).get(e) - 1);
                    }
                }
                if ((values = (HashMap)this.toolValues.get(tool)) != null) {
                    for (Enchantment e : values.keySet()) {
                        if (axe.getEnchantmentLevel(e) < (Integer)values.get(e)) continue;
                        return new DebugResult(this, DebugResult.Type.TOOL, e.toString(), axe.getEnchantmentLevel(e), (Integer)values.get(e) - 1);
                    }
                }
                if ((values = (HashMap)this.treeValues.get(tree)) != null) {
                    for (Enchantment e : values.keySet()) {
                        if (axe.getEnchantmentLevel(e) < (Integer)values.get(e)) continue;
                        return new DebugResult(this, DebugResult.Type.TREE, e.toString(), axe.getEnchantmentLevel(e), (Integer)values.get(e) - 1);
                    }
                }
                return new DebugResult(this, DebugResult.Type.SUCCESS, new Object[0]);
            }

            @Override
            public String getDesc(boolean ingame) {
                return "Tools must not have these enchantments or have them lower than this level to fell trees" + (ingame ? "" : "\nex:\n- silk_touch: 1\n- unbreaking: 3");
            }

            @Override
            public String[] getDebugText() {
                return 72.generateDebugText("Tool contains banned enchantment$: {0} ({1}>{2})", "No banned enchantments found");
            }

            @Override
            public ItemBuilder getConfigurationDisplayItem(HashMap<Enchantment, Integer> value) {
                ItemBuilder builder = new ItemBuilder(Material.ENCHANTED_BOOK);
                if (value != null) {
                    for (Enchantment enchantment : value.keySet()) {
                        builder.enchant(enchantment, value.get(enchantment));
                    }
                }
                return builder;
            }

            @Override
            public void openGlobalModifyMenu(MenuGlobalConfiguration parent) {
                parent.open(new MenuModifyEnchantmentMap(parent, parent.plugin, parent.player, this.name, true, (HashMap)this.globalValue, value -> {
                    this.globalValue = value;
                }));
            }

            @Override
            public void openToolModifyMenu(MenuToolConfiguration parent, Tool tool) {
                parent.open(new MenuModifyEnchantmentMap(parent, parent.plugin, parent.player, this.name, true, (HashMap)this.toolValues.get(tool), value -> {
                    if (value == null) {
                        this.toolValues.remove(tool);
                    } else {
                        this.toolValues.put(tool, value);
                    }
                }));
            }

            @Override
            public void openTreeModifyMenu(MenuTreeConfiguration parent, Tree tree) {
                parent.open(new MenuModifyEnchantmentMap(parent, parent.plugin, parent.player, this.name, true, (HashMap)this.treeValues.get(tree), value -> {
                    if (value == null) {
                        this.treeValues.remove(tree);
                    } else {
                        this.treeValues.put(tree, value);
                    }
                }));
            }

            @Override
            public String writeToConfig(HashMap<Enchantment, Integer> value) {
                if (value == null) {
                    return "";
                }
                String s = "{";
                String str = "";
                for (Enchantment e : value.keySet()) {
                    str = str + ", " + e.getKey().getKey() + ": " + value.get(e);
                }
                if (!str.isEmpty()) {
                    s = s + str.substring(2);
                }
                return s + "}";
            }
        };
        MIN_DURABILITY = new Option<Short>("Min Durability", true, true, true, null){

            @Override
            public Short load(Object o) {
                return 73.loadShort(o);
            }

            @Override
            public DebugResult doCheck(TreeFeller plugin, Tool tool, Tree tree, Block block, Player player, ItemStack axe) {
                int durability = axe.getType().getMaxDurability() - axe.getDurability();
                if (axe.getType().getMaxDurability() > 0) {
                    if (this.toolValues.get(tool) == null && this.treeValues.get(tree) == null && this.globalValue != null && durability < (Short)this.globalValue) {
                        return new DebugResult(this, DebugResult.Type.GLOBAL, durability, this.globalValue);
                    }
                    if (this.toolValues.containsKey(tool) && durability < (Short)this.toolValues.get(tool)) {
                        return new DebugResult(this, DebugResult.Type.TOOL, durability, this.toolValues.get(tool));
                    }
                    if (this.treeValues.containsKey(tree) && durability < (Short)this.treeValues.get(tree)) {
                        return new DebugResult(this, DebugResult.Type.TREE, durability, this.treeValues.get(tree));
                    }
                }
                return new DebugResult(this, DebugResult.Type.SUCCESS, new Object[0]);
            }

            @Override
            public String getDesc(boolean ingame) {
                return "Tools with less than this much durability will be unable to fell trees";
            }

            @Override
            public String[] getDebugText() {
                return 73.generateDebugText("Tool durability is less than minimum allowed$: {0}<{1}", "Tool meets minimum durability requirement");
            }

            @Override
            public ItemBuilder getConfigurationDisplayItem(Short value) {
                return new ItemBuilder(Material.DIAMOND_AXE).setDurability(value);
            }

            @Override
            public void openGlobalModifyMenu(MenuGlobalConfiguration parent) {
                parent.open(new MenuModifyShort(parent, parent.plugin, parent.player, this.name, 0, Short.MAX_VALUE, true, (Short)this.globalValue, value -> {
                    this.globalValue = value;
                }));
            }

            @Override
            public void openToolModifyMenu(MenuToolConfiguration parent, Tool tool) {
                parent.open(new MenuModifyShort(parent, parent.plugin, parent.player, this.name, 0, Short.MAX_VALUE, true, (Short)this.toolValues.get(tool), value -> {
                    if (value == null) {
                        this.toolValues.remove(tool);
                    } else {
                        this.toolValues.put(tool, value);
                    }
                }));
            }

            @Override
            public void openTreeModifyMenu(MenuTreeConfiguration parent, Tree tree) {
                parent.open(new MenuModifyShort(parent, parent.plugin, parent.player, this.name, 0, Short.MAX_VALUE, true, (Short)this.treeValues.get(tree), value -> {
                    if (value == null) {
                        this.treeValues.remove(tree);
                    } else {
                        this.treeValues.put(tree, value);
                    }
                }));
            }
        };
        MAX_DURABILITY = new Option<Short>("Max Durability", true, true, true, null){

            @Override
            public Short load(Object o) {
                return 74.loadShort(o);
            }

            @Override
            public DebugResult doCheck(TreeFeller plugin, Tool tool, Tree tree, Block block, Player player, ItemStack axe) {
                int durability = axe.getType().getMaxDurability() - axe.getDurability();
                if (axe.getType().getMaxDurability() > 0) {
                    if (this.toolValues.get(tool) == null && this.treeValues.get(tree) == null && this.globalValue != null && durability > (Short)this.globalValue) {
                        return new DebugResult(this, DebugResult.Type.GLOBAL, durability, this.globalValue);
                    }
                    if (this.toolValues.containsKey(tool) && durability > (Short)this.toolValues.get(tool)) {
                        return new DebugResult(this, DebugResult.Type.TOOL, durability, this.toolValues.get(tool));
                    }
                    if (this.treeValues.containsKey(tree) && durability > (Short)this.treeValues.get(tree)) {
                        return new DebugResult(this, DebugResult.Type.TREE, durability, this.treeValues.get(tree));
                    }
                }
                return new DebugResult(this, DebugResult.Type.SUCCESS, new Object[0]);
            }

            @Override
            public String getDesc(boolean ingame) {
                return "Tools with more than this much durability will be unable to fell trees";
            }

            @Override
            public String[] getDebugText() {
                return 74.generateDebugText("Tool durability is greater than maximum allowed: {0}>{1}", "Tool meets maximum durability requirement");
            }

            @Override
            public ItemBuilder getConfigurationDisplayItem(Short value) {
                return new ItemBuilder(Material.DIAMOND_AXE).setDurability(value);
            }

            @Override
            public void openGlobalModifyMenu(MenuGlobalConfiguration parent) {
                parent.open(new MenuModifyShort(parent, parent.plugin, parent.player, this.name, 0, Short.MAX_VALUE, true, (Short)this.globalValue, value -> {
                    this.globalValue = value;
                }));
            }

            @Override
            public void openToolModifyMenu(MenuToolConfiguration parent, Tool tool) {
                parent.open(new MenuModifyShort(parent, parent.plugin, parent.player, this.name, 0, Short.MAX_VALUE, true, (Short)this.toolValues.get(tool), value -> {
                    if (value == null) {
                        this.toolValues.remove(tool);
                    } else {
                        this.toolValues.put(tool, value);
                    }
                }));
            }

            @Override
            public void openTreeModifyMenu(MenuTreeConfiguration parent, Tree tree) {
                parent.open(new MenuModifyShort(parent, parent.plugin, parent.player, this.name, 0, Short.MAX_VALUE, true, (Short)this.treeValues.get(tree), value -> {
                    if (value == null) {
                        this.treeValues.remove(tree);
                    } else {
                        this.treeValues.put(tree, value);
                    }
                }));
            }
        };
        MIN_DURABILITY_PERCENT = new Option<Float>("Min Durability Percent", true, true, true, null){

            @Override
            public Float load(Object o) {
                return 75.loadFloat(o);
            }

            @Override
            public DebugResult doCheck(TreeFeller plugin, Tool tool, Tree tree, Block block, Player player, ItemStack axe) {
                int durability = axe.getType().getMaxDurability() - axe.getDurability();
                float durabilityPercent = (float)durability / (float)axe.getType().getMaxDurability();
                if (axe.getType().getMaxDurability() > 0) {
                    if (this.toolValues.get(tool) == null && this.treeValues.get(tree) == null && this.globalValue != null && durabilityPercent < ((Float)this.globalValue).floatValue()) {
                        return new DebugResult(this, DebugResult.Type.GLOBAL, Float.valueOf((float)Math.round(durabilityPercent * 1000.0f) / 10.0f), Float.valueOf((float)Math.round(((Float)this.globalValue).floatValue() * 1000.0f) / 10.0f));
                    }
                    if (this.toolValues.containsKey(tool) && durabilityPercent < ((Float)this.toolValues.get(tool)).floatValue()) {
                        return new DebugResult(this, DebugResult.Type.TOOL, Float.valueOf((float)Math.round(durabilityPercent * 1000.0f) / 10.0f), Float.valueOf((float)Math.round(((Float)this.toolValues.get(tool)).floatValue() * 1000.0f) / 10.0f));
                    }
                    if (this.treeValues.containsKey(tree) && durabilityPercent < ((Float)this.treeValues.get(tree)).floatValue()) {
                        return new DebugResult(this, DebugResult.Type.TREE, Float.valueOf((float)Math.round(durabilityPercent * 1000.0f) / 10.0f), Float.valueOf((float)Math.round(((Float)this.treeValues.get(tree)).floatValue() * 1000.0f) / 10.0f));
                    }
                }
                return new DebugResult(this, DebugResult.Type.SUCCESS, new Object[0]);
            }

            @Override
            public String getDesc(boolean ingame) {
                return "Tools with less than this percentage of durability will be unable to fell trees";
            }

            @Override
            public String[] getDebugText() {
                return 75.generateDebugText("Tool durability is less than minimum allowed$: {0}%<{1}%", "Tool meets minimum durability percentage requirement");
            }

            @Override
            public ItemBuilder getConfigurationDisplayItem(Float value) {
                return new ItemBuilder(Material.DIAMOND_AXE).setDurability((value == null ? 1.0f : value.floatValue()) * (float)Material.DIAMOND_AXE.getMaxDurability());
            }

            @Override
            public void openGlobalModifyMenu(MenuGlobalConfiguration parent) {
                parent.open(new MenuModifyFloat(parent, parent.plugin, parent.player, this.name, 0.0f, 1.0f, true, (Float)this.globalValue, value -> {
                    this.globalValue = value;
                }));
            }

            @Override
            public void openToolModifyMenu(MenuToolConfiguration parent, Tool tool) {
                parent.open(new MenuModifyFloat(parent, parent.plugin, parent.player, this.name, 0.0f, 1.0f, true, (Float)this.toolValues.get(tool), value -> {
                    if (value == null) {
                        this.toolValues.remove(tool);
                    } else {
                        this.toolValues.put(tool, value);
                    }
                }));
            }

            @Override
            public void openTreeModifyMenu(MenuTreeConfiguration parent, Tree tree) {
                parent.open(new MenuModifyFloat(parent, parent.plugin, parent.player, this.name, 0.0f, 1.0f, true, (Float)this.treeValues.get(tree), value -> {
                    if (value == null) {
                        this.treeValues.remove(tree);
                    } else {
                        this.treeValues.put(tree, value);
                    }
                }));
            }
        };
        MAX_DURABILITY_PERCENT = new Option<Float>("Max Durability Percent", true, true, true, null){

            @Override
            public Float load(Object o) {
                return 76.loadFloat(o);
            }

            @Override
            public DebugResult doCheck(TreeFeller plugin, Tool tool, Tree tree, Block block, Player player, ItemStack axe) {
                int durability = axe.getType().getMaxDurability() - axe.getDurability();
                float durabilityPercent = (float)durability / (float)axe.getType().getMaxDurability();
                if (axe.getType().getMaxDurability() > 0) {
                    if (this.toolValues.get(tool) == null && this.treeValues.get(tree) == null && this.globalValue != null && durabilityPercent > ((Float)this.globalValue).floatValue()) {
                        return new DebugResult(this, DebugResult.Type.GLOBAL, Float.valueOf((float)Math.round(durabilityPercent * 1000.0f) / 10.0f), Float.valueOf((float)Math.round(((Float)this.globalValue).floatValue() * 1000.0f) / 10.0f));
                    }
                    if (this.toolValues.containsKey(tool) && durabilityPercent > ((Float)this.toolValues.get(tool)).floatValue()) {
                        return new DebugResult(this, DebugResult.Type.TOOL, Float.valueOf((float)Math.round(durabilityPercent * 1000.0f) / 10.0f), Float.valueOf((float)Math.round(((Float)this.toolValues.get(tool)).floatValue() * 1000.0f) / 10.0f));
                    }
                    if (this.treeValues.containsKey(tree) && durabilityPercent > ((Float)this.treeValues.get(tree)).floatValue()) {
                        return new DebugResult(this, DebugResult.Type.TREE, Float.valueOf((float)Math.round(durabilityPercent * 1000.0f) / 10.0f), Float.valueOf((float)Math.round(((Float)this.treeValues.get(tree)).floatValue() * 1000.0f) / 10.0f));
                    }
                }
                return new DebugResult(this, DebugResult.Type.SUCCESS, new Object[0]);
            }

            @Override
            public String getDesc(boolean ingame) {
                return "Tools with more than this percentage of durability will be unable to fell trees";
            }

            @Override
            public String[] getDebugText() {
                return 76.generateDebugText("Tool durability is greater than maximum allowed: {0}%>{1}%", "Tool meets maximum durability percentage requirement");
            }

            @Override
            public ItemBuilder getConfigurationDisplayItem(Float value) {
                return new ItemBuilder(Material.DIAMOND_AXE).setDurability((value == null ? 1.0f : value.floatValue()) * (float)Material.DIAMOND_AXE.getMaxDurability());
            }

            @Override
            public void openGlobalModifyMenu(MenuGlobalConfiguration parent) {
                parent.open(new MenuModifyFloat(parent, parent.plugin, parent.player, this.name, 0.0f, 1.0f, true, (Float)this.globalValue, value -> {
                    this.globalValue = value;
                }));
            }

            @Override
            public void openToolModifyMenu(MenuToolConfiguration parent, Tool tool) {
                parent.open(new MenuModifyFloat(parent, parent.plugin, parent.player, this.name, 0.0f, 1.0f, true, (Float)this.toolValues.get(tool), value -> {
                    if (value == null) {
                        this.toolValues.remove(tool);
                    } else {
                        this.toolValues.put(tool, value);
                    }
                }));
            }

            @Override
            public void openTreeModifyMenu(MenuTreeConfiguration parent, Tree tree) {
                parent.open(new MenuModifyFloat(parent, parent.plugin, parent.player, this.name, 0.0f, 1.0f, true, (Float)this.treeValues.get(tree), value -> {
                    if (value == null) {
                        this.treeValues.remove(tree);
                    } else {
                        this.treeValues.put(tree, value);
                    }
                }));
            }
        };
        PREVENT_BREAKAGE = new OptionBoolean("Prevent Breakage", true, true, true, false){

            @Override
            public String getDesc(boolean ingame) {
                return "If set to true, tools will not be able to fell a tree if doing so would break the tool.";
            }

            @Override
            public ItemBuilder getConfigurationDisplayItem(Boolean value) {
                return new ItemBuilder(Material.WOODEN_AXE);
            }
        };
        REQUIRED_LORE = new Option<ArrayList<String>>("Required Lore", true, true, true, null){

            @Override
            public ArrayList<String> load(Object o) {
                if (o instanceof Iterable) {
                    ArrayList<String> lores = new ArrayList<String>();
                    for (Object ob : (Iterable)o) {
                        Object newLores = this.load(ob);
                        if (newLores == null) continue;
                        lores.addAll((Collection<String>)newLores);
                    }
                    return lores;
                }
                if (o instanceof String) {
                    ArrayList<String> lores = new ArrayList<String>();
                    lores.add((String)o);
                    return lores;
                }
                return null;
            }

            @Override
            public DebugResult doCheck(TreeFeller plugin, Tool tool, Tree tree, Block block, Player player, ItemStack axe) {
                boolean has;
                ItemMeta meta;
                ArrayList lore = new ArrayList();
                if (axe.hasItemMeta() && (meta = axe.getItemMeta()).hasLore()) {
                    lore = new ArrayList(meta.getLore());
                }
                if (this.toolValues.get(tool) == null && this.treeValues.get(tree) == null && this.globalValue != null) {
                    for (String s : (ArrayList)this.globalValue) {
                        has = false;
                        for (String lor : lore) {
                            if (!lor.contains(s)) continue;
                            has = true;
                        }
                        if (has) continue;
                        return new DebugResult(this, DebugResult.Type.GLOBAL, s);
                    }
                }
                if (this.toolValues.containsKey(tool)) {
                    for (String s : (ArrayList)this.toolValues.get(tool)) {
                        has = false;
                        for (String lor : lore) {
                            if (!lor.contains(s)) continue;
                            has = true;
                        }
                        if (has) continue;
                        return new DebugResult(this, DebugResult.Type.TOOL, s);
                    }
                }
                if (this.treeValues.containsKey(tree)) {
                    for (String s : (ArrayList)this.treeValues.get(tree)) {
                        has = false;
                        for (String lor : lore) {
                            if (!lor.contains(s)) continue;
                            has = true;
                        }
                        if (has) continue;
                        return new DebugResult(this, DebugResult.Type.TREE, s);
                    }
                }
                return new DebugResult(this, DebugResult.Type.SUCCESS, new Object[0]);
            }

            @Override
            public String getDesc(boolean ingame) {
                return "Tools must have all literal strings in this list in order to fell trees" + (ingame ? "" : "\nex:\n- Can fell trees");
            }

            @Override
            public String[] getDebugText() {
                return 78.generateDebugText("Tool is missing required lore$: {0}", "Tool has all required lore");
            }

            @Override
            public ItemBuilder getConfigurationDisplayItem(ArrayList<String> value) {
                return new ItemBuilder(Material.BOOK);
            }

            @Override
            public void openGlobalModifyMenu(MenuGlobalConfiguration parent) {
                parent.open(new MenuModifyStringList(parent, parent.plugin, parent.player, this.name, true, (ArrayList)this.globalValue, value -> {
                    this.globalValue = value;
                }));
            }

            @Override
            public void openToolModifyMenu(MenuToolConfiguration parent, Tool tool) {
                parent.open(new MenuModifyStringList(parent, parent.plugin, parent.player, this.name, true, (ArrayList)this.toolValues.get(tool), value -> {
                    if (value == null) {
                        this.toolValues.remove(tool);
                    } else {
                        this.toolValues.put(tool, value);
                    }
                }));
            }

            @Override
            public void openTreeModifyMenu(MenuTreeConfiguration parent, Tree tree) {
                parent.open(new MenuModifyStringList(parent, parent.plugin, parent.player, this.name, true, (ArrayList)this.treeValues.get(tree), value -> {
                    if (value == null) {
                        this.treeValues.remove(tree);
                    } else {
                        this.treeValues.put(tree, value);
                    }
                }));
            }
        };
        REQUIRED_NAME = new Option<String>("Required Name", true, true, true, null){

            @Override
            public String load(Object o) {
                return 79.loadString(o);
            }

            @Override
            public DebugResult doCheck(TreeFeller plugin, Tool tool, Tree tree, Block block, Player player, ItemStack axe) {
                String name = null;
                if (axe.hasItemMeta()) {
                    ItemMeta meta = axe.getItemMeta();
                    name = meta.getDisplayName();
                }
                if (this.toolValues.get(tool) == null && this.treeValues.get(tree) == null && this.globalValue != null && !((String)this.globalValue).equals(name)) {
                    return new DebugResult(this, DebugResult.Type.GLOBAL, name, this.globalValue);
                }
                if (this.toolValues.containsKey(tool) && !((String)this.toolValues.get(tool)).equals(name)) {
                    return new DebugResult(this, DebugResult.Type.TOOL, name, this.toolValues.get(tool));
                }
                if (this.treeValues.containsKey(tree) && !((String)this.treeValues.get(tree)).equals(name)) {
                    return new DebugResult(this, DebugResult.Type.TREE, name, this.treeValues.get(tree));
                }
                return new DebugResult(this, DebugResult.Type.SUCCESS, new Object[0]);
            }

            @Override
            public String getDesc(boolean ingame) {
                return "A tool's name must match exactly in order to fell trees (colors can be designated with \u00a7)";
            }

            @Override
            public String[] getDebugText() {
                return 79.generateDebugText("Tool name {0} " + ChatColor.RESET + "does not match required name$: {1}", "Tool name matches");
            }

            @Override
            public ItemBuilder getConfigurationDisplayItem(String value) {
                return new ItemBuilder(Material.PAPER);
            }

            @Override
            public void openGlobalModifyMenu(MenuGlobalConfiguration parent) {
                parent.openAnvilGUI(this.globalValue == null ? "" : (String)this.globalValue, "Edit Required Name", (p, str) -> {
                    this.globalValue = str == null || str.isEmpty() || str.equalsIgnoreCase("null") ? null : str;
                });
            }

            @Override
            public void openToolModifyMenu(MenuToolConfiguration parent, Tool tool) {
                parent.openAnvilGUI(this.toolValues.containsKey(tool) ? (String)this.toolValues.get(tool) : "", "Edit Required Name", (p, str) -> {
                    String value;
                    String string = value = str == null || str.isEmpty() || str.equalsIgnoreCase("null") ? null : str;
                    if (value == null) {
                        this.toolValues.remove(tool);
                    } else {
                        this.toolValues.put(tool, value);
                    }
                });
            }

            @Override
            public void openTreeModifyMenu(MenuTreeConfiguration parent, Tree tree) {
                parent.openAnvilGUI(this.treeValues.containsKey(tree) ? (String)this.treeValues.get(tree) : "", "Edit Required Name", (p, str) -> {
                    String value;
                    String string = value = str == null || str.isEmpty() || str.equalsIgnoreCase("null") ? null : str;
                    if (value == null) {
                        this.treeValues.remove(tree);
                    } else {
                        this.treeValues.put(tree, value);
                    }
                });
            }
        };
        REQUIRED_PERMISSIONS = new Option<HashSet<String>>("Required Permissions", true, true, true, new HashSet(), null){

            @Override
            public HashSet<String> load(Object o) {
                if (o instanceof Iterable) {
                    HashSet<String> permissions = new HashSet<String>();
                    for (Object ob : (Iterable)o) {
                        Object newPerms = this.load(ob);
                        if (newPerms == null) continue;
                        permissions.addAll((Collection<String>)newPerms);
                    }
                    return permissions;
                }
                if (o instanceof String) {
                    HashSet<String> permissions = new HashSet<String>();
                    permissions.add((String)o);
                    return permissions;
                }
                return null;
            }

            @Override
            public DebugResult doCheck(TreeFeller plugin, Tool tool, Tree tree, Block block, Player player, ItemStack axe) {
                if (this.toolValues.get(tool) == null && this.treeValues.get(tree) == null && this.globalValue != null) {
                    for (String s : (HashSet)this.globalValue) {
                        if (player.hasPermission(s)) continue;
                        return new DebugResult(this, DebugResult.Type.GLOBAL, s);
                    }
                }
                if (this.toolValues.containsKey(tool)) {
                    for (String s : (HashSet)this.toolValues.get(tool)) {
                        if (player.hasPermission(s)) continue;
                        return new DebugResult(this, DebugResult.Type.TOOL, s);
                    }
                }
                if (this.treeValues.containsKey(tree)) {
                    for (String s : (HashSet)this.treeValues.get(tree)) {
                        if (player.hasPermission(s)) continue;
                        return new DebugResult(this, DebugResult.Type.TREE, s);
                    }
                }
                return new DebugResult(this, DebugResult.Type.SUCCESS, new Object[0]);
            }

            @Override
            public String getDesc(boolean ingame) {
                return "Trees can only be cut down by players who have all permissons listed here" + (ingame ? "" : "\nex:\n- treefeller.example");
            }

            @Override
            public String[] getDebugText() {
                return 80.generateDebugText("Player is missing required permission$: {0}", "Player has all required permissions");
            }

            @Override
            public ItemBuilder getConfigurationDisplayItem(HashSet<String> value) {
                return new ItemBuilder(Material.PAPER);
            }

            @Override
            public void openGlobalModifyMenu(MenuGlobalConfiguration parent) {
                parent.open(new MenuModifyStringSet(parent, parent.plugin, parent.player, this.name, true, (HashSet)this.globalValue, value -> {
                    this.globalValue = value;
                }));
            }

            @Override
            public void openToolModifyMenu(MenuToolConfiguration parent, Tool tool) {
                parent.open(new MenuModifyStringSet(parent, parent.plugin, parent.player, this.name, true, (HashSet)this.toolValues.get(tool), value -> {
                    if (value == null) {
                        this.toolValues.remove(tool);
                    } else {
                        this.toolValues.put(tool, value);
                    }
                }));
            }

            @Override
            public void openTreeModifyMenu(MenuTreeConfiguration parent, Tree tree) {
                parent.open(new MenuModifyStringSet(parent, parent.plugin, parent.player, this.name, true, (HashSet)this.treeValues.get(tree), value -> {
                    if (value == null) {
                        this.treeValues.remove(tree);
                    } else {
                        this.treeValues.put(tree, value);
                    }
                }));
            }
        };
        MIN_TIME = new Option<Integer>("Min Time", true, true, true, null){

            @Override
            public Integer load(Object o) {
                return 81.loadInt(o);
            }

            @Override
            public DebugResult doCheck(TreeFeller plugin, Tool tool, Tree tree, Block block, Player player, ItemStack axe) {
                long dayTime = block.getWorld().getTime();
                if (axe.getType().getMaxDurability() > 0) {
                    if (this.toolValues.get(tool) == null && this.treeValues.get(tree) == null && this.globalValue != null && dayTime < (long)((Integer)this.globalValue).intValue()) {
                        return new DebugResult(this, DebugResult.Type.GLOBAL, dayTime, this.globalValue);
                    }
                    if (this.toolValues.containsKey(tool) && dayTime < (long)((Integer)this.toolValues.get(tool)).intValue()) {
                        return new DebugResult(this, DebugResult.Type.TOOL, dayTime, this.toolValues.get(tool));
                    }
                    if (this.treeValues.containsKey(tree) && dayTime < (long)((Integer)this.treeValues.get(tree)).intValue()) {
                        return new DebugResult(this, DebugResult.Type.TREE, dayTime, this.treeValues.get(tree));
                    }
                }
                return new DebugResult(this, DebugResult.Type.SUCCESS, new Object[0]);
            }

            @Override
            public String getDesc(boolean ingame) {
                return "What should the minimum time be for felling trees? (0-24000)";
            }

            @Override
            public String[] getDebugText() {
                return 81.generateDebugText("Time is less than minimum allowed$: {0}<{1}", "Time meets minimum requirement");
            }

            @Override
            public ItemBuilder getConfigurationDisplayItem(Integer value) {
                return new ItemBuilder(Material.CLOCK);
            }

            @Override
            public void openGlobalModifyMenu(MenuGlobalConfiguration parent) {
                parent.open(new MenuModifyInteger(parent, parent.plugin, parent.player, this.name, 0, 24000, true, (Integer)this.globalValue, value -> {
                    this.globalValue = value;
                }));
            }

            @Override
            public void openToolModifyMenu(MenuToolConfiguration parent, Tool tool) {
                parent.open(new MenuModifyInteger(parent, parent.plugin, parent.player, this.name, 0, 24000, true, (Integer)this.toolValues.get(tool), value -> {
                    if (value == null) {
                        this.toolValues.remove(tool);
                    } else {
                        this.toolValues.put(tool, value);
                    }
                }));
            }

            @Override
            public void openTreeModifyMenu(MenuTreeConfiguration parent, Tree tree) {
                parent.open(new MenuModifyInteger(parent, parent.plugin, parent.player, this.name, 0, 24000, true, (Integer)this.treeValues.get(tree), value -> {
                    if (value == null) {
                        this.treeValues.remove(tree);
                    } else {
                        this.treeValues.put(tree, value);
                    }
                }));
            }
        };
        MAX_TIME = new Option<Integer>("Max Time", true, true, true, null){

            @Override
            public Integer load(Object o) {
                return 82.loadInt(o);
            }

            @Override
            public DebugResult doCheck(TreeFeller plugin, Tool tool, Tree tree, Block block, Player player, ItemStack axe) {
                long dayTime = block.getWorld().getTime();
                if (axe.getType().getMaxDurability() > 0) {
                    if (this.toolValues.get(tool) == null && this.treeValues.get(tree) == null && this.globalValue != null && dayTime > (long)((Integer)this.globalValue).intValue()) {
                        return new DebugResult(this, DebugResult.Type.GLOBAL, dayTime, this.globalValue);
                    }
                    if (this.toolValues.containsKey(tool) && dayTime > (long)((Integer)this.toolValues.get(tool)).intValue()) {
                        return new DebugResult(this, DebugResult.Type.TOOL, dayTime, this.toolValues.get(tool));
                    }
                    if (this.treeValues.containsKey(tree) && dayTime > (long)((Integer)this.treeValues.get(tree)).intValue()) {
                        return new DebugResult(this, DebugResult.Type.TREE, dayTime, this.treeValues.get(tree));
                    }
                }
                return new DebugResult(this, DebugResult.Type.SUCCESS, new Object[0]);
            }

            @Override
            public String getDesc(boolean ingame) {
                return "What should the maximum time be for felling trees? (0-24000)";
            }

            @Override
            public String[] getDebugText() {
                return 82.generateDebugText("Time is greater than maximum allowed$: {0}>{1}", "Time meets maximum requirement");
            }

            @Override
            public ItemBuilder getConfigurationDisplayItem(Integer value) {
                return new ItemBuilder(Material.CLOCK);
            }

            @Override
            public void openGlobalModifyMenu(MenuGlobalConfiguration parent) {
                parent.open(new MenuModifyInteger(parent, parent.plugin, parent.player, this.name, 0, 24000, true, (Integer)this.globalValue, value -> {
                    this.globalValue = value;
                }));
            }

            @Override
            public void openToolModifyMenu(MenuToolConfiguration parent, Tool tool) {
                parent.open(new MenuModifyInteger(parent, parent.plugin, parent.player, this.name, 0, 24000, true, (Integer)this.toolValues.get(tool), value -> {
                    if (value == null) {
                        this.toolValues.remove(tool);
                    } else {
                        this.toolValues.put(tool, value);
                    }
                }));
            }

            @Override
            public void openTreeModifyMenu(MenuTreeConfiguration parent, Tree tree) {
                parent.open(new MenuModifyInteger(parent, parent.plugin, parent.player, this.name, 0, 24000, true, (Integer)this.treeValues.get(tree), value -> {
                    if (value == null) {
                        this.treeValues.remove(tree);
                    } else {
                        this.treeValues.put(tree, value);
                    }
                }));
            }
        };
        MIN_PHASE = new Option<Integer>("Min Phase", true, true, true, null){

            @Override
            public Integer load(Object o) {
                return 83.loadInt(o);
            }

            @Override
            public DebugResult doCheck(TreeFeller plugin, Tool tool, Tree tree, Block block, Player player, ItemStack axe) {
                long gameTime = block.getWorld().getFullTime();
                long day = gameTime / 24000L;
                long phase = day % 8L;
                if (axe.getType().getMaxDurability() > 0) {
                    if (this.toolValues.get(tool) == null && this.treeValues.get(tree) == null && this.globalValue != null && phase < (long)((Integer)this.globalValue).intValue()) {
                        return new DebugResult(this, DebugResult.Type.GLOBAL, phase, this.globalValue);
                    }
                    if (this.toolValues.containsKey(tool) && phase < (long)((Integer)this.toolValues.get(tool)).intValue()) {
                        return new DebugResult(this, DebugResult.Type.TOOL, phase, this.toolValues.get(tool));
                    }
                    if (this.treeValues.containsKey(tree) && phase < (long)((Integer)this.treeValues.get(tree)).intValue()) {
                        return new DebugResult(this, DebugResult.Type.TREE, phase, this.treeValues.get(tree));
                    }
                }
                return new DebugResult(this, DebugResult.Type.SUCCESS, new Object[0]);
            }

            @Override
            public String getDesc(boolean ingame) {
                return "What should the minimum phase be for felling trees? (0-7)\nPhases:\n0 = full moon\n1 = waning gibbous\n2 = first quarter\n3 = waning crescent\n4 = new moon\n5 = waxing crescent\n6 = third quarter\n7 = waxing gibbous\n";
            }

            @Override
            public String[] getDebugText() {
                return 83.generateDebugText("Phase is less than minimum allowed$: {0}<{1}", "Phase meets minimum requirement");
            }

            @Override
            public ItemBuilder getConfigurationDisplayItem(Integer value) {
                return new ItemBuilder(Material.CLOCK);
            }

            @Override
            public void openGlobalModifyMenu(MenuGlobalConfiguration parent) {
                parent.open(new MenuModifyInteger(parent, parent.plugin, parent.player, this.name, 0, 7, true, (Integer)this.globalValue, value -> {
                    this.globalValue = value;
                }));
            }

            @Override
            public void openToolModifyMenu(MenuToolConfiguration parent, Tool tool) {
                parent.open(new MenuModifyInteger(parent, parent.plugin, parent.player, this.name, 0, 7, true, (Integer)this.toolValues.get(tool), value -> {
                    if (value == null) {
                        this.toolValues.remove(tool);
                    } else {
                        this.toolValues.put(tool, value);
                    }
                }));
            }

            @Override
            public void openTreeModifyMenu(MenuTreeConfiguration parent, Tree tree) {
                parent.open(new MenuModifyInteger(parent, parent.plugin, parent.player, this.name, 0, 7, true, (Integer)this.treeValues.get(tree), value -> {
                    if (value == null) {
                        this.treeValues.remove(tree);
                    } else {
                        this.treeValues.put(tree, value);
                    }
                }));
            }
        };
        MAX_PHASE = new Option<Integer>("Max Phase", true, true, true, null){

            @Override
            public Integer load(Object o) {
                return 84.loadInt(o);
            }

            @Override
            public DebugResult doCheck(TreeFeller plugin, Tool tool, Tree tree, Block block, Player player, ItemStack axe) {
                long gameTime = block.getWorld().getFullTime();
                long day = gameTime / 24000L;
                long phase = day % 8L;
                if (axe.getType().getMaxDurability() > 0) {
                    if (this.toolValues.get(tool) == null && this.treeValues.get(tree) == null && this.globalValue != null && phase > (long)((Integer)this.globalValue).intValue()) {
                        return new DebugResult(this, DebugResult.Type.GLOBAL, phase, this.globalValue);
                    }
                    if (this.toolValues.containsKey(tool) && phase > (long)((Integer)this.toolValues.get(tool)).intValue()) {
                        return new DebugResult(this, DebugResult.Type.TOOL, phase, this.toolValues.get(tool));
                    }
                    if (this.treeValues.containsKey(tree) && phase > (long)((Integer)this.treeValues.get(tree)).intValue()) {
                        return new DebugResult(this, DebugResult.Type.TREE, phase, this.treeValues.get(tree));
                    }
                }
                return new DebugResult(this, DebugResult.Type.SUCCESS, new Object[0]);
            }

            @Override
            public String getDesc(boolean ingame) {
                return "What should the maximum phase be for felling trees? (0-7)\nPhases:\n0 = full moon\n1 = waning gibbous\n2 = first quarter\n3 = waning crescent\n4 = new moon\n5 = waxing crescent\n6 = third quarter\n7 = waxing gibbous\n";
            }

            @Override
            public String[] getDebugText() {
                return 84.generateDebugText("Phase is greater than maximum allowed$: {0}>{1}", "Phase meets maximum requirement");
            }

            @Override
            public ItemBuilder getConfigurationDisplayItem(Integer value) {
                return new ItemBuilder(Material.CLOCK);
            }

            @Override
            public void openGlobalModifyMenu(MenuGlobalConfiguration parent) {
                parent.open(new MenuModifyInteger(parent, parent.plugin, parent.player, this.name, 0, 7, true, (Integer)this.globalValue, value -> {
                    this.globalValue = value;
                }));
            }

            @Override
            public void openToolModifyMenu(MenuToolConfiguration parent, Tool tool) {
                parent.open(new MenuModifyInteger(parent, parent.plugin, parent.player, this.name, 0, 7, true, (Integer)this.toolValues.get(tool), value -> {
                    if (value == null) {
                        this.toolValues.remove(tool);
                    } else {
                        this.toolValues.put(tool, value);
                    }
                }));
            }

            @Override
            public void openTreeModifyMenu(MenuTreeConfiguration parent, Tree tree) {
                parent.open(new MenuModifyInteger(parent, parent.plugin, parent.player, this.name, 0, 7, true, (Integer)this.treeValues.get(tree), value -> {
                    if (value == null) {
                        this.treeValues.remove(tree);
                    } else {
                        this.treeValues.put(tree, value);
                    }
                }));
            }
        };
        MIN_FOOD = new Option<Integer>("Min Food", true, true, true, null){

            @Override
            public Integer load(Object o) {
                return 85.loadInt(o);
            }

            @Override
            public DebugResult doCheck(TreeFeller plugin, Tool tool, Tree tree, Block block, Player player, ItemStack axe) {
                int food = player.getFoodLevel();
                if (this.toolValues.get(tool) == null && this.treeValues.get(tree) == null && this.globalValue != null && food < (Integer)this.globalValue) {
                    return new DebugResult(this, DebugResult.Type.GLOBAL, food, this.globalValue);
                }
                if (this.toolValues.containsKey(tool) && food < (Integer)this.toolValues.get(tool)) {
                    return new DebugResult(this, DebugResult.Type.TOOL, food, this.toolValues.get(tool));
                }
                if (this.treeValues.containsKey(tree) && food < (Integer)this.treeValues.get(tree)) {
                    return new DebugResult(this, DebugResult.Type.TREE, food, this.treeValues.get(tree));
                }
                return new DebugResult(this, DebugResult.Type.SUCCESS, food);
            }

            @Override
            public String getDesc(boolean ingame) {
                return "How much food should be required to fell trees? (0 - 20)";
            }

            @Override
            public String[] getDebugText() {
                return 85.generateDebugText("Not enough food$: {0}<{1}", "Food meets minimum requirement");
            }

            @Override
            public ItemBuilder getConfigurationDisplayItem(Integer value) {
                return new ItemBuilder(Material.BREAD);
            }

            @Override
            public void openGlobalModifyMenu(MenuGlobalConfiguration parent) {
                parent.open(new MenuModifyInteger(parent, parent.plugin, parent.player, this.name, 0, 20, true, (Integer)this.globalValue, value -> {
                    this.globalValue = value;
                }));
            }

            @Override
            public void openToolModifyMenu(MenuToolConfiguration parent, Tool tool) {
                parent.open(new MenuModifyInteger(parent, parent.plugin, parent.player, this.name, 0, 20, true, (Integer)this.toolValues.get(tool), value -> {
                    if (value == null) {
                        this.toolValues.remove(tool);
                    } else {
                        this.toolValues.put(tool, value);
                    }
                }));
            }

            @Override
            public void openTreeModifyMenu(MenuTreeConfiguration parent, Tree tree) {
                parent.open(new MenuModifyInteger(parent, parent.plugin, parent.player, this.name, 0, 20, true, (Integer)this.treeValues.get(tree), value -> {
                    if (value == null) {
                        this.treeValues.remove(tree);
                    } else {
                        this.treeValues.put(tree, value);
                    }
                }));
            }
        };
        MAX_FOOD = new Option<Integer>("Max Food", true, true, true, null){

            @Override
            public Integer load(Object o) {
                return 86.loadInt(o);
            }

            @Override
            public DebugResult doCheck(TreeFeller plugin, Tool tool, Tree tree, Block block, Player player, ItemStack axe) {
                int food = player.getFoodLevel();
                if (this.toolValues.get(tool) == null && this.treeValues.get(tree) == null && this.globalValue != null && food > (Integer)this.globalValue) {
                    return new DebugResult(this, DebugResult.Type.GLOBAL, food, this.globalValue);
                }
                if (this.toolValues.containsKey(tool) && food > (Integer)this.toolValues.get(tool)) {
                    return new DebugResult(this, DebugResult.Type.TOOL, food, this.toolValues.get(tool));
                }
                if (this.treeValues.containsKey(tree) && food > (Integer)this.treeValues.get(tree)) {
                    return new DebugResult(this, DebugResult.Type.TREE, food, this.treeValues.get(tree));
                }
                return new DebugResult(this, DebugResult.Type.SUCCESS, food);
            }

            @Override
            public String getDesc(boolean ingame) {
                return "What is the maximum food level allowed in order to fell trees? (0 - 20)";
            }

            @Override
            public String[] getDebugText() {
                return 86.generateDebugText("Too much food$: {0}>{1}", "Food meets maximum requirement");
            }

            @Override
            public ItemBuilder getConfigurationDisplayItem(Integer value) {
                return new ItemBuilder(Material.COOKED_BEEF);
            }

            @Override
            public void openGlobalModifyMenu(MenuGlobalConfiguration parent) {
                parent.open(new MenuModifyInteger(parent, parent.plugin, parent.player, this.name, 0, 20, true, (Integer)this.globalValue, value -> {
                    this.globalValue = value;
                }));
            }

            @Override
            public void openToolModifyMenu(MenuToolConfiguration parent, Tool tool) {
                parent.open(new MenuModifyInteger(parent, parent.plugin, parent.player, this.name, 0, 20, true, (Integer)this.toolValues.get(tool), value -> {
                    if (value == null) {
                        this.toolValues.remove(tool);
                    } else {
                        this.toolValues.put(tool, value);
                    }
                }));
            }

            @Override
            public void openTreeModifyMenu(MenuTreeConfiguration parent, Tree tree) {
                parent.open(new MenuModifyInteger(parent, parent.plugin, parent.player, this.name, 0, 20, true, (Integer)this.treeValues.get(tree), value -> {
                    if (value == null) {
                        this.treeValues.remove(tree);
                    } else {
                        this.treeValues.put(tree, value);
                    }
                }));
            }
        };
        MIN_HEALTH = new Option<Double>("Min Health", true, true, true, null){

            @Override
            public Double load(Object o) {
                return 87.loadDouble(o);
            }

            @Override
            public DebugResult doCheck(TreeFeller plugin, Tool tool, Tree tree, Block block, Player player, ItemStack axe) {
                double health = player.getHealth();
                if (this.toolValues.get(tool) == null && this.treeValues.get(tree) == null && this.globalValue != null && health < (Double)this.globalValue) {
                    return new DebugResult(this, DebugResult.Type.GLOBAL, health, this.globalValue);
                }
                if (this.toolValues.containsKey(tool) && health < (Double)this.toolValues.get(tool)) {
                    return new DebugResult(this, DebugResult.Type.TOOL, health, this.toolValues.get(tool));
                }
                if (this.treeValues.containsKey(tree) && health < (Double)this.treeValues.get(tree)) {
                    return new DebugResult(this, DebugResult.Type.TREE, health, this.treeValues.get(tree));
                }
                return new DebugResult(this, DebugResult.Type.SUCCESS, health);
            }

            @Override
            public String getDesc(boolean ingame) {
                return "How much health should be required to fell trees?";
            }

            @Override
            public String[] getDebugText() {
                return 87.generateDebugText("Not enough health$: {0}<{1}", "Health meets minimum requirement");
            }

            @Override
            public ItemBuilder getConfigurationDisplayItem(Double value) {
                return new ItemBuilder(Material.GOLDEN_CARROT);
            }

            @Override
            public void openGlobalModifyMenu(MenuGlobalConfiguration parent) {
                parent.open(new MenuModifyDouble(parent, parent.plugin, parent.player, this.name, 0.0, 2.147483647E9, 1.0, true, (Double)this.globalValue, value -> {
                    this.globalValue = value;
                }));
            }

            @Override
            public void openToolModifyMenu(MenuToolConfiguration parent, Tool tool) {
                parent.open(new MenuModifyDouble(parent, parent.plugin, parent.player, this.name, 0.0, 2.147483647E9, 1.0, true, (Double)this.toolValues.get(tool), value -> {
                    if (value == null) {
                        this.toolValues.remove(tool);
                    } else {
                        this.toolValues.put(tool, value);
                    }
                }));
            }

            @Override
            public void openTreeModifyMenu(MenuTreeConfiguration parent, Tree tree) {
                parent.open(new MenuModifyDouble(parent, parent.plugin, parent.player, this.name, 0.0, 2.147483647E9, 1.0, true, (Double)this.treeValues.get(tree), value -> {
                    if (value == null) {
                        this.treeValues.remove(tree);
                    } else {
                        this.treeValues.put(tree, value);
                    }
                }));
            }
        };
        MAX_HEALTH = new Option<Double>("Max Health", true, true, true, null){

            @Override
            public Double load(Object o) {
                return 88.loadDouble(o);
            }

            @Override
            public DebugResult doCheck(TreeFeller plugin, Tool tool, Tree tree, Block block, Player player, ItemStack axe) {
                double health = player.getHealth();
                if (this.toolValues.get(tool) == null && this.treeValues.get(tree) == null && this.globalValue != null && health > (Double)this.globalValue) {
                    return new DebugResult(this, DebugResult.Type.GLOBAL, health, this.globalValue);
                }
                if (this.toolValues.containsKey(tool) && health > (Double)this.toolValues.get(tool)) {
                    return new DebugResult(this, DebugResult.Type.TOOL, health, this.toolValues.get(tool));
                }
                if (this.treeValues.containsKey(tree) && health > (Double)this.treeValues.get(tree)) {
                    return new DebugResult(this, DebugResult.Type.TREE, health, this.treeValues.get(tree));
                }
                return new DebugResult(this, DebugResult.Type.SUCCESS, health);
            }

            @Override
            public String getDesc(boolean ingame) {
                return "What is the maximum health level allowed in order to fell trees?";
            }

            @Override
            public String[] getDebugText() {
                return 88.generateDebugText("Too much health$: {0}>{1}", "Health meets maximum requirement");
            }

            @Override
            public ItemBuilder getConfigurationDisplayItem(Double value) {
                return new ItemBuilder(Material.GOLDEN_APPLE);
            }

            @Override
            public void openGlobalModifyMenu(MenuGlobalConfiguration parent) {
                parent.open(new MenuModifyDouble(parent, parent.plugin, parent.player, this.name, 0.0, 2.147483647E9, 1.0, true, (Double)this.globalValue, value -> {
                    this.globalValue = value;
                }));
            }

            @Override
            public void openToolModifyMenu(MenuToolConfiguration parent, Tool tool) {
                parent.open(new MenuModifyDouble(parent, parent.plugin, parent.player, this.name, 0.0, 2.147483647E9, 1.0, true, (Double)this.toolValues.get(tool), value -> {
                    if (value == null) {
                        this.toolValues.remove(tool);
                    } else {
                        this.toolValues.put(tool, value);
                    }
                }));
            }

            @Override
            public void openTreeModifyMenu(MenuTreeConfiguration parent, Tree tree) {
                parent.open(new MenuModifyDouble(parent, parent.plugin, parent.player, this.name, 0.0, 2.147483647E9, 1.0, true, (Double)this.treeValues.get(tree), value -> {
                    if (value == null) {
                        this.treeValues.remove(tree);
                    } else {
                        this.treeValues.put(tree, value);
                    }
                }));
            }
        };
        CUSTOM_MODEL_DATA = new Option<Integer>("Custom Model Data", true, true, true, null){

            @Override
            public Integer load(Object o) {
                return 89.loadInt(o);
            }

            @Override
            public DebugResult doCheck(TreeFeller plugin, Tool tool, Tree tree, Block block, Player player, ItemStack axe) {
                int data;
                ItemMeta meta = axe.getItemMeta();
                int n = data = meta == null || !meta.hasCustomModelData() ? 0 : meta.getCustomModelData();
                if (this.toolValues.get(tool) == null && this.treeValues.get(tree) == null && this.globalValue != null && data != (Integer)this.globalValue) {
                    return new DebugResult(this, DebugResult.Type.GLOBAL, data, this.globalValue);
                }
                if (this.toolValues.containsKey(tool) && data != (Integer)this.toolValues.get(tool)) {
                    return new DebugResult(this, DebugResult.Type.TOOL, data, this.toolValues.get(tool));
                }
                if (this.treeValues.containsKey(tree) && data != (Integer)this.treeValues.get(tree)) {
                    return new DebugResult(this, DebugResult.Type.TREE, data, this.treeValues.get(tree));
                }
                return new DebugResult(this, DebugResult.Type.SUCCESS, new Object[0]);
            }

            @Override
            public String getDesc(boolean ingame) {
                return "Tool's CustomModelData must match in order to fell trees";
            }

            @Override
            public String[] getDebugText() {
                return 89.generateDebugText("Custom model data does not match$: {0} != {1}", "Custom model data matches!");
            }

            @Override
            public ItemBuilder getConfigurationDisplayItem(Integer value) {
                return new ItemBuilder(Material.CLOCK);
            }

            @Override
            public void openGlobalModifyMenu(MenuGlobalConfiguration parent) {
                parent.open(new MenuModifyInteger(parent, parent.plugin, parent.player, this.name, Integer.MIN_VALUE, Integer.MAX_VALUE, true, (Integer)this.globalValue, value -> {
                    this.globalValue = value;
                }));
            }

            @Override
            public void openToolModifyMenu(MenuToolConfiguration parent, Tool tool) {
                parent.open(new MenuModifyInteger(parent, parent.plugin, parent.player, this.name, Integer.MIN_VALUE, Integer.MAX_VALUE, true, (Integer)this.toolValues.get(tool), value -> {
                    if (value == null) {
                        this.toolValues.remove(tool);
                    } else {
                        this.toolValues.put(tool, value);
                    }
                }));
            }

            @Override
            public void openTreeModifyMenu(MenuTreeConfiguration parent, Tree tree) {
                parent.open(new MenuModifyInteger(parent, parent.plugin, parent.player, this.name, Integer.MIN_VALUE, Integer.MAX_VALUE, true, (Integer)this.treeValues.get(tree), value -> {
                    if (value == null) {
                        this.treeValues.remove(tree);
                    } else {
                        this.treeValues.put(tree, value);
                    }
                }));
            }
        };
        ALLOWED_TREES = new Option<ArrayList<Tree>>("Allowed Trees", false, true, false, null){

            @Override
            public ArrayList<Tree> load(Object o) {
                if (o instanceof Iterable) {
                    ArrayList<Tree> trees = new ArrayList<Tree>();
                    for (Object ob : (Iterable)o) {
                        Object newTrees = this.load(ob);
                        if (newTrees == null) continue;
                        trees.addAll((Collection<Tree>)newTrees);
                    }
                    return trees;
                }
                if (o instanceof Tree) {
                    ArrayList<Tree> trees = new ArrayList<Tree>();
                    trees.add((Tree)o);
                    return trees;
                }
                if (o instanceof String) {
                    ArrayList<Tree> trees = new ArrayList<Tree>();
                    block1: for (Tree tree : TreeFeller.trees) {
                        for (Material m : tree.trunk) {
                            if (!m.toString().contains(((String)o).toUpperCase().replace(" ", "_"))) continue;
                            trees.add(tree);
                            continue block1;
                        }
                    }
                    return trees;
                }
                if (o instanceof Integer) {
                    ArrayList<Tree> trees = new ArrayList<Tree>();
                    int i = (Integer)o;
                    if (i >= 0 && i < TreeFeller.trees.size()) {
                        trees.add(TreeFeller.trees.get(i));
                        return trees;
                    }
                }
                return null;
            }

            @Override
            public DebugResult doCheck(TreeFeller plugin, Tool tool, Tree tree, Block block, Player player, ItemStack axe) {
                if (this.toolValues.containsKey(tool) && !((ArrayList)this.toolValues.get(tool)).contains(tree)) {
                    return new DebugResult(this, DebugResult.Type.TOOL, TreeFeller.trees.indexOf(tree));
                }
                return new DebugResult(this, DebugResult.Type.SUCCESS, new Object[0]);
            }

            @Override
            public String getDesc(boolean ingame) {
                return "If set, the tool can only fell specific trees. The given value is a list of tree indicies, starting at 0 (the first tree defined is 0, the second is 1, etc.)";
            }

            @Override
            public String[] getDebugText() {
                return 90.generateDebugText("Tree is not allowed$: {0}", "Tree is allowed for tool");
            }

            @Override
            public ItemBuilder getConfigurationDisplayItem(ArrayList<Tree> value) {
                return new ItemBuilder(Material.SPRUCE_SAPLING);
            }

            @Override
            public void openGlobalModifyMenu(MenuGlobalConfiguration parent) {
                parent.open(new MenuModifyTreeSet(parent, parent.plugin, parent.player, this.name, true, (Collection)this.globalValue, value -> {
                    this.globalValue = new ArrayList(value);
                }));
            }

            @Override
            public void openToolModifyMenu(MenuToolConfiguration parent, Tool tool) {
                parent.open(new MenuModifyTreeSet(parent, parent.plugin, parent.player, this.name, true, (Collection)this.toolValues.get(tool), value -> {
                    if (value == null) {
                        this.toolValues.remove(tool);
                    } else {
                        this.toolValues.put(tool, new ArrayList(value));
                    }
                }));
            }

            @Override
            public void openTreeModifyMenu(MenuTreeConfiguration parent, Tree tree) {
                parent.open(new MenuModifyTreeSet(parent, parent.plugin, parent.player, this.name, true, (Collection)this.treeValues.get(tree), value -> {
                    if (value == null) {
                        this.treeValues.remove(tree);
                    } else {
                        this.treeValues.put(tree, new ArrayList(value));
                    }
                }));
            }

            @Override
            public String writeToConfig(ArrayList<Tree> value) {
                ArrayList<Integer> indicies = new ArrayList<Integer>();
                for (Tree t : value) {
                    indicies.add(TreeFeller.trees.indexOf(t));
                }
                return indicies.toString();
            }
        };
        ENABLE_ADVENTURE = new OptionBoolean("Enable Adventure", true, true, true, false){

            @Override
            public DebugResult doCheck(TreeFeller plugin, Tool tool, Tree tree, Block block, Player player, ItemStack axe) {
                if (player == null || player.getGameMode() != GameMode.ADVENTURE) {
                    return null;
                }
                if (this.toolValues.get(tool) == null && this.treeValues.get(tree) == null && Objects.equals(this.globalValue, false)) {
                    return new DebugResult(this, DebugResult.Type.GLOBAL, new Object[0]);
                }
                if (Objects.equals(this.toolValues.get(tool), false)) {
                    return new DebugResult(this, DebugResult.Type.TOOL, new Object[0]);
                }
                if (Objects.equals(this.treeValues.get(tree), false)) {
                    return new DebugResult(this, DebugResult.Type.TREE, new Object[0]);
                }
                return new DebugResult(this, DebugResult.Type.SUCCESS, new Object[0]);
            }

            @Override
            public String getDesc(boolean ingame) {
                return "Should the tree feller work in adventure mode?";
            }

            @Override
            public String[] getDebugText() {
                return 91.generateDebugText("TreeFeller is disabled in adventure mode", "Tool is disabled in adventure mode", "Tree is disabled in adventure mode", "All components OK for adventure mode");
            }

            @Override
            public ItemBuilder getConfigurationDisplayItem(Boolean value) {
                return new ItemBuilder(Material.MAP);
            }
        };
        ENABLE_SURVIVAL = new OptionBoolean("Enable Survival", true, true, true, true){

            @Override
            public DebugResult doCheck(TreeFeller plugin, Tool tool, Tree tree, Block block, Player player, ItemStack axe) {
                if (player == null || player.getGameMode() != GameMode.SURVIVAL) {
                    return null;
                }
                if (this.toolValues.get(tool) == null && this.treeValues.get(tree) == null && Objects.equals(this.globalValue, false)) {
                    return new DebugResult(this, DebugResult.Type.GLOBAL, new Object[0]);
                }
                if (Objects.equals(this.toolValues.get(tool), false)) {
                    return new DebugResult(this, DebugResult.Type.TOOL, new Object[0]);
                }
                if (Objects.equals(this.treeValues.get(tree), false)) {
                    return new DebugResult(this, DebugResult.Type.TREE, new Object[0]);
                }
                return new DebugResult(this, DebugResult.Type.SUCCESS, new Object[0]);
            }

            @Override
            public String getDesc(boolean ingame) {
                return "Should the tree feller work in survival mode?";
            }

            @Override
            public String[] getDebugText() {
                return 92.generateDebugText("TreeFeller is disabled in survival mode", "Tool is disabled in survival mode", "Tree is disabled in survival mode", "All components OK for survival mode");
            }

            @Override
            public ItemBuilder getConfigurationDisplayItem(Boolean value) {
                return new ItemBuilder(Material.IRON_SWORD);
            }
        };
        ENABLE_CREATIVE = new OptionBoolean("Enable Creative", true, true, true, false){

            @Override
            public DebugResult doCheck(TreeFeller plugin, Tool tool, Tree tree, Block block, Player player, ItemStack axe) {
                if (player == null || player.getGameMode() != GameMode.CREATIVE) {
                    return null;
                }
                if (this.toolValues.get(tool) == null && this.treeValues.get(tree) == null && Objects.equals(this.globalValue, false)) {
                    return new DebugResult(this, DebugResult.Type.GLOBAL, new Object[0]);
                }
                if (Objects.equals(this.toolValues.get(tool), false)) {
                    return new DebugResult(this, DebugResult.Type.TOOL, new Object[0]);
                }
                if (Objects.equals(this.treeValues.get(tree), false)) {
                    return new DebugResult(this, DebugResult.Type.TREE, new Object[0]);
                }
                return new DebugResult(this, DebugResult.Type.SUCCESS, new Object[0]);
            }

            @Override
            public String getDesc(boolean ingame) {
                return "Should the tree feller work in creative mode?";
            }

            @Override
            public String[] getDebugText() {
                return 93.generateDebugText("TreeFeller is disabled in creative mode", "Tool is disabled in creative mode", "Tree is disabled in creative mode", "All components OK for creative mode");
            }

            @Override
            public ItemBuilder getConfigurationDisplayItem(Boolean value) {
                return new ItemBuilder(Material.GRASS_BLOCK);
            }
        };
        WITH_SNEAK = new OptionBoolean("With Sneak", true, true, true, false){

            @Override
            public DebugResult doCheck(TreeFeller plugin, Tool tool, Tree tree, Block block, Player player, ItemStack axe) {
                if (player == null || !player.isSneaking()) {
                    return null;
                }
                if (this.toolValues.get(tool) == null && this.treeValues.get(tree) == null && Objects.equals(this.globalValue, false)) {
                    return new DebugResult(this, DebugResult.Type.GLOBAL, new Object[0]);
                }
                if (Objects.equals(this.toolValues.get(tool), false)) {
                    return new DebugResult(this, DebugResult.Type.TOOL, new Object[0]);
                }
                if (Objects.equals(this.treeValues.get(tree), false)) {
                    return new DebugResult(this, DebugResult.Type.TREE, new Object[0]);
                }
                return new DebugResult(this, DebugResult.Type.SUCCESS, new Object[0]);
            }

            @Override
            public String getDesc(boolean ingame) {
                return "Should the tree feller work when sneaking?";
            }

            @Override
            public String[] getDebugText() {
                return 94.generateDebugText("TreeFeller is disabled when sneaking", "Tool is disabled when sneaking", "Tree is disabled when sneaking", "Felling allowed when sneaking");
            }

            @Override
            public ItemBuilder getConfigurationDisplayItem(Boolean value) {
                return new ItemBuilder(Material.LEATHER_BOOTS);
            }
        };
        WITHOUT_SNEAK = new OptionBoolean("Without Sneak", true, true, true, true){

            @Override
            public DebugResult doCheck(TreeFeller plugin, Tool tool, Tree tree, Block block, Player player, ItemStack axe) {
                if (player == null || player.isSneaking()) {
                    return null;
                }
                if (this.toolValues.get(tool) == null && this.treeValues.get(tree) == null && Objects.equals(this.globalValue, false)) {
                    return new DebugResult(this, DebugResult.Type.GLOBAL, new Object[0]);
                }
                if (Objects.equals(this.treeValues.get(tree), false)) {
                    return new DebugResult(this, DebugResult.Type.TREE, new Object[0]);
                }
                if (Objects.equals(this.toolValues.get(tool), false)) {
                    return new DebugResult(this, DebugResult.Type.TOOL, new Object[0]);
                }
                return new DebugResult(this, DebugResult.Type.SUCCESS, new Object[0]);
            }

            @Override
            public String getDesc(boolean ingame) {
                return "Should the tree feller work when not sneaking?";
            }

            @Override
            public String[] getDebugText() {
                return 95.generateDebugText("TreeFeller is disabled when not sneaking", "Tool is disabled when not sneaking", "Tree is disabled when not sneaking", "Felling allowed when not sneaking");
            }

            @Override
            public ItemBuilder getConfigurationDisplayItem(Boolean value) {
                return new ItemBuilder(Material.IRON_BOOTS);
            }
        };
        WORLDS = new Option<HashSet<String>>("Worlds", true, true, true, null){

            @Override
            public DebugResult doCheck(TreeFeller plugin, Tool tool, Tree tree, Block block, Player player, ItemStack axe) {
                boolean foundWorld;
                boolean blacklist;
                HashSet worlds;
                if (this.toolValues.containsKey(tool)) {
                    worlds = (HashSet)this.toolValues.get(tool);
                    blacklist = Objects.equals(WORLD_BLACKLIST.getValue(tool), true);
                    foundWorld = false;
                    for (String world : worlds) {
                        if (!world.equalsIgnoreCase(block.getWorld().getName()) && !world.equalsIgnoreCase(block.getWorld().getUID().toString())) continue;
                        if (blacklist) {
                            return new DebugResult(this, DebugResult.Type.TOOL, block.getWorld().getName() + " (" + block.getWorld().getUID().toString() + ")");
                        }
                        foundWorld = true;
                        break;
                    }
                    if (!blacklist && !foundWorld) {
                        return new DebugResult(this, DebugResult.Type.TOOL, block.getWorld().getName() + " (" + block.getWorld().getUID().toString() + ")");
                    }
                }
                if (this.treeValues.containsKey(tree)) {
                    worlds = (HashSet)this.treeValues.get(tree);
                    blacklist = Objects.equals(WORLD_BLACKLIST.getValue(tree), true);
                    foundWorld = false;
                    for (String world : worlds) {
                        if (!world.equalsIgnoreCase(block.getWorld().getName()) && !world.equalsIgnoreCase(block.getWorld().getUID().toString())) continue;
                        if (blacklist) {
                            return new DebugResult(this, DebugResult.Type.TREE, block.getWorld().getName() + " (" + block.getWorld().getUID().toString() + ")");
                        }
                        foundWorld = true;
                        break;
                    }
                    if (!blacklist && !foundWorld) {
                        return new DebugResult(this, DebugResult.Type.TREE, block.getWorld().getName() + " (" + block.getWorld().getUID().toString() + ")");
                    }
                }
                if (this.toolValues.get(tool) == null && this.treeValues.get(tree) == null && this.globalValue != null) {
                    boolean blacklist2 = Objects.equals(96.WORLD_BLACKLIST.globalValue, true);
                    boolean foundWorld2 = false;
                    for (String world : (HashSet)this.globalValue) {
                        if (!world.equalsIgnoreCase(block.getWorld().getName()) && !world.equalsIgnoreCase(block.getWorld().getUID().toString())) continue;
                        if (blacklist2) {
                            return new DebugResult(this, DebugResult.Type.GLOBAL, block.getWorld().getName() + " (" + block.getWorld().getUID().toString() + ")");
                        }
                        foundWorld2 = true;
                        break;
                    }
                    if (!blacklist2 && !foundWorld2) {
                        return new DebugResult(this, DebugResult.Type.GLOBAL, block.getWorld().getName() + " (" + block.getWorld().getUID().toString() + ")");
                    }
                }
                return new DebugResult(this, DebugResult.Type.SUCCESS, block.getWorld().getName() + " (" + block.getWorld().getUID().toString() + ")");
            }

            @Override
            public HashSet<String> load(Object o) {
                if (o instanceof String) {
                    HashSet<String> worlds = new HashSet<String>();
                    worlds.add((String)o);
                    return worlds;
                }
                if (o instanceof Iterable) {
                    HashSet<String> worlds = new HashSet<String>();
                    for (Object ob : (Iterable)o) {
                        if (!(ob instanceof String)) continue;
                        worlds.add((String)ob);
                    }
                    return worlds;
                }
                return null;
            }

            @Override
            public String getDesc(boolean ingame) {
                return "In what worlds should the tree feller work? (Inverted if world-blacklist is set to true)";
            }

            @Override
            public String[] getDebugText() {
                return 96.generateDebugText("World {0} is invalid$", "World {0} is valid");
            }

            @Override
            public ItemBuilder getConfigurationDisplayItem(HashSet<String> value) {
                return new ItemBuilder(Material.GRASS_BLOCK);
            }

            @Override
            public void openGlobalModifyMenu(MenuGlobalConfiguration parent) {
                parent.open(new MenuModifyStringSet(parent, parent.plugin, parent.player, this.name, true, (HashSet)this.globalValue, value -> {
                    this.globalValue = value;
                }));
            }

            @Override
            public void openToolModifyMenu(MenuToolConfiguration parent, Tool tool) {
                parent.open(new MenuModifyStringSet(parent, parent.plugin, parent.player, this.name, true, (HashSet)this.toolValues.get(tool), value -> {
                    if (value == null) {
                        this.toolValues.remove(tool);
                    } else {
                        this.toolValues.put(tool, value);
                    }
                }));
            }

            @Override
            public void openTreeModifyMenu(MenuTreeConfiguration parent, Tree tree) {
                parent.open(new MenuModifyStringSet(parent, parent.plugin, parent.player, this.name, true, (HashSet)this.treeValues.get(tree), value -> {
                    if (value == null) {
                        this.treeValues.remove(tree);
                    } else {
                        this.treeValues.put(tree, value);
                    }
                }));
            }
        };
        WORLD_BLACKLIST = new OptionBoolean("World Blacklist", true, true, true, false){

            @Override
            public String getDesc(boolean ingame) {
                return null;
            }

            @Override
            public ItemBuilder getConfigurationDisplayItem(Boolean value) {
                return new ItemBuilder(Material.GRASS_BLOCK);
            }
        };
        COOLDOWN = new Option<Integer>("Cooldown", true, true, true, null){

            @Override
            public Integer load(Object o) {
                return 98.loadInt(o);
            }

            @Override
            public DebugResult doCheck(TreeFeller plugin, Tool tool, Tree tree, Block block, Player player, ItemStack axe) {
                if (player == null) {
                    return null;
                }
                Cooldown cooldown = TreeFeller.cooldowns.get(player.getUniqueId());
                if (cooldown != null) {
                    long diff;
                    long now = System.currentTimeMillis();
                    if (this.globalValue != null && (diff = now - cooldown.globalCooldown) / 50L <= (long)((Integer)this.globalValue).intValue()) {
                        return new DebugResult(this, DebugResult.Type.GLOBAL, (long)((Integer)this.globalValue).intValue() - diff, ((long)((Integer)this.globalValue).intValue() - diff) / 50L, ((long)((Integer)this.globalValue).intValue() - diff) / 1000L);
                    }
                    if (this.toolValues.containsKey(tool) && cooldown.toolCooldowns.containsKey(tool) && (diff = now - cooldown.toolCooldowns.get(tool)) / 50L <= (long)((Integer)this.toolValues.get(tool)).intValue()) {
                        return new DebugResult(this, DebugResult.Type.TOOL, (long)((Integer)this.toolValues.get(tool)).intValue() - diff, ((long)((Integer)this.toolValues.get(tool)).intValue() - diff) / 50L, ((long)((Integer)this.toolValues.get(tool)).intValue() - diff) / 1000L);
                    }
                    if (this.treeValues.containsKey(tree) && cooldown.treeCooldowns.containsKey(tree) && (diff = now - cooldown.treeCooldowns.get(tree)) / 50L <= (long)((Integer)this.treeValues.get(tree)).intValue()) {
                        return new DebugResult(this, DebugResult.Type.TREE, (long)((Integer)this.treeValues.get(tree)).intValue() - diff, ((long)((Integer)this.treeValues.get(tree)).intValue() - diff) / 50L, ((long)((Integer)this.treeValues.get(tree)).intValue() - diff) / 1000L);
                    }
                }
                return new DebugResult(this, DebugResult.Type.SUCCESS, new Object[0]);
            }

            @Override
            public String getDesc(boolean ingame) {
                return "How long (in ticks) should players have to wait before felling another tree?";
            }

            @Override
            public String[] getDebugText() {
                return 98.generateDebugText("Cooldown remaining: {0}ms", "Tool cooldown remaining: {0}ms", "Tree cooldown remaining: {0}ms", "Cooldown ready");
            }

            @Override
            public ItemBuilder getConfigurationDisplayItem(Integer value) {
                return new ItemBuilder(Material.CLOCK);
            }

            @Override
            public void openGlobalModifyMenu(MenuGlobalConfiguration parent) {
                parent.open(new MenuModifyInteger(parent, parent.plugin, parent.player, this.name, 0, Integer.MAX_VALUE, true, (Integer)this.globalValue, value -> {
                    this.globalValue = value;
                }));
            }

            @Override
            public void openToolModifyMenu(MenuToolConfiguration parent, Tool tool) {
                parent.open(new MenuModifyInteger(parent, parent.plugin, parent.player, this.name, 0, Integer.MAX_VALUE, true, (Integer)this.toolValues.get(tool), value -> {
                    if (value == null) {
                        this.toolValues.remove(tool);
                    } else {
                        this.toolValues.put(tool, value);
                    }
                }));
            }

            @Override
            public void openTreeModifyMenu(MenuTreeConfiguration parent, Tree tree) {
                parent.open(new MenuModifyInteger(parent, parent.plugin, parent.player, this.name, 0, Integer.MAX_VALUE, true, (Integer)this.treeValues.get(tree), value -> {
                    if (value == null) {
                        this.treeValues.remove(tree);
                    } else {
                        this.treeValues.put(tree, value);
                    }
                }));
            }
        };
        CASCADE = new OptionBoolean("Cascade", true, true, true, false){

            @Override
            public String getDesc(boolean ingame) {
                return "If enabled, connected trees will also be felled resulting in a cascade that could fell an entire forest";
            }

            @Override
            public ItemBuilder getConfigurationDisplayItem(Boolean value) {
                ItemBuilder builder = new ItemBuilder(Material.CHAIN_COMMAND_BLOCK);
                if (Objects.equals(value, true)) {
                    builder.enchant(Enchantment.ARROW_INFINITE);
                }
                return builder;
            }
        };
        PARALLEL_CASCADE_LIMIT = new Option<Integer>("Parallel Cascade Limit", true, false, false, Integer.valueOf(1)){

            @Override
            public Integer load(Object o) {
                return 100.loadInt(o);
            }

            @Override
            public String getDesc(boolean ingame) {
                return "How many cascades can happen in the same tick? (Keep low to prevent runaway performance)";
            }

            @Override
            public ItemBuilder getConfigurationDisplayItem(Integer value) {
                return new ItemBuilder(Material.CHAIN).setCount(value);
            }

            @Override
            public void openGlobalModifyMenu(MenuGlobalConfiguration parent) {
                parent.open(new MenuModifyInteger(parent, parent.plugin, parent.player, this.name, 1, Integer.MAX_VALUE, true, (Integer)this.globalValue, value -> {
                    this.globalValue = value;
                }));
            }

            @Override
            public void openToolModifyMenu(MenuToolConfiguration parent, Tool tool) {
                parent.open(new MenuModifyInteger(parent, parent.plugin, parent.player, this.name, 1, Integer.MAX_VALUE, true, (Integer)this.toolValues.get(tool), value -> {
                    if (value == null) {
                        this.toolValues.remove(tool);
                    } else {
                        this.toolValues.put(tool, value);
                    }
                }));
            }

            @Override
            public void openTreeModifyMenu(MenuTreeConfiguration parent, Tree tree) {
                parent.open(new MenuModifyInteger(parent, parent.plugin, parent.player, this.name, 1, Integer.MAX_VALUE, true, (Integer)this.treeValues.get(tree), value -> {
                    if (value == null) {
                        this.treeValues.remove(tree);
                    } else {
                        this.treeValues.put(tree, value);
                    }
                }));
            }
        };
        CASCADE_CHECK_LIMIT = new Option<Integer>("Cascade Check Limit", true, false, false, Integer.valueOf(64)){

            @Override
            public Integer load(Object o) {
                return 101.loadInt(o);
            }

            @Override
            public String getDesc(boolean ingame) {
                return "How many cascade checks can happen in the same tick? (Much less performance impact, but will help performance when cutting down big trees)";
            }

            @Override
            public ItemBuilder getConfigurationDisplayItem(Integer value) {
                return new ItemBuilder(Material.CHAIN).setCount(value);
            }

            @Override
            public void openGlobalModifyMenu(MenuGlobalConfiguration parent) {
                parent.open(new MenuModifyInteger(parent, parent.plugin, parent.player, this.name, 1, Integer.MAX_VALUE, true, (Integer)this.globalValue, value -> {
                    this.globalValue = value;
                }));
            }

            @Override
            public void openToolModifyMenu(MenuToolConfiguration parent, Tool tool) {
                parent.open(new MenuModifyInteger(parent, parent.plugin, parent.player, this.name, 1, Integer.MAX_VALUE, true, (Integer)this.toolValues.get(tool), value -> {
                    if (value == null) {
                        this.toolValues.remove(tool);
                    } else {
                        this.toolValues.put(tool, value);
                    }
                }));
            }

            @Override
            public void openTreeModifyMenu(MenuTreeConfiguration parent, Tree tree) {
                parent.open(new MenuModifyInteger(parent, parent.plugin, parent.player, this.name, 1, Integer.MAX_VALUE, true, (Integer)this.treeValues.get(tree), value -> {
                    if (value == null) {
                        this.treeValues.remove(tree);
                    } else {
                        this.treeValues.put(tree, value);
                    }
                }));
            }
        };
        CASCADE_TREES = new Option<ArrayList<Tree>>("Cascade Trees", false, false, true, null){

            @Override
            public ArrayList<Tree> load(Object o) {
                if (o instanceof Iterable) {
                    ArrayList<Tree> trees = new ArrayList<Tree>();
                    for (Object ob : (Iterable)o) {
                        Object newTrees = this.load(ob);
                        if (newTrees == null) continue;
                        trees.addAll((Collection<Tree>)newTrees);
                    }
                    return trees;
                }
                if (o instanceof Tree) {
                    ArrayList<Tree> trees = new ArrayList<Tree>();
                    trees.add((Tree)o);
                    return trees;
                }
                if (o instanceof String) {
                    ArrayList<Tree> trees = new ArrayList<Tree>();
                    block1: for (Tree tree : TreeFeller.trees) {
                        for (Material m : tree.trunk) {
                            if (!m.toString().contains(((String)o).toUpperCase().replace(" ", "_"))) continue;
                            trees.add(tree);
                            continue block1;
                        }
                    }
                    return trees;
                }
                if (o instanceof Integer) {
                    ArrayList<Tree> trees = new ArrayList<Tree>();
                    int i = (Integer)o;
                    if (i >= 0 && i < TreeFeller.trees.size()) {
                        trees.add(TreeFeller.trees.get(i));
                        return trees;
                    }
                }
                return null;
            }

            @Override
            public String getDesc(boolean ingame) {
                return "Which trees should be checked during a cascade? (If not set, only the tree which was originally cut will be checked) The given value is a list of tree indicies, starting at 0 (the first tree defined is 0, the second is 1, etc.)";
            }

            @Override
            public ItemBuilder getConfigurationDisplayItem(ArrayList<Tree> value) {
                return new ItemBuilder(Material.JUNGLE_SAPLING);
            }

            @Override
            public void openGlobalModifyMenu(MenuGlobalConfiguration parent) {
                parent.open(new MenuModifyTreeSet(parent, parent.plugin, parent.player, this.name, true, (Collection)this.globalValue, value -> {
                    this.globalValue = new ArrayList(value);
                }));
            }

            @Override
            public void openToolModifyMenu(MenuToolConfiguration parent, Tool tool) {
                parent.open(new MenuModifyTreeSet(parent, parent.plugin, parent.player, this.name, true, (Collection)this.toolValues.get(tool), value -> {
                    if (value == null) {
                        this.toolValues.remove(tool);
                    } else {
                        this.toolValues.put(tool, new ArrayList(value));
                    }
                }));
            }

            @Override
            public void openTreeModifyMenu(MenuTreeConfiguration parent, Tree tree) {
                parent.open(new MenuModifyTreeSet(parent, parent.plugin, parent.player, this.name, true, (Collection)this.treeValues.get(tree), value -> {
                    if (value == null) {
                        this.treeValues.remove(tree);
                    } else {
                        this.treeValues.put(tree, new ArrayList(value));
                    }
                }));
            }

            @Override
            public String writeToConfig(ArrayList<Tree> value) {
                ArrayList<Integer> indicies = new ArrayList<Integer>();
                for (Tree t : value) {
                    indicies.add(TreeFeller.trees.indexOf(t));
                }
                return indicies.toString();
            }
        };
    }
}

