/*
 * Decompiled with CFR 0.152.
 */
package com.thizthizzydizzy.treefeller;

import com.thizthizzydizzy.treefeller.TreeFeller;
import com.thizthizzydizzy.treefeller.compat.TreeFellerCompat;
import java.util.ArrayList;
import org.bukkit.Axis;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Orientable;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class NaturalFall {
    private static final double interval = 0.1;
    private final Player player;
    private final Vector v;
    private final Block origin;
    private final Block block;
    private final int height;
    private final Material material;
    private Axis axis = null;
    private final ArrayList<Material> overridables;
    private boolean fell = false;

    public NaturalFall(Player player, Vector v, Block origin, Block block, int height, boolean rotate, ArrayList<Material> overridables) {
        this.player = player;
        this.v = v.multiply(0.1);
        this.origin = origin;
        this.block = block;
        this.height = height;
        this.material = block.getType();
        if (rotate && block.getBlockData() instanceof Orientable) {
            this.axis = ((Orientable)block.getBlockData()).getAxis();
        }
        this.overridables = overridables;
    }

    public void fall(TreeFeller plugin) {
        Block b;
        if (this.fell) {
            return;
        }
        this.fell = true;
        double dist = 0.0;
        Block target = this.block;
        BlockState was = this.block.getState();
        Location l = this.block.getLocation().add(0.5, 0.5, 0.5);
        while (dist < (double)this.height) {
            dist += 0.1;
            l = l.add(this.v);
            b = l.getBlock();
            this.triggerNaturalFall(plugin, b);
            if (!this.overridables.contains(b.getType())) break;
            target = b;
        }
        while (this.overridables.contains((b = target.getRelative(0, -1, 0)).getType())) {
            this.triggerNaturalFall(plugin, b);
            target = b;
        }
        target.setType(this.material);
        if (this.axis != null) {
            double xDiff = Math.abs(this.origin.getX() - target.getX());
            double yDiff = Math.abs(this.origin.getY() - target.getY());
            double zDiff = Math.abs(this.origin.getZ() - target.getZ());
            Axis newAxis = Axis.Y;
            if (Math.max(Math.max(xDiff, yDiff), zDiff) == xDiff) {
                newAxis = Axis.X;
            }
            if (Math.max(Math.max(xDiff, yDiff), zDiff) == zDiff) {
                newAxis = Axis.Z;
            }
            if (newAxis == Axis.X) {
                switch (this.axis) {
                    case X: {
                        this.axis = Axis.Y;
                        break;
                    }
                    case Y: {
                        this.axis = Axis.X;
                        break;
                    }
                }
            }
            if (newAxis == Axis.Z) {
                switch (this.axis) {
                    case X: {
                        break;
                    }
                    case Y: {
                        this.axis = Axis.Z;
                        break;
                    }
                    case Z: {
                        this.axis = Axis.X;
                    }
                }
            }
            BlockData data = target.getBlockData();
            ((Orientable)data).setAxis(this.axis);
            target.setBlockData(data);
        }
        TreeFellerCompat.addBlock(plugin, this.player, target, was);
    }

    private void triggerNaturalFall(TreeFeller plugin, Block b) {
        for (NaturalFall fall : plugin.naturalFalls) {
            if (fall == this || !fall.block.equals(b)) continue;
            fall.fall(plugin);
        }
    }
}

