/*
 * Decompiled with CFR 0.152.
 */
package com.thizthizzydizzy.treefeller;

import com.thizthizzydizzy.simplegui.ItemBuilder;
import com.thizthizzydizzy.treefeller.Option;
import com.thizthizzydizzy.vanillify.Vanillify;
import java.util.ArrayList;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;

public class Message {
    public static ArrayList<Message> messages = new ArrayList();
    public final String name;
    public String actionbar = null;
    public String chat = null;
    public String debug;
    public final ItemBuilder icon;

    private static void addMessage(Option option) {
        if (option.global) {
            Message.addMessage(option.getGlobalName(), option.getGlobalDebugText(), option.getConfigurationDisplayItem());
        }
        if (option.tool) {
            Message.addMessage(option.getGlobalName() + "-tool", option.getToolDebugText(), option.getConfigurationDisplayItem());
        }
        if (option.tree) {
            Message.addMessage(option.getGlobalName() + "-tree", option.getTreeDebugText(), option.getConfigurationDisplayItem());
        }
        Message.addMessage(option.getGlobalName() + "-success", option.getSuccessDebugText(), option.getConfigurationDisplayItem());
    }

    private static Message addMessage(String name, String debug, ItemBuilder icon) {
        Message message = new Message(name, debug, icon);
        messages.add(message);
        return message;
    }

    public Message(String name, String debug, ItemBuilder icon) {
        this.name = name;
        this.debug = debug;
        this.icon = icon;
    }

    public static Message getMessage(String name) {
        for (Message m : messages) {
            if (!m.name.equals(name)) continue;
            return m;
        }
        return null;
    }

    public void load(FileConfiguration f) {
        this.actionbar = f.getString("actionbar-" + this.name);
        this.chat = f.getString("chat-" + this.name);
        String debg = f.getString("debug-" + this.name);
        if (debg != null) {
            this.debug = debg;
        }
    }

    public String getDebugText() {
        return this.debug;
    }

    public void send(Player player, Object ... vars) {
        int i;
        if (this.actionbar != null) {
            String action = this.actionbar;
            for (i = 0; i < vars.length; ++i) {
                action = action.replace("{" + i + "}", vars[i].toString());
            }
            this.actionbar(player, action);
        }
        if (this.chat != null) {
            String cha = this.chat;
            for (i = 0; i < vars.length; ++i) {
                cha = cha.replace("{" + i + "}", vars[i].toString());
            }
            player.sendMessage(cha);
        }
    }

    public void send(CommandSender sender, Object ... vars) {
        if (this.chat != null) {
            String cha = this.chat;
            for (int i = 0; i < vars.length; ++i) {
                cha = cha.replace("{" + i + "}", vars[i].toString());
            }
            sender.sendMessage(cha);
        }
    }

    private void actionbar(Player player, String text) {
        Vanillify.actionbar(player, text);
    }

    static {
        Message.addMessage("toggle", "Tree feller is currently toggled off", new ItemBuilder(Material.BLACK_CONCRETE));
        Message.addMessage("checking", "Checking tree #{0} with tool #{1}", new ItemBuilder(Material.YELLOW_CONCRETE));
        Message.addMessage("prevent-breakage", "Felling this tree would break the tool", new ItemBuilder(Material.WOODEN_AXE).setDurability(1.0f));
        Message.addMessage("prevent-breakage-success", "Felling this tree won't break the tool", new ItemBuilder(Material.WOODEN_AXE));
        Message.addMessage("durability-low", "Tool durability is too low: {0}<{1}", new ItemBuilder(Material.GOLDEN_AXE).setDurability(10.0f));
        Message.addMessage("partial", "Tool is cutting partial tree", new ItemBuilder(Material.OAK_PLANKS));
        Message.addMessage("partial-tool", "Tool has partial durability", new ItemBuilder(Material.WOODEN_AXE));
        Message.addMessage("protected", "This tree is protected by {0} at {1} {2} {3}", new ItemBuilder(Material.SHIELD));
        Message.addMessage("success", "Success! Felling tree...", new ItemBuilder(Material.GREEN_CONCRETE));
        for (Option o : Option.options) {
            if (!o.hasDebugText()) continue;
            Message.addMessage(o);
        }
        Message.addMessage((String)"reload", null, (ItemBuilder)new ItemBuilder((Material)Material.COMMAND_BLOCK)).chat = "Tree Feller reloaded!";
        Message.addMessage((String)"debug-enable", null, (ItemBuilder)new ItemBuilder((Material)Material.REPEATING_COMMAND_BLOCK)).chat = "Debug mode enabled";
        Message.addMessage((String)"debug-disable", null, (ItemBuilder)new ItemBuilder((Material)Material.REPEATING_COMMAND_BLOCK)).chat = "Debug mode disabled";
        Message.addMessage((String)"toggle-on", null, (ItemBuilder)new ItemBuilder((Material)Material.IRON_AXE)).chat = "Tree Feller enabled";
        Message.addMessage((String)"toggle-off", null, (ItemBuilder)new ItemBuilder((Material)Material.WOODEN_AXE)).chat = "Tree Feller disabled";
        Message.addMessage((String)"unknown-command", null, (ItemBuilder)new ItemBuilder((Material)Material.CHAIN_COMMAND_BLOCK)).chat = ChatColor.RED + "Unknown Command";
        Message.addMessage((String)"no-permission", null, (ItemBuilder)new ItemBuilder((Material)Material.BARRIER)).chat = ChatColor.RED + "Unknown Command";
        Message.addMessage((String)"command-usage", null, (ItemBuilder)new ItemBuilder((Material)Material.WRITABLE_BOOK)).chat = "Usage: {0}";
    }
}

