/*
 * Decompiled with CFR 0.152.
 */
package com.thizthizzydizzy.treefeller;

import com.thizthizzydizzy.treefeller.DetectedTree;
import com.thizthizzydizzy.treefeller.DirectionalFallBehavior;
import com.thizthizzydizzy.treefeller.FallingTreeBlock;
import com.thizthizzydizzy.treefeller.Modifier;
import com.thizthizzydizzy.treefeller.NaturalFall;
import com.thizthizzydizzy.treefeller.Option;
import com.thizthizzydizzy.treefeller.RotationData;
import com.thizthizzydizzy.treefeller.Tool;
import com.thizthizzydizzy.treefeller.Tree;
import com.thizthizzydizzy.treefeller.TreeFeller;
import com.thizthizzydizzy.vanillify.Vanillify;
import java.util.ArrayList;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Orientable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public enum FellBehavior {
    BREAK(Material.COBBLESTONE, "blocks will break and fall as items"){

        @Override
        void breakBlock(DetectedTree detectedTree, TreeFeller plugin, boolean dropItems, Tree tree, Tool tool, ItemStack axe, Block block, Block origin, int lowest, Player player, long seed, ArrayList<Modifier> modifiers, DirectionalFallBehavior directionalFallBehavior, boolean lockCardinal, double directionalFallVelocity, boolean rotate, ArrayList<Material> overridables, double randomFallVelocity, double explosiveFallVelocity, double verticalFallVelocity) {
            if (dropItems) {
                int[] xp = new int[]{0};
                for (ItemStack itemStack : plugin.getDropsWithBonus(block, tool, tree, axe, xp, modifiers)) {
                    plugin.dropItem(detectedTree, player, block.getWorld().dropItemNaturally(block.getLocation(), itemStack));
                }
                plugin.dropExp(block.getWorld(), block.getLocation(), xp[0]);
            }
            block.setType(Material.AIR);
        }

        @Override
        public FellBehavior getDecorationBehavior() {
            return BREAK;
        }
    }
    ,
    INVENTORY(Material.CHEST, "blocks will appear in the player's inventory as items, or fall as items if the player inventory is full"){

        @Override
        void breakBlock(DetectedTree detectedTree, TreeFeller plugin, boolean dropItems, Tree tree, Tool tool, ItemStack axe, Block block, Block origin, int lowest, Player player, long seed, ArrayList<Modifier> modifiers, DirectionalFallBehavior directionalFallBehavior, boolean lockCardinal, double directionalFallVelocity, boolean rotate, ArrayList<Material> overridables, double randomFallVelocity, double explosiveFallVelocity, double verticalFallVelocity) {
            if (player == null) {
                BREAK.breakBlock(detectedTree, plugin, dropItems, tree, tool, axe, block, origin, lowest, player, seed, modifiers, directionalFallBehavior, lockCardinal, directionalFallVelocity, rotate, overridables, randomFallVelocity, explosiveFallVelocity, verticalFallVelocity);
            }
            if (dropItems) {
                int[] xp = new int[]{0};
                for (ItemStack itemStack : plugin.getDropsWithBonus(block, tool, tree, axe, xp, modifiers)) {
                    for (ItemStack st : player.getInventory().addItem(new ItemStack[]{itemStack}).values()) {
                        plugin.dropItem(detectedTree, player, block.getWorld().dropItemNaturally(block.getLocation(), st));
                    }
                }
                player.setTotalExperience(player.getTotalExperience() + xp[0]);
            }
            block.setType(Material.AIR);
        }

        @Override
        public FellBehavior getDecorationBehavior() {
            return INVENTORY;
        }
    }
    ,
    NATURAL(Material.OAK_SAPLING, "blocks will instantly fall in a more natural way (May not work with cutting-animation)"){

        @Override
        void breakBlock(DetectedTree detectedTree, TreeFeller plugin, boolean dropItems, Tree tree, Tool tool, ItemStack axe, Block block, Block origin, int lowest, Player player, long seed, ArrayList<Modifier> modifiers, DirectionalFallBehavior directionalFallBehavior, boolean lockCardinal, double directionalFallVelocity, boolean rotate, ArrayList<Material> overridables, double randomFallVelocity, double explosiveFallVelocity, double verticalFallVelocity) {
            Vector v = directionalFallBehavior.getDirectionalVel(seed, player, block, lockCardinal, directionalFallVelocity).normalize();
            plugin.naturalFalls.add(new NaturalFall(player, v, origin, block, block.getY() - lowest, rotate, overridables));
            block.setType(Material.AIR);
        }

        @Override
        public FellBehavior getDecorationBehavior() {
            return BREAK;
        }
    }
    ,
    FALL(Material.SAND, "blocks will fall as falling blocks"){

        @Override
        void breakBlock(DetectedTree detectedTree, TreeFeller plugin, boolean dropItems, Tree tree, Tool tool, ItemStack axe, Block block, Block origin, int lowest, Player player, long seed, ArrayList<Modifier> modifiers, DirectionalFallBehavior directionalFallBehavior, boolean lockCardinal, double directionalFallVelocity, boolean rotate, ArrayList<Material> overridables, double randomFallVelocity, double explosiveFallVelocity, double verticalFallVelocity) {
            FellBehavior.processDelayedFallBehavior(detectedTree, false, false, false, plugin, dropItems, tree, tool, axe, block, origin, lowest, player, seed, modifiers, directionalFallBehavior, lockCardinal, directionalFallVelocity, rotate, overridables, randomFallVelocity, explosiveFallVelocity, verticalFallVelocity);
        }

        @Override
        public FellBehavior getDecorationBehavior() {
            return BREAK;
        }
    }
    ,
    FALL_HURT(Material.ANVIL, "blocks will fall as falling blocks and hurt any entity they land on"){

        @Override
        void breakBlock(DetectedTree detectedTree, TreeFeller plugin, boolean dropItems, Tree tree, Tool tool, ItemStack axe, Block block, Block origin, int lowest, Player player, long seed, ArrayList<Modifier> modifiers, DirectionalFallBehavior directionalFallBehavior, boolean lockCardinal, double directionalFallVelocity, boolean rotate, ArrayList<Material> overridables, double randomFallVelocity, double explosiveFallVelocity, double verticalFallVelocity) {
            FellBehavior.processDelayedFallBehavior(detectedTree, true, false, false, plugin, dropItems, tree, tool, axe, block, origin, lowest, player, seed, modifiers, directionalFallBehavior, lockCardinal, directionalFallVelocity, rotate, overridables, randomFallVelocity, explosiveFallVelocity, verticalFallVelocity);
        }

        @Override
        public FellBehavior getDecorationBehavior() {
            return BREAK;
        }
    }
    ,
    FALL_BREAK(Material.GRAVEL, "blocks will fall as falling blocks and break when they reach the ground"){

        @Override
        void breakBlock(DetectedTree detectedTree, TreeFeller plugin, boolean dropItems, Tree tree, Tool tool, ItemStack axe, Block block, Block origin, int lowest, Player player, long seed, ArrayList<Modifier> modifiers, DirectionalFallBehavior directionalFallBehavior, boolean lockCardinal, double directionalFallVelocity, boolean rotate, ArrayList<Material> overridables, double randomFallVelocity, double explosiveFallVelocity, double verticalFallVelocity) {
            FellBehavior.processDelayedFallBehavior(detectedTree, false, true, false, plugin, dropItems, tree, tool, axe, block, origin, lowest, player, seed, modifiers, directionalFallBehavior, lockCardinal, directionalFallVelocity, rotate, overridables, randomFallVelocity, explosiveFallVelocity, verticalFallVelocity);
        }

        @Override
        public FellBehavior getDecorationBehavior() {
            return BREAK;
        }
    }
    ,
    FALL_HURT_BREAK(Material.DAMAGED_ANVIL, "blocks will fall as falling blocks, hurt entities they land on, and break when they reach the ground"){

        @Override
        void breakBlock(DetectedTree detectedTree, TreeFeller plugin, boolean dropItems, Tree tree, Tool tool, ItemStack axe, Block block, Block origin, int lowest, Player player, long seed, ArrayList<Modifier> modifiers, DirectionalFallBehavior directionalFallBehavior, boolean lockCardinal, double directionalFallVelocity, boolean rotate, ArrayList<Material> overridables, double randomFallVelocity, double explosiveFallVelocity, double verticalFallVelocity) {
            FellBehavior.processDelayedFallBehavior(detectedTree, true, true, false, plugin, dropItems, tree, tool, axe, block, origin, lowest, player, seed, modifiers, directionalFallBehavior, lockCardinal, directionalFallVelocity, rotate, overridables, randomFallVelocity, explosiveFallVelocity, verticalFallVelocity);
        }

        @Override
        public FellBehavior getDecorationBehavior() {
            return BREAK;
        }
    }
    ,
    FALL_INVENTORY(Material.ENDER_CHEST, "blocks will fall as falling blocks, break, and appear in the player's inventory upon reaching the ground"){

        @Override
        void breakBlock(DetectedTree detectedTree, TreeFeller plugin, boolean dropItems, Tree tree, Tool tool, ItemStack axe, Block block, Block origin, int lowest, Player player, long seed, ArrayList<Modifier> modifiers, DirectionalFallBehavior directionalFallBehavior, boolean lockCardinal, double directionalFallVelocity, boolean rotate, ArrayList<Material> overridables, double randomFallVelocity, double explosiveFallVelocity, double verticalFallVelocity) {
            FellBehavior.processDelayedFallBehavior(detectedTree, false, false, true, plugin, dropItems, tree, tool, axe, block, origin, lowest, player, seed, modifiers, directionalFallBehavior, lockCardinal, directionalFallVelocity, rotate, overridables, randomFallVelocity, explosiveFallVelocity, verticalFallVelocity);
        }

        @Override
        public FellBehavior getDecorationBehavior() {
            return INVENTORY;
        }
    }
    ,
    FALL_HURT_INVENTORY(Material.TRAPPED_CHEST, "blocks will fall as falling blocks, break, hurt entities they land on, and appear in the player's inventory upon reaching the ground"){

        @Override
        void breakBlock(DetectedTree detectedTree, TreeFeller plugin, boolean dropItems, Tree tree, Tool tool, ItemStack axe, Block block, Block origin, int lowest, Player player, long seed, ArrayList<Modifier> modifiers, DirectionalFallBehavior directionalFallBehavior, boolean lockCardinal, double directionalFallVelocity, boolean rotate, ArrayList<Material> overridables, double randomFallVelocity, double explosiveFallVelocity, double verticalFallVelocity) {
            FellBehavior.processDelayedFallBehavior(detectedTree, true, false, true, plugin, dropItems, tree, tool, axe, block, origin, lowest, player, seed, modifiers, directionalFallBehavior, lockCardinal, directionalFallVelocity, rotate, overridables, randomFallVelocity, explosiveFallVelocity, verticalFallVelocity);
        }

        @Override
        public FellBehavior getDecorationBehavior() {
            return INVENTORY;
        }
    }
    ,
    FALL_NATURAL(Material.SAND, "blocks will fall as falling blocks. Blocks will attempt to target a position to land as if the tree fell over realistically"){

        @Override
        void breakBlock(DetectedTree detectedTree, TreeFeller plugin, boolean dropItems, Tree tree, Tool tool, ItemStack axe, Block block, Block origin, int lowest, Player player, long seed, ArrayList<Modifier> modifiers, DirectionalFallBehavior directionalFallBehavior, boolean lockCardinal, double directionalFallVelocity, boolean rotate, ArrayList<Material> overridables, double randomFallVelocity, double explosiveFallVelocity, double verticalFallVelocity) {
            FellBehavior.processDelayedNaturalFallBehavior(detectedTree, false, false, false, plugin, dropItems, tree, tool, axe, block, origin, lowest, player, seed, modifiers, directionalFallBehavior, lockCardinal, rotate, overridables, verticalFallVelocity);
        }

        @Override
        public FellBehavior getDecorationBehavior() {
            return BREAK;
        }
    }
    ,
    FALL_NATURAL_HURT(Material.ANVIL, "blocks will fall as falling blocks and hurt any entity they land on. Blocks will attempt to target a position to land as if the tree fell over realistically"){

        @Override
        void breakBlock(DetectedTree detectedTree, TreeFeller plugin, boolean dropItems, Tree tree, Tool tool, ItemStack axe, Block block, Block origin, int lowest, Player player, long seed, ArrayList<Modifier> modifiers, DirectionalFallBehavior directionalFallBehavior, boolean lockCardinal, double directionalFallVelocity, boolean rotate, ArrayList<Material> overridables, double randomFallVelocity, double explosiveFallVelocity, double verticalFallVelocity) {
            FellBehavior.processDelayedNaturalFallBehavior(detectedTree, true, false, false, plugin, dropItems, tree, tool, axe, block, origin, lowest, player, seed, modifiers, directionalFallBehavior, lockCardinal, rotate, overridables, verticalFallVelocity);
        }

        @Override
        public FellBehavior getDecorationBehavior() {
            return BREAK;
        }
    }
    ,
    FALL_NATURAL_BREAK(Material.GRAVEL, "blocks will fall as falling blocks and break when they reach the ground. Blocks will attempt to target a position to land as if the tree fell over realistically"){

        @Override
        void breakBlock(DetectedTree detectedTree, TreeFeller plugin, boolean dropItems, Tree tree, Tool tool, ItemStack axe, Block block, Block origin, int lowest, Player player, long seed, ArrayList<Modifier> modifiers, DirectionalFallBehavior directionalFallBehavior, boolean lockCardinal, double directionalFallVelocity, boolean rotate, ArrayList<Material> overridables, double randomFallVelocity, double explosiveFallVelocity, double verticalFallVelocity) {
            FellBehavior.processDelayedNaturalFallBehavior(detectedTree, false, true, false, plugin, dropItems, tree, tool, axe, block, origin, lowest, player, seed, modifiers, directionalFallBehavior, lockCardinal, rotate, overridables, verticalFallVelocity);
        }

        @Override
        public FellBehavior getDecorationBehavior() {
            return BREAK;
        }
    }
    ,
    FALL_NATURAL_HURT_BREAK(Material.DAMAGED_ANVIL, "blocks will fall as falling blocks, hurt entities they land on, and break when they reach the ground. Blocks will attempt to target a position to land as if the tree fell over realistically"){

        @Override
        void breakBlock(DetectedTree detectedTree, TreeFeller plugin, boolean dropItems, Tree tree, Tool tool, ItemStack axe, Block block, Block origin, int lowest, Player player, long seed, ArrayList<Modifier> modifiers, DirectionalFallBehavior directionalFallBehavior, boolean lockCardinal, double directionalFallVelocity, boolean rotate, ArrayList<Material> overridables, double randomFallVelocity, double explosiveFallVelocity, double verticalFallVelocity) {
            FellBehavior.processDelayedNaturalFallBehavior(detectedTree, true, true, false, plugin, dropItems, tree, tool, axe, block, origin, lowest, player, seed, modifiers, directionalFallBehavior, lockCardinal, rotate, overridables, verticalFallVelocity);
        }

        @Override
        public FellBehavior getDecorationBehavior() {
            return BREAK;
        }
    }
    ,
    FALL_NATURAL_INVENTORY(Material.ENDER_CHEST, "blocks will fall as falling blocks, break, and appear in the player's inventory upon reaching the ground. Blocks will attempt to target a position to land as if the tree fell over realistically"){

        @Override
        void breakBlock(DetectedTree detectedTree, TreeFeller plugin, boolean dropItems, Tree tree, Tool tool, ItemStack axe, Block block, Block origin, int lowest, Player player, long seed, ArrayList<Modifier> modifiers, DirectionalFallBehavior directionalFallBehavior, boolean lockCardinal, double directionalFallVelocity, boolean rotate, ArrayList<Material> overridables, double randomFallVelocity, double explosiveFallVelocity, double verticalFallVelocity) {
            FellBehavior.processDelayedNaturalFallBehavior(detectedTree, false, false, true, plugin, dropItems, tree, tool, axe, block, origin, lowest, player, seed, modifiers, directionalFallBehavior, lockCardinal, rotate, overridables, verticalFallVelocity);
        }

        @Override
        public FellBehavior getDecorationBehavior() {
            return INVENTORY;
        }
    }
    ,
    FALL_NATURAL_HURT_INVENTORY(Material.TRAPPED_CHEST, "blocks will fall as falling blocks, break, hurt entities they land on, and appear in the player's inventory upon reaching the ground. Blocks will attempt to target a position to land as if the tree fell over realistically"){

        @Override
        void breakBlock(DetectedTree detectedTree, TreeFeller plugin, boolean dropItems, Tree tree, Tool tool, ItemStack axe, Block block, Block origin, int lowest, Player player, long seed, ArrayList<Modifier> modifiers, DirectionalFallBehavior directionalFallBehavior, boolean lockCardinal, double directionalFallVelocity, boolean rotate, ArrayList<Material> overridables, double randomFallVelocity, double explosiveFallVelocity, double verticalFallVelocity) {
            FellBehavior.processDelayedNaturalFallBehavior(detectedTree, true, false, true, plugin, dropItems, tree, tool, axe, block, origin, lowest, player, seed, modifiers, directionalFallBehavior, lockCardinal, rotate, overridables, verticalFallVelocity);
        }

        @Override
        public FellBehavior getDecorationBehavior() {
            return INVENTORY;
        }
    };

    private final Material item;
    private final String description;
    private static final double GRAVITY = 0.04;
    private static final double DRAG = 0.02;
    private static final Vector UP;

    private FellBehavior(Material item, String description) {
        this.item = item;
        this.description = description;
    }

    public static FellBehavior match(String s) {
        return FellBehavior.valueOf(s.toUpperCase().trim().replace("-", "_"));
    }

    public Material getItem() {
        return this.item;
    }

    abstract void breakBlock(DetectedTree var1, TreeFeller var2, boolean var3, Tree var4, Tool var5, ItemStack var6, Block var7, Block var8, int var9, Player var10, long var11, ArrayList<Modifier> var13, DirectionalFallBehavior var14, boolean var15, double var16, boolean var18, ArrayList<Material> var19, double var20, double var22, double var24);

    public abstract FellBehavior getDecorationBehavior();

    private static void processDelayedFallBehavior(final DetectedTree detectedTree, final boolean hurt, final boolean doBreak, final boolean inventory, final TreeFeller plugin, final boolean dropItems, final Tree tree, final Tool tool, final ItemStack axe, final Block block, final Block origin, final int lowest, final Player player, final long seed, final ArrayList<Modifier> modifiers, final DirectionalFallBehavior directionalFallBehavior, final boolean lockCardinal, final double directionalFallVelocity, final boolean rotate, final ArrayList<Material> overridables, final double randomFallVelocity, final double explosiveFallVelocity, final double verticalFallVelocity) {
        final BlockData data = block.getBlockData();
        block.setType(Material.AIR);
        int delay = Option.FALL_DELAY.get(tool, tree);
        if (delay > 0) {
            new BukkitRunnable(){

                public void run() {
                    FellBehavior.processFallBehavior(data, detectedTree, hurt, doBreak, inventory, plugin, dropItems, tree, tool, axe, block, origin, lowest, player, seed, modifiers, directionalFallBehavior, lockCardinal, directionalFallVelocity, rotate, overridables, randomFallVelocity, explosiveFallVelocity, verticalFallVelocity);
                }
            }.runTaskLater((Plugin)plugin, (long)delay);
        } else {
            FellBehavior.processFallBehavior(data, detectedTree, hurt, doBreak, inventory, plugin, dropItems, tree, tool, axe, block, origin, lowest, player, seed, modifiers, directionalFallBehavior, lockCardinal, directionalFallVelocity, rotate, overridables, randomFallVelocity, explosiveFallVelocity, verticalFallVelocity);
        }
    }

    private static void processFallBehavior(BlockData data, DetectedTree detectedTree, boolean hurt, boolean doBreak, boolean inventory, TreeFeller plugin, boolean dropItems, Tree tree, Tool tool, ItemStack axe, Block block, Block origin, int lowest, Player player, long seed, ArrayList<Modifier> modifiers, DirectionalFallBehavior directionalFallBehavior, boolean lockCardinal, double directionalFallVelocity, boolean rotate, ArrayList<Material> overridables, double randomFallVelocity, double explosiveFallVelocity, double verticalFallVelocity) {
        FallingBlock falling = block.getWorld().spawnFallingBlock(block.getLocation().add(0.5, 0.5, 0.5), data);
        falling.addScoreboardTag("tree_feller");
        Vector v = falling.getVelocity();
        if (directionalFallVelocity > 0.0) {
            v.add(directionalFallBehavior.getDirectionalVel(seed, player, origin, lockCardinal, directionalFallVelocity).setY(0));
        }
        v.add(new Vector((Math.random() * 2.0 - 1.0) * randomFallVelocity, verticalFallVelocity, (Math.random() * 2.0 - 1.0) * randomFallVelocity));
        if (block.getX() != origin.getX() || block.getZ() != origin.getZ()) {
            Vector explosive = new Vector(block.getLocation().getX() - origin.getLocation().getX(), 0.0, block.getLocation().getZ() - origin.getLocation().getZ());
            if (lockCardinal) {
                explosive = Math.abs(explosive.getX()) > Math.abs(explosive.getZ()) ? (explosive.getX() > 0.0 ? new Vector(1, 0, 0) : new Vector(-1, 0, 0)) : (explosive.getZ() > 0.0 ? new Vector(0, 0, 1) : new Vector(0, 0, -1));
            }
            explosive = explosive.normalize();
            explosive = explosive.multiply(explosiveFallVelocity);
            v.add(explosive);
        }
        falling.setVelocity(v);
        falling.setHurtEntities(hurt);
        Vanillify.modifyEntityNBT((Entity)falling, "FallHurtAmount", Option.FALL_HURT_AMOUNT.get(tool, tree));
        Vanillify.modifyEntityNBT((Entity)falling, "FallHurtMax", Option.FALL_HURT_MAX.get(tool, tree));
        Player inv = null;
        if (inventory) {
            if (player == null) {
                doBreak = true;
            } else {
                inv = player;
            }
        }
        RotationData rot = null;
        if (falling.getBlockData() instanceof Orientable && rotate) {
            rot = new RotationData((Orientable)falling.getBlockData(), origin);
        }
        plugin.fallingBlocks.add(new FallingTreeBlock(detectedTree, falling, tool, tree, axe, doBreak, inv, rot, dropItems, modifiers));
    }

    private static void processDelayedNaturalFallBehavior(final DetectedTree detectedTree, final boolean hurt, final boolean doBreak, final boolean inventory, final TreeFeller plugin, final boolean dropItems, final Tree tree, final Tool tool, final ItemStack axe, final Block block, final Block origin, final int lowest, final Player player, final long seed, final ArrayList<Modifier> modifiers, final DirectionalFallBehavior directionalFallBehavior, final boolean lockCardinal, final boolean rotate, final ArrayList<Material> overridables, final double verticalFallVelocity) {
        final BlockData data = block.getBlockData();
        block.setType(Material.AIR);
        int delay = Option.FALL_DELAY.get(tool, tree);
        if (delay > 0) {
            new BukkitRunnable(){

                public void run() {
                    FellBehavior.processNaturalFallBehavior(data, detectedTree, hurt, doBreak, inventory, plugin, dropItems, tree, tool, axe, block, origin, lowest, player, seed, modifiers, directionalFallBehavior, lockCardinal, rotate, overridables, verticalFallVelocity);
                }
            }.runTaskLater((Plugin)plugin, (long)delay);
        } else {
            FellBehavior.processNaturalFallBehavior(data, detectedTree, hurt, doBreak, inventory, plugin, dropItems, tree, tool, axe, block, origin, lowest, player, seed, modifiers, directionalFallBehavior, lockCardinal, rotate, overridables, verticalFallVelocity);
        }
    }

    private static void processNaturalFallBehavior(BlockData data, DetectedTree detectedTree, boolean hurt, boolean doBreak, boolean inventory, TreeFeller plugin, boolean dropItems, Tree tree, Tool tool, ItemStack axe, Block block, Block origin, int lowest, Player player, long seed, ArrayList<Modifier> modifiers, DirectionalFallBehavior directionalFallBehavior, boolean lockCardinal, boolean rotate, ArrayList<Material> overridables, double verticalFallVelocity) {
        FallingBlock falling = block.getWorld().spawnFallingBlock(block.getLocation().add(0.5, 0.5, 0.5), data);
        falling.addScoreboardTag("tree_feller");
        try {
            Vector v = FellBehavior.calculateVelocityForBlock(block, lowest, directionalFallBehavior.getDirectionalVel(seed, player, origin, lockCardinal, 1.0).setY(0).normalize(), verticalFallVelocity).setY(verticalFallVelocity);
            if (!(Double.isFinite(v.getX()) && Double.isFinite(v.getY()) && Double.isFinite(v.getZ()))) {
                v = new Vector(0.0, verticalFallVelocity, 0.0);
            }
            falling.setVelocity(v);
        }
        catch (IllegalArgumentException v) {
            // empty catch block
        }
        falling.setHurtEntities(hurt);
        Vanillify.modifyEntityNBT((Entity)falling, "FallHurtAmount", Option.FALL_HURT_AMOUNT.get(tool, tree));
        Vanillify.modifyEntityNBT((Entity)falling, "FallHurtMax", Option.FALL_HURT_MAX.get(tool, tree));
        Player inv = null;
        if (inventory) {
            if (player == null) {
                doBreak = true;
            } else {
                inv = player;
            }
        }
        RotationData rot = null;
        if (falling.getBlockData() instanceof Orientable && rotate) {
            rot = new RotationData((Orientable)falling.getBlockData(), origin);
        }
        plugin.fallingBlocks.add(new FallingTreeBlock(detectedTree, falling, tool, tree, axe, doBreak, inv, rot, dropItems, modifiers));
    }

    public String getDescription() {
        return this.description;
    }

    private static Vector calculateVelocityForBlock(Block b, int bottomLogY, Vector fallDirection, double yVelocity) {
        Vector start = b.getLocation().toVector();
        Vector bottomLogPos = start.clone().setY(bottomLogY);
        Vector end = FellBehavior.getEndPosition(start, bottomLogPos, fallDirection, yVelocity);
        return FellBehavior.calculateInitialVelocity(start, end.add(start), yVelocity);
    }

    private static Vector getEndPosition(Vector start, Vector bottomLog, Vector fallDirection, double yVelocity) {
        return start.clone().subtract(bottomLog).rotateAroundAxis(fallDirection.crossProduct(UP), -90.0);
    }

    private static int getFallTime(double height, double yVelocity) {
        double currHeight = height;
        double vel = -yVelocity;
        int ticks = 0;
        while (currHeight > 0.0) {
            vel += 0.04;
            currHeight -= (vel *= 0.98);
            ++ticks;
        }
        return ticks;
    }

    private static Vector calculateInitialVelocity(Vector start, Vector end, double yVelocity) {
        int t = FellBehavior.getFallTime(start.getY() - end.getY(), yVelocity);
        return new Vector(FellBehavior.getAxisVelocity(end.getX() - start.getX(), t), 0.0, FellBehavior.getAxisVelocity(end.getZ() - start.getZ(), t));
    }

    private static double getAxisVelocity(double s, int t) {
        return s * 0.02 / (1.0 - Math.pow(0.98, t));
    }

    static {
        UP = new Vector(0, 1, 0);
    }
}

