/*
 * Decompiled with CFR 0.152.
 */
package com.thizthizzydizzy.treefeller;

import com.thizthizzydizzy.treefeller.Option;
import com.thizthizzydizzy.treefeller.Tool;
import com.thizthizzydizzy.treefeller.Tree;
import java.util.ArrayList;
import java.util.HashMap;

public class Cooldown {
    public HashMap<Tree, Long> treeCooldowns = new HashMap();
    public HashMap<Tool, Long> toolCooldowns = new HashMap();
    public long globalCooldown;

    public long getCooldown(Tree tree) {
        if (!this.treeCooldowns.containsKey(tree)) {
            return 0L;
        }
        return this.treeCooldowns.get(tree);
    }

    public long getCooldown(Tool tool) {
        if (!this.toolCooldowns.containsKey(tool)) {
            return 0L;
        }
        return this.toolCooldowns.get(tool);
    }

    public long getGlobal() {
        long diff = System.currentTimeMillis() - this.globalCooldown;
        return Math.max(0L, (long)Option.COOLDOWN.getValue().intValue() - diff);
    }

    public long get(Tree tree) {
        long diff = System.currentTimeMillis() - this.getCooldown(tree);
        return Math.max(0L, (long)Option.COOLDOWN.getValue(tree).intValue() - diff);
    }

    public long get(Tool tool) {
        long diff = System.currentTimeMillis() - this.getCooldown(tool);
        return Math.max(0L, (long)Option.COOLDOWN.getValue(tool).intValue() - diff);
    }

    public ArrayList<Long> getCooldowns() {
        ArrayList<Long> cooldowns = new ArrayList<Long>();
        cooldowns.add(this.getGlobal());
        for (Tree tree : this.treeCooldowns.keySet()) {
            cooldowns.add(this.get(tree));
        }
        for (Tool tool : this.toolCooldowns.keySet()) {
            cooldowns.add(this.get(tool));
        }
        return cooldowns;
    }
}

