/*
 * Decompiled with CFR 0.152.
 */
package com.thizthizzydizzy.treefeller;

import com.thizthizzydizzy.treefeller.Effect;
import com.thizthizzydizzy.treefeller.Message;
import com.thizthizzydizzy.treefeller.Option;
import com.thizthizzydizzy.treefeller.Tool;
import com.thizthizzydizzy.treefeller.Tree;
import com.thizthizzydizzy.treefeller.TreeFeller;
import com.thizthizzydizzy.treefeller.compat.TreeFellerCompat;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import java.util.Objects;

public class ConfigGenerator {
    private static final ArrayList<String> toWrite = new ArrayList();

    public static void generateConfiguration(TreeFeller plugin) {
        String version = plugin.getDescription().getVersion();
        ConfigGenerator.add("# Tree Feller by ThizThizzyDizzy");
        ConfigGenerator.add("# Version " + version);
        ConfigGenerator.add();
        for (Option o : Option.options) {
            if (!o.global) continue;
            ConfigGenerator.add();
            for (String s : o.getDescription(false)) {
                ConfigGenerator.add("# " + s);
            }
            ConfigGenerator.add(o.getGlobalName() + ": " + o.writeToConfig());
        }
        ConfigGenerator.add();
        ConfigGenerator.add("# What tools can be used to cut down trees?");
        ConfigGenerator.add("# Format:");
        ConfigGenerator.add("#    - {type: AXE_MATERIAL, <variables>}");
        ConfigGenerator.add("# Any of the following variables may be used: (See above for descriptions)");
        int len = 0;
        for (Option option : Option.options) {
            if (!option.tool) continue;
            len = Math.max(len, ("# " + option.getGlobalName()).length());
        }
        for (Option option : Option.options) {
            if (!option.tool) continue;
            if (option.global) {
                ConfigGenerator.add("# " + option.getGlobalName());
                continue;
            }
            ConfigGenerator.add(ConfigGenerator.normalize("# " + option.getGlobalName(), len) + " " + option.getDesc(false));
        }
        ConfigGenerator.add("# AIR can be used instead of an item name if you want every item, including an empty hand, to fell a tree");
        ConfigGenerator.add("# Examples of valid tools:");
        ConfigGenerator.add("#    - {type: WOODEN_AXE, required-enchantments: {efficiency: 4, unbreaking: 1}, banned-enchantments: {unbreaking: 2}, min-durability: 4, max-durability-percent: 0.9}");
        ConfigGenerator.add("#    - {type: DIAMOND_AXE, required-enchantments: {efficiency: 4}, banned-enchantments: {unbreaking: 2}, required-lore: [A line of lore, Another line of lore]}");
        ConfigGenerator.add("#    - {type: GOLDEN_AXE, required-permissions: [treefeller.example,treefeller.anotherexample]}");
        ConfigGenerator.add("#    - STONE_AXE");
        ConfigGenerator.add("#    - {type: IRON_AXE, allowed-trees: [0,1,3]} <-this tool can only cut down the first, second, and fourth trees defined.");
        ConfigGenerator.add("#    - {type: AIR, damage-mult: 0}");
        ConfigGenerator.add("tools:");
        for (Tool tool : TreeFeller.tools) {
            ConfigGenerator.add("    - " + tool.writeToConfig());
        }
        ConfigGenerator.add();
        ConfigGenerator.add("# What materials count as trees?");
        ConfigGenerator.add("# Format:");
        ConfigGenerator.add("#    - [[TRUNK_MATERIALS], [LEAF_MATERIALS], {<options>}]");
        ConfigGenerator.add("# Any of the following variables may be used: (See above for descriptions)");
        len = 0;
        for (Option option : Option.options) {
            if (!option.tree) continue;
            len = Math.max(len, ("# " + option.getGlobalName()).length());
        }
        for (Option option : Option.options) {
            if (!option.tree) continue;
            if (option.global) {
                ConfigGenerator.add("# " + option.getGlobalName());
                continue;
            }
            ConfigGenerator.add(ConfigGenerator.normalize("# " + option.getGlobalName(), len) + " " + option.getDesc(false));
        }
        ConfigGenerator.add("# Examples of valid trees:");
        ConfigGenerator.add("#    - [[OAK_LOG, OAK_WOOD], OAK_LEAVES]");
        ConfigGenerator.add("#    - [BIRCH_LOG, BIRCH_LEAVES]");
        ConfigGenerator.add("#    - [STONE, NETHERRACK, {damage-mult: 50, allow-partial: false, sapling: OAK_SAPLING}]");
        ConfigGenerator.add("#    - SPRUCE_LOG           <-This will attempt to automatically detect the leaf material.");
        ConfigGenerator.add("trees:");
        for (Tree tree : TreeFeller.trees) {
            ConfigGenerator.add("    - " + tree.writeToConfig());
        }
        ConfigGenerator.add();
        ConfigGenerator.add("# Here, you can create custom effects for trees or tools");
        ConfigGenerator.add("# Fields:");
        ConfigGenerator.add("# name: <value>        This is the effect's name. It is used to assign the effect to a tree or tool");
        ConfigGenerator.add("# chance: <value>      This is the chance of the effect happening (0-1, default 1)");
        ConfigGenerator.add("# location: <value>    This is where the effect will occur. valid options:");
        len = 0;
        for (Iterator<Object> iterator : Effect.EffectLocation.values()) {
            len = Math.max(len, ("#   " + ((Enum)((Object)iterator)).name()).length());
        }
        for (Iterator<Object> iterator : Effect.EffectLocation.values()) {
            ConfigGenerator.add(ConfigGenerator.normalize("#   " + ((Enum)((Object)iterator)).name().toLowerCase(Locale.ROOT), len) + " " + ((Effect.EffectLocation)((Object)iterator)).description);
        }
        ConfigGenerator.add("# type: <value>     This is what type of effect should occur. Valid options:");
        ConfigGenerator.add("#   particle  A particle effect, such as flame, block, etc. particles");
        ConfigGenerator.add("#   sound     Any sound");
        ConfigGenerator.add("#   explosion An explosion that Will destroy blocks and items- This will occur after the block is destroyed");
        ConfigGenerator.add("#   marker    A marker for use with datapacks (An armor stand or area effect cloud)");
        ConfigGenerator.add("# Particle settings:");
        ConfigGenerator.add("#   particle: <value> The particle to display");
        ConfigGenerator.add("#   x: <value>        The X offset from the center of the block to display the particle (default 0)");
        ConfigGenerator.add("#   y: <value>        The Y offset from the center of the block to display the particle (default 0)");
        ConfigGenerator.add("#   z: <value>        The Z offset from the center of the block to display the particle (default 0)");
        ConfigGenerator.add("#   dx: <value>       The delta X of the particle field (default 0)");
        ConfigGenerator.add("#   dy: <value>       The delta Y of the particle field (default 0)");
        ConfigGenerator.add("#   dz: <value>       The delta Z of the particle field (default 0)");
        ConfigGenerator.add("#   speed: <value>    The speed of the particles (default 0)");
        ConfigGenerator.add("#   count: <value>    The number of particles to display (default 1)");
        ConfigGenerator.add("#   Extra information is required for some particles");
        ConfigGenerator.add("#   For Dust particles:");
        ConfigGenerator.add("#     r: <value>    The Red color channel for this particle, 0-255");
        ConfigGenerator.add("#     g: <value>    The Green color channel for this particle, 0-255");
        ConfigGenerator.add("#     b: <value>    The Blue color channel for this particle, 0-255");
        ConfigGenerator.add("#     size: <value> The size of the particle");
        ConfigGenerator.add("#   for Item particles:");
        ConfigGenerator.add("#     item: <value> The item to be used for this particle");
        ConfigGenerator.add("#   for Block or Falling Dust particles:");
        ConfigGenerator.add("#     block: <value> The block to be used for this particle");
        ConfigGenerator.add("# Sound settings:");
        ConfigGenerator.add("#   sound: <value>     The sound to play");
        ConfigGenerator.add("#   volume: <value>    The volume at which to play the sound (Default 1)");
        ConfigGenerator.add("#   pitch: <value>     The pitch at which to play the sound (0.5-2, Default 1)");
        ConfigGenerator.add("# Explosion settings:");
        ConfigGenerator.add("#   power: <value>     The explosion power, where creepers are 3, tnt 4, charged creepers 5");
        ConfigGenerator.add("#   fire: (true|false) Weather or not to light fires with the explosion (Default false)");
        ConfigGenerator.add("# Marker settings:");
        ConfigGenerator.add("#   permanent: (true|false) If true, an armor stand will be created. If false, an area effect cloud will be created. (Area effect clouds last exactly 1 tick)");
        ConfigGenerator.add("#   tags: [<values>]   A list of tags to apply to the created entity. (Note that the \"tree_feller\" tag is always applied)");
        ConfigGenerator.add("# Examples of valid effects:");
        ConfigGenerator.add("#   - {name: smoke, chance: 1, location: logs, type: particle, particle: smoke, dx: 0.5, dy: 0.5, dz: 0.5, speed: .01, count: 10}");
        ConfigGenerator.add("#   - {name: explosion, chance: .01, location: tool, type: explosion, power: 4}");
        ConfigGenerator.add("#   - {name: ghost sound, chance: .1, location: tree, type: sound, sound: ambient.cave, volume: 10, pitch: 0.5}");
        ConfigGenerator.add("effects:");
        for (Effect effect : TreeFeller.effects) {
            ConfigGenerator.add("    - " + effect.writeToConfig());
        }
        ConfigGenerator.add();
        ConfigGenerator.add("# Here, you can customize what messages are sent the tree feller is unable to cut down a tree. Most options are customizable; The debug messages are provided for reference");
        ConfigGenerator.add("# Format:  prefix-<option name>-suffix: \"<text>\"");
        ConfigGenerator.add("# Valid prefixes are:");
        ConfigGenerator.add("# debug        This is the message used when debug mode is on");
        ConfigGenerator.add("# actionbar    This will be sent to the player's actionbar");
        ConfigGenerator.add("# chat         This will be sent to the player in the chat");
        ConfigGenerator.add("# Valid suffixes are:");
        ConfigGenerator.add("# <no suffix>  This defines what message is sent when this option's global requirement is not met");
        ConfigGenerator.add("# -tool        This defines what message is sent when a tool requirement is not met");
        ConfigGenerator.add("# -tree        This defines what message is sent when a tree requirement is not met");
        ConfigGenerator.add("# -success     This defines what message is sent when global, tree, and tool requirements for are all met");
        ConfigGenerator.add("# In addition to the options, there are a few additional messages that can be customized:");
        ConfigGenerator.add("# toggle           This is sent when the player cuts down a tree when the tree feller is off");
        ConfigGenerator.add("# checking         This is sent for each tree/tool pair the tree feller checks");
        ConfigGenerator.add("# durability-low   This is sent when the tool's durability is too low to fell the tree");
        ConfigGenerator.add("# partial          This is sent when a tree is being partially cut");
        ConfigGenerator.add("# protected        This is sent when a tree cannot be felled due to a protection plugin (This may be on top of that plugin's protected message)");
        ConfigGenerator.add("# success          This is sent when a tree is successfully felled");
        ConfigGenerator.add("# For example, if you want a player to be sent a message in the chat if the tree is too small:");
        ConfigGenerator.add("# chat-required-logs: The tree's too small!");
        ConfigGenerator.add();
        for (Message message : Message.messages) {
            if (message.debug == null) continue;
            ConfigGenerator.add("debug-" + message.name + ": \"" + message.debug + "\"");
        }
        for (Message message : Message.messages) {
            if (message.chat == null) continue;
            ConfigGenerator.add("chat-" + message.name + ": \"" + message.chat + "\"");
        }
        for (Message message : Message.messages) {
            if (message.actionbar == null) continue;
            ConfigGenerator.add("actionbar-" + message.name + ": \"" + message.actionbar + "\"");
        }
        ConfigGenerator.write(new File(plugin.getDataFolder(), "config.yml"));
    }

    public static void main(String[] args) {
        if (args.length == 1 && args[0].equals("genConfig")) {
            TreeFellerCompat.init(null);
            String version = ConfigGenerator.read(new File("src/plugin.yml"));
            int i = version.indexOf("version:");
            if (i == -1) {
                throw new IllegalArgumentException("Version is not specified in plugin.yml");
            }
            if ((i = (version = version.substring(i)).indexOf("\n")) == -1) {
                throw new IllegalArgumentException("Version is EOF");
            }
            version = version.substring(8, i).trim();
            ConfigGenerator.add("# Tree Feller by ThizThizzyDizzy");
            ConfigGenerator.add("# Version " + version);
            ConfigGenerator.add();
            for (Option o : Option.options) {
                if (!o.global) continue;
                ConfigGenerator.add();
                for (String s : o.getDescription(false)) {
                    ConfigGenerator.add("# " + s);
                }
                if (o.getDefaultConfigValue() == null) {
                    ConfigGenerator.add(o.getGlobalName() + ":");
                    continue;
                }
                ConfigGenerator.add(o.getGlobalName() + ": " + o.getDefaultConfigValue());
            }
            ConfigGenerator.add();
            ConfigGenerator.add("# What tools can be used to cut down trees?");
            ConfigGenerator.add("# Format:");
            ConfigGenerator.add("#    - {type: AXE_MATERIAL, <variables>}");
            ConfigGenerator.add("# Any of the following variables may be used: (See above for descriptions)");
            int len = 0;
            for (Option o : Option.options) {
                if (!o.tool) continue;
                len = Math.max(len, ("# " + o.getGlobalName()).length());
            }
            for (Option o : Option.options) {
                if (!o.tool) continue;
                if (o.global) {
                    ConfigGenerator.add("# " + o.getGlobalName());
                    continue;
                }
                ConfigGenerator.add(ConfigGenerator.normalize("# " + o.getGlobalName(), len) + " " + o.getDesc(false));
            }
            ConfigGenerator.add("# AIR can be used instead of an item name if you want every item, including an empty hand, to fell a tree");
            ConfigGenerator.add("# Examples of valid tools:");
            ConfigGenerator.add("#    - {type: WOODEN_AXE, required-enchantments: {efficiency: 4, unbreaking: 1}, banned-enchantments: {unbreaking: 2}, min-durability: 4, max-durability-percent: 0.9}");
            ConfigGenerator.add("#    - {type: DIAMOND_AXE, required-enchantments: {efficiency: 4}, banned-enchantments: {unbreaking: 2}, required-lore: [A line of lore, Another line of lore]}");
            ConfigGenerator.add("#    - {type: GOLDEN_AXE, required-permissions: [treefeller.example,treefeller.anotherexample]}");
            ConfigGenerator.add("#    - STONE_AXE");
            ConfigGenerator.add("#    - {type: IRON_AXE, allowed-trees: [0,1,3]} <-this tool can only cut down the first, second, and fourth trees defined.");
            ConfigGenerator.add("#    - {type: AIR, damage-mult: 0}");
            ConfigGenerator.add("tools:");
            ConfigGenerator.add("    - WOODEN_AXE");
            ConfigGenerator.add("    - STONE_AXE");
            ConfigGenerator.add("    - IRON_AXE");
            ConfigGenerator.add("    - GOLDEN_AXE");
            ConfigGenerator.add("    - DIAMOND_AXE");
            ConfigGenerator.add("    - NETHERITE_AXE");
            ConfigGenerator.add();
            ConfigGenerator.add("# What materials count as trees?");
            ConfigGenerator.add("# Format:");
            ConfigGenerator.add("#    - [[TRUNK_MATERIALS], [LEAF_MATERIALS], {<options>}]");
            ConfigGenerator.add("# Any of the following variables may be used: (See above for descriptions)");
            len = 0;
            for (Option o : Option.options) {
                if (!o.tree) continue;
                len = Math.max(len, ("# " + o.getGlobalName()).length());
            }
            for (Option o : Option.options) {
                if (!o.tree) continue;
                if (o.global) {
                    ConfigGenerator.add("# " + o.getGlobalName());
                    continue;
                }
                ConfigGenerator.add(ConfigGenerator.normalize("# " + o.getGlobalName(), len) + " " + o.getDesc(false));
            }
            ConfigGenerator.add("# Examples of valid trees:");
            ConfigGenerator.add("#    - [[OAK_LOG, OAK_WOOD], OAK_LEAVES]");
            ConfigGenerator.add("#    - [BIRCH_LOG, BIRCH_LEAVES]");
            ConfigGenerator.add("#    - [STONE, NETHERRACK, {damage-mult: 50, allow-partial: false, sapling: OAK_SAPLING}]");
            ConfigGenerator.add("#    - SPRUCE_LOG           <-This will attempt to automatically detect the leaf material.");
            ConfigGenerator.add("trees:");
            ConfigGenerator.add("    - [[OAK_LOG, OAK_WOOD], OAK_LEAVES, {sapling: OAK_SAPLING, max-saplings: 1}]");
            ConfigGenerator.add("    - [[BIRCH_LOG, BIRCH_WOOD], BIRCH_LEAVES, {sapling: BIRCH_SAPLING, max-saplings: 1}]");
            ConfigGenerator.add("    - [[SPRUCE_LOG, SPRUCE_WOOD], SPRUCE_LEAVES, {sapling: SPRUCE_SAPLING, max-saplings: 4}]");
            ConfigGenerator.add("    - [[JUNGLE_LOG, JUNGLE_WOOD], JUNGLE_LEAVES, {sapling: JUNGLE_SAPLING, max-saplings: 4}]");
            ConfigGenerator.add("    - [[DARK_OAK_LOG, DARK_OAK_WOOD], DARK_OAK_LEAVES, {sapling: DARK_OAK_SAPLING, max-saplings: 4}]");
            ConfigGenerator.add("    - [[ACACIA_LOG, ACACIA_WOOD], ACACIA_LEAVES, {sapling: ACACIA_SAPLING, max-saplings: 1}]");
            ConfigGenerator.add("    - [[OAK_LOG, OAK_WOOD], [AZALEA_LEAVES, FLOWERING_AZALEA_LEAVES], {sapling: [AZALEA, FLOWERING_AZALEA], max-saplings: 1, diagonal-leaves: true}]");
            ConfigGenerator.add("    - [[MANGROVE_LOG, MANGROVE_WOOD], [MANGROVE_ROOTS, MANGROVE_LEAVES], {roots: [MANGROVE_ROOTS], sapling: [MANGROVE_PROPAGULE], max-saplings: 1, max-trunks: 16, max-horizontal-trunk-pillar-length: 16, leaf-detect-range: 16, leaf-break-range: 16, required-logs: 3, root-distance: 16, diagonal-leaves: true}]");
            ConfigGenerator.add("    - [[CHERRY_LOG, CHERRY_WOOD], CHERRY_LEAVES, {sapling: CHERRY_SAPLING, max-saplings: 1}]");
            ConfigGenerator.add("    - [[CRIMSON_STEM, CRIMSON_HYPHAE], [NETHER_WART_BLOCK, SHROOMLIGHT], {sapling: CRIMSON_FUNGUS, max-saplings: 1, grass: [CRIMSON_NYLIUM], diagonal-leaves: true, leaf-detect-range: 8, leaf-break-range: 8}]");
            ConfigGenerator.add("    - [[WARPED_STEM, WARPED_HYPHAE], [WARPED_WART_BLOCK, SHROOMLIGHT], {sapling: WARPED_FUNGUS, max-saplings: 1, grass: [WARPED_NYLIUM], diagonal-leaves: true, leaf-detect-range: 8, leaf-break-range: 8}]");
            ConfigGenerator.add();
            ConfigGenerator.add("# Here, you can create custom effects for trees or tools");
            ConfigGenerator.add("# Fields:");
            ConfigGenerator.add("# name: <value>        This is the effect's name. It is used to assign the effect to a tree or tool");
            ConfigGenerator.add("# chance: <value>      This is the chance of the effect happening (0-1, default 1)");
            ConfigGenerator.add("# location: <value>    This is where the effect will occur. valid options:");
            len = 0;
            for (Effect.EffectLocation loc : Effect.EffectLocation.values()) {
                len = Math.max(len, ("#   " + loc.name()).length());
            }
            for (Effect.EffectLocation loc : Effect.EffectLocation.values()) {
                ConfigGenerator.add(ConfigGenerator.normalize("#   " + loc.name().toLowerCase(Locale.ROOT), len) + " " + loc.description);
            }
            ConfigGenerator.add("# type: <value>     This is what type of effect should occur. Valid options:");
            ConfigGenerator.add("#   particle  A particle effect, such as flame, block, etc. particles");
            ConfigGenerator.add("#   sound     Any sound");
            ConfigGenerator.add("#   explosion An explosion that Will destroy blocks and items- This will occur after the block is destroyed");
            ConfigGenerator.add("#   marker    A marker for use with datapacks (An armor stand or area effect cloud)");
            ConfigGenerator.add("# Particle settings:");
            ConfigGenerator.add("#   particle: <value> The particle to display");
            ConfigGenerator.add("#   x: <value>        The X offset from the center of the block to display the particle (default 0)");
            ConfigGenerator.add("#   y: <value>        The Y offset from the center of the block to display the particle (default 0)");
            ConfigGenerator.add("#   z: <value>        The Z offset from the center of the block to display the particle (default 0)");
            ConfigGenerator.add("#   dx: <value>       The delta X of the particle field (default 0)");
            ConfigGenerator.add("#   dy: <value>       The delta Y of the particle field (default 0)");
            ConfigGenerator.add("#   dz: <value>       The delta Z of the particle field (default 0)");
            ConfigGenerator.add("#   speed: <value>    The speed of the particles (default 0)");
            ConfigGenerator.add("#   count: <value>    The number of particles to display (default 1)");
            ConfigGenerator.add("#   Extra information is required for some particles");
            ConfigGenerator.add("#   For Dust particles:");
            ConfigGenerator.add("#     r: <value>    The Red color channel for this particle, 0-255");
            ConfigGenerator.add("#     g: <value>    The Green color channel for this particle, 0-255");
            ConfigGenerator.add("#     b: <value>    The Blue color channel for this particle, 0-255");
            ConfigGenerator.add("#     size: <value> The size of the particle");
            ConfigGenerator.add("#   for Item particles:");
            ConfigGenerator.add("#     item: <value> The item to be used for this particle");
            ConfigGenerator.add("#   for Block or Falling Dust particles:");
            ConfigGenerator.add("#     block: <value> The block to be used for this particle");
            ConfigGenerator.add("# Sound settings:");
            ConfigGenerator.add("#   sound: <value>     The sound to play");
            ConfigGenerator.add("#   volume: <value>    The volume at which to play the sound (Default 1)");
            ConfigGenerator.add("#   pitch: <value>     The pitch at which to play the sound (0.5-2, Default 1)");
            ConfigGenerator.add("# Explosion settings:");
            ConfigGenerator.add("#   power: <value>     The explosion power, where creepers are 3, tnt 4, charged creepers 5");
            ConfigGenerator.add("#   fire: (true|false) Weather or not to light fires with the explosion (Default false)");
            ConfigGenerator.add("# Marker settings:");
            ConfigGenerator.add("#   permanent: (true|false) If true, an armor stand will be created. If false, an area effect cloud will be created. (Area effect clouds last exactly 1 tick)");
            ConfigGenerator.add("#   tags: [<values>]   A list of tags to apply to the created entity. (Note that the \"tree_feller\" tag is always applied)");
            ConfigGenerator.add("# Examples of valid effects:");
            ConfigGenerator.add("#   - {name: smoke, chance: 1, location: logs, type: particle, particle: smoke, dx: 0.5, dy: 0.5, dz: 0.5, speed: .01, count: 10}");
            ConfigGenerator.add("#   - {name: explosion, chance: .01, location: tool, type: explosion, power: 4}");
            ConfigGenerator.add("#   - {name: ghost sound, chance: .1, location: tree, type: sound, sound: ambient.cave, volume: 10, pitch: 0.5}");
            ConfigGenerator.add("effects:");
            ConfigGenerator.add();
            ConfigGenerator.add("# Here, you can customize what messages are sent the tree feller is unable to cut down a tree. Most options are customizable; The debug messages are provided for reference");
            ConfigGenerator.add("# Format:  prefix-<option name>-suffix: \"<text>\"");
            ConfigGenerator.add("# Valid prefixes are:");
            ConfigGenerator.add("# debug        This is the message used when debug mode is on");
            ConfigGenerator.add("# actionbar    This will be sent to the player's actionbar");
            ConfigGenerator.add("# chat         This will be sent to the player in the chat");
            ConfigGenerator.add("# Valid suffixes are:");
            ConfigGenerator.add("# <no suffix>  This defines what message is sent when this option's global requirement is not met");
            ConfigGenerator.add("# -tool        This defines what message is sent when a tool requirement is not met");
            ConfigGenerator.add("# -tree        This defines what message is sent when a tree requirement is not met");
            ConfigGenerator.add("# -success     This defines what message is sent when global, tree, and tool requirements for are all met");
            ConfigGenerator.add("# In addition to the options, there are a few additional messages that can be customized:");
            ConfigGenerator.add("# toggle           This is sent when the player cuts down a tree when the tree feller is off");
            ConfigGenerator.add("# checking         This is sent for each tree/tool pair the tree feller checks");
            ConfigGenerator.add("# durability-low   This is sent when the tool's durability is too low to fell the tree");
            ConfigGenerator.add("# partial          This is sent when a tree is being partially cut");
            ConfigGenerator.add("# protected        This is sent when a tree cannot be felled due to a protection plugin (This may be on top of that plugin's protected message)");
            ConfigGenerator.add("# success          This is sent when a tree is successfully felled");
            ConfigGenerator.add("# For example, if you want a player to be sent a message in the chat if the tree is too small:");
            ConfigGenerator.add("# chat-required-logs: The tree's too small!");
            ConfigGenerator.add();
            for (Message m : Message.messages) {
                if (m.debug == null) continue;
                ConfigGenerator.add("debug-" + m.name + ": \"" + m.debug + "\"");
            }
            for (Message m : Message.messages) {
                if (m.chat == null) continue;
                ConfigGenerator.add("chat-" + m.name + ": \"" + m.chat + "\"");
            }
            for (Message m : Message.messages) {
                if (m.actionbar == null) continue;
                ConfigGenerator.add("actionbar-" + m.name + ": \"" + m.actionbar + "\"");
            }
            ConfigGenerator.write(new File("src/config.yml"));
            return;
        }
        System.out.println("To install the Tree Feller, put this file in the plugins folder on your server");
    }

    private static String read(File file) {
        String text = "";
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));){
            String line;
            while ((line = reader.readLine()) != null) {
                text = text + "\n" + line;
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        if (!text.isEmpty()) {
            text = text.substring(1);
        }
        return text;
    }

    private static void write(File file) {
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file)));){
            for (String s : toWrite) {
                writer.write(s + "\n");
            }
        }
        catch (IOException ex) {
            toWrite.clear();
            throw new RuntimeException(ex);
        }
        toWrite.clear();
    }

    private static void add(String s) {
        toWrite.add(s);
    }

    private static void add() {
        ConfigGenerator.add("");
    }

    private static int findMaxWidth(Object[] objs) {
        int len = 0;
        for (Object o : objs) {
            len = Math.max(len, Objects.toString(o).length());
        }
        return len;
    }

    private static String normalize(String name, int width) {
        while (name.length() < width) {
            name = name + " ";
        }
        return name;
    }
}

