/*
 * Decompiled with CFR 0.152.
 */
package com.thizthizzydizzy.treefeller;

import com.thizthizzydizzy.treefeller.Message;
import com.thizthizzydizzy.treefeller.TreeFeller;
import com.thizthizzydizzy.treefeller.TreeFellerCommand;
import com.thizthizzydizzy.treefeller.menu.MenuConfiguration;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.entity.Player;

public class CommandTreeFeller
implements TabExecutor {
    private final TreeFeller plugin;
    private final ArrayList<TreeFellerCommand> commands = new ArrayList();

    public CommandTreeFeller(TreeFeller plugin) {
        this.commands.add(new TreeFellerCommand("help", new TreeFellerCommand[0]){

            @Override
            protected boolean run(CommandSender sender, Command command, String label, String[] args) {
                for (TreeFellerCommand cmd : CommandTreeFeller.this.commands) {
                    String s;
                    if (!cmd.hasPermission(sender) || (s = cmd.getFullUsage()) == null) continue;
                    sender.sendMessage("/treefeller " + s);
                }
                return true;
            }
        });
        TreeFellerCommand toggleOn = new TreeFellerCommand("on", "toggle", new TreeFellerCommand[0]){

            @Override
            protected boolean run(CommandSender sender, Command command, String label, String[] args) {
                CommandTreeFeller.this.plugin.toggle((Player)sender, true);
                return true;
            }
        };
        TreeFellerCommand toggleOff = new TreeFellerCommand("off", "toggle", new TreeFellerCommand[0]){

            @Override
            protected boolean run(CommandSender sender, Command command, String label, String[] args) {
                CommandTreeFeller.this.plugin.toggle((Player)sender, false);
                return true;
            }
        };
        this.commands.add(new TreeFellerCommand("toggle", new TreeFellerCommand[]{toggleOn, toggleOff}){

            @Override
            protected boolean run(CommandSender sender, Command command, String label, String[] args) {
                CommandTreeFeller.this.plugin.toggle((Player)sender);
                return true;
            }
        });
        this.commands.add(toggleOn);
        this.commands.add(toggleOff);
        this.commands.add(new TreeFellerCommand("reload", new TreeFellerCommand[0]){

            @Override
            protected boolean run(CommandSender sender, Command command, String label, String[] args) {
                CommandTreeFeller.this.plugin.reloadConfig();
                CommandTreeFeller.this.plugin.reload(sender);
                Message.getMessage("reload").send(sender, new Object[0]);
                return true;
            }
        });
        TreeFellerCommand debugOn = new TreeFellerCommand("on", "debug", new TreeFellerCommand[0]){

            @Override
            protected boolean run(CommandSender sender, Command command, String label, String[] args) {
                ((CommandTreeFeller)CommandTreeFeller.this).plugin.debug = true;
                Message.getMessage("debug-enable").send(sender, new Object[0]);
                return true;
            }
        };
        TreeFellerCommand debugOff = new TreeFellerCommand("off", "debug", new TreeFellerCommand[0]){

            @Override
            protected boolean run(CommandSender sender, Command command, String label, String[] args) {
                ((CommandTreeFeller)CommandTreeFeller.this).plugin.debug = false;
                Message.getMessage("debug-disable").send(sender, new Object[0]);
                return true;
            }
        };
        this.commands.add(new TreeFellerCommand("debug", new TreeFellerCommand[]{debugOn, debugOff}){

            @Override
            protected boolean run(CommandSender sender, Command command, String label, String[] args) {
                ((CommandTreeFeller)CommandTreeFeller.this).plugin.debug = !((CommandTreeFeller)CommandTreeFeller.this).plugin.debug;
                Message.getMessage("debug-" + (((CommandTreeFeller)CommandTreeFeller.this).plugin.debug ? "enable" : "disable")).send(sender, new Object[0]);
                return true;
            }
        });
        this.commands.add(new TreeFellerCommand("config", new TreeFellerCommand[0]){

            @Override
            protected boolean run(CommandSender sender, Command command, String label, String[] args) {
                if (!(sender instanceof Player)) {
                    sender.sendMessage("You're not a player!");
                    return false;
                }
                new MenuConfiguration(null, CommandTreeFeller.this.plugin, (Player)sender).openInventory();
                return true;
            }
        });
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length < 1) {
            this.sendUsageResponse(sender);
            return true;
        }
        for (TreeFellerCommand cmd : this.commands) {
            if (!args[0].equals(cmd.command)) continue;
            return cmd.onCommand(sender, command, label, this.trim(args, 1), args);
        }
        this.sendUsageResponse(sender);
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String label, String[] args) {
        ArrayList<String> strs = new ArrayList<String>();
        if (args.length == 1) {
            for (TreeFellerCommand cmd : this.commands) {
                if (!cmd.command.substring(0, cmd.command.length() - 1).startsWith(args[0]) || !cmd.hasPermission(sender)) continue;
                strs.add(cmd.command);
            }
        }
        if (args.length > 1) {
            for (TreeFellerCommand cmd : this.commands) {
                if (!args[0].equals(cmd.command)) continue;
                return cmd.onTabComplete(sender, command, label, this.trim(args, 1));
            }
        }
        return strs;
    }

    public String[] trim(String[] data, int beginning) {
        if (data == null) {
            return null;
        }
        String[] newData = new String[Math.max(0, data.length - beginning)];
        for (int i = 0; i < newData.length; ++i) {
            newData[i] = data[i + beginning];
        }
        return newData;
    }

    private String getFullUsage(CommandSender sender) {
        String usage = "/treefeller ";
        boolean foundValidCommand = false;
        String subUsage = "";
        for (TreeFellerCommand cmd : this.commands) {
            if (!cmd.hasPermission(sender)) continue;
            subUsage = subUsage + "|" + cmd.getFullUsage();
            foundValidCommand = true;
        }
        if (!foundValidCommand) {
            return null;
        }
        usage = usage + subUsage.substring(1);
        return usage;
    }

    private void sendUsageResponse(CommandSender sender) {
        String usage = this.getFullUsage(sender);
        if (usage == null) {
            Message.getMessage("unknown-command").send(sender, new Object[0]);
        } else {
            Message.getMessage("command-usage").send(sender, new Object[0]);
        }
    }
}

