/*
 * Decompiled with CFR 0.152.
 */
package com.thizthizzydizzy.simplegui;

import com.thizthizzydizzy.simplegui.Component;
import com.thizthizzydizzy.simplegui.ItemBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.BiConsumer;
import net.wesjd.anvilgui.AnvilGUI;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public abstract class Menu {
    public final Plugin plugin;
    public final Player player;
    protected final String title;
    protected Inventory inventory;
    private MenuListener listener = new MenuListener();
    private boolean open;
    protected final int size;
    protected final ArrayList<Component> components = new ArrayList();
    public final Menu parent;

    public Menu(Menu parent, Plugin plugin, Player player, String title, int size) {
        this.parent = parent;
        this.plugin = plugin;
        this.player = player;
        this.title = title;
        this.size = size;
    }

    public void openInventory() {
        if (this.open) {
            this.updateInventory();
            return;
        }
        Bukkit.getPluginManager().registerEvents((Listener)this.listener, this.plugin);
        this.inventory = Bukkit.createInventory(null, (int)this.size, (String)this.title);
        this.updateInventory();
        this.player.openInventory(this.inventory);
        this.open = true;
        this.onOpen();
    }

    public final void open(Menu menu) {
        this.doClose(menu == null);
        if (menu != null) {
            menu.openInventory();
        }
    }

    private void doClose(boolean closeInv) {
        if (!this.open) {
            return;
        }
        this.open = false;
        if (closeInv && !this.inventory.getViewers().isEmpty()) {
            this.player.closeInventory();
        }
        HandlerList.unregisterAll((Listener)this.listener);
    }

    public final void close() {
        this.doClose(true);
    }

    public final void openAnvilGUI(String initialText, String title, BiConsumer<Player, String> completeFunction) {
        this.close();
        new AnvilGUI.Builder().text(initialText).plugin(this.plugin).title(title).itemLeft(new ItemBuilder(Material.PAPER).setDisplayName(initialText).build()).onClose(plyr -> new BukkitRunnable(){

            public void run() {
                Menu.this.open(Menu.this);
            }
        }.runTask(this.plugin)).onClick((i, state) -> {
            completeFunction.accept(state.getPlayer(), state.getText());
            new BukkitRunnable(){

                public void run() {
                    Menu.this.open(Menu.this);
                }
            }.runTask(this.plugin);
            return Arrays.asList(AnvilGUI.ResponseAction.close());
        }).open(this.player);
    }

    public <T extends Component> T add(T component) {
        if (component == null) {
            throw new IllegalArgumentException("Cannot add null to a menu!");
        }
        this.components.add(component);
        return component;
    }

    protected void updateInventory() {
        if (this.inventory == null) {
            return;
        }
        this.inventory.clear();
        for (Component c : this.components) {
            this.inventory.setItem(c.index, c.draw());
        }
    }

    public void onClose() {
        new BukkitRunnable(){

            public void run() {
                Menu.this.open(Menu.this.parent);
            }
        }.runTask(this.plugin);
    }

    public void onOpen() {
    }

    public void onVoidClicked() {
    }

    public void onClick(int slot, ClickType click) {
    }

    public void onInventoryClick(int slot, ClickType click) {
    }

    private void click(int slot, ClickType click) {
        for (int i = 0; i < this.components.size(); ++i) {
            Component c = this.components.get(i);
            if (c.index != slot) continue;
            c.onClick(click);
        }
        this.onClick(slot, click);
    }

    protected int[] convertIdToCenteredCoords(int id) {
        int x = id;
        int y = 0;
        while (x > 8) {
            x -= 9;
            ++y;
        }
        return new int[]{x -= 4, y -= this.size / 18};
    }

    protected int convertCenteredCoordsToId(int x, int y) {
        int row = y + this.size / 18;
        int column = x + 4;
        if (row < 0 || column < 0 || row > this.size / 9 - 1 || column > 8) {
            return -1;
        }
        return row * 9 + column;
    }

    protected ItemBuilder makeItem(Material type) {
        return new ItemBuilder(type);
    }

    class MenuListener
    implements Listener {
        MenuListener() {
        }

        @EventHandler
        public void onInventoryClick(InventoryClickEvent event) {
            if (event.getInventory().equals(Menu.this.inventory)) {
                Player clicker = (Player)event.getWhoClicked();
                event.setCancelled(true);
                if (clicker != Menu.this.player) {
                    return;
                }
                if (event.getRawSlot() < 0) {
                    Menu.this.onVoidClicked();
                } else if (event.getClickedInventory().equals(Menu.this.inventory)) {
                    Menu.this.click(event.getSlot(), event.getClick());
                } else {
                    Menu.this.onInventoryClick(event.getSlot(), event.getClick());
                }
            }
        }

        @EventHandler
        public void onInventoryDrag(InventoryDragEvent event) {
            if (event.getInventory().equals(Menu.this.inventory)) {
                event.setCancelled(true);
            }
        }

        @EventHandler
        public void onInventoryClose(InventoryCloseEvent event) {
            if (Menu.this.open && event.getInventory().equals(Menu.this.inventory)) {
                Menu.this.close();
                Menu.this.onClose();
            }
        }
    }
}

