/*
 * Decompiled with CFR 0.152.
 */
package com.thizthizzydizzy.simplegui;

import java.util.ArrayList;
import java.util.HashMap;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;

public class ItemBuilder {
    protected final Material type;
    protected String displayName = null;
    protected String localizedName = null;
    protected ArrayList<String> lore = new ArrayList();
    protected HashMap<Enchantment, Integer> enchantments = new HashMap();
    protected Color color = null;
    protected Integer customModelData = null;
    protected int count = 1;
    protected Short durability = null;
    protected ArrayList<ItemFlag> flags = new ArrayList();
    protected Boolean unbreakable = null;
    protected ArrayList<AttributeAndModifier> attributes = new ArrayList();

    public static ItemStack setDisplayName(Material item, String name) {
        return ItemBuilder.setDisplayName(new ItemStack(item), name);
    }

    public static ItemStack setDisplayName(ItemStack item, String name) {
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName(name);
        item.setItemMeta(meta);
        return item;
    }

    public static ItemStack dye(Material item, Color color) {
        return ItemBuilder.dye(new ItemStack(item), color);
    }

    public static ItemStack dye(ItemStack item, Color color) {
        ItemMeta meta = item.getItemMeta();
        if (meta instanceof LeatherArmorMeta) {
            ((LeatherArmorMeta)meta).setColor(color);
            item.setItemMeta(meta);
        }
        return item;
    }

    public ItemBuilder(Material type) {
        this.type = type;
    }

    public ItemBuilder(ItemBuilder builder) {
        this.type = builder.type;
        this.displayName = builder.displayName;
        this.localizedName = builder.localizedName;
        this.lore.addAll(builder.lore);
        this.enchantments.putAll(builder.enchantments);
        this.color = builder.color;
        this.customModelData = builder.customModelData;
        this.count = builder.count;
        this.durability = builder.durability;
        this.flags.addAll(builder.flags);
        this.unbreakable = builder.unbreakable;
        for (AttributeAndModifier m : builder.attributes) {
            this.attributes.add(new AttributeAndModifier(m));
        }
    }

    public ItemBuilder setDisplayName(String name) {
        if (name != null && !name.startsWith(ChatColor.RESET.toString())) {
            name = ChatColor.RESET.toString() + name;
        }
        this.displayName = name;
        return this;
    }

    public ItemBuilder setLocalizedName(String name) {
        if (!name.startsWith(ChatColor.RESET.toString())) {
            name = ChatColor.RESET.toString() + name;
        }
        this.localizedName = name;
        return this;
    }

    public ItemBuilder addLore(String str) {
        if (str != null) {
            this.lore.add(str);
        }
        return this;
    }

    public ItemBuilder addLore(Iterable<String> strs) {
        for (String str : strs) {
            this.addLore(str);
        }
        return this;
    }

    public ItemBuilder addLore(String[] strs) {
        for (String str : strs) {
            this.addLore(str);
        }
        return this;
    }

    public ItemBuilder dye(Color color) {
        this.color = color;
        return this;
    }

    public ItemBuilder setCustomModelData(Integer data) {
        this.customModelData = data;
        return this;
    }

    public ItemBuilder setCustomModelData(int data) {
        this.customModelData = data;
        return this;
    }

    public ItemBuilder setCount(Integer count) {
        return this.setCount(count == null ? 1 : count);
    }

    public ItemBuilder setCount(int count) {
        this.count = Math.max(1, Math.min(64, count));
        return this;
    }

    public ItemBuilder setDurability(Short durability) {
        this.durability = durability;
        return this;
    }

    public ItemBuilder setDurability(short durability) {
        this.durability = durability;
        return this;
    }

    public ItemBuilder setDurability(Float durability) {
        if (durability == null) {
            return this;
        }
        this.durability = (short)((float)this.type.getMaxDurability() * durability.floatValue());
        return this;
    }

    public ItemBuilder setDurability(float durability) {
        this.durability = (short)((float)this.type.getMaxDurability() * durability);
        return this;
    }

    public ItemBuilder addFlag(ItemFlag flag) {
        this.flags.add(flag);
        return this;
    }

    public ItemBuilder enchant(Enchantment ench) {
        return this.enchant(ench, 1);
    }

    public ItemBuilder enchant(Enchantment ench, int level) {
        if (this.enchantments.containsKey(ench)) {
            this.enchantments.put(ench, Math.max(this.enchantments.get(ench), level));
        } else {
            this.enchantments.put(ench, level);
        }
        return this;
    }

    public ItemBuilder addAttributeModifier(Attribute attribute, AttributeModifier modifier) {
        this.attributes.add(new AttributeAndModifier(attribute, modifier));
        return this;
    }

    public ItemBuilder setUnbreakable(boolean unbreakable) {
        this.unbreakable = unbreakable;
        return this;
    }

    public ItemStack build() {
        ItemStack stack = new ItemStack(this.type, this.count);
        ItemMeta meta = stack.getItemMeta();
        if (this.durability != null) {
            stack.setDurability((short)(stack.getType().getMaxDurability() - this.durability));
        }
        if (this.displayName != null) {
            meta.setDisplayName(this.displayName);
        }
        if (this.localizedName != null) {
            meta.setLocalizedName(this.localizedName);
        }
        if (!this.lore.isEmpty()) {
            meta.setLore(this.lore);
        }
        if (this.customModelData != null) {
            meta.setCustomModelData(this.customModelData);
        }
        if (this.color != null && meta instanceof LeatherArmorMeta) {
            ((LeatherArmorMeta)meta).setColor(this.color);
        }
        for (ItemFlag flag : this.flags) {
            meta.addItemFlags(new ItemFlag[]{flag});
        }
        for (Enchantment e : this.enchantments.keySet()) {
            meta.addEnchant(e, this.enchantments.get(e).intValue(), true);
        }
        for (AttributeAndModifier mod : this.attributes) {
            meta.addAttributeModifier(mod.attribute, mod.modifier);
        }
        if (this.unbreakable != null) {
            meta.setUnbreakable(this.unbreakable.booleanValue());
        }
        stack.setItemMeta(meta);
        return stack;
    }

    private static class AttributeAndModifier {
        private final Attribute attribute;
        private final AttributeModifier modifier;

        public AttributeAndModifier(Attribute attribute, AttributeModifier modifier) {
            this.attribute = attribute;
            this.modifier = modifier;
        }

        private AttributeAndModifier(AttributeAndModifier m) {
            this(m.attribute, m.modifier);
        }
    }
}

