/*
 * Decompiled with CFR 0.152.
 */
package hu.montlikadani.v1_8_8;

import com.mojang.authlib.GameProfile;
import hu.montlikadani.api.IPacketNM;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import net.minecraft.server.v1_8_R3.EntityPlayer;
import net.minecraft.server.v1_8_R3.EnumChatFormat;
import net.minecraft.server.v1_8_R3.IChatBaseComponent;
import net.minecraft.server.v1_8_R3.IScoreboardCriteria;
import net.minecraft.server.v1_8_R3.MinecraftServer;
import net.minecraft.server.v1_8_R3.Packet;
import net.minecraft.server.v1_8_R3.PacketPlayOutPlayerInfo;
import net.minecraft.server.v1_8_R3.PacketPlayOutPlayerListHeaderFooter;
import net.minecraft.server.v1_8_R3.PacketPlayOutScoreboardDisplayObjective;
import net.minecraft.server.v1_8_R3.PacketPlayOutScoreboardObjective;
import net.minecraft.server.v1_8_R3.PacketPlayOutScoreboardScore;
import net.minecraft.server.v1_8_R3.PacketPlayOutScoreboardTeam;
import net.minecraft.server.v1_8_R3.PlayerInteractManager;
import net.minecraft.server.v1_8_R3.Scoreboard;
import net.minecraft.server.v1_8_R3.ScoreboardObjective;
import net.minecraft.server.v1_8_R3.ScoreboardScore;
import net.minecraft.server.v1_8_R3.ScoreboardTeam;
import net.minecraft.server.v1_8_R3.ScoreboardTeamBase;
import net.minecraft.server.v1_8_R3.World;
import net.minecraft.server.v1_8_R3.WorldServer;
import net.minecraft.server.v1_8_R3.WorldSettings;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_8_R3.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_8_R3.scoreboard.CraftScoreboard;
import org.bukkit.entity.Player;
import org.bukkit.scoreboard.NameTagVisibility;
import org.bukkit.scoreboard.Team;

public final class v1_8_8
implements IPacketNM {
    private final List<ObjectiveStorage> objectiveStorage = new ArrayList<ObjectiveStorage>();
    private Field headerField;
    private Field footerField;
    private Field entriesField;
    private Field infoList;
    private Field playerInfoAction;
    private Field scoreboardTeamPlayers;
    private Field scoreboardTeamPrefix;
    private Field scoreboardTeamSuffix;
    private Field scoreboardTeamNameTagVisibility;
    private Field scoreboardTeamEnumChatFormat;
    private Field scoreboardTeamName;
    private final Scoreboard scoreboard = new Scoreboard();
    private final Set<TagTeam> tagTeams = new HashSet<TagTeam>();

    public v1_8_8() {
        try {
            this.headerField = PacketPlayOutPlayerListHeaderFooter.class.getDeclaredField("a");
            this.headerField.setAccessible(true);
            this.footerField = PacketPlayOutPlayerListHeaderFooter.class.getDeclaredField("b");
            this.footerField.setAccessible(true);
            this.infoList = PacketPlayOutPlayerInfo.class.getDeclaredField("b");
            this.infoList.setAccessible(true);
            this.playerInfoAction = PacketPlayOutPlayerInfo.class.getDeclaredField("a");
            this.playerInfoAction.setAccessible(true);
            this.scoreboardTeamPlayers = PacketPlayOutScoreboardTeam.class.getDeclaredField("g");
            this.scoreboardTeamPlayers.setAccessible(true);
            this.scoreboardTeamPrefix = PacketPlayOutScoreboardTeam.class.getDeclaredField("c");
            this.scoreboardTeamPrefix.setAccessible(true);
            this.scoreboardTeamSuffix = PacketPlayOutScoreboardTeam.class.getDeclaredField("d");
            this.scoreboardTeamSuffix.setAccessible(true);
            this.scoreboardTeamNameTagVisibility = PacketPlayOutScoreboardTeam.class.getDeclaredField("e");
            this.scoreboardTeamNameTagVisibility.setAccessible(true);
            this.scoreboardTeamEnumChatFormat = PacketPlayOutScoreboardTeam.class.getDeclaredField("f");
            this.scoreboardTeamEnumChatFormat.setAccessible(true);
            this.scoreboardTeamName = PacketPlayOutScoreboardTeam.class.getDeclaredField("a");
            this.scoreboardTeamName.setAccessible(true);
        }
        catch (NoSuchFieldException | SecurityException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void sendPacket(Player player2, Object packet) {
        this.getPlayerHandle((Player)player2).playerConnection.sendPacket((Packet)packet);
    }

    private void sendPacket(EntityPlayer player2, Packet<?> packet) {
        player2.playerConnection.sendPacket(packet);
    }

    @Override
    public void addPlayerChannelListener(Player player2, List<Class<?>> classesToListen) {
        EntityPlayer entityPlayer = this.getPlayerHandle(player2);
        if (entityPlayer.playerConnection.networkManager.channel.pipeline().get("TLPacketInjector") == null) {
            try {
                entityPlayer.playerConnection.networkManager.channel.pipeline().addBefore("packet_handler", "TLPacketInjector", (ChannelHandler)new PacketReceivingListener(player2.getUniqueId(), classesToListen));
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
        }
    }

    @Override
    public void removePlayerChannelListener(Player player2) {
        EntityPlayer entityPlayer = this.getPlayerHandle(player2);
        if (entityPlayer.playerConnection.networkManager.channel != null) {
            try {
                entityPlayer.playerConnection.networkManager.channel.pipeline().remove("TLPacketInjector");
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
        }
    }

    public EntityPlayer getPlayerHandle(Player player2) {
        return ((CraftPlayer)player2).getHandle();
    }

    public IChatBaseComponent fromJson(String json) {
        return IChatBaseComponent.ChatSerializer.a((String)json);
    }

    @Override
    public void sendTabTitle(Player player2, Object header, Object footer) {
        PacketPlayOutPlayerListHeaderFooter packet = new PacketPlayOutPlayerListHeaderFooter();
        try {
            this.headerField.set(packet, header);
            this.footerField.set(packet, footer);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
        }
        this.sendPacket(player2, packet);
    }

    public EntityPlayer getNewEntityPlayer(GameProfile profile) {
        WorldServer worldServer = MinecraftServer.getServer().getWorldServer(0);
        return new EntityPlayer(MinecraftServer.getServer(), worldServer, profile, new PlayerInteractManager((World)worldServer));
    }

    @Override
    public int playerPing(Player player2) {
        return this.getPlayerHandle((Player)player2).ping;
    }

    @Override
    public double[] serverTps() {
        return MinecraftServer.getServer().recentTps;
    }

    public PacketPlayOutPlayerInfo updateDisplayNamePacket(Object entityPlayer, Object component, boolean listName) {
        if (listName) {
            this.setListName(entityPlayer, component);
        }
        return new PacketPlayOutPlayerInfo(PacketPlayOutPlayerInfo.EnumPlayerInfoAction.UPDATE_DISPLAY_NAME, new EntityPlayer[]{(EntityPlayer)entityPlayer});
    }

    @Override
    public void setListName(Object entityPlayer, Object component) {
        ((EntityPlayer)entityPlayer).listName = (IChatBaseComponent)component;
    }

    public PacketPlayOutPlayerInfo newPlayerInfoUpdatePacketAdd(Object ... entityPlayers) {
        ArrayList<EntityPlayer> players = new ArrayList<EntityPlayer>(entityPlayers.length);
        for (Object one : entityPlayers) {
            players.add((EntityPlayer)one);
        }
        return new PacketPlayOutPlayerInfo(PacketPlayOutPlayerInfo.EnumPlayerInfoAction.ADD_PLAYER, players);
    }

    public PacketPlayOutPlayerInfo updateLatency(Object entityPlayer) {
        return new PacketPlayOutPlayerInfo(PacketPlayOutPlayerInfo.EnumPlayerInfoAction.UPDATE_LATENCY, new EntityPlayer[]{(EntityPlayer)entityPlayer});
    }

    public PacketPlayOutPlayerInfo removeEntityPlayers(Object ... entityPlayers) {
        ArrayList<EntityPlayer> players = new ArrayList<EntityPlayer>(entityPlayers.length);
        for (Object one : entityPlayers) {
            players.add((EntityPlayer)one);
        }
        return new PacketPlayOutPlayerInfo(PacketPlayOutPlayerInfo.EnumPlayerInfoAction.REMOVE_PLAYER, players);
    }

    @Override
    public void setInfoData(Object info, UUID id, int ping, Object component) {
        PacketPlayOutPlayerInfo update = (PacketPlayOutPlayerInfo)info;
        try {
            for (PacketPlayOutPlayerInfo.PlayerInfoData playerInfo : (List)this.infoList.get(update)) {
                if (!playerInfo.a().getId().equals(id)) continue;
                PacketPlayOutPlayerInfo packetPlayOutPlayerInfo = update;
                Objects.requireNonNull(packetPlayOutPlayerInfo);
                this.setEntriesField(update, Collections.singletonList(new PacketPlayOutPlayerInfo.PlayerInfoData(packetPlayOutPlayerInfo, playerInfo.a(), ping == -2 ? playerInfo.b() : ping, playerInfo.c(), (IChatBaseComponent)component)));
                break;
            }
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
        }
    }

    private void setEntriesField(PacketPlayOutPlayerInfo playerInfoPacket, List<PacketPlayOutPlayerInfo.PlayerInfoData> list) {
        try {
            if (this.entriesField == null) {
                this.entriesField = playerInfoPacket.getClass().getDeclaredField("b");
                this.entriesField.setAccessible(true);
            }
            this.entriesField.set(playerInfoPacket, list);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void createBoardTeam(String teamName, Player player2, boolean followNameTagVisibility) {
        ScoreboardTeam playerTeam = this.scoreboard.createTeam(teamName);
        this.scoreboard.addPlayerToTeam(player2.getName(), teamName);
        if (followNameTagVisibility) {
            ScoreboardTeamBase.EnumNameTagVisibility visibility = null;
            block4: for (Team team : player2.getScoreboard().getTeams()) {
                NameTagVisibility optionStatus = team.getNameTagVisibility();
                switch (optionStatus) {
                    case HIDE_FOR_OTHER_TEAMS: {
                        visibility = ScoreboardTeamBase.EnumNameTagVisibility.HIDE_FOR_OTHER_TEAMS;
                        continue block4;
                    }
                    case HIDE_FOR_OWN_TEAM: {
                        visibility = ScoreboardTeamBase.EnumNameTagVisibility.HIDE_FOR_OWN_TEAM;
                        continue block4;
                    }
                }
                if (optionStatus == NameTagVisibility.ALWAYS) continue;
                visibility = ScoreboardTeamBase.EnumNameTagVisibility.NEVER;
            }
            if (visibility != null) {
                playerTeam.setNameTagVisibility(visibility);
            }
        }
        if (this.tagTeams.isEmpty()) {
            for (Player one : Bukkit.getOnlinePlayers()) {
                this.sendPacket(this.getPlayerHandle(one), (Packet<?>)new PacketPlayOutScoreboardTeam(playerTeam, 0));
            }
        } else {
            for (TagTeam tagTeam : this.tagTeams) {
                if (!tagTeam.playerName.equals(player2.getName())) continue;
                tagTeam.scoreboardTeam.setDisplayName(playerTeam.getDisplayName());
                tagTeam.scoreboardTeam.setNameTagVisibility(playerTeam.getNameTagVisibility());
                for (Player one : Bukkit.getOnlinePlayers()) {
                    EntityPlayer handle = this.getPlayerHandle(one);
                    this.sendPacket(handle, (Packet<?>)new PacketPlayOutScoreboardTeam(playerTeam, 0));
                    this.sendPacket(handle, (Packet<?>)new PacketPlayOutScoreboardTeam(tagTeam.scoreboardTeam, 0));
                }
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PacketPlayOutScoreboardTeam unregisterBoardTeamPacket(String teamName) {
        Collection teams;
        Collection collection = teams = this.scoreboard.getTeams();
        synchronized (collection) {
            for (ScoreboardTeam team : new ArrayList(teams)) {
                if (!team.getName().equals(teamName)) continue;
                this.scoreboard.removeTeam(team);
                return new PacketPlayOutScoreboardTeam(team, 1);
            }
        }
        return null;
    }

    public ScoreboardObjective createObjectivePacket(String objectiveName, Object nameComponent, IPacketNM.ObjectiveFormat objectiveFormat, Object formatComponent) {
        Scoreboard scoreboard = new Scoreboard();
        ScoreboardObjective objective = new ScoreboardObjective(scoreboard, objectiveName, IScoreboardCriteria.b);
        this.objectiveStorage.add(new ObjectiveStorage(scoreboard, objective));
        return objective;
    }

    public PacketPlayOutScoreboardObjective scoreboardObjectivePacket(Object objective, int mode) {
        return new PacketPlayOutScoreboardObjective((ScoreboardObjective)objective, mode);
    }

    public PacketPlayOutScoreboardDisplayObjective scoreboardDisplayObjectivePacket(Object objective, int slot) {
        return new PacketPlayOutScoreboardDisplayObjective(slot, (ScoreboardObjective)objective);
    }

    public PacketPlayOutScoreboardScore changeScoreboardScorePacket(String objectiveName, String scoreName, int score) {
        for (ObjectiveStorage objectiveStorage : this.objectiveStorage) {
            if (!objectiveStorage.objective.getName().equals(objectiveName)) continue;
            ScoreboardScore scoreboardScore = new ScoreboardScore(objectiveStorage.scoreboard, objectiveStorage.objective, scoreName);
            scoreboardScore.setScore(score);
            return new PacketPlayOutScoreboardScore(scoreboardScore);
        }
        return null;
    }

    public PacketPlayOutScoreboardScore removeScoreboardScorePacket(String objectiveName, String scoreName, int score) {
        return this.objectiveStorage.removeIf(storage -> storage.objective.getName().equals(objectiveName)) ? new PacketPlayOutScoreboardScore(objectiveName) : null;
    }

    public ScoreboardObjective createScoreboardHealthObjectivePacket(String objectiveName, Object nameComponent) {
        return new ScoreboardObjective(null, objectiveName, IScoreboardCriteria.g);
    }

    private final class PacketReceivingListener
    extends ChannelDuplexHandler {
        private final UUID listenerPlayerId;
        private final List<Class<?>> classesToListen;

        public PacketReceivingListener(UUID listenerPlayerId, List<Class<?>> classesToListen) {
            this.listenerPlayerId = listenerPlayerId;
            this.classesToListen = classesToListen;
        }

        public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
            Class<?> receivingClass = msg.getClass();
            if (!this.classesToListen.contains(receivingClass)) {
                super.write(ctx, msg, promise);
                return;
            }
            if (receivingClass == PacketPlayOutScoreboardTeam.class) {
                this.scoreboardTeamPacket((PacketPlayOutScoreboardTeam)msg);
            } else if (receivingClass == PacketPlayOutPlayerInfo.class) {
                this.packetPlayPlayerInfo((PacketPlayOutPlayerInfo)msg);
            }
            super.write(ctx, msg, promise);
        }

        private void packetPlayPlayerInfo(PacketPlayOutPlayerInfo playerInfoPacket) throws Exception {
            if (v1_8_8.this.playerInfoAction.get(playerInfoPacket) != PacketPlayOutPlayerInfo.EnumPlayerInfoAction.UPDATE_GAME_MODE) {
                return;
            }
            Player player2 = Bukkit.getPlayer((UUID)this.listenerPlayerId);
            if (player2 == null) {
                return;
            }
            for (PacketPlayOutPlayerInfo.PlayerInfoData infoData : (List)v1_8_8.this.infoList.get(playerInfoPacket)) {
                if (infoData.c() != WorldSettings.EnumGamemode.SPECTATOR || infoData.a().getId().equals(this.listenerPlayerId)) continue;
                PacketPlayOutPlayerInfo updatePacket = new PacketPlayOutPlayerInfo(PacketPlayOutPlayerInfo.EnumPlayerInfoAction.UPDATE_GAME_MODE, Collections.emptyList());
                PacketPlayOutPlayerInfo packetPlayOutPlayerInfo = playerInfoPacket;
                Objects.requireNonNull(packetPlayOutPlayerInfo);
                v1_8_8.this.setEntriesField(updatePacket, Collections.singletonList(new PacketPlayOutPlayerInfo.PlayerInfoData(packetPlayOutPlayerInfo, infoData.a(), infoData.b(), WorldSettings.EnumGamemode.SURVIVAL, infoData.d())));
                v1_8_8.this.sendPacket(player2, updatePacket);
            }
        }

        private void scoreboardTeamPacket(PacketPlayOutScoreboardTeam packetScoreboardTeam) throws Exception {
            Collection players = (Collection)v1_8_8.this.scoreboardTeamPlayers.get(packetScoreboardTeam);
            if (players == null || players.isEmpty()) {
                return;
            }
            ScoreboardTeamBase.EnumNameTagVisibility enumNameTagVisibility = ScoreboardTeamBase.EnumNameTagVisibility.a((String)((String)v1_8_8.this.scoreboardTeamNameTagVisibility.get(packetScoreboardTeam)));
            if (enumNameTagVisibility == null) {
                enumNameTagVisibility = ScoreboardTeamBase.EnumNameTagVisibility.ALWAYS;
            } else if (enumNameTagVisibility == ScoreboardTeamBase.EnumNameTagVisibility.NEVER) {
                return;
            }
            String prefix = (String)v1_8_8.this.scoreboardTeamPrefix.get(packetScoreboardTeam);
            String suffix = (String)v1_8_8.this.scoreboardTeamSuffix.get(packetScoreboardTeam);
            if (prefix.isEmpty() && suffix.isEmpty()) {
                return;
            }
            String playerName = (String)players.iterator().next();
            for (TagTeam team : v1_8_8.this.tagTeams) {
                if (!team.playerName.equals(playerName)) continue;
                return;
            }
            Player player2 = Bukkit.getPlayer((String)playerName);
            if (player2 == null) {
                return;
            }
            EnumChatFormat enumChatFormat = EnumChatFormat.a((int)((Integer)v1_8_8.this.scoreboardTeamEnumChatFormat.get(packetScoreboardTeam)));
            if (enumChatFormat == null) {
                enumChatFormat = EnumChatFormat.RESET;
            }
            ScoreboardTeam scoreboardTeam = new ScoreboardTeam(((CraftScoreboard)player2.getScoreboard()).getHandle(), (String)v1_8_8.this.scoreboardTeamName.get(packetScoreboardTeam));
            scoreboardTeam.setPrefix(prefix);
            scoreboardTeam.setSuffix(suffix);
            scoreboardTeam.setNameTagVisibility(enumNameTagVisibility);
            scoreboardTeam.a(enumChatFormat);
            scoreboardTeam.getPlayerNameSet().add(playerName);
            v1_8_8.this.tagTeams.add(new TagTeam(playerName, scoreboardTeam));
        }
    }

    private static class TagTeam {
        public final String playerName;
        public final ScoreboardTeam scoreboardTeam;

        public TagTeam(String playerName, ScoreboardTeam scoreboardTeam) {
            this.playerName = playerName;
            this.scoreboardTeam = scoreboardTeam;
        }

        public boolean equals(Object other) {
            return other != null && this.getClass() == other.getClass() && this.playerName.equals(((TagTeam)other).playerName);
        }

        public int hashCode() {
            return Objects.hash(this.playerName);
        }
    }

    private static class ObjectiveStorage {
        private final Scoreboard scoreboard;
        private final ScoreboardObjective objective;

        public ObjectiveStorage(Scoreboard scoreboard, ScoreboardObjective objective) {
            this.scoreboard = scoreboard;
            this.objective = objective;
        }
    }
}

