/*
 * Decompiled with CFR 0.152.
 */
package hu.montlikadani.v1_20_4;

import com.mojang.authlib.GameProfile;
import hu.montlikadani.api.IPacketNM;
import io.netty.channel.AbstractChannel;
import io.netty.channel.Channel;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelMetadata;
import io.netty.channel.ChannelOutboundBuffer;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultChannelConfig;
import io.netty.channel.EventLoop;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import net.minecraft.EnumChatFormat;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.PacketListener;
import net.minecraft.network.PacketSendListener;
import net.minecraft.network.chat.ChatModifier;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.numbers.FixedFormat;
import net.minecraft.network.chat.numbers.NumberFormat;
import net.minecraft.network.chat.numbers.StyledFormat;
import net.minecraft.network.protocol.EnumProtocolDirection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoRemovePacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket;
import net.minecraft.network.protocol.game.PacketPlayOutPlayerListHeaderFooter;
import net.minecraft.network.protocol.game.PacketPlayOutScoreboardDisplayObjective;
import net.minecraft.network.protocol.game.PacketPlayOutScoreboardObjective;
import net.minecraft.network.protocol.game.PacketPlayOutScoreboardScore;
import net.minecraft.network.protocol.game.PacketPlayOutScoreboardTeam;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ClientInformation;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.network.CommonListenerCookie;
import net.minecraft.server.network.PlayerConnection;
import net.minecraft.world.level.EnumGamemode;
import net.minecraft.world.scores.DisplaySlot;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.ScoreboardObjective;
import net.minecraft.world.scores.ScoreboardTeam;
import net.minecraft.world.scores.ScoreboardTeamBase;
import net.minecraft.world.scores.criteria.IScoreboardCriteria;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_20_R3.CraftServer;
import org.bukkit.craftbukkit.v1_20_R3.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_20_R3.scoreboard.CraftScoreboard;
import org.bukkit.entity.Player;
import org.bukkit.scoreboard.Team;

public final class v1_20_4
implements IPacketNM {
    private Field entriesField;
    private Field playerNetworkManagerField;
    private final Scoreboard scoreboard = new Scoreboard();
    private final Set<TagTeam> tagTeams = new HashSet<TagTeam>();
    private Method playerGameProfileMethod;

    @Override
    public void sendPacket(Player player2, Object packet) {
        this.getPlayerHandle((Player)player2).c.b((Packet)packet);
    }

    private void sendPacket(EntityPlayer player2, Packet<?> packet) {
        player2.c.b(packet);
    }

    @Override
    public void addPlayerChannelListener(Player player2, List<Class<?>> classesToListen) {
        Channel channel = this.playerChannel(this.getPlayerHandle((Player)player2).c);
        if (channel != null && channel.pipeline().get("TLPacketInjector") == null) {
            try {
                channel.pipeline().addBefore("packet_handler", "TLPacketInjector", (ChannelHandler)new PacketReceivingListener(player2.getUniqueId(), classesToListen));
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
        }
    }

    private Channel playerChannel(PlayerConnection connection) {
        if (this.playerNetworkManagerField == null && (this.playerNetworkManagerField = this.fieldByType(connection.getClass().getSuperclass(), NetworkManager.class)) == null) {
            return null;
        }
        try {
            return ((NetworkManager)this.playerNetworkManagerField.get((Object)connection)).n;
        }
        catch (IllegalAccessException ignored) {
            return null;
        }
    }

    private Field fieldByType(Class<?> where, Class<?> type) {
        for (Field field : where.getDeclaredFields()) {
            if (field.getType() != type) continue;
            field.setAccessible(true);
            return field;
        }
        return null;
    }

    @Override
    public void removePlayerChannelListener(Player player2) {
        Channel channel = this.playerChannel(this.getPlayerHandle((Player)player2).c);
        if (channel != null) {
            try {
                channel.pipeline().remove("TLPacketInjector");
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
        }
    }

    public EntityPlayer getPlayerHandle(Player player2) {
        return ((CraftPlayer)player2).getHandle();
    }

    public IChatBaseComponent fromJson(String json) {
        return IChatBaseComponent.ChatSerializer.a((String)json);
    }

    @Override
    public void sendTabTitle(Player player2, Object header, Object footer) {
        this.sendPacket(player2, new PacketPlayOutPlayerListHeaderFooter((IChatBaseComponent)header, (IChatBaseComponent)footer));
    }

    private MinecraftServer minecraftServer() {
        return ((CraftServer)Bukkit.getServer()).getServer();
    }

    public EntityPlayer getNewEntityPlayer(GameProfile profile) {
        MinecraftServer server = this.minecraftServer();
        ClientInformation clientInfo = ClientInformation.a();
        EntityPlayer entityPlayer = new EntityPlayer(server, server.F(), profile, clientInfo);
        entityPlayer.c = new EmptyPacketListener(server, new EmptyConnection(EnumProtocolDirection.b), entityPlayer, new CommonListenerCookie(profile, 0, clientInfo));
        return entityPlayer;
    }

    @Override
    public double[] serverTps() {
        return this.minecraftServer().recentTps;
    }

    public ClientboundPlayerInfoUpdatePacket updateDisplayNamePacket(Object entityPlayer, Object component, boolean listName) {
        if (listName) {
            this.setListName(entityPlayer, component);
        }
        return new ClientboundPlayerInfoUpdatePacket(ClientboundPlayerInfoUpdatePacket.a.f, (EntityPlayer)entityPlayer);
    }

    @Override
    public void setListName(Object entityPlayer, Object component) {
        ((EntityPlayer)entityPlayer).listName = (IChatBaseComponent)component;
    }

    public ClientboundPlayerInfoUpdatePacket newPlayerInfoUpdatePacketAdd(Object ... entityPlayers) {
        ArrayList<EntityPlayer> players = new ArrayList<EntityPlayer>(entityPlayers.length);
        for (Object one : entityPlayers) {
            players.add((EntityPlayer)one);
        }
        return new ClientboundPlayerInfoUpdatePacket(EnumSet.of(ClientboundPlayerInfoUpdatePacket.a.a, ClientboundPlayerInfoUpdatePacket.a.d, ClientboundPlayerInfoUpdatePacket.a.e, ClientboundPlayerInfoUpdatePacket.a.f), players);
    }

    public ClientboundPlayerInfoUpdatePacket updateLatency(Object entityPlayer) {
        return new ClientboundPlayerInfoUpdatePacket(ClientboundPlayerInfoUpdatePacket.a.e, (EntityPlayer)entityPlayer);
    }

    public ClientboundPlayerInfoRemovePacket removeEntityPlayers(Object ... entityPlayers) {
        ArrayList<UUID> players = new ArrayList<UUID>(entityPlayers.length);
        if (this.playerGameProfileMethod == null) {
            for (Method method : EntityPlayer.class.getSuperclass().getDeclaredMethods()) {
                if (method.getReturnType() != GameProfile.class || method.getParameterCount() != 0) continue;
                this.playerGameProfileMethod = method;
                break;
            }
        }
        if (this.playerGameProfileMethod != null) {
            for (Object one : entityPlayers) {
                try {
                    players.add(((GameProfile)this.playerGameProfileMethod.invoke(one, new Object[0])).getId());
                }
                catch (IllegalAccessException | InvocationTargetException ex) {
                    ex.printStackTrace();
                }
            }
        }
        return new ClientboundPlayerInfoRemovePacket(players);
    }

    @Override
    public void setInfoData(Object info, UUID id, int ping, Object component) {
        ClientboundPlayerInfoUpdatePacket update = (ClientboundPlayerInfoUpdatePacket)info;
        for (ClientboundPlayerInfoUpdatePacket.b playerInfo : update.d()) {
            if (!playerInfo.a().equals(id)) continue;
            this.setEntriesField(update, Collections.singletonList(new ClientboundPlayerInfoUpdatePacket.b(playerInfo.a(), playerInfo.b(), playerInfo.c(), ping == -2 ? playerInfo.d() : ping, playerInfo.e(), (IChatBaseComponent)component, playerInfo.g())));
            break;
        }
    }

    private void setEntriesField(ClientboundPlayerInfoUpdatePacket playerInfoPacket, List<ClientboundPlayerInfoUpdatePacket.b> list) {
        try {
            if (this.entriesField == null) {
                this.entriesField = playerInfoPacket.getClass().getDeclaredField("b");
                this.entriesField.setAccessible(true);
            }
            this.entriesField.set(playerInfoPacket, list);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void createBoardTeam(String teamName, Player player2, boolean followNameTagVisibility) {
        ScoreboardTeam playerTeam = this.scoreboard.c(teamName);
        this.scoreboard.a(player2.getName(), playerTeam);
        if (followNameTagVisibility) {
            ScoreboardTeamBase.EnumNameTagVisibility visibility = null;
            block4: for (Team team : player2.getScoreboard().getTeams()) {
                Team.OptionStatus optionStatus = team.getOption(Team.Option.NAME_TAG_VISIBILITY);
                switch (optionStatus) {
                    case FOR_OTHER_TEAMS: {
                        visibility = ScoreboardTeamBase.EnumNameTagVisibility.c;
                        continue block4;
                    }
                    case FOR_OWN_TEAM: {
                        visibility = ScoreboardTeamBase.EnumNameTagVisibility.d;
                        continue block4;
                    }
                }
                if (optionStatus == Team.OptionStatus.ALWAYS) continue;
                visibility = ScoreboardTeamBase.EnumNameTagVisibility.b;
            }
            if (visibility != null) {
                playerTeam.a(visibility);
            }
        }
        if (this.tagTeams.isEmpty()) {
            for (Player one : Bukkit.getOnlinePlayers()) {
                this.sendPacket(this.getPlayerHandle(one), (Packet<?>)PacketPlayOutScoreboardTeam.a((ScoreboardTeam)playerTeam, (boolean)true));
            }
        } else {
            for (TagTeam tagTeam : this.tagTeams) {
                if (!tagTeam.playerName.equals(player2.getName())) continue;
                tagTeam.scoreboardTeam.a(playerTeam.c());
                tagTeam.scoreboardTeam.a(playerTeam.j());
                for (Player one : Bukkit.getOnlinePlayers()) {
                    EntityPlayer handle = this.getPlayerHandle(one);
                    this.sendPacket(handle, (Packet<?>)PacketPlayOutScoreboardTeam.a((ScoreboardTeam)playerTeam, (boolean)true));
                    this.sendPacket(handle, (Packet<?>)PacketPlayOutScoreboardTeam.a((ScoreboardTeam)tagTeam.scoreboardTeam, (boolean)true));
                }
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PacketPlayOutScoreboardTeam unregisterBoardTeamPacket(String teamName) {
        Collection teams;
        Collection collection = teams = this.scoreboard.g();
        synchronized (collection) {
            for (ScoreboardTeam team : new ArrayList(teams)) {
                if (!team.b().equals(teamName)) continue;
                this.scoreboard.d(team);
                return PacketPlayOutScoreboardTeam.a((ScoreboardTeam)team);
            }
        }
        return null;
    }

    public ScoreboardObjective createObjectivePacket(String objectiveName, Object nameComponent, IPacketNM.ObjectiveFormat objectiveFormat, Object formatComponent) {
        FixedFormat numberFormat = null;
        if (objectiveFormat != null) {
            switch (objectiveFormat) {
                case FIXED: {
                    numberFormat = new FixedFormat((IChatBaseComponent)formatComponent);
                    break;
                }
                case STYLED: {
                    String[] arr = (String[])formatComponent;
                    EnumChatFormat[] enumChatFormats = new EnumChatFormat[arr.length];
                    for (int i = 0; i < arr.length; ++i) {
                        EnumChatFormat enumChatFormat = EnumChatFormat.b((String)arr[i]);
                        enumChatFormats[i] = enumChatFormat == null ? (i == 0 ? EnumChatFormat.g : EnumChatFormat.o) : enumChatFormat;
                    }
                    numberFormat = new StyledFormat(ChatModifier.a.a(enumChatFormats));
                    break;
                }
            }
        }
        return new ScoreboardObjective(null, objectiveName, IScoreboardCriteria.a, (IChatBaseComponent)nameComponent, IScoreboardCriteria.EnumScoreboardHealthDisplay.a, false, (NumberFormat)numberFormat);
    }

    public PacketPlayOutScoreboardObjective scoreboardObjectivePacket(Object objective, int mode) {
        return new PacketPlayOutScoreboardObjective((ScoreboardObjective)objective, mode);
    }

    public PacketPlayOutScoreboardDisplayObjective scoreboardDisplayObjectivePacket(Object objective, int slot) {
        DisplaySlot ds = DisplaySlot.a;
        if (slot != 0) {
            for (DisplaySlot displaySlot : DisplaySlot.values()) {
                if (displaySlot.a() != slot) continue;
                ds = displaySlot;
                break;
            }
        }
        return new PacketPlayOutScoreboardDisplayObjective(ds, (ScoreboardObjective)objective);
    }

    public PacketPlayOutScoreboardScore changeScoreboardScorePacket(String objectiveName, String scoreName, int score) {
        return new PacketPlayOutScoreboardScore(scoreName, objectiveName, score, IChatBaseComponent.a((String)""), null);
    }

    public PacketPlayOutScoreboardScore removeScoreboardScorePacket(String objectiveName, String scoreName, int score) {
        return new PacketPlayOutScoreboardScore(scoreName, objectiveName, score, IChatBaseComponent.a((String)""), null);
    }

    public ScoreboardObjective createScoreboardHealthObjectivePacket(String objectiveName, Object nameComponent) {
        return new ScoreboardObjective(null, objectiveName, IScoreboardCriteria.a, (IChatBaseComponent)nameComponent, IScoreboardCriteria.EnumScoreboardHealthDisplay.b, true, null);
    }

    private final class PacketReceivingListener
    extends ChannelDuplexHandler {
        private final UUID listenerPlayerId;
        private final List<Class<?>> classesToListen;

        public PacketReceivingListener(UUID listenerPlayerId, List<Class<?>> classesToListen) {
            this.listenerPlayerId = listenerPlayerId;
            this.classesToListen = classesToListen;
        }

        public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
            Class<?> receivingClass = msg.getClass();
            if (!this.classesToListen.contains(receivingClass)) {
                super.write(ctx, msg, promise);
                return;
            }
            if (receivingClass == PacketPlayOutScoreboardTeam.class) {
                this.scoreboardTeamPacket((PacketPlayOutScoreboardTeam)msg);
            } else if (receivingClass == ClientboundPlayerInfoUpdatePacket.class) {
                this.playerInfoUpdatePacket((ClientboundPlayerInfoUpdatePacket)msg);
            }
            super.write(ctx, msg, promise);
        }

        private void playerInfoUpdatePacket(ClientboundPlayerInfoUpdatePacket playerInfoPacket) {
            if (!playerInfoPacket.a().contains(ClientboundPlayerInfoUpdatePacket.a.c)) {
                return;
            }
            Player player2 = Bukkit.getPlayer((UUID)this.listenerPlayerId);
            if (player2 == null) {
                return;
            }
            for (ClientboundPlayerInfoUpdatePacket.b entry : playerInfoPacket.d()) {
                if (entry.e() != EnumGamemode.d || entry.a().equals(this.listenerPlayerId)) continue;
                ClientboundPlayerInfoUpdatePacket updatePacket = new ClientboundPlayerInfoUpdatePacket(EnumSet.of(ClientboundPlayerInfoUpdatePacket.a.c), Collections.emptyList());
                v1_20_4.this.setEntriesField(updatePacket, Collections.singletonList(new ClientboundPlayerInfoUpdatePacket.b(entry.a(), entry.b(), entry.c(), entry.d(), EnumGamemode.a, entry.f(), entry.g())));
                v1_20_4.this.sendPacket(player2, updatePacket);
            }
        }

        private void scoreboardTeamPacket(PacketPlayOutScoreboardTeam packetScoreboardTeam) {
            Collection players = packetScoreboardTeam.f();
            if (players == null || players.isEmpty()) {
                return;
            }
            packetScoreboardTeam.g().ifPresent(packetTeam -> {
                ScoreboardTeamBase.EnumNameTagVisibility enumNameTagVisibility = ScoreboardTeamBase.EnumNameTagVisibility.a((String)packetTeam.d());
                if (enumNameTagVisibility == null) {
                    enumNameTagVisibility = ScoreboardTeamBase.EnumNameTagVisibility.a;
                } else if (enumNameTagVisibility == ScoreboardTeamBase.EnumNameTagVisibility.b) {
                    return;
                }
                IChatBaseComponent prefix = packetTeam.f();
                IChatBaseComponent suffix = packetTeam.g();
                if (prefix != null && !prefix.getString().isEmpty() || suffix != null && !suffix.getString().isEmpty()) {
                    String playerName = (String)players.iterator().next();
                    for (TagTeam team : v1_20_4.this.tagTeams) {
                        if (!team.playerName.equals(playerName)) continue;
                        return;
                    }
                    Player player2 = Bukkit.getPlayer((String)playerName);
                    if (player2 == null) {
                        return;
                    }
                    ScoreboardTeamBase.EnumTeamPush enumTeamPush = ScoreboardTeamBase.EnumTeamPush.a((String)packetTeam.e());
                    if (enumTeamPush == null) {
                        enumTeamPush = ScoreboardTeamBase.EnumTeamPush.a;
                    }
                    ScoreboardTeam scoreboardTeam = new ScoreboardTeam(((CraftScoreboard)player2.getScoreboard()).getHandle(), packetTeam.a().getString());
                    scoreboardTeam.b(prefix);
                    scoreboardTeam.c(suffix);
                    scoreboardTeam.a(enumNameTagVisibility);
                    scoreboardTeam.a(enumTeamPush);
                    scoreboardTeam.a(packetTeam.c());
                    scoreboardTeam.g().add(playerName);
                    v1_20_4.this.tagTeams.add(new TagTeam(playerName, scoreboardTeam));
                }
            });
        }
    }

    private static class EmptyPacketListener
    extends PlayerConnection {
        public EmptyPacketListener(MinecraftServer minecraftserver, NetworkManager networkmanager, EntityPlayer entityplayer, CommonListenerCookie commonlistenercookie) {
            super(minecraftserver, networkmanager, entityplayer, commonlistenercookie);
        }

        public void h() {
        }

        public void b(Packet<?> packet) {
        }
    }

    private static class EmptyConnection
    extends NetworkManager {
        private Field packetListenerField;
        private Field disconnectListenerField;

        public EmptyConnection(EnumProtocolDirection enumprotocoldirection) {
            super(enumprotocoldirection);
            this.n = new EmptyChannel(null);
            this.o = new SocketAddress(){};
        }

        public void c() {
        }

        public boolean k() {
            return true;
        }

        public void a(Packet packet) {
        }

        public void a(Packet packet, PacketSendListener genericfuturelistener) {
        }

        public void a(Packet packet, PacketSendListener genericfuturelistener, boolean flag) {
        }

        public void a(PacketListener pl) {
            if (this.packetListenerField == null) {
                try {
                    this.packetListenerField = NetworkManager.class.getDeclaredField("q");
                    this.packetListenerField.setAccessible(true);
                }
                catch (NoSuchFieldException ex) {
                    ex.printStackTrace();
                }
            }
            try {
                this.packetListenerField.set((Object)this, pl);
            }
            catch (IllegalAccessException ex) {
                ex.printStackTrace();
            }
            if (this.disconnectListenerField == null) {
                try {
                    this.disconnectListenerField = NetworkManager.class.getDeclaredField("p");
                    this.disconnectListenerField.setAccessible(true);
                }
                catch (NoSuchFieldException ex) {
                    ex.printStackTrace();
                }
            }
            try {
                this.disconnectListenerField.set((Object)this, null);
            }
            catch (IllegalAccessException ex) {
                ex.printStackTrace();
            }
        }
    }

    private static class TagTeam {
        public final String playerName;
        public final ScoreboardTeam scoreboardTeam;

        public TagTeam(String playerName, ScoreboardTeam scoreboardTeam) {
            this.playerName = playerName;
            this.scoreboardTeam = scoreboardTeam;
        }

        public boolean equals(Object other) {
            return other != null && this.getClass() == other.getClass() && this.playerName.equals(((TagTeam)other).playerName);
        }

        public int hashCode() {
            return Objects.hash(this.playerName);
        }
    }

    private static class EmptyChannel
    extends AbstractChannel {
        private final ChannelConfig config = new DefaultChannelConfig((Channel)this);

        protected EmptyChannel(Channel parent) {
            super(parent);
        }

        protected AbstractChannel.AbstractUnsafe newUnsafe() {
            return null;
        }

        protected boolean isCompatible(EventLoop loop) {
            return false;
        }

        protected SocketAddress localAddress0() {
            return null;
        }

        protected SocketAddress remoteAddress0() {
            return null;
        }

        protected void doBind(SocketAddress localAddress) {
        }

        protected void doDisconnect() {
        }

        protected void doClose() {
        }

        protected void doBeginRead() {
        }

        protected void doWrite(ChannelOutboundBuffer in) {
        }

        public ChannelConfig config() {
            this.config.setAutoRead(true);
            return this.config;
        }

        public boolean isOpen() {
            return false;
        }

        public boolean isActive() {
            return false;
        }

        public ChannelMetadata metadata() {
            return new ChannelMetadata(true);
        }
    }
}

