/*
 * Decompiled with CFR 0.152.
 */
package hu.montlikadani.v1_18_2;

import com.mojang.authlib.GameProfile;
import hu.montlikadani.api.IPacketNM;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutPlayerInfo;
import net.minecraft.network.protocol.game.PacketPlayOutPlayerListHeaderFooter;
import net.minecraft.network.protocol.game.PacketPlayOutScoreboardDisplayObjective;
import net.minecraft.network.protocol.game.PacketPlayOutScoreboardObjective;
import net.minecraft.network.protocol.game.PacketPlayOutScoreboardScore;
import net.minecraft.network.protocol.game.PacketPlayOutScoreboardTeam;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ScoreboardServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.world.level.EnumGamemode;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.ScoreboardObjective;
import net.minecraft.world.scores.ScoreboardTeam;
import net.minecraft.world.scores.ScoreboardTeamBase;
import net.minecraft.world.scores.criteria.IScoreboardCriteria;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_18_R2.CraftServer;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_18_R2.scoreboard.CraftScoreboard;
import org.bukkit.entity.Player;
import org.bukkit.scoreboard.Team;

public final class v1_18_2
implements IPacketNM {
    private final Scoreboard scoreboard = new Scoreboard();
    private final Set<TagTeam> tagTeams = new HashSet<TagTeam>();

    @Override
    public void sendPacket(Player player2, Object packet) {
        this.getPlayerHandle((Player)player2).b.a((Packet)packet);
    }

    private void sendPacket(EntityPlayer player2, Packet<?> packet) {
        player2.b.a(packet);
    }

    @Override
    public void addPlayerChannelListener(Player player2, List<Class<?>> classesToListen) {
        EntityPlayer entityPlayer = this.getPlayerHandle(player2);
        if (entityPlayer.b.a.m.pipeline().get("TLPacketInjector") == null) {
            try {
                entityPlayer.b.a.m.pipeline().addBefore("packet_handler", "TLPacketInjector", (ChannelHandler)new PacketReceivingListener(player2.getUniqueId(), classesToListen));
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
        }
    }

    @Override
    public void removePlayerChannelListener(Player player2) {
        EntityPlayer entityPlayer = this.getPlayerHandle(player2);
        if (entityPlayer.b.a.m != null) {
            try {
                entityPlayer.b.a.m.pipeline().remove("TLPacketInjector");
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
        }
    }

    public EntityPlayer getPlayerHandle(Player player2) {
        return ((CraftPlayer)player2).getHandle();
    }

    public IChatBaseComponent fromJson(String json) {
        return IChatBaseComponent.ChatSerializer.a((String)json);
    }

    @Override
    public void sendTabTitle(Player player2, Object header, Object footer) {
        this.sendPacket(player2, new PacketPlayOutPlayerListHeaderFooter((IChatBaseComponent)header, (IChatBaseComponent)footer));
    }

    private MinecraftServer minecraftServer() {
        return ((CraftServer)Bukkit.getServer()).getServer();
    }

    public EntityPlayer getNewEntityPlayer(GameProfile profile) {
        MinecraftServer server = this.minecraftServer();
        return new EntityPlayer(server, server.D(), profile);
    }

    @Override
    public double[] serverTps() {
        return this.minecraftServer().recentTps;
    }

    public PacketPlayOutPlayerInfo updateDisplayNamePacket(Object entityPlayer, Object component, boolean listName) {
        if (listName) {
            this.setListName(entityPlayer, component);
        }
        return new PacketPlayOutPlayerInfo(PacketPlayOutPlayerInfo.EnumPlayerInfoAction.d, new EntityPlayer[]{(EntityPlayer)entityPlayer});
    }

    @Override
    public void setListName(Object entityPlayer, Object component) {
        ((EntityPlayer)entityPlayer).listName = (IChatBaseComponent)component;
    }

    public PacketPlayOutPlayerInfo newPlayerInfoUpdatePacketAdd(Object ... entityPlayers) {
        ArrayList<EntityPlayer> players = new ArrayList<EntityPlayer>(entityPlayers.length);
        for (Object one : entityPlayers) {
            players.add((EntityPlayer)one);
        }
        return new PacketPlayOutPlayerInfo(PacketPlayOutPlayerInfo.EnumPlayerInfoAction.a, players);
    }

    public PacketPlayOutPlayerInfo updateLatency(Object entityPlayer) {
        return new PacketPlayOutPlayerInfo(PacketPlayOutPlayerInfo.EnumPlayerInfoAction.c, new EntityPlayer[]{(EntityPlayer)entityPlayer});
    }

    public PacketPlayOutPlayerInfo removeEntityPlayers(Object ... entityPlayers) {
        ArrayList<EntityPlayer> players = new ArrayList<EntityPlayer>(entityPlayers.length);
        for (Object one : entityPlayers) {
            players.add((EntityPlayer)one);
        }
        return new PacketPlayOutPlayerInfo(PacketPlayOutPlayerInfo.EnumPlayerInfoAction.e, players);
    }

    @Override
    public void setInfoData(Object info, UUID id, int ping, Object component) {
        PacketPlayOutPlayerInfo update = (PacketPlayOutPlayerInfo)info;
        for (PacketPlayOutPlayerInfo.PlayerInfoData playerInfo : update.b()) {
            if (!playerInfo.a().getId().equals(id)) continue;
            this.setEntriesField(update, Collections.singletonList(new PacketPlayOutPlayerInfo.PlayerInfoData(playerInfo.a(), ping == -2 ? playerInfo.b() : ping, playerInfo.c(), (IChatBaseComponent)component)));
            break;
        }
    }

    private void setEntriesField(PacketPlayOutPlayerInfo playerInfoPacket, List<PacketPlayOutPlayerInfo.PlayerInfoData> list) {
        playerInfoPacket.b().clear();
        playerInfoPacket.b().addAll(list);
    }

    @Override
    public void createBoardTeam(String teamName, Player player2, boolean followNameTagVisibility) {
        ScoreboardTeam playerTeam = this.scoreboard.g(teamName);
        this.scoreboard.a(player2.getName(), playerTeam);
        if (followNameTagVisibility) {
            ScoreboardTeamBase.EnumNameTagVisibility visibility = null;
            block4: for (Team team : player2.getScoreboard().getTeams()) {
                Team.OptionStatus optionStatus = team.getOption(Team.Option.NAME_TAG_VISIBILITY);
                switch (optionStatus) {
                    case FOR_OTHER_TEAMS: {
                        visibility = ScoreboardTeamBase.EnumNameTagVisibility.c;
                        continue block4;
                    }
                    case FOR_OWN_TEAM: {
                        visibility = ScoreboardTeamBase.EnumNameTagVisibility.d;
                        continue block4;
                    }
                }
                if (optionStatus == Team.OptionStatus.ALWAYS) continue;
                visibility = ScoreboardTeamBase.EnumNameTagVisibility.b;
            }
            if (visibility != null) {
                playerTeam.a(visibility);
            }
        }
        if (this.tagTeams.isEmpty()) {
            for (Player one : Bukkit.getOnlinePlayers()) {
                this.sendPacket(this.getPlayerHandle(one), (Packet<?>)PacketPlayOutScoreboardTeam.a((ScoreboardTeam)playerTeam, (boolean)true));
            }
        } else {
            for (TagTeam tagTeam : this.tagTeams) {
                if (!tagTeam.playerName.equals(player2.getName())) continue;
                tagTeam.scoreboardTeam.a(playerTeam.c());
                tagTeam.scoreboardTeam.a(playerTeam.j());
                for (Player one : Bukkit.getOnlinePlayers()) {
                    EntityPlayer handle = this.getPlayerHandle(one);
                    this.sendPacket(handle, (Packet<?>)PacketPlayOutScoreboardTeam.a((ScoreboardTeam)playerTeam, (boolean)true));
                    this.sendPacket(handle, (Packet<?>)PacketPlayOutScoreboardTeam.a((ScoreboardTeam)tagTeam.scoreboardTeam, (boolean)true));
                }
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PacketPlayOutScoreboardTeam unregisterBoardTeamPacket(String teamName) {
        Collection teams;
        Collection collection = teams = this.scoreboard.g();
        synchronized (collection) {
            for (ScoreboardTeam team : new ArrayList(teams)) {
                if (!team.b().equals(teamName)) continue;
                this.scoreboard.d(team);
                return PacketPlayOutScoreboardTeam.a((ScoreboardTeam)team);
            }
        }
        return null;
    }

    public ScoreboardObjective createObjectivePacket(String objectiveName, Object nameComponent, IPacketNM.ObjectiveFormat objectiveFormat, Object formatComponent) {
        return new ScoreboardObjective(null, objectiveName, IScoreboardCriteria.a, (IChatBaseComponent)nameComponent, IScoreboardCriteria.EnumScoreboardHealthDisplay.a);
    }

    public PacketPlayOutScoreboardObjective scoreboardObjectivePacket(Object objective, int mode) {
        return new PacketPlayOutScoreboardObjective((ScoreboardObjective)objective, mode);
    }

    public PacketPlayOutScoreboardDisplayObjective scoreboardDisplayObjectivePacket(Object objective, int slot) {
        return new PacketPlayOutScoreboardDisplayObjective(slot, (ScoreboardObjective)objective);
    }

    public PacketPlayOutScoreboardScore changeScoreboardScorePacket(String objectiveName, String scoreName, int score) {
        return new PacketPlayOutScoreboardScore(ScoreboardServer.Action.a, objectiveName, scoreName, score);
    }

    public PacketPlayOutScoreboardScore removeScoreboardScorePacket(String objectiveName, String scoreName, int score) {
        return new PacketPlayOutScoreboardScore(ScoreboardServer.Action.b, objectiveName, scoreName, score);
    }

    public ScoreboardObjective createScoreboardHealthObjectivePacket(String objectiveName, Object nameComponent) {
        return new ScoreboardObjective(null, objectiveName, IScoreboardCriteria.a, (IChatBaseComponent)nameComponent, IScoreboardCriteria.EnumScoreboardHealthDisplay.b);
    }

    private final class PacketReceivingListener
    extends ChannelDuplexHandler {
        private final UUID listenerPlayerId;
        private final List<Class<?>> classesToListen;

        public PacketReceivingListener(UUID listenerPlayerId, List<Class<?>> classesToListen) {
            this.listenerPlayerId = listenerPlayerId;
            this.classesToListen = classesToListen;
        }

        public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
            Class<?> receivingClass = msg.getClass();
            if (!this.classesToListen.contains(receivingClass)) {
                super.write(ctx, msg, promise);
                return;
            }
            if (receivingClass == PacketPlayOutScoreboardTeam.class) {
                this.scoreboardTeamPacket((PacketPlayOutScoreboardTeam)msg);
            } else if (receivingClass == PacketPlayOutPlayerInfo.class) {
                this.playerInfoPacket((PacketPlayOutPlayerInfo)msg);
            }
            super.write(ctx, msg, promise);
        }

        private void playerInfoPacket(PacketPlayOutPlayerInfo playerInfoPacket) {
            if (playerInfoPacket.c() != PacketPlayOutPlayerInfo.EnumPlayerInfoAction.b) {
                return;
            }
            Player player2 = Bukkit.getPlayer((UUID)this.listenerPlayerId);
            if (player2 == null) {
                return;
            }
            for (PacketPlayOutPlayerInfo.PlayerInfoData entry : playerInfoPacket.b()) {
                if (entry.c() != EnumGamemode.d || entry.a().getId().equals(this.listenerPlayerId)) continue;
                PacketPlayOutPlayerInfo updatePacket = new PacketPlayOutPlayerInfo(PacketPlayOutPlayerInfo.EnumPlayerInfoAction.c, Collections.emptyList());
                v1_18_2.this.setEntriesField(updatePacket, Collections.singletonList(new PacketPlayOutPlayerInfo.PlayerInfoData(entry.a(), entry.b(), EnumGamemode.a, entry.d())));
                v1_18_2.this.sendPacket(player2, updatePacket);
            }
        }

        private void scoreboardTeamPacket(PacketPlayOutScoreboardTeam packetScoreboardTeam) {
            Collection players = packetScoreboardTeam.e();
            if (players == null || players.isEmpty()) {
                return;
            }
            packetScoreboardTeam.f().ifPresent(packetTeam -> {
                ScoreboardTeamBase.EnumNameTagVisibility enumNameTagVisibility = ScoreboardTeamBase.EnumNameTagVisibility.a((String)packetTeam.d());
                if (enumNameTagVisibility == null) {
                    enumNameTagVisibility = ScoreboardTeamBase.EnumNameTagVisibility.a;
                } else if (enumNameTagVisibility == ScoreboardTeamBase.EnumNameTagVisibility.b) {
                    return;
                }
                IChatBaseComponent prefix = packetTeam.f();
                IChatBaseComponent suffix = packetTeam.g();
                if (prefix != null && !prefix.getString().isEmpty() || suffix != null && !suffix.getString().isEmpty()) {
                    String playerName = (String)players.iterator().next();
                    for (TagTeam team : v1_18_2.this.tagTeams) {
                        if (!team.playerName.equals(playerName)) continue;
                        return;
                    }
                    Player player2 = Bukkit.getPlayer((String)playerName);
                    if (player2 == null) {
                        return;
                    }
                    ScoreboardTeamBase.EnumTeamPush enumTeamPush = ScoreboardTeamBase.EnumTeamPush.a((String)packetTeam.e());
                    if (enumTeamPush == null) {
                        enumTeamPush = ScoreboardTeamBase.EnumTeamPush.a;
                    }
                    ScoreboardTeam scoreboardTeam = new ScoreboardTeam(((CraftScoreboard)player2.getScoreboard()).getHandle(), packetTeam.a().getString());
                    scoreboardTeam.b(prefix);
                    scoreboardTeam.c(suffix);
                    scoreboardTeam.a(enumNameTagVisibility);
                    scoreboardTeam.a(enumTeamPush);
                    scoreboardTeam.a(packetTeam.c());
                    scoreboardTeam.g().add(playerName);
                    v1_18_2.this.tagTeams.add(new TagTeam(playerName, scoreboardTeam));
                }
            });
        }
    }

    private static class TagTeam {
        public final String playerName;
        public final ScoreboardTeam scoreboardTeam;

        public TagTeam(String playerName, ScoreboardTeam scoreboardTeam) {
            this.playerName = playerName;
            this.scoreboardTeam = scoreboardTeam;
        }

        public boolean equals(Object other) {
            return other != null && this.getClass() == other.getClass() && this.playerName.equals(((TagTeam)other).playerName);
        }

        public int hashCode() {
            return Objects.hash(this.playerName);
        }
    }
}

