/*
 * Decompiled with CFR 0.152.
 */
package hu.montlikadani.tablist.utils.variables;

import hu.montlikadani.api.Pair;
import hu.montlikadani.api.TicksPerSecondType;
import hu.montlikadani.tablist.FoliaPack;
import hu.montlikadani.tablist.Global;
import hu.montlikadani.tablist.TabList;
import hu.montlikadani.tablist.api.TabListAPI;
import hu.montlikadani.tablist.config.constantsLoader.ConfigValues;
import hu.montlikadani.tablist.logicalOperators.LogicalNode;
import hu.montlikadani.tablist.user.TabListUser;
import hu.montlikadani.tablist.utils.PluginUtils;
import hu.montlikadani.tablist.utils.Util;
import hu.montlikadani.tablist.utils.operators.OverriddenOperatorNodes;
import hu.montlikadani.tablist.utils.variables.TimedVariable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.function.Supplier;
import java.util.logging.Level;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.World;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public final class Variables {
    private final TabList plugin;
    private final List<LogicalNode> nodes = new ArrayList<LogicalNode>();
    private final Set<TimedVariable> timedVariables = new HashSet<TimedVariable>(8);
    private final boolean entityAttributeSupported;
    private String fixedTpsString;

    public Variables(TabList plugin) {
        boolean att;
        this.plugin = plugin;
        try {
            Attribute.GENERIC_MAX_HEALTH.name();
            att = true;
        }
        catch (Error err) {
            att = false;
        }
        this.entityAttributeSupported = att;
    }

    public void load() {
        LogicalNode node;
        this.nodes.clear();
        this.timedVariables.clear();
        if (ConfigValues.isPingFormatEnabled()) {
            for (String f : ConfigValues.getPingColorFormats()) {
                if (f.isEmpty() || (node = LogicalNode.newNode(LogicalNode.NodeType.PING).parseInput(f)).getCondition() == null) continue;
                this.nodes.add(node);
            }
        }
        if (ConfigValues.isTpsFormatEnabled()) {
            for (String f : ConfigValues.getTpsColorFormats()) {
                if (f.isEmpty() || (node = new OverriddenOperatorNodes(LogicalNode.NodeType.TPS).parseInput(f)).getCondition() == null) continue;
                this.nodes.add(node);
            }
        }
        LogicalNode.reverseOrderOfArray(this.nodes);
        if (ConfigValues.getDateFormat() != null) {
            this.timedVariables.add(new TimedVariable("date", 3, variable -> this.getTimeAsString(ConfigValues.getDateFormat())));
        }
        this.timedVariables.add(new TimedVariable("online-players", 2, variable -> {
            int players = PluginUtils.countVanishedPlayers();
            if (ConfigValues.isCountFakePlayersToOnlinePlayers()) {
                players += this.plugin.getFakePlayerHandler().fakePlayers.size();
            }
            return Integer.toString(players);
        }));
        this.timedVariables.add(new TimedVariable("max-players", 20, variable -> Integer.toString(this.plugin.getServer().getMaxPlayers())));
        this.timedVariables.add(new TimedVariable("vanished-players", 2, variable -> {
            int vanishedPlayers = PluginUtils.getVanishedPlayers();
            return vanishedPlayers == 0 ? "0" : Integer.toString(vanishedPlayers);
        }));
        this.timedVariables.add(new TimedVariable("motd", 10, variable -> this.plugin.getComplement().motd()));
        this.timedVariables.add(new TimedVariable("fake-players", 3, variable -> {
            int size = this.plugin.getFakePlayerHandler().fakePlayers.size();
            return size == 0 ? "0" : Integer.toString(size);
        }));
        this.timedVariables.add(new TimedVariable("staff-online", 3, variable -> {
            int staffs = 0;
            for (TabListUser user : this.plugin.getUsers()) {
                Player player2 = user.getPlayer();
                if (player2 == null || !PluginUtils.hasPermission(player2, "tablist.onlinestaff") || !ConfigValues.isCountVanishedStaff() && PluginUtils.isVanished(player2)) continue;
                ++staffs;
            }
            return staffs == 0 ? "0" : Integer.toString(staffs);
        }));
        this.timedVariables.add(new TimedVariable("tps-overflow", 3, variable -> this.roundTpsDigits(TabListAPI.getTPS()[0])));
        this.timedVariables.add(new TimedVariable("tps", 3, variable -> this.tpsDigits(TabListAPI.getTPS()[0])));
        if (this.plugin.hasPapi()) {
            this.timedVariables.add(new TimedVariable("server_total_chunks", 30, variable -> Integer.toString(this.getWorldChunks())));
            this.timedVariables.add(new TimedVariable("server_total_living_entities", 10, variable -> Integer.toString(this.getLivingEntities())));
            this.timedVariables.add(new TimedVariable("server_total_entities", 10, variable -> Integer.toString(this.getTotalEntities())));
        }
    }

    public String replaceMiscVariables(String str) {
        str = str.replace("%servertype%", this.plugin.getServer().getName());
        str = str.replace("%mc-version%", this.plugin.getServer().getBukkitVersion());
        str = Global.replaceToUnicodeSymbol(str);
        return Util.applyTextFormat(str);
    }

    public String replaceVariables(Player player2, String str) {
        if (str.isEmpty()) {
            return str;
        }
        for (TimedVariable timedVariable : this.timedVariables) {
            if (timedVariable.canReplace(str)) {
                str = str.replace(timedVariable.fullName, timedVariable.keptValue(timedVariable.function.apply(timedVariable)));
                continue;
            }
            if (timedVariable.getKeptValue() == null) continue;
            str = str.replace(timedVariable.fullName, timedVariable.getKeptValue());
        }
        if (player2 != null) {
            str = this.setPlayerPlaceholders(player2, str);
        }
        if (ConfigValues.getTimeFormat() != null) {
            str = Global.replace(str, "%server-time%", () -> this.getTimeAsString(ConfigValues.getTimeFormat()));
        }
        long megaBytes = 0x100000L;
        Runtime runtime = Runtime.getRuntime();
        str = Global.replace(str, "%server-ram-free%", () -> Long.toString(runtime.freeMemory() / 0x100000L));
        str = Global.replace(str, "%server-ram-max%", () -> Long.toString(runtime.maxMemory() / 0x100000L));
        str = Global.replace(str, "%server-ram-used%", () -> Long.toString((runtime.totalMemory() - runtime.freeMemory()) / 0x100000L));
        for (TicksPerSecondType one : TicksPerSecondType.VALUES) {
            str = Global.replace(str, "%tps-overflow-" + one.type + "%", () -> {
                switch (one) {
                    case MINUTES_1: {
                        return this.roundTpsDigits(TabListAPI.getTPS()[0]);
                    }
                    case MINUTES_5: {
                        return this.roundTpsDigits(TabListAPI.getTPS()[1]);
                    }
                    case MINUTES_15: {
                        return this.roundTpsDigits(TabListAPI.getTPS()[2]);
                    }
                }
                return "no value by this type";
            });
            str = Global.replace(str, "%tps-" + one.type + "%", () -> {
                switch (one) {
                    case MINUTES_1: {
                        return this.tpsDigits(TabListAPI.getTPS()[0]);
                    }
                    case MINUTES_5: {
                        return this.tpsDigits(TabListAPI.getTPS()[1]);
                    }
                    case MINUTES_15: {
                        return this.tpsDigits(TabListAPI.getTPS()[2]);
                    }
                }
                return "no value by this type";
            });
            if (!this.plugin.isFoliaServer()) continue;
            str = Global.replace(str, "%folia-current-region-average-tps-" + one.type + "%", () -> {
                Pair tickReportData = FoliaPack.tickReportDataByType((TicksPerSecondType)one);
                return (Double)tickReportData.key == -1.0 ? (String)tickReportData.value : this.tpsDigits((Double)tickReportData.key);
            });
        }
        return str;
    }

    private String tpsDigits(double tps) {
        String string = tps >= 21.0 ? (this.fixedTpsString == null ? (this.fixedTpsString = this.roundTpsDigits(20.0)) : this.fixedTpsString) : this.roundTpsDigits(tps);
        return string;
    }

    String setPlayerPlaceholders(Player player2, String text) {
        if (this.plugin.hasPapi()) {
            text = PlaceholderAPI.setPlaceholders((Player)player2, (String)text);
        }
        text = Global.replace(text, "%player%", () -> ((Player)player2).getName());
        text = Global.replace(text, "%world%", () -> player2.getWorld().getName());
        text = Global.replace(text, "%player-gamemode%", () -> player2.getGameMode().name());
        text = Global.replace(text, "%player-displayname%", () -> this.plugin.getComplement().displayName(player2));
        text = Global.replace(text, "%player-health%", () -> Double.toString(player2.getHealth()));
        text = Global.replace(text, "%ping%", () -> this.formatPing(TabListAPI.getPing(player2)));
        text = Global.replace(text, "%exp-to-level%", () -> Integer.toString(player2.getExpToLevel()));
        text = Global.replace(text, "%level%", () -> Integer.toString(player2.getLevel()));
        text = Global.replace(text, "%xp%", () -> Float.toString(player2.getExp()));
        text = Global.replace(text, "%light-level%", () -> Integer.toString(player2.getLocation().getBlock().getLightLevel()));
        text = Global.replace(text, "%player-max-health%", () -> {
            if (this.entityAttributeSupported) {
                AttributeInstance attribute = player2.getAttribute(Attribute.GENERIC_MAX_HEALTH);
                return attribute == null ? "" : Double.toString(attribute.getDefaultValue());
            }
            return Double.toString(player2.getMaxHealth());
        });
        text = Global.replace(text, "%ip-address%", () -> {
            String hostAddress;
            InetAddress inetAddress;
            InetSocketAddress address = player2.getAddress();
            if (address != null && (inetAddress = address.getAddress()) != null && (hostAddress = inetAddress.getHostAddress()) != null) {
                return hostAddress;
            }
            return "";
        });
        return text;
    }

    private String roundTpsDigits(double value) {
        if (!ConfigValues.isTpsFormatEnabled() || this.nodes.isEmpty()) {
            return Double.toString(value);
        }
        int digits = ConfigValues.getTpsDigits();
        value = (double)Math.round(value * (double)digits) / (double)digits;
        return LogicalNode.parseCondition(value, LogicalNode.NodeType.TPS, this.nodes).toString();
    }

    private String formatPing(int ping) {
        if (!ConfigValues.isPingFormatEnabled() || this.nodes.isEmpty()) {
            return Integer.toString(ping);
        }
        return LogicalNode.parseCondition(ping, LogicalNode.NodeType.PING, this.nodes).toString();
    }

    private String getTimeAsString(DateTimeFormatter formatterPattern) {
        return (ConfigValues.getTimeZone() == null ? LocalDateTime.now() : LocalDateTime.now(ConfigValues.getTimeZone().toZoneId())).format(formatterPattern);
    }

    private int getWorldChunks() {
        return this.callSyncMethod(() -> {
            int loadedChunks = 0;
            for (World world : this.plugin.getServer().getWorlds()) {
                loadedChunks += world.getLoadedChunks().length;
            }
            return loadedChunks;
        });
    }

    private int getLivingEntities() {
        return this.callSyncMethod(() -> {
            int livingEntities = 0;
            for (World world : this.plugin.getServer().getWorlds()) {
                livingEntities += world.getLivingEntities().size();
            }
            return livingEntities;
        });
    }

    private int getTotalEntities() {
        return this.callSyncMethod(() -> {
            int allEntities = 0;
            for (World world : this.plugin.getServer().getWorlds()) {
                allEntities += world.getEntities().size();
            }
            return allEntities;
        });
    }

    private <V> V callSyncMethod(Supplier<V> supplier) {
        try {
            return this.plugin.getServer().getScheduler().callSyncMethod((Plugin)this.plugin, supplier::get).get();
        }
        catch (InterruptedException | ExecutionException ex) {
            Util.printTrace(Level.SEVERE, (Plugin)this.plugin, ex.getMessage(), ex);
            return supplier.get();
        }
    }
}

