/*
 * Decompiled with CFR 0.152.
 */
package hu.montlikadani.tablist.utils.scheduler;

import hu.montlikadani.tablist.utils.scheduler.TLScheduler;
import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.util.concurrent.TimeUnit;
import org.bukkit.Location;
import org.bukkit.plugin.Plugin;

public final class FoliaScheduler
implements TLScheduler {
    private final Plugin plugin;
    private ScheduledTask scheduledTask;

    public FoliaScheduler(Plugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public TLScheduler submitAsync(Runnable task, long initialDelay, long period) {
        this.scheduledTask = this.plugin.getServer().getAsyncScheduler().runAtFixedRate(this.plugin, consumer -> task.run(), initialDelay, period * 20L, TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public void runDelayed(Runnable task, Location location, long delay) {
        this.plugin.getServer().getRegionScheduler().runDelayed(this.plugin, location, consumer -> task.run(), delay);
    }

    @Override
    public void submitSync(Runnable runnable) {
        this.plugin.getServer().getGlobalRegionScheduler().execute(this.plugin, runnable);
    }

    @Override
    public void runTaskAsynchronously(Runnable task) {
        this.plugin.getServer().getAsyncScheduler().runNow(this.plugin, schedule -> task.run());
    }

    @Override
    public void cancelTask() {
        if (this.scheduledTask != null) {
            this.scheduledTask.cancel();
        }
    }
}

