/*
 * Decompiled with CFR 0.152.
 */
package hu.montlikadani.tablist.utils.scheduler;

import hu.montlikadani.tablist.utils.scheduler.TLScheduler;
import org.bukkit.Location;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public final class BukkitScheduler
implements TLScheduler {
    private final Plugin plugin;
    private BukkitTask bukkitTask;

    public BukkitScheduler(Plugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public BukkitScheduler submitAsync(Runnable task, long initialDelay, long period) {
        this.bukkitTask = this.plugin.getServer().getScheduler().runTaskTimerAsynchronously(this.plugin, task, initialDelay, period);
        return this;
    }

    @Override
    public void runDelayed(Runnable task, Location location, long delay) {
        this.plugin.getServer().getScheduler().runTaskLater(this.plugin, task, delay);
    }

    @Override
    public void submitSync(Runnable runnable) {
        if (this.plugin.isEnabled() && !this.plugin.getServer().isPrimaryThread()) {
            this.plugin.getServer().getScheduler().runTask(this.plugin, runnable);
        }
    }

    @Override
    public void runTaskAsynchronously(Runnable task) {
        this.plugin.getServer().getScheduler().runTaskAsynchronously(this.plugin, task);
    }

    @Override
    public void cancelTask() {
        if (this.bukkitTask != null) {
            this.bukkitTask.cancel();
        }
    }
}

