/*
 * Decompiled with CFR 0.152.
 */
package hu.montlikadani.tablist.utils.reflection;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import hu.montlikadani.tablist.Global;
import hu.montlikadani.tablist.packets.PacketNM;
import hu.montlikadani.tablist.tablist.TabText;
import hu.montlikadani.tablist.utils.reflection.MColor;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.NamespacedKey;

public final class JsonComponent {
    public static final Gson GSON = new GsonBuilder().disableHtmlEscaping().create();
    private final ArrayList<JsonObject> jsonList = new ArrayList(10);
    private Map<String, String> fonts;
    private Object emptyJson;

    Object parseProperty(String text, List<TabText.JsonElementData> existingJson) {
        if (text.isEmpty()) {
            if (this.emptyJson == null) {
                this.emptyJson = PacketNM.NMS_PACKET.fromJson(GSON.toJson((Object)""));
            }
            return this.emptyJson;
        }
        this.jsonList.clear();
        this.jsonList.trimToSize();
        text = text.replace('\u00a7', '&').replace("&#", "#").replace("&x", "#");
        int length = text.length();
        int index = 0;
        MColor lastColor = null;
        JsonObject obj = new JsonObject();
        StringBuilder builder = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            char charAt;
            int j;
            int count = i + 13;
            for (j = i + 1; j < count && j < length && text.charAt(j) == '&'; j += 2) {
            }
            if (j == count) {
                text = Global.replaceFrom(text, i, "&", "", 6);
                length = text.length();
            }
            if ((charAt = text.charAt(i)) == '[' && existingJson != null && index < existingJson.size() && text.charAt(i + 1) == '\"' && text.charAt(i + 2) == '\"' && text.charAt(i + 3) == ',' && text.charAt(i + 4) == '{') {
                if (builder.length() != 0) {
                    obj.addProperty("text", builder.toString());
                    this.jsonList.add(obj);
                    builder = new StringBuilder();
                }
                obj = new JsonObject();
                obj.addProperty("text", "");
                TabText.JsonElementDataNew data = (TabText.JsonElementDataNew)existingJson.get(index);
                obj.add("extra", data.element);
                this.jsonList.add(obj);
                i += data.jsonLength - 1;
                obj = new JsonObject();
                ++index;
                continue;
            }
            if (charAt == '&') {
                int next = i + 1;
                if (next < length) {
                    lastColor = MColor.byCode(text.charAt(next));
                }
                if (lastColor != null) {
                    if (builder.length() != 0) {
                        obj.addProperty("text", builder.toString());
                        this.jsonList.add(obj);
                        obj = new JsonObject();
                        builder = new StringBuilder();
                    }
                    if (lastColor != MColor.WHITE && lastColor != MColor.RESET) {
                        if (lastColor.formatter) {
                            obj.addProperty(lastColor.propertyName, Boolean.valueOf(true));
                        } else {
                            obj.addProperty("color", lastColor.propertyName);
                        }
                    }
                    i = next;
                    continue;
                }
                builder.append(charAt);
                continue;
            }
            if (charAt == '#') {
                int end = i + 7;
                if (end >= length || !this.validateHex(text, i + 1, end)) {
                    builder.append(charAt);
                    continue;
                }
                if (builder.length() != 0) {
                    obj.addProperty("text", builder.toString());
                    this.jsonList.add(obj);
                    builder = new StringBuilder();
                }
                obj = new JsonObject();
                obj.addProperty("color", text.substring(i, end));
                i += 6;
                continue;
            }
            if (charAt == '{') {
                int closeIndex;
                int closeIndex2;
                int fromIndex = i + 10;
                if (text.regionMatches(true, i, "{gradient=", 0, 10) && (closeIndex2 = text.indexOf(125, fromIndex)) != -1) {
                    Color[] colors = new Color[2];
                    int co = 0;
                    for (String one : text.substring(fromIndex, closeIndex2).split(":", 2)) {
                        if (one.isEmpty() || one.charAt(0) != '#' || !this.validateHex(one, 1, one.length())) {
                            closeIndex2 = -1;
                            break;
                        }
                        colors[co] = Color.decode(one);
                        ++co;
                    }
                    if (co == 2) {
                        int g = closeIndex2 + 1;
                        int endIndex = text.indexOf("{/gradient}", g);
                        if (endIndex == -1) continue;
                        Color startColor = colors[0];
                        Color endColor = colors[1];
                        if (builder.length() != 0) {
                            obj.addProperty("text", builder.toString());
                            this.jsonList.add(obj);
                            builder = new StringBuilder();
                        }
                        obj = new JsonObject();
                        while (g < endIndex) {
                            obj.addProperty("text", Character.valueOf(text.charAt(g)));
                            double perc = (double)g / (double)endIndex;
                            int red = (int)((double)startColor.getRed() + perc * (double)(endColor.getRed() - startColor.getRed()));
                            int green = (int)((double)startColor.getGreen() + perc * (double)(endColor.getGreen() - startColor.getGreen()));
                            int blue = (int)((double)startColor.getBlue() + perc * (double)(endColor.getBlue() - startColor.getBlue()));
                            obj.addProperty("color", String.format("#%06x", (red & 0xFF) << 16 | (green & 0xFF) << 8 | blue & 0xFF));
                            if (lastColor != null && lastColor.formatter) {
                                obj.addProperty(lastColor.propertyName, Boolean.valueOf(true));
                            }
                            this.jsonList.add(obj);
                            obj = new JsonObject();
                            ++g;
                        }
                        lastColor = null;
                        i = endIndex + 10;
                        continue;
                    }
                }
                fromIndex = i + 6;
                String font = "";
                if (text.regionMatches(true, i, "{font=", 0, 6) && (closeIndex = text.indexOf(125, fromIndex)) != -1) {
                    String res;
                    if (this.fonts == null) {
                        this.fonts = new HashMap<String, String>(1);
                    }
                    if ((res = this.fonts.computeIfAbsent(text.substring(fromIndex, closeIndex), key -> {
                        try {
                            return NamespacedKey.minecraft((String)key).toString();
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            return null;
                        }
                    })) != null) {
                        font = res;
                    }
                } else if (text.regionMatches(true, i, "{/font", 0, 6) && (closeIndex = text.indexOf(125, fromIndex)) != -1) {
                    font = this.fonts.computeIfAbsent("default", s -> NamespacedKey.minecraft((String)s).toString());
                } else {
                    builder.append(charAt);
                    continue;
                }
                if (builder.length() != 0) {
                    obj.addProperty("text", builder.toString());
                    this.jsonList.add(obj);
                    builder = new StringBuilder();
                }
                obj = new JsonObject();
                obj.addProperty("font", font);
                i = closeIndex;
                continue;
            }
            builder.append(charAt);
        }
        obj.addProperty("text", builder.toString());
        this.jsonList.add(obj);
        return PacketNM.NMS_PACKET.fromJson("[\"\"," + Global.replaceFrom(GSON.toJson(this.jsonList, List.class), 0, "[", "", 1));
    }

    private boolean validateHex(String text, int start, int end) {
        for (int b = start; b < end; ++b) {
            if (Character.isLetterOrDigit(text.charAt(b))) continue;
            return false;
        }
        return true;
    }
}

