/*
 * Decompiled with CFR 0.152.
 */
package hu.montlikadani.tablist.utils.reflection;

import hu.montlikadani.tablist.tablist.TabText;
import hu.montlikadani.tablist.utils.reflection.JsonComponent;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;

public final class ComponentParser {
    public static final Object EMPTY_COMPONENT;
    private static JsonComponent jsonComponent;
    private static final ReentrantLock LOCK;

    private ComponentParser() {
    }

    private static JsonComponent getJsonComponent() {
        if (jsonComponent == null) {
            try {
                jsonComponent = new JsonComponent();
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
        }
        return jsonComponent;
    }

    public static Object asComponent(TabText text) {
        Object component;
        List<TabText.JsonElementData> json = text.getJsonElements();
        LOCK.lock();
        try {
            component = ComponentParser.getJsonComponent().parseProperty(text.getPlainText(), json.isEmpty() ? null : json);
        }
        finally {
            LOCK.unlock();
        }
        return component;
    }

    public static Object asComponent(String text) {
        Object component;
        LOCK.lock();
        try {
            component = ComponentParser.getJsonComponent().parseProperty(text, null);
        }
        finally {
            LOCK.unlock();
        }
        return component;
    }

    static {
        LOCK = new ReentrantLock();
        EMPTY_COMPONENT = ComponentParser.asComponent("");
    }
}

