/*
 * Decompiled with CFR 0.152.
 */
package hu.montlikadani.tablist.utils.reflection;

import com.mojang.authlib.GameProfile;
import hu.montlikadani.tablist.utils.Util;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import org.bukkit.scoreboard.Team;

public final class ClazzContainer {
    private static Field infoList;
    private static Field packetScoreboardTeamName;
    private static Field scoreboardTeamDisplayName;
    private static Field scoreboardTeamNames;
    private static Field packetScoreboardTeamMode;
    private static Field nameTagVisibility;
    private static Field playerInfoDataProfileField;
    private static Field playerInfoDataGameMode;
    private static Field actionField;
    private static Field playerInfoDataPing;
    private static Field playerInfoDisplayName;
    private static Field packetScoreboardTeamPrefix;
    private static Field packetScoreboardTeamSuffix;
    private static Field packetScoreboardTeamChatFormatColorField;
    private static Class<?> iChatBaseComponent;
    private static Class<?> packet;
    private static Class<?> enumPlayerInfoAction;
    private static Class<?> packetPlayOutScoreboardTeam;
    private static Object addPlayer;
    private static Object removePlayer;
    private static Object updateLatency;
    private static Object updateDisplayName;
    private static Object updateGameMode;
    private static Object enumScoreboardHealthDisplayInteger;
    private static Object enumScoreboardActionChange;
    private static Object enumScoreboardActionRemove;
    private static Object iScoreboardCriteriaDummy;
    private static Object gameModeSpectator;
    private static Object gameModeSurvival;
    private static Object nameTagVisibilityAlways;
    private static Object nameTagVisibilityNever;
    private static Method scoreboardTeamSetNameTagVisibility;
    private static Method scoreboardTeamSetDisplayName;
    private static Method packetScoreboardTeamRemove;
    private static Method packetScoreboardTeamUpdateCreate;
    private static Method playerNameSetMethod;
    private static Method nameTagVisibilityByNameMethod;
    private static Method iChatBaseComponentGetStringMethod;
    private static Method enumChatFormatByIntMethod;
    private static Method scoreboardTeamSetPrefix;
    private static Method scoreboardTeamSetSuffix;
    private static Method scoreboardTeamSetChatFormat;
    private static Method parametersNameTagVisibility;
    private static Method parametersTeamPrefix;
    private static Method parametersTeamSuffix;
    private static Method packetScoreboardTeamParametersMethod;
    private static Method scoreboardTeamName;
    private static Method scoreboardTeamColor;
    private static Constructor<?> playerInfoDataConstr;
    private static Constructor<?> playOutPlayerInfoConstructor;
    private static Constructor<?> scoreboardConstructor;
    private static Constructor<?> scoreboardTeamConstructor;
    private static Constructor<?> packetPlayOutScoreboardTeamConstructor;
    private static Constructor<?> packetPlayOutScoreboardScoreConstructor;
    private static Constructor<?> packetPlayOutScoreboardObjectiveConstructor;
    private static Constructor<?> firstScoreboardObjectiveConstructor;
    private static Constructor<?> packetPlayOutScoreboardDisplayObjectiveConstructor;
    private static boolean isTeamOptionStatusEnumExist;

    private ClazzContainer() {
    }

    public static Class<?> classByName(String newPackageName, String name) throws ClassNotFoundException {
        if (newPackageName == null) {
            return Class.forName("net.minecraft.server." + Util.legacyNmsVersion() + "." + name);
        }
        try {
            return Class.forName(newPackageName + "." + name);
        }
        catch (ClassNotFoundException ex) {
            return Class.forName("net.minecraft.server." + Util.legacyNmsVersion() + "." + name);
        }
    }

    public static Field fieldByTypeOrName(Class<?> from, Class<?> type, String ... names) {
        Field[] fields = from.getDeclaredFields();
        if (type == null) {
            for (Field field : fields) {
                for (String name : names) {
                    if (!field.getName().equals(name)) continue;
                    field.setAccessible(true);
                    return field;
                }
            }
            return null;
        }
        for (Field field : fields) {
            if (field.getType() != type) continue;
            if (names.length == 0) {
                field.setAccessible(true);
                return field;
            }
            for (String name : names) {
                if (!field.getName().equals(name)) continue;
                field.setAccessible(true);
                return field;
            }
        }
        return null;
    }

    private static Object fieldObjectByTypeOrName(Class<?> from, Object obj, Class<?> type, String ... names) {
        Field field = ClazzContainer.fieldByTypeOrName(from, type, names);
        if (field != null) {
            try {
                return field.get(obj == null ? from : obj);
            }
            catch (IllegalAccessException ex) {
                ex.printStackTrace();
            }
        }
        return null;
    }

    public static Method methodByTypeAndName(Class<?> from, Class<?> returnType, Class<?>[] parameters, String ... names) {
        Method[] methods = from.getDeclaredMethods();
        if (parameters != null) {
            for (Method method : methods) {
                if (!Arrays.equals(method.getParameterTypes(), parameters)) continue;
                return method;
            }
        }
        if (returnType == null) {
            for (Method method : methods) {
                for (String name : names) {
                    if (!method.getName().equals(name)) continue;
                    return method;
                }
            }
            return null;
        }
        for (Method method : methods) {
            if (method.getReturnType() != returnType) continue;
            if (names.length == 0) {
                return method;
            }
            for (String name : names) {
                if (!method.getName().equals(name)) continue;
                return method;
            }
        }
        return null;
    }

    public static Object newInstanceOfPacketPlayOutScoreboardScore(Object action, String objectiveName, String scoreName, int score) {
        try {
            if (packetPlayOutScoreboardScoreConstructor.getParameterCount() == 1) {
                return packetPlayOutScoreboardScoreConstructor.newInstance(objectiveName);
            }
            return packetPlayOutScoreboardScoreConstructor.newInstance(action, objectiveName, scoreName, score);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Object scoreboardTeamPacketByAction(Object scoreboardTeam, int action) throws Exception {
        switch (action) {
            case 0: {
                return packetScoreboardTeamUpdateCreate.invoke(packetPlayOutScoreboardTeam, scoreboardTeam, true);
            }
            case 1: {
                return packetScoreboardTeamRemove.invoke(packetPlayOutScoreboardTeam, scoreboardTeam);
            }
            case 2: {
                return packetScoreboardTeamUpdateCreate.invoke(packetPlayOutScoreboardTeam, scoreboardTeam, false);
            }
        }
        return null;
    }

    public static GameProfile getPlayerInfoDataProfile(Object infoData) {
        try {
            return (GameProfile)playerInfoDataProfileField.get(infoData);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean isTeamOptionStatusEnumExist() {
        return isTeamOptionStatusEnumExist;
    }

    public static Class<?> getPacket() {
        return packet;
    }

    public static Field getInfoList() {
        return infoList;
    }

    public static Constructor<?> getScoreboardConstructor() {
        return scoreboardConstructor;
    }

    public static Constructor<?> getPacketPlayOutScoreboardTeamConstructor() {
        return packetPlayOutScoreboardTeamConstructor;
    }

    public static Constructor<?> getScoreboardTeamConstructor() {
        return scoreboardTeamConstructor;
    }

    public static Constructor<?> getPlayerInfoDataConstructor() {
        return playerInfoDataConstr;
    }

    public static Constructor<?> getPlayOutPlayerInfoConstructor() {
        return playOutPlayerInfoConstructor;
    }

    public static Object getAddPlayer() {
        return addPlayer;
    }

    public static Object getRemovePlayer() {
        return removePlayer;
    }

    public static Object getUpdateLatency() {
        return updateLatency;
    }

    public static Object getUpdateDisplayName() {
        return updateDisplayName;
    }

    public static Class<?> getIChatBaseComponent() {
        return iChatBaseComponent;
    }

    public static Method getScoreboardTeamSetNameTagVisibility() {
        return scoreboardTeamSetNameTagVisibility;
    }

    public static Method getScoreboardTeamSetDisplayName() {
        return scoreboardTeamSetDisplayName;
    }

    public static Field getPacketScoreboardTeamName() {
        return packetScoreboardTeamName;
    }

    public static Field getScoreboardTeamDisplayName() {
        return scoreboardTeamDisplayName;
    }

    public static Field getScoreboardTeamNames() {
        return scoreboardTeamNames;
    }

    public static Field getNameTagVisibility() {
        return nameTagVisibility;
    }

    public static Field getPlayerInfoDataGameMode() {
        return playerInfoDataGameMode;
    }

    public static Method getPlayerNameSetMethod() {
        return playerNameSetMethod;
    }

    public static Constructor<?> getPacketPlayOutScoreboardObjectiveConstructor() {
        return packetPlayOutScoreboardObjectiveConstructor;
    }

    public static Constructor<?> getFirstScoreboardObjectiveConstructor() {
        return firstScoreboardObjectiveConstructor;
    }

    public static Object getEnumScoreboardHealthDisplayInteger() {
        return enumScoreboardHealthDisplayInteger;
    }

    public static Constructor<?> getPacketPlayOutScoreboardDisplayObjectiveConstructor() {
        return packetPlayOutScoreboardDisplayObjectiveConstructor;
    }

    public static Object getEnumScoreboardActionChange() {
        return enumScoreboardActionChange;
    }

    public static Object getEnumScoreboardActionRemove() {
        return enumScoreboardActionRemove;
    }

    public static Object getiScoreboardCriteriaDummy() {
        return iScoreboardCriteriaDummy;
    }

    public static Object getEnumUpdateGameMode() {
        return updateGameMode;
    }

    public static Field getActionField() {
        return actionField;
    }

    public static Object getGameModeSpectator() {
        return gameModeSpectator;
    }

    public static Field getPlayerInfoDataPing() {
        return playerInfoDataPing;
    }

    public static Field getPlayerInfoDisplayName() {
        return playerInfoDisplayName;
    }

    public static Object getGameModeSurvival() {
        return gameModeSurvival;
    }

    public static Class<?> packetPlayOutScoreboardTeam() {
        return packetPlayOutScoreboardTeam;
    }

    public static Method getNameTagVisibilityByNameMethod() {
        return nameTagVisibilityByNameMethod;
    }

    public static Object getNameTagVisibilityAlways() {
        return nameTagVisibilityAlways;
    }

    public static Object getNameTagVisibilityNever() {
        return nameTagVisibilityNever;
    }

    public static Field getPacketScoreboardTeamPrefix() {
        return packetScoreboardTeamPrefix;
    }

    public static Field getPacketScoreboardTeamSuffix() {
        return packetScoreboardTeamSuffix;
    }

    public static Method getiChatBaseComponentGetStringMethod() {
        return iChatBaseComponentGetStringMethod;
    }

    public static Method getEnumChatFormatByIntMethod() {
        return enumChatFormatByIntMethod;
    }

    public static Field getPacketScoreboardTeamChatFormatColorField() {
        return packetScoreboardTeamChatFormatColorField;
    }

    public static Method getScoreboardTeamSetPrefix() {
        return scoreboardTeamSetPrefix;
    }

    public static Method getScoreboardTeamSetSuffix() {
        return scoreboardTeamSetSuffix;
    }

    public static Method getScoreboardTeamSetChatFormat() {
        return scoreboardTeamSetChatFormat;
    }

    public static Method getParametersNameTagVisibility() {
        return parametersNameTagVisibility;
    }

    public static Method getParametersTeamPrefix() {
        return parametersTeamPrefix;
    }

    public static Method getParametersTeamSuffix() {
        return parametersTeamSuffix;
    }

    public static Method getPacketScoreboardTeamParametersMethod() {
        return packetScoreboardTeamParametersMethod;
    }

    public static Field getPacketScoreboardTeamMode() {
        return packetScoreboardTeamMode;
    }

    public static Method getScoreboardTeamName() {
        return scoreboardTeamName;
    }

    public static Method getScoreboardTeamColor() {
        return scoreboardTeamColor;
    }

    static {
        try {
            Class<?> enumGameMode;
            Class<?> playerInfoData;
            Class<?> enumScoreboardAction;
            Class<?> enumScoreboardHealthDisplay;
            iChatBaseComponent = ClazzContainer.classByName("net.minecraft.network.chat", "IChatBaseComponent");
            packet = ClazzContainer.classByName("net.minecraft.network.protocol", "Packet");
            packetPlayOutScoreboardTeam = ClazzContainer.classByName("net.minecraft.network.protocol.game", "PacketPlayOutScoreboardTeam");
            Class<?> packetPlayOutPlayerInfo = ClazzContainer.classByName("net.minecraft.network.protocol.game", "PacketPlayOutPlayerInfo");
            try {
                Team.class.getDeclaredMethod("getOption", Team.Option.class);
                isTeamOptionStatusEnumExist = true;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            iChatBaseComponentGetStringMethod = ClazzContainer.methodByTypeAndName(iChatBaseComponent, String.class, null, "getString", "getText", "e");
            try {
                enumPlayerInfoAction = ClazzContainer.classByName(null, "EnumPlayerInfoAction");
            }
            catch (ClassNotFoundException c) {
                for (Class<?> clazz : packetPlayOutPlayerInfo.getClasses()) {
                    if (!clazz.getName().contains("EnumPlayerInfoAction")) continue;
                    enumPlayerInfoAction = clazz;
                    break;
                }
            }
            Class<?> enumChatFormat = ClazzContainer.classByName("net.minecraft", "EnumChatFormat");
            enumChatFormatByIntMethod = ClazzContainer.methodByTypeAndName(enumChatFormat, enumChatFormat, new Class[]{String.class}, "getById", "a");
            addPlayer = ClazzContainer.fieldObjectByTypeOrName(enumPlayerInfoAction, null, null, "ADD_PLAYER", "a");
            updateLatency = ClazzContainer.fieldObjectByTypeOrName(enumPlayerInfoAction, null, null, "UPDATE_LATENCY", "c");
            updateDisplayName = ClazzContainer.fieldObjectByTypeOrName(enumPlayerInfoAction, null, null, "UPDATE_DISPLAY_NAME", "d");
            updateGameMode = ClazzContainer.fieldObjectByTypeOrName(enumPlayerInfoAction, null, null, "UPDATE_GAME_MODE", "b");
            removePlayer = ClazzContainer.fieldObjectByTypeOrName(enumPlayerInfoAction, null, null, "REMOVE_PLAYER", "e");
            packetScoreboardTeamParametersMethod = ClazzContainer.methodByTypeAndName(packetPlayOutScoreboardTeam, Optional.class, null, "f", "k", "parameters");
            Class<?> scoreboardClass = ClazzContainer.classByName("net.minecraft.world.scores", "Scoreboard");
            scoreboardConstructor = scoreboardClass.getConstructor(new Class[0]);
            Class<?> scoreboardNameTagVisibility = ClazzContainer.classByName("net.minecraft.world.scores", "ScoreboardTeamBase$EnumNameTagVisibility");
            nameTagVisibilityByNameMethod = ClazzContainer.methodByTypeAndName(scoreboardNameTagVisibility, String.class, new Class[]{String.class}, "a", "byName");
            nameTagVisibilityAlways = ClazzContainer.fieldObjectByTypeOrName(scoreboardNameTagVisibility, null, null, "a", "ALWAYS");
            nameTagVisibilityNever = ClazzContainer.fieldObjectByTypeOrName(scoreboardNameTagVisibility, null, null, "b", "NEVER");
            Class<?>[] classes = packetPlayOutScoreboardTeam.getDeclaredClasses();
            if (classes.length > 1) {
                Class<?> parameterType = classes[1];
                parametersNameTagVisibility = ClazzContainer.methodByTypeAndName(parameterType, scoreboardNameTagVisibility, null, "getNametagVisibility", "d");
                parametersTeamPrefix = ClazzContainer.methodByTypeAndName(parameterType, iChatBaseComponent, null, "getPlayerPrefix", "f");
                parametersTeamSuffix = ClazzContainer.methodByTypeAndName(parameterType, iChatBaseComponent, null, "getPlayerSuffix", "g");
            }
            if ((packetScoreboardTeamPrefix = ClazzContainer.fieldByTypeOrName(packetPlayOutScoreboardTeam, iChatBaseComponent, "c", "playerPrefix")) == null) {
                packetScoreboardTeamPrefix = ClazzContainer.fieldByTypeOrName(packetPlayOutScoreboardTeam, String.class, "c", "playerPrefix");
                packetScoreboardTeamSuffix = ClazzContainer.fieldByTypeOrName(packetPlayOutScoreboardTeam, String.class, "d", "playerSuffix");
            } else {
                packetScoreboardTeamSuffix = ClazzContainer.fieldByTypeOrName(packetPlayOutScoreboardTeam, iChatBaseComponent, "d", "playerSuffix");
            }
            Class<?> scoreboardTeamClass = ClazzContainer.classByName("net.minecraft.world.scores", "ScoreboardTeam");
            scoreboardTeamConstructor = scoreboardTeamClass.getConstructor(scoreboardClass, String.class);
            scoreboardTeamName = ClazzContainer.methodByTypeAndName(scoreboardTeamClass, String.class, null, "getName", "b");
            playerNameSetMethod = ClazzContainer.methodByTypeAndName(scoreboardTeamClass, Collection.class, null, "g", "getPlayers", "getPlayerNameSet");
            scoreboardTeamSetNameTagVisibility = ClazzContainer.methodByTypeAndName(scoreboardTeamClass, null, new Class[]{scoreboardNameTagVisibility}, "a", "setNameTagVisibility");
            scoreboardTeamSetPrefix = ClazzContainer.methodByTypeAndName(scoreboardTeamClass, null, new Class[]{iChatBaseComponent}, "b", "setPlayerPrefix");
            scoreboardTeamSetSuffix = ClazzContainer.methodByTypeAndName(scoreboardTeamClass, null, new Class[]{iChatBaseComponent}, "c", "setPlayerSuffix");
            if (scoreboardTeamSetSuffix == null) {
                scoreboardTeamSetPrefix = ClazzContainer.methodByTypeAndName(scoreboardTeamClass, null, new Class[]{String.class}, "b", "setPrefix");
                scoreboardTeamSetSuffix = ClazzContainer.methodByTypeAndName(scoreboardTeamClass, null, new Class[]{String.class}, "c", "setSuffix");
            }
            scoreboardTeamSetChatFormat = ClazzContainer.methodByTypeAndName(scoreboardTeamClass, null, new Class[]{enumChatFormat}, "a", "m", "setColor");
            scoreboardTeamColor = ClazzContainer.methodByTypeAndName(scoreboardTeamClass, null, null, "getColor", "n");
            scoreboardTeamSetDisplayName = ClazzContainer.methodByTypeAndName(scoreboardTeamClass, null, new Class[]{iChatBaseComponent}, "a", "setDisplayName");
            try {
                packetPlayOutScoreboardTeamConstructor = packetPlayOutScoreboardTeam.getDeclaredConstructor(new Class[0]);
            }
            catch (NoSuchMethodException e) {
                try {
                    packetPlayOutScoreboardTeamConstructor = packetPlayOutScoreboardTeam.getDeclaredConstructor(ClazzContainer.classByName(null, "ScoreboardTeam"), Integer.TYPE);
                }
                catch (NoSuchMethodException ex) {
                    scoreboardTeamNames = ClazzContainer.fieldByTypeOrName(scoreboardTeamClass, Set.class, "e", "f", "players");
                    packetScoreboardTeamRemove = packetPlayOutScoreboardTeam.getMethod("a", scoreboardTeamClass);
                    packetScoreboardTeamUpdateCreate = packetPlayOutScoreboardTeam.getMethod("a", scoreboardTeamClass, Boolean.TYPE);
                }
            }
            if (packetPlayOutScoreboardTeamConstructor != null) {
                packetPlayOutScoreboardTeamConstructor.setAccessible(true);
                packetScoreboardTeamName = packetPlayOutScoreboardTeam.getDeclaredField("a");
                packetScoreboardTeamName.setAccessible(true);
                scoreboardTeamDisplayName = packetPlayOutScoreboardTeam.getDeclaredField("b");
                scoreboardTeamDisplayName.setAccessible(true);
                nameTagVisibility = packetPlayOutScoreboardTeam.getDeclaredField("e");
                nameTagVisibility.setAccessible(true);
                packetScoreboardTeamMode = ClazzContainer.fieldByTypeOrName(packetPlayOutScoreboardTeam, Integer.TYPE, "i", "h");
                scoreboardTeamNames = ClazzContainer.fieldByTypeOrName(packetPlayOutScoreboardTeam, Collection.class, "h", "e");
                packetScoreboardTeamChatFormatColorField = packetPlayOutScoreboardTeam.getDeclaredField("g");
                packetScoreboardTeamChatFormatColorField.setAccessible(true);
            }
            Class<?> scoreboardObjective = ClazzContainer.classByName("net.minecraft.world.scores", "ScoreboardObjective");
            packetPlayOutScoreboardDisplayObjectiveConstructor = ClazzContainer.classByName("net.minecraft.network.protocol.game", "PacketPlayOutScoreboardDisplayObjective").getConstructor(Integer.TYPE, scoreboardObjective);
            firstScoreboardObjectiveConstructor = scoreboardObjective.getConstructors()[0];
            packetPlayOutScoreboardObjectiveConstructor = ClazzContainer.classByName("net.minecraft.network.protocol.game", "PacketPlayOutScoreboardObjective").getConstructor(scoreboardObjective, Integer.TYPE);
            try {
                enumScoreboardHealthDisplay = ClazzContainer.classByName("net.minecraft.world.scores.criteria", "IScoreboardCriteria$EnumScoreboardHealthDisplay");
            }
            catch (ClassNotFoundException e) {
                enumScoreboardHealthDisplay = ClazzContainer.classByName("net.minecraft.world.scores.criteria", "EnumScoreboardHealthDisplay");
            }
            enumScoreboardHealthDisplayInteger = ClazzContainer.fieldObjectByTypeOrName(enumScoreboardHealthDisplay, null, null, "a", "INTEGER");
            Class<?> iScoreboardCriteria = ClazzContainer.classByName("net.minecraft.world.scores.criteria", "IScoreboardCriteria");
            iScoreboardCriteriaDummy = ClazzContainer.fieldObjectByTypeOrName(iScoreboardCriteria, null, iScoreboardCriteria, new String[0]);
            try {
                enumScoreboardAction = ClazzContainer.classByName("net.minecraft.server", "ScoreboardServer$Action");
            }
            catch (ClassNotFoundException e) {
                try {
                    enumScoreboardAction = ClazzContainer.classByName("net.minecraft.server", "PacketPlayOutScoreboardScore$EnumScoreboardAction");
                }
                catch (ClassNotFoundException ex) {
                    enumScoreboardAction = ClazzContainer.classByName("net.minecraft.server", "EnumScoreboardAction");
                }
            }
            enumScoreboardActionChange = ClazzContainer.fieldObjectByTypeOrName(enumScoreboardAction, null, null, "a", "CHANGE");
            enumScoreboardActionRemove = ClazzContainer.fieldObjectByTypeOrName(enumScoreboardAction, null, null, "b", "REMOVE");
            try {
                packetPlayOutScoreboardScoreConstructor = ClazzContainer.classByName("net.minecraft.network.protocol.game", "PacketPlayOutScoreboardScore").getConstructor(enumScoreboardAction, String.class, String.class, Integer.TYPE);
            }
            catch (NoSuchMethodException excep) {
                packetPlayOutScoreboardScoreConstructor = ClazzContainer.classByName("net.minecraft.network.protocol.game", "PacketPlayOutScoreboardScore").getConstructor(String.class);
            }
            infoList = packetPlayOutPlayerInfo.getDeclaredField("b");
            infoList.setAccessible(true);
            actionField = packetPlayOutPlayerInfo.getDeclaredField("a");
            actionField.setAccessible(true);
            try {
                playerInfoData = ClazzContainer.classByName("net.minecraft.network.protocol.game", "PacketPlayOutPlayerInfo$PlayerInfoData");
            }
            catch (ClassNotFoundException e) {
                playerInfoData = ClazzContainer.classByName(null, "PlayerInfoData");
            }
            for (Constructor<?> constr : playerInfoData.getConstructors()) {
                int paramCount = constr.getParameterCount();
                if (paramCount != 4 && paramCount != 5) continue;
                playerInfoDataConstr = constr;
                playerInfoDataConstr.setAccessible(true);
                break;
            }
            for (Constructor<?> constructor : packetPlayOutPlayerInfo.getConstructors()) {
                if (constructor.getParameterCount() != 2 || !constructor.getParameters()[1].getType().isArray()) continue;
                playOutPlayerInfoConstructor = constructor;
                playOutPlayerInfoConstructor.setAccessible(true);
                break;
            }
            try {
                enumGameMode = ClazzContainer.classByName("net.minecraft.world.level", "EnumGamemode");
            }
            catch (ClassNotFoundException e) {
                enumGameMode = ClazzContainer.classByName(null, "WorldSettings$EnumGamemode");
            }
            gameModeSurvival = ClazzContainer.fieldObjectByTypeOrName(enumGameMode, null, null, "SURVIVAL", "a");
            gameModeSpectator = ClazzContainer.fieldObjectByTypeOrName(enumGameMode, null, null, "SPECTATOR", "d");
            playerInfoDataProfileField = ClazzContainer.fieldByTypeOrName(playerInfoData, GameProfile.class, "c", "d");
            playerInfoDataPing = ClazzContainer.fieldByTypeOrName(playerInfoData, Integer.TYPE, "a", "b");
            playerInfoDataGameMode = ClazzContainer.fieldByTypeOrName(playerInfoData, enumGameMode, "b", "c");
            playerInfoDisplayName = ClazzContainer.fieldByTypeOrName(playerInfoData, iChatBaseComponent, "d", "e");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

