/*
 * Decompiled with CFR 0.152.
 */
package hu.montlikadani.tablist.utils.plugin;

import net.luckperms.api.LuckPermsProvider;
import net.milkbowl.vault.permission.Permission;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.RegisteredServiceProvider;

public final class PermissionService {
    public final boolean hasLuckPerms;
    private Permission perm;

    public PermissionService() {
        RegisteredServiceProvider rsp = Bukkit.getServer().getServicesManager().getRegistration(Permission.class);
        if (rsp != null) {
            this.perm = (Permission)rsp.getProvider();
        }
        this.hasLuckPerms = Bukkit.getServer().getPluginManager().isPluginEnabled("LuckPerms");
    }

    public Permission getPermission() {
        return this.perm;
    }

    public Object groupObjectByName(String groupName) {
        return this.hasLuckPerms ? LuckPermsProvider.get().getGroupManager().getGroup(groupName) : null;
    }

    public String getPrimaryGroup(Player player2) {
        try {
            return this.perm.getPrimaryGroup(player2);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            return null;
        }
    }

    public boolean playerInGroup(Player player2, String group2) {
        try {
            if (this.perm.playerInGroup(player2, group2)) {
                return true;
            }
            for (String playerGroup : this.perm.getPlayerGroups(player2)) {
                if (!group2.equalsIgnoreCase(playerGroup)) continue;
                return true;
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        return false;
    }

    public boolean playerInGroup(Player player2, String world, String group2) {
        try {
            if (this.perm.playerInGroup(world, (OfflinePlayer)player2, group2)) {
                return true;
            }
            for (String playerGroup : this.perm.getPlayerGroups(world, (OfflinePlayer)player2)) {
                if (!group2.equalsIgnoreCase(playerGroup)) continue;
                return true;
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        return false;
    }

    public String[] getGroups() {
        try {
            return this.perm.getGroups();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            return new String[0];
        }
    }
}

