/*
 * Decompiled with CFR 0.152.
 */
package hu.montlikadani.tablist.utils.datafetcher.impl;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import hu.montlikadani.tablist.utils.PlayerSkinProperties;
import hu.montlikadani.tablist.utils.Util;
import hu.montlikadani.tablist.utils.datafetcher.RequestType;
import hu.montlikadani.tablist.utils.datafetcher.UrlDataReader;

public final class MineToolsProfile
implements RequestType {
    @Override
    public PlayerSkinProperties get(String playerId) {
        JsonObject json = UrlDataReader.readJsonObject("https://api.minetools.eu/profile/" + playerId);
        if (json == null) {
            return null;
        }
        JsonElement rawElement = json.get("raw");
        if (rawElement == null) {
            return null;
        }
        JsonArray jsonArray = rawElement.getAsJsonObject().get("properties").getAsJsonArray();
        if (jsonArray.isEmpty()) {
            return null;
        }
        String userName = json.get("decoded").getAsJsonObject().get("profileName").getAsString();
        String value = jsonArray.get(0).getAsJsonObject().get("value").getAsString();
        json = UrlDataReader.decodeSkinValue(value);
        return new PlayerSkinProperties(userName, Util.tryParseId(playerId).orElse(null), value, json.get("textures").getAsJsonObject().get("SKIN").getAsJsonObject().get("url").getAsString());
    }
}

