/*
 * Decompiled with CFR 0.152.
 */
package hu.montlikadani.tablist.utils.datafetcher.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import hu.montlikadani.tablist.utils.PlayerSkinProperties;
import hu.montlikadani.tablist.utils.Util;
import hu.montlikadani.tablist.utils.datafetcher.RequestType;
import hu.montlikadani.tablist.utils.datafetcher.UrlDataReader;
import java.util.UUID;

public final class AshconProfile
implements RequestType {
    @Override
    public PlayerSkinProperties get(String playerIdOrName) {
        JsonObject json = UrlDataReader.readJsonObject("https://api.ashcon.app/mojang/v2/user/" + playerIdOrName);
        if (json == null) {
            return null;
        }
        JsonElement playerIdElement = json.get("uuid");
        if (playerIdElement == null) {
            return null;
        }
        JsonElement texturesElement = json.get("textures");
        if (texturesElement == null) {
            return null;
        }
        JsonElement rawTextureObject = texturesElement.getAsJsonObject().get("raw");
        if (rawTextureObject == null) {
            return null;
        }
        String value = rawTextureObject.getAsJsonObject().get("value").getAsString();
        json = UrlDataReader.decodeSkinValue(value);
        UUID id = Util.tryParseId(playerIdElement.getAsString()).orElse(null);
        return new PlayerSkinProperties(id == null ? playerIdOrName : null, id, value, json.get("textures").getAsJsonObject().get("SKIN").getAsJsonObject().get("url").getAsString());
    }
}

