/*
 * Decompiled with CFR 0.152.
 */
package hu.montlikadani.tablist.utils.datafetcher;

import hu.montlikadani.tablist.utils.PlayerSkinProperties;
import hu.montlikadani.tablist.utils.datafetcher.RequestType;
import hu.montlikadani.tablist.utils.datafetcher.impl.AshconProfile;
import hu.montlikadani.tablist.utils.datafetcher.impl.MineToolsProfile;
import hu.montlikadani.tablist.utils.datafetcher.impl.SessionServerProfile;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;

public final class URLDataFetcher {
    private static final RequestType[] DATA_FETCHERS = new RequestType[3];

    public static CompletableFuture<PlayerSkinProperties> fetchProfile(String playerNameOrId) {
        return CompletableFuture.supplyAsync(() -> URLDataFetcher.fetchData(playerNameOrId));
    }

    private static PlayerSkinProperties fetchData(String playerNameOrId) {
        if (PlayerSkinProperties.cacheSize() > 100) {
            return null;
        }
        for (RequestType fetcher : DATA_FETCHERS) {
            try {
                return fetcher.get(playerNameOrId);
            }
            catch (IOException iOException) {
            }
        }
        return null;
    }

    static {
        URLDataFetcher.DATA_FETCHERS[0] = new AshconProfile();
        URLDataFetcher.DATA_FETCHERS[1] = new MineToolsProfile();
        URLDataFetcher.DATA_FETCHERS[2] = new SessionServerProfile();
    }
}

