/*
 * Decompiled with CFR 0.152.
 */
package hu.montlikadani.tablist.utils;

import hu.montlikadani.tablist.config.constantsLoader.ConfigValues;
import java.util.Optional;
import java.util.UUID;
import java.util.logging.Level;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.plugin.Plugin;

public final class Util {
    private static final boolean MINIMESSAGE_SUPPORTED;
    private static String legacyNmsVersion;

    public static void consolePrint(Level level, Plugin plugin, String text, Object ... params) {
        if (ConfigValues.isLogConsole()) {
            Util.printTrace(level, plugin, text, params);
        }
    }

    public static void printTrace(Level loggingLevel, Plugin plugin, String text, Object ... parameters) {
        plugin.getLogger().log(loggingLevel, text, parameters);
    }

    public static String legacyNmsVersion() {
        return legacyNmsVersion == null ? (legacyNmsVersion = Bukkit.getServer().getClass().getPackage().getName().split("\\.", 4)[3]) : legacyNmsVersion;
    }

    public static String applyTextFormat(String value) {
        return Util.applyTextFormat(value, true);
    }

    public static String applyTextFormat(String value, boolean applyLegacyColours) {
        if (MINIMESSAGE_SUPPORTED) {
            value = value.replace("&", "-{-}-").replace("\u00a7", "-{-}-");
            value = LegacyComponentSerializer.legacyAmpersand().serialize(MiniMessage.miniMessage().deserialize((Object)value)).replace("-{-}-", "&");
        }
        return applyLegacyColours ? ChatColor.translateAlternateColorCodes((char)'&', (String)value) : value;
    }

    public static Optional<UUID> tryParseId(String uuid) {
        if (uuid == null) {
            return Optional.empty();
        }
        try {
            return Optional.of(UUID.fromString(uuid));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return Optional.empty();
        }
    }

    static {
        boolean supported;
        try {
            Class.forName("net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer");
            Class.forName("net.kyori.adventure.text.minimessage.MiniMessage").getDeclaredMethod("miniMessage", new Class[0]);
            supported = true;
        }
        catch (ClassNotFoundException | NoSuchMethodException cn) {
            supported = false;
        }
        MINIMESSAGE_SUPPORTED = supported;
    }
}

