/*
 * Decompiled with CFR 0.152.
 */
package hu.montlikadani.tablist.utils;

import hu.montlikadani.tablist.TabList;
import hu.montlikadani.tablist.utils.Util;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.UnknownHostException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.regex.Pattern;
import org.bukkit.plugin.Plugin;

public abstract class UpdateDownloader {
    public static void checkFromGithub(TabList tabList) {
        UpdateDownloader.deleteDirectory(tabList);
        if (!tabList.getConfig().getBoolean("check-update", true)) {
            return;
        }
        CompletableFuture.supplyAsync(() -> {
            try {
                return UpdateDownloader.fetch(tabList);
            }
            catch (FileNotFoundException | UnknownHostException iOException) {
            }
            catch (IOException ex) {
                Util.printTrace(Level.SEVERE, (Plugin)tabList, ex.getMessage(), ex);
            }
            return -1;
        }).thenAccept(code -> {
            if (code == 200) {
                Util.consolePrint(Level.INFO, (Plugin)tabList, "The new TabList has been downloaded, restart the server to apply.", new Object[0]);
            } else if (code != -2) {
                Util.consolePrint(Level.INFO, (Plugin)tabList, "Downloading update failed, error code: {0}", code);
            }
        });
    }

    private static int fetch(TabList tabList) throws IOException {
        int currentVersion;
        String lineWithVersion = "";
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(URI.create("https://raw.githubusercontent.com/montlikadani/TabList/master/bukkit/src/main/resources/plugin.yml").toURL().openStream()));){
            String s;
            while ((s = reader.readLine()) != null) {
                if (s.indexOf("version") == -1) continue;
                lineWithVersion = s;
                break;
            }
        }
        if (lineWithVersion.isEmpty()) {
            return -2;
        }
        String pluginVersion = "";
        try {
            pluginVersion = tabList.getPluginMeta().getVersion();
        }
        catch (NoSuchMethodError s) {
            // empty catch block
        }
        if (pluginVersion.isEmpty()) {
            pluginVersion = tabList.getDescription().getVersion();
        }
        Pattern pattern = Pattern.compile("[^0-9]");
        try {
            currentVersion = Integer.parseInt(pattern.matcher(pluginVersion).replaceAll(""));
        }
        catch (NumberFormatException ex) {
            return -2;
        }
        String versionString = Pattern.compile(": ").split(lineWithVersion, 2)[1];
        int newVersion = Integer.parseInt(pattern.matcher(versionString).replaceAll(""));
        if (newVersion <= currentVersion) {
            return -2;
        }
        Util.consolePrint(Level.INFO, (Plugin)tabList, "-------------", new Object[0]);
        Util.consolePrint(Level.INFO, (Plugin)tabList, "New update is available for TabList", new Object[0]);
        Util.consolePrint(Level.INFO, (Plugin)tabList, "Your version: {0}, New version {1}", pluginVersion, versionString);
        boolean downloadUpdates = tabList.getConfig().getBoolean("download-updates", false);
        if (!downloadUpdates) {
            Util.consolePrint(Level.INFO, (Plugin)tabList, "Download: https://www.spigotmc.org/resources/46229/", new Object[0]);
            Util.consolePrint(Level.INFO, (Plugin)tabList, "", new Object[0]);
            Util.consolePrint(Level.INFO, (Plugin)tabList, "Always consider upgrading to the latest version, which may include fixes.", new Object[0]);
        }
        Util.consolePrint(Level.INFO, (Plugin)tabList, "", new Object[0]);
        Util.consolePrint(Level.INFO, (Plugin)tabList, "To disable update checking, go to the config file", new Object[0]);
        Util.consolePrint(Level.INFO, (Plugin)tabList, "-------------", new Object[0]);
        if (!downloadUpdates) {
            return -2;
        }
        File updateFolder = tabList.getServer().getUpdateFolderFile();
        if (!updateFolder.exists() && !updateFolder.mkdir()) {
            return -2;
        }
        String name = "TabList-bukkit-v" + versionString + ".jar";
        File jar = new File(updateFolder, name);
        if (jar.exists()) {
            return -2;
        }
        Util.consolePrint(Level.INFO, (Plugin)tabList, "Downloading new version of TabList...", new Object[0]);
        HttpURLConnection urlConnection = (HttpURLConnection)URI.create("https://github.com/montlikadani/TabList/releases/latest/download/" + name).toURL().openConnection();
        urlConnection.setRequestMethod("HEAD");
        int responseCode = urlConnection.getResponseCode();
        if (responseCode == 200) {
            try (InputStream in = urlConnection.getInputStream();){
                Files.copy(in, jar.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
        }
        return responseCode;
    }

    private static void deleteDirectory(TabList tabList) {
        File releasesFolder = new File(tabList.getDataFolder(), "releases");
        if (!releasesFolder.exists()) {
            return;
        }
        File[] files = releasesFolder.listFiles();
        if (files != null) {
            for (File file : files) {
                try {
                    file.delete();
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
            }
        }
        try {
            releasesFolder.delete();
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }
}

