/*
 * Decompiled with CFR 0.152.
 */
package hu.montlikadani.tablist.utils;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Containers.CMIUser;
import de.myzelyam.api.vanish.VanishAPI;
import hu.montlikadani.tablist.config.constantsLoader.ConfigValues;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.UUID;
import me.xtomyserrax.StaffFacilities.SFAPI;
import net.ess3.api.IEssentials;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import ru.tehkode.permissions.bukkit.PermissionsEx;

public final class PluginUtils {
    private static final Plugin ESSENTIALS;
    private static final Plugin CMIP;
    private static final Plugin PEX;
    private static final Plugin SUPER_VANISH;
    private static final Plugin PREMIUM_VANISH;
    private static final Plugin STAFF_FACILITIES;
    private static Method purpurPlayerAfkStatusMethod;

    public static boolean isAfk(Player player2) {
        if (player2 == null) {
            return false;
        }
        if (ESSENTIALS != null && ESSENTIALS.isEnabled()) {
            return ((IEssentials)ESSENTIALS).getUser(player2).isAfk();
        }
        if (CMIP != null && CMIP.isEnabled()) {
            CMIUser user = CMI.getInstance().getPlayerManager().getUser(player2.getUniqueId());
            return user != null && user.isAfk();
        }
        if (purpurPlayerAfkStatusMethod != null) {
            try {
                return (Boolean)purpurPlayerAfkStatusMethod.invoke((Object)player2, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException ex) {
                ex.printStackTrace();
            }
        }
        return false;
    }

    public static boolean isVanished(Player player2) {
        if (SUPER_VANISH != null && SUPER_VANISH.isEnabled() || PREMIUM_VANISH != null && PREMIUM_VANISH.isEnabled()) {
            return VanishAPI.isInvisibleOffline((UUID)player2.getUniqueId());
        }
        if (ESSENTIALS != null && ESSENTIALS.isEnabled()) {
            return ((IEssentials)ESSENTIALS).getUser(player2).isVanished();
        }
        if (STAFF_FACILITIES != null && STAFF_FACILITIES.isEnabled()) {
            return SFAPI.isPlayerVanished((Player)player2);
        }
        if (CMIP != null && CMIP.isEnabled()) {
            CMIUser user = CMI.getInstance().getPlayerManager().getUser(player2.getUniqueId());
            return user != null && user.isVanished();
        }
        return false;
    }

    public static int countVanishedPlayers() {
        int plSize = Bukkit.getServer().getOnlinePlayers().size();
        if (!ConfigValues.isIgnoreVanishedPlayers()) {
            return plSize;
        }
        int vanishedPlayers = PluginUtils.getVanishedPlayers();
        return vanishedPlayers == 0 ? plSize : plSize - vanishedPlayers;
    }

    public static int getVanishedPlayers() {
        if (SUPER_VANISH != null && SUPER_VANISH.isEnabled() || PREMIUM_VANISH != null && PREMIUM_VANISH.isEnabled()) {
            return VanishAPI.getInvisiblePlayers().size();
        }
        if (ESSENTIALS != null && ESSENTIALS.isEnabled()) {
            return ((IEssentials)ESSENTIALS).getVanishedPlayersNew().size();
        }
        if (STAFF_FACILITIES != null && STAFF_FACILITIES.isEnabled()) {
            return SFAPI.vanishedPlayersList().size();
        }
        if (CMIP != null && CMIP.isEnabled()) {
            return CMI.getInstance().getVanishManager().getAllVanished().size();
        }
        return 0;
    }

    public static boolean hasPermission(Player player2, String perm) {
        if (PEX != null && PEX.isEnabled()) {
            try {
                return PermissionsEx.getPermissionManager().has(player2, perm);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return player2.hasPermission(perm);
    }

    static {
        PluginManager pm = Bukkit.getServer().getPluginManager();
        ESSENTIALS = pm.getPlugin("Essentials");
        CMIP = pm.getPlugin("CMI");
        PEX = pm.getPlugin("PermissionsEx");
        SUPER_VANISH = pm.getPlugin("SuperVanish");
        PREMIUM_VANISH = pm.getPlugin("PremiumVanish");
        STAFF_FACILITIES = pm.getPlugin("StaffFacilities");
        try {
            purpurPlayerAfkStatusMethod = Player.class.getDeclaredMethod("isAfk", new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }
}

