/*
 * Decompiled with CFR 0.152.
 */
package hu.montlikadani.tablist.utils;

import hu.montlikadani.tablist.utils.datafetcher.URLDataFetcher;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;

public final class PlayerSkinProperties {
    private static final Set<PlayerSkinProperties> CACHE = new HashSet<PlayerSkinProperties>();
    public static final int MAX_REQUESTS = 100;
    public final UUID playerId;
    public String playerName;
    public String textureRawValue;
    public String decodedTextureValue;

    public static PlayerSkinProperties findPlayerProperty(String playerName, UUID playerId) {
        for (PlayerSkinProperties one : CACHE) {
            if ((playerId == null || !playerId.equals(one.playerId)) && (playerName == null || !playerName.equals(one.playerName))) continue;
            return one;
        }
        return null;
    }

    public static int cacheSize() {
        return CACHE.size();
    }

    public PlayerSkinProperties(String playerName, UUID playerId) {
        this(playerName, playerId, null, null);
    }

    public PlayerSkinProperties(String playerName, UUID playerId, String textureRawValue, String decodedTextureValue) {
        this.playerName = playerName;
        this.playerId = playerId;
        if (textureRawValue != null && decodedTextureValue != null) {
            this.textureRawValue = textureRawValue;
            this.decodedTextureValue = decodedTextureValue;
            CACHE.add(this);
        }
    }

    public CompletableFuture<Void> retrieveTextureData() {
        if (this.textureRawValue != null && this.decodedTextureValue != null) {
            CompletableFuture<Void> future = new CompletableFuture<Void>();
            future.complete(null);
            return future;
        }
        if (this.playerName != null) {
            return URLDataFetcher.fetchProfile(this.playerName).thenAccept(properties -> {
                this.textureRawValue = properties.textureRawValue;
                this.decodedTextureValue = properties.decodedTextureValue;
            });
        }
        if (this.playerId == null) {
            CompletableFuture<Void> future = new CompletableFuture<Void>();
            future.complete(null);
            return future;
        }
        return URLDataFetcher.fetchProfile(this.playerId.toString()).thenAccept(properties -> {
            this.textureRawValue = properties.textureRawValue;
            this.decodedTextureValue = properties.decodedTextureValue;
        });
    }
}

