/*
 * Decompiled with CFR 0.152.
 */
package hu.montlikadani.tablist.user;

import hu.montlikadani.tablist.Objects;
import hu.montlikadani.tablist.TabList;
import hu.montlikadani.tablist.config.constantsLoader.ConfigValues;
import hu.montlikadani.tablist.tablist.TabHandler;
import hu.montlikadani.tablist.tablist.groups.GroupPlayer;
import hu.montlikadani.tablist.tablist.playerlist.PlayerList;
import hu.montlikadani.tablist.user.PlayerScore;
import java.util.UUID;
import org.bukkit.entity.Player;

public final class TabListUser {
    private final TabList plugin;
    private final UUID uniqueId;
    private final transient GroupPlayer groupPlayer;
    private final transient TabHandler tabHandler;
    private transient PlayerScore playerScore;
    private transient PlayerList playerList;
    private boolean tabVisible = true;

    public TabListUser(TabList plugin, UUID uniqueId) {
        this.plugin = plugin;
        this.uniqueId = uniqueId;
        this.tabHandler = new TabHandler(plugin, this);
        this.groupPlayer = new GroupPlayer(plugin, this);
        String entry = plugin.getServer().getOfflinePlayer(uniqueId).getName();
        if (entry != null) {
            this.playerScore = new PlayerScore(entry);
        }
    }

    public Player getPlayer() {
        return this.plugin.getServer().getPlayer(this.uniqueId);
    }

    public UUID getUniqueId() {
        return this.uniqueId;
    }

    public GroupPlayer getGroupPlayer() {
        return this.groupPlayer;
    }

    public TabHandler getTabHandler() {
        return this.tabHandler;
    }

    public boolean isHidden() {
        return this.playerList != null;
    }

    public void setHidden(boolean hidden) {
        if (hidden) {
            if (this.playerList == null) {
                this.playerList = new PlayerList(this.plugin, this);
            }
            this.playerList.hide();
        } else if (this.playerList != null) {
            this.playerList.showEveryone();
            this.playerList = null;
        }
    }

    public PlayerList getPlayerList() {
        return this.playerList;
    }

    public PlayerScore getPlayerScore() {
        return this.playerScore;
    }

    public PlayerScore getPlayerScore(boolean initPlayerScore) {
        if (!initPlayerScore) {
            return this.playerScore;
        }
        if (ConfigValues.getObjectType() == Objects.ObjectTypes.NONE) {
            this.playerScore.setObjectiveCreated();
            this.playerScore = null;
            return null;
        }
        if (this.playerScore != null) {
            return this.playerScore;
        }
        Player player2 = this.getPlayer();
        this.playerScore = new PlayerScore(player2 == null ? "" : player2.getName());
        return this.playerScore;
    }

    public boolean isTabVisible() {
        return this.tabVisible;
    }

    public void setTabVisibility(boolean visibility) {
        this.tabVisible = visibility;
    }

    public boolean equals(Object o) {
        return o != null && o.getClass() == this.getClass() && this.uniqueId.equals(((TabListUser)o).uniqueId);
    }
}

