/*
 * Decompiled with CFR 0.152.
 */
package hu.montlikadani.tablist.tablist.playerlist;

import hu.montlikadani.tablist.TabList;
import hu.montlikadani.tablist.config.constantsLoader.ConfigValues;
import hu.montlikadani.tablist.user.TabListUser;
import java.util.List;
import java.util.UUID;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class PlayerList {
    private final transient TabList plugin;
    private final transient TabListUser user;
    private final transient boolean isHideShowByPluginSupported;

    public PlayerList(TabList plugin, TabListUser user) {
        boolean hsSupported;
        this.plugin = plugin;
        this.user = user;
        try {
            Player.class.getDeclaredMethod("hidePlayer", Plugin.class, Player.class);
            hsSupported = true;
        }
        catch (NoSuchMethodException ex) {
            hsSupported = false;
        }
        this.isHideShowByPluginSupported = hsSupported;
    }

    public void hide() {
        Player player2 = this.user.getPlayer();
        if (player2 == null) {
            return;
        }
        boolean checked = false;
        for (TabListUser user : this.plugin.getUsers()) {
            if (!checked && user.getUniqueId().equals(this.user.getUniqueId())) {
                checked = true;
                continue;
            }
            Player pl = user.getPlayer();
            if (pl == null) continue;
            this.hide(player2, pl);
            this.hide(pl, player2);
        }
    }

    public void showEveryone() {
        Player player2 = this.user.getPlayer();
        if (player2 == null) {
            return;
        }
        boolean checked = false;
        for (TabListUser user : this.plugin.getUsers()) {
            if (!checked && user.getUniqueId().equals(this.user.getUniqueId())) {
                checked = true;
                continue;
            }
            Player pls = user.getPlayer();
            if (pls == null) continue;
            this.show(pls, player2);
            this.show(player2, pls);
        }
    }

    public void displayInWorld() {
        Player player2 = this.user.getPlayer();
        if (player2 == null) {
            return;
        }
        boolean checked = false;
        World playerWorld = player2.getWorld();
        UUID worldId = playerWorld.getUID();
        for (TabListUser user : this.plugin.getUsers()) {
            if (!checked && user.getUniqueId().equals(this.user.getUniqueId())) {
                checked = true;
                continue;
            }
            Player pls = user.getPlayer();
            if (pls == null || !worldId.equals(pls.getWorld().getUID())) continue;
            this.show(player2, pls);
            this.show(pls, player2);
        }
        String playerWorldName = playerWorld.getName();
        int index = -1;
        checked = false;
        for (List<String> keys : ConfigValues.PER_WORLD_LIST_NAMES) {
            for (int i = 0; i < keys.size(); ++i) {
                if (!playerWorldName.equalsIgnoreCase(keys.get(i))) continue;
                index = i;
                break;
            }
            if (index == -1) continue;
            for (int a = 0; a < keys.size(); ++a) {
                World world;
                if (index == a || (world = this.plugin.getServer().getWorld(keys.get(a))) == null) continue;
                for (Player worldPlayer : world.getPlayers()) {
                    if (!checked && worldPlayer.getUniqueId().equals(this.user.getUniqueId())) {
                        checked = true;
                        continue;
                    }
                    this.show(worldPlayer, player2);
                    this.show(player2, worldPlayer);
                }
            }
        }
    }

    private void hide(Player to, Player pls) {
        if (this.isHideShowByPluginSupported) {
            to.hidePlayer((Plugin)this.plugin, pls);
        } else {
            to.hidePlayer(pls);
        }
    }

    private void show(Player to, Player pls) {
        if (this.isHideShowByPluginSupported) {
            to.showPlayer((Plugin)this.plugin, pls);
        } else {
            to.showPlayer(pls);
        }
    }
}

