/*
 * Decompiled with CFR 0.152.
 */
package hu.montlikadani.tablist.tablist.groups;

import hu.montlikadani.tablist.TabList;
import hu.montlikadani.tablist.config.constantsLoader.ConfigValues;
import hu.montlikadani.tablist.tablist.TabText;
import hu.montlikadani.tablist.tablist.groups.GroupPlayer;
import hu.montlikadani.tablist.tablist.groups.TeamHandler;
import hu.montlikadani.tablist.user.TabListUser;
import hu.montlikadani.tablist.utils.PluginUtils;
import hu.montlikadani.tablist.utils.Util;
import hu.montlikadani.tablist.utils.scheduler.TLScheduler;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.stream.Collectors;
import net.luckperms.api.model.group.Group;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public final class Groups {
    private final TabList plugin;
    private TLScheduler animationTask;
    private final List<TeamHandler> teams = new ArrayList<TeamHandler>();
    private final Deque<GroupPlayer> sortedPlayers = new ConcurrentLinkedDeque<GroupPlayer>();
    private final Set<GroupPlayer> afkPlayersCache = new HashSet<GroupPlayer>();
    private boolean toSort = true;
    private TeamHandler defaultAssignedGroup;
    private final ReentrantLock lock = new ReentrantLock();

    public Groups(TabList plugin) {
        this.plugin = plugin;
    }

    public List<TeamHandler> getTeams() {
        return new ArrayList<TeamHandler>(this.teams);
    }

    public TeamHandler getDefaultAssignedGroup() {
        return this.defaultAssignedGroup;
    }

    public Optional<TeamHandler> getTeam(String name) {
        if (name.isEmpty()) {
            throw new IllegalArgumentException("The team name can not be empty");
        }
        for (TeamHandler handler : this.teams) {
            if (!handler.name.equalsIgnoreCase(name)) continue;
            return Optional.of(handler);
        }
        return Optional.empty();
    }

    public boolean isToSort() {
        return this.toSort;
    }

    public void setToSort(boolean toSort) {
        this.toSort = toSort;
    }

    public void load() {
        ConfigurationSection section;
        this.teams.clear();
        if (!ConfigValues.isPrefixSuffixEnabled()) {
            return;
        }
        FileConfiguration gr = this.plugin.getConf().getGroups();
        String globPrefix = gr.getString("globalGroup.prefix", "");
        String globSuffix = gr.getString("globalGroup.suffix", "");
        String globTabName = gr.getString("globalGroup.tabname", "");
        if (!(globTabName.isEmpty() && globPrefix.isEmpty() && globSuffix.isEmpty())) {
            TeamHandler team = new TeamHandler("global", TabText.parseFromText(this.plugin.getPlaceholders().replaceMiscVariables(globPrefix)), TabText.parseFromText(this.plugin.getPlaceholders().replaceMiscVariables(globSuffix)));
            team.global = true;
            team.tabName = TabText.parseFromText(this.plugin.getPlaceholders().replaceMiscVariables(globTabName));
            this.teams.add(team);
        }
        if ((section = gr.getConfigurationSection("groups")) == null) {
            if (!this.teams.isEmpty()) {
                this.startTask();
            }
            return;
        }
        Set keys = section.getKeys(false);
        if (keys.isEmpty()) {
            if (!this.teams.isEmpty()) {
                this.startTask();
            }
            return;
        }
        if (ConfigValues.isSyncPluginsGroups() && this.plugin.hasPermissionService()) {
            boolean saveRequired = false;
            block2: for (String one : this.plugin.getPermissionService().getGroups()) {
                for (String name : keys) {
                    if (!one.equalsIgnoreCase(name)) continue;
                    continue block2;
                }
                Object group2 = this.plugin.getPermissionService().groupObjectByName(one);
                if (group2 != null) {
                    String prefix = ((Group)group2).getCachedData().getMetaData().getPrefix();
                    section.set(one + ".prefix", prefix != null ? prefix : "[" + one + "] - ");
                } else {
                    section.set(one + ".prefix", (Object)("[" + one + "] - "));
                }
                saveRequired = true;
            }
            if (saveRequired) {
                try {
                    gr.save(this.plugin.getConf().getGroupsFile());
                }
                catch (IOException ex) {
                    Util.printTrace(Level.SEVERE, (Plugin)this.plugin, ex.getMessage(), ex);
                }
            }
        }
        int last = 0;
        for (String name : keys) {
            if ("exampleGroup".equals(name) || "PlayerName".equals(name)) continue;
            TabText prefix = TabText.parseFromText(this.plugin.getPlaceholders().replaceMiscVariables(section.getString(name + ".prefix", "")));
            TabText suffix = TabText.parseFromText(this.plugin.getPlaceholders().replaceMiscVariables(section.getString(name + ".suffix", "")));
            last = section.getInt(name + ".sort-priority", last + 1);
            TeamHandler th = new TeamHandler(name, prefix, suffix, section.getString(name + ".permission", ""), last);
            th.setAfkSortPriority(section.getInt(name + ".afk-sort-priority", -1));
            th.tabName = TabText.parseFromText(this.plugin.getPlaceholders().replaceMiscVariables(section.getString(name + ".tabname", "")));
            this.teams.add(th);
        }
        this.defaultAssignedGroup = new TeamHandler("defaultLast", TabText.EMPTY, TabText.EMPTY, "", 0);
        this.teams.add(this.defaultAssignedGroup);
        this.setTeamWeights();
        this.startTask();
    }

    private void setTeamWeights() {
        if (!ConfigValues.isUseLPWeightToOrderGroupsFirst() || ConfigValues.isPreferPrimaryVaultGroup() || !this.plugin.hasPermissionService() || !this.plugin.getPermissionService().hasLuckPerms) {
            return;
        }
        for (TeamHandler teamHandler : this.teams) {
            Group group2 = (Group)this.plugin.getPermissionService().groupObjectByName(teamHandler.name);
            if (group2 == null) continue;
            group2.getWeight().ifPresent(weight -> {
                teamHandler.priority = weight;
            });
        }
    }

    public void setPlayerTeam(GroupPlayer groupPlayer, int safePriority) {
        groupPlayer.setSafePriority(safePriority);
        groupPlayer.tabTeam.createAndUpdateTeam();
    }

    public GroupPlayer addPlayer(Player player2) {
        TabListUser user = this.plugin.getUser(player2).orElse(null);
        if (user == null) {
            return null;
        }
        GroupPlayer groupPlayer = user.getGroupPlayer();
        groupPlayer.update();
        this.setToSort(true);
        this.sortedPlayers.add(groupPlayer);
        this.sortPlayers();
        return groupPlayer;
    }

    public void removePlayerGroup(TabListUser user) {
        GroupPlayer groupPlayer = user.getGroupPlayer();
        this.sortedPlayers.remove(groupPlayer);
        this.afkPlayersCache.remove(groupPlayer);
        groupPlayer.removeGroup();
    }

    public boolean removeTeam(String teamName) {
        this.getTeam(teamName).ifPresent(this.teams::remove);
        FileConfiguration config = this.plugin.getConf().getGroups();
        String path = "groups." + teamName;
        if (!config.contains(path)) {
            return false;
        }
        config.set(path, null);
        try {
            config.save(this.plugin.getConf().getGroupsFile());
        }
        catch (IOException ex) {
            Util.printTrace(Level.SEVERE, (Plugin)this.plugin, ex.getMessage(), ex);
        }
        return true;
    }

    public void addTeam(TeamHandler team) {
        this.teams.add(team);
        this.setTeamWeights();
    }

    public void cancelUpdate() {
        this.cancelTask();
        this.sortedPlayers.clear();
        this.afkPlayersCache.clear();
        for (TabListUser user : this.plugin.getUsers()) {
            user.getGroupPlayer().removeGroup();
        }
    }

    private void cancelTask() {
        if (this.animationTask != null) {
            this.animationTask.cancelTask();
            this.animationTask = null;
        }
    }

    public void startTask() {
        if (!ConfigValues.isPrefixSuffixEnabled()) {
            return;
        }
        int refreshInt = ConfigValues.getGroupsRefreshInterval();
        if (refreshInt < 1) {
            this.updatePlayers();
            return;
        }
        if (this.animationTask == null) {
            this.animationTask = this.plugin.newTLScheduler().submitAsync(() -> {
                if (this.plugin.tpsIsUnderValue() || this.plugin.getUsers().isEmpty()) {
                    this.cancelTask();
                    return;
                }
                if (!this.lock.isLocked()) {
                    this.updatePlayers();
                }
            }, 0L, refreshInt);
        }
    }

    private void updatePlayers() {
        for (TabListUser user : this.plugin.getUsers()) {
            GroupPlayer gp = user.getGroupPlayer();
            if (!gp.update()) continue;
            this.sortedPlayers.remove(gp);
            this.sortedPlayers.add(gp);
        }
        this.sortPlayers();
    }

    private void sortPlayers() {
        List playerGroups;
        this.lock.lock();
        try {
            playerGroups = this.sortedPlayers.stream().sorted(Comparator.comparingInt(GroupPlayer::getPriority)).collect(Collectors.toList());
        }
        finally {
            this.lock.unlock();
        }
        this.sortedPlayers.clear();
        this.sortedPlayers.addAll(playerGroups);
        int priority = playerGroups.size();
        for (GroupPlayer groupPlayer : this.sortedPlayers) {
            if (ConfigValues.isAfkStatusEnabled() && (ConfigValues.isAfkSortLast() || groupPlayer.getGroup() != null && groupPlayer.getGroup().getAfkSortPriority() != -1)) {
                if (PluginUtils.isAfk(groupPlayer.tabListUser.getPlayer())) {
                    if (!this.afkPlayersCache.add(groupPlayer) || this.toSort) continue;
                    this.setToSort(true);
                    continue;
                }
                if (this.afkPlayersCache.remove(groupPlayer) && !this.toSort) {
                    this.setToSort(true);
                }
            }
            this.setPlayerTeam(groupPlayer, priority--);
        }
        if (!this.afkPlayersCache.isEmpty()) {
            int size = playerGroups.size();
            for (GroupPlayer afk : this.afkPlayersCache) {
                int afkSortPriority = afk.getGroup().getAfkSortPriority();
                this.setPlayerTeam(afk, afk.getGroup() == null || afkSortPriority == -1 ? size++ : afkSortPriority);
            }
        }
        if (this.toSort) {
            this.setToSort(false);
        }
    }
}

