/*
 * Decompiled with CFR 0.152.
 */
package hu.montlikadani.tablist.tablist.groups;

import hu.montlikadani.tablist.TabList;
import hu.montlikadani.tablist.config.constantsLoader.ConfigValues;
import hu.montlikadani.tablist.tablist.TabText;
import hu.montlikadani.tablist.tablist.groups.Groups;
import hu.montlikadani.tablist.tablist.groups.TeamHandler;
import hu.montlikadani.tablist.tablist.groups.impl.ReflectionHandled;
import hu.montlikadani.tablist.user.TabListUser;
import hu.montlikadani.tablist.utils.PluginUtils;
import java.util.List;
import org.bukkit.entity.Player;

public final class GroupPlayer {
    public final transient TabListUser tabListUser;
    public final transient ReflectionHandled tabTeam;
    private final transient TabList tl;
    private transient TeamHandler group;
    private transient TeamHandler globalGroup;
    private String customPrefix;
    private String customSuffix;
    private String playerPrimaryGroup;
    private int customPriority = Integer.MIN_VALUE;
    private int safePriority;
    private TabText fullName;

    public GroupPlayer(TabList tl, TabListUser tabListUser) {
        this.tl = tl;
        this.tabListUser = tabListUser;
        this.tabTeam = new ReflectionHandled(tl, this);
    }

    public void setGroup(TeamHandler group2) {
        this.group = group2;
        this.tl.getGroups().setToSort(true);
    }

    public TeamHandler getGroup() {
        return this.group;
    }

    public String getFullGroupTeamName() {
        return "a" + (this.safePriority > 9 ? "" : "0") + this.safePriority;
    }

    public void removeGroup() {
        this.tabTeam.unregisterTeam();
        this.globalGroup = null;
        this.group = null;
        this.playerPrimaryGroup = null;
    }

    public void setCustomPrefix(String customPrefix) {
        this.customPrefix = customPrefix;
    }

    public void setCustomSuffix(String customSuffix) {
        this.customSuffix = customSuffix;
    }

    public void setCustomPriority(int customPriority) {
        this.customPriority = customPriority;
    }

    public void setSafePriority(int safePriority) {
        if (safePriority > 98) {
            this.safePriority = 99;
            return;
        }
        if (safePriority < 0) {
            safePriority = 0;
        }
        this.safePriority = safePriority;
    }

    public int getPriority() {
        return this.customPriority == Integer.MIN_VALUE ? (this.group == null ? Integer.MAX_VALUE : this.group.priority) : this.customPriority;
    }

    private void refreshPlayerPrimaryGroup(Player player2) {
        if (!this.tl.hasPermissionService() || !ConfigValues.isPreferPrimaryVaultGroup()) {
            return;
        }
        if (this.playerPrimaryGroup == null || !this.tl.getPermissionService().playerInGroup(player2, this.playerPrimaryGroup)) {
            this.playerPrimaryGroup = this.tl.getPermissionService().getPrimaryGroup(player2);
        }
    }

    public boolean update() {
        Player player2 = this.tabListUser.getPlayer();
        if (player2 == null) {
            return false;
        }
        if (!this.isPlayerCanSeeGroup(player2)) {
            if (this.group != null || this.globalGroup != null) {
                this.tl.getGroups().removePlayerGroup(this.tabListUser);
                this.tl.getGroups().setToSort(false);
                return true;
            }
            return false;
        }
        Groups groups = this.tl.getGroups();
        List<TeamHandler> teams = groups.getTeams();
        boolean update = false;
        for (TeamHandler gl : teams) {
            if (!gl.global || this.globalGroup == gl) continue;
            this.globalGroup = gl;
            groups.setToSort(true);
            update = true;
            break;
        }
        String playerName = player2.getName();
        for (TeamHandler team : teams) {
            if (team.global || !playerName.equalsIgnoreCase(team.name)) continue;
            if (this.group != team) {
                this.setGroup(team);
                return true;
            }
            return update;
        }
        this.refreshPlayerPrimaryGroup(player2);
        for (TeamHandler team : teams) {
            if (team.global) continue;
            if (this.playerPrimaryGroup != null) {
                if (!this.playerPrimaryGroup.equalsIgnoreCase(team.name)) continue;
                if (this.group != team) {
                    update = true;
                    this.setGroup(team);
                }
                return update;
            }
            if (!team.permission.isEmpty()) {
                if (!PluginUtils.hasPermission(player2, team.permission)) continue;
                if (this.group != team) {
                    update = true;
                    this.setGroup(team);
                }
                return update;
            }
            if (!this.tl.hasPermissionService() || !this.tl.getPermissionService().playerInGroup(player2, team.name)) continue;
            if (this.group != team) {
                update = true;
                this.setGroup(team);
            }
            return update;
        }
        if (this.group != groups.getDefaultAssignedGroup() || this.group == null && this.globalGroup == null) {
            this.setGroup(groups.getDefaultAssignedGroup());
            update = true;
        }
        return update;
    }

    private boolean isPlayerCanSeeGroup(Player player2) {
        if (ConfigValues.isAfkStatusEnabled() && !ConfigValues.isAfkStatusShowPlayerGroup() && PluginUtils.isAfk(player2)) {
            return false;
        }
        if (ConfigValues.isHideGroupInVanish() && PluginUtils.isVanished(player2)) {
            this.tabTeam.unregisterTeam();
            return false;
        }
        boolean containsWorld = ConfigValues.getGroupsDisabledWorlds().indexOf(player2.getWorld().getName()) != -1;
        boolean useDisabledWorldsAsWhiteList = ConfigValues.isUseDisabledWorldsAsWhiteList();
        return !(useDisabledWorldsAsWhiteList && !containsWorld || !useDisabledWorldsAsWhiteList && containsWorld);
    }

    public TabText getTabNameWithPrefixSuffix() {
        Object suffix;
        Object prefix;
        Object tabName = null;
        if (ConfigValues.isAssignGlobalGroup() && this.globalGroup != null && !this.globalGroup.tabName.getPlainText().isEmpty()) {
            tabName = this.globalGroup.tabName.getPlainText();
            if (this.group != null && !this.group.tabName.getPlainText().isEmpty()) {
                tabName = this.group.tabName.getPlainText() + (String)tabName;
            }
        } else if (this.group != null && !this.group.tabName.getPlainText().isEmpty()) {
            tabName = this.group.tabName.getPlainText();
        }
        Player player2 = this.tabListUser.getPlayer();
        if (tabName == null) {
            if (this.globalGroup != null && !this.globalGroup.tabName.getPlainText().isEmpty()) {
                tabName = this.globalGroup.tabName.getPlainText();
            } else {
                Object object = tabName = player2 != null ? player2.getName() : "";
            }
        }
        Object object = this.customPrefix == null ? (this.group == null ? "" : this.group.prefix.getPlainText()) : (prefix = this.customPrefix);
        Object object2 = this.customSuffix == null ? (this.group == null ? "" : this.group.suffix.getPlainText()) : (suffix = this.customSuffix);
        if (this.globalGroup != null) {
            if (ConfigValues.isAssignGlobalGroup()) {
                prefix = this.globalGroup.prefix.getPlainText() + (String)prefix;
                suffix = (String)suffix + this.globalGroup.suffix.getPlainText();
            } else if (((String)prefix).isEmpty() && ((String)suffix).isEmpty()) {
                prefix = this.globalGroup.prefix.getPlainText();
                suffix = this.globalGroup.suffix.getPlainText();
            }
        }
        if (player2 != null && ConfigValues.isAfkStatusEnabled()) {
            if (!ConfigValues.isAfkStatusShowInRightLeftSide()) {
                prefix = (PluginUtils.isAfk(player2) ? ConfigValues.getAfkFormatYes() : ConfigValues.getAfkFormatNo()) + (String)prefix;
            } else {
                suffix = (String)suffix + (PluginUtils.isAfk(player2) ? ConfigValues.getAfkFormatYes() : ConfigValues.getAfkFormatNo());
            }
        }
        String full = this.tl.getPlaceholders().replaceVariables(player2, this.tl.makeAnim((String)prefix + (String)tabName + (String)suffix));
        if (this.fullName == null) {
            this.fullName = TabText.parseFromText(full);
        } else {
            this.fullName.updateText(full);
        }
        return this.fullName;
    }
}

