/*
 * Decompiled with CFR 0.152.
 */
package hu.montlikadani.tablist.tablist.fakeplayers;

import hu.montlikadani.tablist.TabList;
import hu.montlikadani.tablist.config.constantsLoader.ConfigValues;
import hu.montlikadani.tablist.tablist.fakeplayers.FakePlayer;
import hu.montlikadani.tablist.tablist.fakeplayers.IFakePlayer;
import hu.montlikadani.tablist.utils.PlayerSkinProperties;
import hu.montlikadani.tablist.utils.Util;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;

public final class FakePlayerHandler {
    private final TabList plugin;
    public final Set<IFakePlayer> fakePlayers = new HashSet<IFakePlayer>();

    public FakePlayerHandler(TabList plugin) {
        this.plugin = plugin;
    }

    public Optional<IFakePlayer> getFakePlayerByName(String name) {
        if (name.isEmpty()) {
            throw new IllegalArgumentException("The fake player name can not be empty");
        }
        for (IFakePlayer fp : this.fakePlayers) {
            if (!fp.getName().equalsIgnoreCase(name)) continue;
            return Optional.of(fp);
        }
        return Optional.empty();
    }

    public void load() {
        this.fakePlayers.clear();
        if (!ConfigValues.isFakePlayers()) {
            File file = this.plugin.getConf().getFakeplayersFile();
            if (!file.exists()) {
                return;
            }
            if (file.length() == 0L) {
                if (!file.delete()) {
                    throw new RuntimeException("Failed to delete file " + file.getName());
                }
                return;
            }
            ConfigurationSection section = YamlConfiguration.loadConfiguration((File)file).getConfigurationSection("list");
            if (section != null && section.getKeys(false).isEmpty() && !file.delete()) {
                throw new RuntimeException("Failed to delete file " + file.getName());
            }
            return;
        }
        ConfigurationSection section = this.plugin.getConf().getFakeplayers().getConfigurationSection("list");
        if (section == null) {
            return;
        }
        for (String name : section.getKeys(false)) {
            FakePlayer fakePlayer = new FakePlayer(name, section.getString(name + ".displayname", ""), section.getString(name + ".headuuid", ""), section.getInt(name + ".ping", -1));
            fakePlayer.show();
            this.fakePlayers.add(fakePlayer);
        }
    }

    public void display() {
        for (IFakePlayer fakePlayer : this.fakePlayers) {
            fakePlayer.show();
        }
    }

    public EditingResult createPlayer(String name, String displayName, String headUUID, int ping) {
        if (name.isEmpty()) {
            return EditingResult.UNKNOWN;
        }
        if (this.getFakePlayerByName(name).isPresent()) {
            return EditingResult.ALREADY_EXIST;
        }
        if (name.length() > 16) {
            name = name.substring(0, 16);
        }
        if (ping < -1) {
            ping = -1;
        }
        String path = "list." + name + ".";
        this.setOptionsAndSave(path + "headuuid", headUUID, path + "ping", ping, path + "displayname", displayName);
        FakePlayer fakePlayer = new FakePlayer(name, displayName, headUUID, ping);
        fakePlayer.show();
        this.fakePlayers.add(fakePlayer);
        return EditingResult.OK;
    }

    public void removeAllFakePlayer() {
        this.fakePlayers.forEach(IFakePlayer::remove);
        this.fakePlayers.clear();
    }

    public EditingResult removePlayer(String name) {
        Optional<IFakePlayer> optional = this.getFakePlayerByName(name);
        if (!optional.isPresent()) {
            return EditingResult.NOT_EXIST;
        }
        ConfigurationSection section = this.plugin.getConf().getFakeplayers().getConfigurationSection("list");
        if (section != null) {
            for (String sName : section.getKeys(false)) {
                if (!sName.equalsIgnoreCase(name)) continue;
                section.set(sName, null);
                try {
                    this.plugin.getConf().getFakeplayers().save(this.plugin.getConf().getFakeplayersFile());
                    break;
                }
                catch (IOException ex) {
                    Util.printTrace(Level.SEVERE, (Plugin)this.plugin, ex.getMessage(), ex);
                    return EditingResult.UNKNOWN;
                }
            }
        }
        IFakePlayer fakePlayer = optional.get();
        fakePlayer.remove();
        this.fakePlayers.remove(fakePlayer);
        return EditingResult.OK;
    }

    public EditingResult renamePlayer(String oldName, String newName) {
        Optional<IFakePlayer> optional = this.getFakePlayerByName(oldName);
        if (!optional.isPresent()) {
            return EditingResult.NOT_EXIST;
        }
        if (newName.length() > 16) {
            newName = newName.substring(0, 16);
        }
        this.setOptionsAndSave("list." + newName, this.plugin.getConf().getFakeplayers().get("list." + oldName), "list." + oldName, null);
        optional.get().setName(newName);
        return EditingResult.OK;
    }

    public EditingResult setSkin(String name, PlayerSkinProperties skinProperties) {
        Optional<IFakePlayer> optional = this.getFakePlayerByName(name);
        if (!optional.isPresent()) {
            return EditingResult.NOT_EXIST;
        }
        this.setOptionsAndSave("list." + name + ".headuuid", skinProperties.playerId.toString());
        optional.get().setSkin(skinProperties);
        return EditingResult.OK;
    }

    public EditingResult setPing(String name, int amount) {
        if (amount < -1) {
            return EditingResult.PING_AMOUNT;
        }
        Optional<IFakePlayer> optional = this.getFakePlayerByName(name);
        if (!optional.isPresent()) {
            return EditingResult.NOT_EXIST;
        }
        this.setOptionsAndSave("list." + name + ".ping", amount);
        optional.get().setPing(amount);
        return EditingResult.OK;
    }

    public EditingResult setDisplayName(String name, String displayName) {
        Optional<IFakePlayer> optional = this.getFakePlayerByName(name);
        if (!optional.isPresent()) {
            return EditingResult.NOT_EXIST;
        }
        this.setOptionsAndSave("list." + name + ".displayname", displayName);
        optional.get().setDisplayName(displayName);
        return EditingResult.OK;
    }

    private void setOptionsAndSave(Object ... pathOption) {
        FileConfiguration config = this.plugin.getConf().getFakeplayers();
        for (int i = 0; i < pathOption.length; i += 2) {
            config.set((String)pathOption[i], pathOption[i + 1]);
        }
        try {
            config.save(this.plugin.getConf().getFakeplayersFile());
        }
        catch (IOException ex) {
            Util.printTrace(Level.SEVERE, (Plugin)this.plugin, ex.getMessage(), ex);
        }
    }

    public static enum EditingResult {
        NOT_EXIST,
        ALREADY_EXIST,
        PING_AMOUNT,
        UNKNOWN,
        OK;

    }
}

