/*
 * Decompiled with CFR 0.152.
 */
package hu.montlikadani.tablist.tablist.fakeplayers;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import hu.montlikadani.tablist.Global;
import hu.montlikadani.tablist.Objects;
import hu.montlikadani.tablist.config.constantsLoader.ConfigValues;
import hu.montlikadani.tablist.packets.PacketNM;
import hu.montlikadani.tablist.tablist.fakeplayers.IFakePlayer;
import hu.montlikadani.tablist.utils.PlayerSkinProperties;
import hu.montlikadani.tablist.utils.Util;
import hu.montlikadani.tablist.utils.reflection.ComponentParser;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public final class FakePlayer
implements IFakePlayer {
    private final String displayName;
    private String name;
    private PlayerSkinProperties playerSkinProperties;
    private int ping = -1;
    private Object fakeEntityPlayer;
    private GameProfile profile;

    public FakePlayer(String name, String displayName, String headId, int ping) {
        this.setNameWithoutRenamingProfile(name);
        this.displayName = displayName == null ? "" : displayName;
        this.ping = ping;
        this.profile = new GameProfile(Util.tryParseId(headId).orElseGet(UUID::randomUUID), this.name);
        this.playerSkinProperties = new PlayerSkinProperties(this.name, this.profile.getId());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public PlayerSkinProperties profileProperties() {
        return this.playerSkinProperties;
    }

    @Override
    public int getPingLatency() {
        return this.ping;
    }

    @Override
    public GameProfile getProfile() {
        return this.profile;
    }

    @Override
    public void setName(String name) {
        this.setNameWithoutRenamingProfile(name);
        this.profile = new GameProfile(this.profile.getId(), this.name);
    }

    private void setNameWithoutRenamingProfile(String name) {
        String string = this.name = name == null ? "" : name;
        if (this.name.length() > 16) {
            this.name = this.name.substring(0, 16);
        }
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    private Object displayNameComponent() {
        return this.displayName.isEmpty() ? ComponentParser.EMPTY_COMPONENT : ComponentParser.asComponent(Util.applyTextFormat(Global.replaceToUnicodeSymbol(this.displayName)));
    }

    @Override
    public void setDisplayName(String displayName) {
        if (this.fakeEntityPlayer == null) {
            return;
        }
        if (displayName == null) {
            displayName = "";
        } else if (!displayName.isEmpty()) {
            displayName = Util.applyTextFormat(Global.replaceToUnicodeSymbol(displayName));
        }
        Object packet = PacketNM.NMS_PACKET.updateDisplayNamePacket(this.fakeEntityPlayer, ComponentParser.asComponent(displayName), true);
        for (Player player2 : Bukkit.getServer().getOnlinePlayers()) {
            PacketNM.NMS_PACKET.sendPacket(player2, packet);
        }
    }

    @Override
    public void show() {
        if (this.fakeEntityPlayer == null) {
            this.putTextureProperty();
            this.fakeEntityPlayer = PacketNM.NMS_PACKET.getNewEntityPlayer(this.profile);
        }
        Object dName = this.displayNameComponent();
        PacketNM.NMS_PACKET.setListName(this.fakeEntityPlayer, dName);
        Object packetAdd = PacketNM.NMS_PACKET.newPlayerInfoUpdatePacketAdd(this.fakeEntityPlayer);
        PacketNM.NMS_PACKET.setInfoData(packetAdd, this.profile.getId(), this.ping, dName);
        for (Player player2 : Bukkit.getServer().getOnlinePlayers()) {
            PacketNM.NMS_PACKET.sendPacket(player2, packetAdd);
        }
    }

    @Override
    public void setPing(int ping) {
        if (this.fakeEntityPlayer == null) {
            return;
        }
        if (ping < -1) {
            ping = -1;
        }
        this.ping = ping;
        Object info = PacketNM.NMS_PACKET.updateLatency(this.fakeEntityPlayer);
        Object packetUpdateScore = null;
        Objects.ObjectTypes objectType = ConfigValues.getObjectType();
        if (objectType == Objects.ObjectTypes.PING) {
            packetUpdateScore = PacketNM.NMS_PACKET.changeScoreboardScorePacket(objectType.objectName, this.name, ping);
        }
        PacketNM.NMS_PACKET.setInfoData(info, this.profile.getId(), ping, this.displayNameComponent());
        for (Player player2 : Bukkit.getServer().getOnlinePlayers()) {
            PacketNM.NMS_PACKET.sendPacket(player2, info);
            if (packetUpdateScore == null) continue;
            PacketNM.NMS_PACKET.sendPacket(player2, packetUpdateScore);
        }
    }

    @Override
    public void setSkin(PlayerSkinProperties skinProperties) {
        this.playerSkinProperties = skinProperties;
        this.putTextureProperty();
    }

    private void putTextureProperty() {
        if (!Bukkit.getServer().getOnlineMode()) {
            return;
        }
        this.playerSkinProperties.retrieveTextureData().thenAcceptAsync(v -> {
            if (this.playerSkinProperties.textureRawValue == null || this.playerSkinProperties.decodedTextureValue == null) {
                return;
            }
            PropertyMap propertyMap = this.profile.getProperties();
            propertyMap.removeAll((Object)"textures");
            propertyMap.put((Object)"name", (Object)new Property("name", this.name));
            propertyMap.put((Object)"textures", (Object)new Property("textures", this.playerSkinProperties.textureRawValue, this.playerSkinProperties.decodedTextureValue));
            if (this.fakeEntityPlayer == null) {
                return;
            }
            Object removeInfo = PacketNM.NMS_PACKET.removeEntityPlayers(this.fakeEntityPlayer);
            Object addInfo = PacketNM.NMS_PACKET.newPlayerInfoUpdatePacketAdd(this.fakeEntityPlayer);
            for (Player player2 : Bukkit.getServer().getOnlinePlayers()) {
                PacketNM.NMS_PACKET.sendPacket(player2, removeInfo);
                PacketNM.NMS_PACKET.sendPacket(player2, addInfo);
            }
        });
    }

    @Override
    public void remove() {
        if (this.fakeEntityPlayer == null) {
            return;
        }
        Object info = PacketNM.NMS_PACKET.removeEntityPlayers(this.fakeEntityPlayer);
        for (Player player2 : Bukkit.getServer().getOnlinePlayers()) {
            PacketNM.NMS_PACKET.sendPacket(player2, info);
        }
        this.fakeEntityPlayer = null;
    }
}

