/*
 * Decompiled with CFR 0.152.
 */
package hu.montlikadani.tablist.tablist;

import hu.montlikadani.tablist.TabList;
import hu.montlikadani.tablist.config.constantsLoader.TabConfigValues;
import hu.montlikadani.tablist.user.TabListUser;
import hu.montlikadani.tablist.utils.Util;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;

public final class TabToggleBase {
    public static final Set<UUID> TEMPORAL_PLAYER_CACHE = new HashSet<UUID>();
    public static boolean globallySwitched = false;

    public static boolean isDisabled(TabListUser user) {
        return globallySwitched || !user.isTabVisible();
    }

    TabToggleBase() {
    }

    public void load(TabList tl) {
        if (!TabConfigValues.isRememberToggledTablistToFile()) {
            return;
        }
        File file = new File(tl.getDataFolder(), "toggledtablists.yml");
        if (!file.exists()) {
            return;
        }
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
        globallySwitched = config.getBoolean("globallySwitched", false);
        if (!globallySwitched) {
            ConfigurationSection section = config.getConfigurationSection("tablists");
            if (section == null) {
                return;
            }
            for (String uuid : section.getKeys(false)) {
                if (section.getBoolean(uuid, false)) continue;
                try {
                    UUID id = UUID.fromString(uuid);
                    Optional<TabListUser> user = tl.getUser(id);
                    if (user.isPresent()) {
                        user.get().setTabVisibility(false);
                        continue;
                    }
                    TEMPORAL_PLAYER_CACHE.add(id);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
            return;
        }
        config.set("tablists", null);
        try {
            config.save(file);
        }
        catch (IOException ex) {
            Util.printTrace(Level.SEVERE, (Plugin)tl, ex.getMessage(), ex);
        }
    }

    public void save(TabList tl) {
        File file = new File(tl.getDataFolder(), "toggledtablists.yml");
        if (!TabConfigValues.isRememberToggledTablistToFile() || !globallySwitched && tl.getUsers().stream().allMatch(TabListUser::isTabVisible)) {
            if (file.exists() && !file.delete()) {
                throw new RuntimeException("Failed to delete file toggledtablists.yml");
            }
            return;
        }
        if (!file.exists()) {
            try {
                if (!file.createNewFile()) {
                    throw new RuntimeException("Failed to create toggledtablists.yml file");
                }
            }
            catch (IOException ex) {
                Util.printTrace(Level.SEVERE, (Plugin)tl, ex.getMessage(), ex);
            }
        }
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
        config.set("tablists", null);
        if (globallySwitched) {
            config.set("globallySwitched", (Object)true);
        } else {
            for (TabListUser user : tl.getUsers()) {
                if (user.isTabVisible()) continue;
                config.set("tablists." + user.getUniqueId().toString(), (Object)false);
            }
            for (UUID id : TEMPORAL_PLAYER_CACHE) {
                config.set("tablists." + id.toString(), (Object)false);
            }
            config.set("globallySwitched", null);
        }
        TEMPORAL_PLAYER_CACHE.clear();
        try {
            config.save(file);
        }
        catch (IOException ex) {
            Util.printTrace(Level.SEVERE, (Plugin)tl, ex.getMessage(), ex);
        }
    }
}

