/*
 * Decompiled with CFR 0.152.
 */
package hu.montlikadani.tablist.tablist;

import com.google.gson.JsonElement;
import hu.montlikadani.tablist.utils.reflection.ComponentParser;
import hu.montlikadani.tablist.utils.reflection.JsonComponent;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;

public final class TabText {
    public static final TabText EMPTY = new TabText();
    String plainText = "";
    private List<JsonElementData> jsonElements = new ArrayList<JsonElementData>();
    private final List<JsonElementData> toSkip = new ArrayList<JsonElementData>(1);

    public TabText() {
    }

    public TabText(TabText another) {
        if (another != null) {
            this.jsonElements = another.jsonElements;
            this.plainText = another.plainText;
        }
    }

    public String getPlainText() {
        return this.plainText;
    }

    public void setPlainText(String plainText) {
        this.plainText = plainText;
    }

    public List<JsonElementData> getJsonElements() {
        return this.jsonElements;
    }

    public static TabText parseFromText(String from) {
        if (from == null) {
            return EMPTY;
        }
        TabText tabText = new TabText();
        tabText.updateText(from);
        return tabText;
    }

    public Object toComponent() {
        return this == EMPTY ? ComponentParser.EMPTY_COMPONENT : ComponentParser.asComponent(this);
    }

    public void updateText(String plainText) {
        this.plainText = plainText;
        this.findJsonInText(new StringBuilder(plainText));
    }

    private void findJsonInText(StringBuilder text) {
        int start;
        int end = 0;
        while ((start = text.indexOf("[\"\",{", end)) != -1) {
            end = text.indexOf("]}]", start);
            if (end == -1) {
                end = text.indexOf("}]", start);
                if (end == -1) {
                    break;
                }
            } else {
                ++end;
            }
            if ((end += 2) > text.length()) {
                end = text.length();
            }
            this.addJson(text.substring(start, end));
        }
    }

    private void addJson(String str) {
        for (JsonElementData jsonElementData : this.jsonElements) {
            if (this.toSkip.indexOf(jsonElementData) != -1) {
                return;
            }
            if (!jsonElementData.plainJson.equals(str)) continue;
            this.toSkip.add(jsonElementData);
            return;
        }
        if (!this.toSkip.isEmpty()) {
            this.jsonElements.clear();
            this.jsonElements.addAll(this.toSkip);
            this.toSkip.clear();
        }
        try {
            JsonElement element = null;
            try {
                element = (JsonElement)JsonComponent.GSON.fromJson((Reader)new StringReader(str), JsonElement.class);
            }
            catch (Exception jsonElementData) {
                // empty catch block
            }
            if (element != null) {
                JsonElementDataNew data = new JsonElementDataNew(str);
                data.element = element;
                this.jsonElements.add(data);
            }
        }
        catch (Throwable noc) {
            this.jsonElements.add(new JsonElementDataOld(str));
        }
    }

    public static class JsonElementData {
        public final String plainJson;
        public final int jsonLength;

        public JsonElementData(String plainJson) {
            this.plainJson = plainJson;
            this.jsonLength = plainJson.length();
        }
    }

    public static final class JsonElementDataNew
    extends JsonElementData {
        public JsonElement element;

        public JsonElementDataNew(String plainJson) {
            super(plainJson);
        }
    }

    public static final class JsonElementDataOld
    extends JsonElementData {
        public JsonElementDataOld(String plainJson) {
            super(plainJson);
        }
    }
}

