/*
 * Decompiled with CFR 0.152.
 */
package hu.montlikadani.tablist.tablist;

import hu.montlikadani.tablist.TabList;
import hu.montlikadani.tablist.config.constantsLoader.TabConfigValues;
import hu.montlikadani.tablist.tablist.TabToggleBase;
import hu.montlikadani.tablist.user.TabListUser;
import hu.montlikadani.tablist.utils.scheduler.TLScheduler;

public final class TabManager {
    private final transient TabList plugin;
    public final transient TabToggleBase toggleBase;
    private TLScheduler scheduler;

    public TabManager(TabList plugin) {
        this.plugin = plugin;
        this.toggleBase = new TabToggleBase();
    }

    public void cancelTask() {
        if (this.scheduler != null) {
            this.scheduler.cancelTask();
            this.scheduler = null;
        }
    }

    public void load(TabListUser user) {
        if (!TabConfigValues.isEnabled()) {
            return;
        }
        user.getTabHandler().loadTabComponents();
        int refreshTime = TabConfigValues.getUpdateInterval();
        if (refreshTime < 1) {
            user.getTabHandler().sendTab();
            return;
        }
        if (this.scheduler == null) {
            this.scheduler = this.plugin.newTLScheduler().submitAsync(() -> {
                if (this.plugin.tpsIsUnderValue() || this.plugin.getUsers().isEmpty()) {
                    this.cancelTask();
                    return;
                }
                for (TabListUser one : this.plugin.getUsers()) {
                    one.getTabHandler().sendTab();
                }
            }, 0L, refreshTime);
        }
    }
}

