/*
 * Decompiled with CFR 0.152.
 */
package hu.montlikadani.tablist.tablist;

import hu.montlikadani.api.Pair;
import hu.montlikadani.tablist.TabList;
import hu.montlikadani.tablist.config.constantsLoader.TabConfigValues;
import hu.montlikadani.tablist.packets.PacketNM;
import hu.montlikadani.tablist.tablist.TabText;
import hu.montlikadani.tablist.tablist.TabToggleBase;
import hu.montlikadani.tablist.user.TabListUser;
import hu.montlikadani.tablist.utils.PluginUtils;
import hu.montlikadani.tablist.utils.reflection.ComponentParser;
import java.util.Map;
import java.util.Random;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permission;

public class TabHandler {
    private final TabList plugin;
    private final TabListUser user;
    private boolean tabEmpty;
    private Random random;
    private TabText[] header;
    private TabText[] footer;
    private TabText linedHeader;
    private TabText linedFooter;

    public TabHandler(TabList plugin, TabListUser user) {
        this.plugin = plugin;
        this.user = user;
    }

    /*
     * WARNING - void declaration
     */
    public void loadTabComponents() {
        void var7_24;
        this.tabEmpty = false;
        this.footer = null;
        this.header = null;
        Player player2 = this.user.getPlayer();
        if (player2 == null) {
            return;
        }
        this.sendEmptyTab(player2);
        if (!TabConfigValues.isEnabled() || TabToggleBase.isDisabled(this.user)) {
            return;
        }
        String world = player2.getWorld().getName();
        if (TabConfigValues.getDisabledWorlds().contains(world)) {
            return;
        }
        String pName = player2.getName();
        if (TabConfigValues.getBlackListedPlayers().contains(pName)) {
            return;
        }
        TabConfigValues.OptionSeparator optionSeparator = TabConfigValues.SEPARATOR_MAP.get(world);
        String[] playerGroups = null;
        if (optionSeparator != null) {
            void var6_10;
            void var6_7;
            Pair<TabText[], TabText[]> pair = optionSeparator.getConfigKeyMap().get(pName);
            if (pair == null && this.plugin.hasPermissionService()) {
                String[] stringArray = playerGroups = this.plugin.getPermissionService().getGroups();
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    Pair<TabText[], TabText[]> pair2;
                    String one = stringArray[i];
                    if (this.plugin.getPermissionService().playerInGroup(player2, world, one) && (pair2 = optionSeparator.getConfigKeyMap().get(one)) != null) break;
                }
            }
            if (var6_7 == null) {
                Pair<TabText[], TabText[]> pair3 = optionSeparator.pair;
            }
            this.header = (TabText[])var6_10.key;
            this.footer = (TabText[])var6_10.value;
        }
        for (Map.Entry<Permission, Pair<TabText[], TabText[]>> entry : TabConfigValues.PERMISSION_MAP.entrySet()) {
            if (!PluginUtils.hasPermission(player2, entry.getKey().getName())) continue;
            this.header = (TabText[])entry.getValue().key;
            this.footer = (TabText[])entry.getValue().value;
            break;
        }
        if ((optionSeparator = TabConfigValues.SEPARATOR_MAP.get(pName)) != null) {
            this.header = (TabText[])optionSeparator.pair.key;
            this.footer = (TabText[])optionSeparator.pair.value;
        }
        if (this.plugin.hasPermissionService()) {
            for (String one : playerGroups == null ? this.plugin.getPermissionService().getGroups() : playerGroups) {
                if (!this.plugin.getPermissionService().playerInGroup(player2, one) || (optionSeparator = TabConfigValues.SEPARATOR_MAP.get(one)) == null) continue;
                this.header = (TabText[])optionSeparator.pair.key;
                this.footer = (TabText[])optionSeparator.pair.value;
                break;
            }
        }
        if (!(this.header != null && this.header.length != 0 || this.footer != null && this.footer.length != 0)) {
            this.header = TabConfigValues.getDefaultHeader();
            this.footer = TabConfigValues.getDefaultFooter();
        }
        if (this.header != null) {
            if (this.header.length == 0) {
                this.header = null;
            } else {
                void var7_22;
                StringBuilder stringBuilder = new StringBuilder();
                boolean bl = false;
                while (var7_22 < this.header.length) {
                    if (var7_22 != false) {
                        stringBuilder.append("\n\u00a7r");
                    }
                    TabText tt = this.header[var7_22];
                    stringBuilder.append(tt.plainText);
                    this.header[var7_22] = tt;
                    ++var7_22;
                }
                this.linedHeader = new TabText();
                this.linedHeader.updateText(stringBuilder.toString());
            }
        }
        if (this.footer == null) {
            return;
        }
        if (this.footer.length == 0) {
            this.footer = null;
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        while (var7_24 < this.footer.length) {
            if (var7_24 != false) {
                stringBuilder.append("\n\u00a7r");
            }
            TabText tt = this.footer[var7_24];
            stringBuilder.append(tt.plainText);
            this.footer[var7_24] = tt;
            ++var7_24;
        }
        this.linedFooter = new TabText();
        this.linedFooter.updateText(stringBuilder.toString());
    }

    public void sendEmptyTab(Player player2) {
        if (player2 != null && !this.tabEmpty) {
            PacketNM.NMS_PACKET.sendTabTitle(player2, ComponentParser.EMPTY_COMPONENT, ComponentParser.EMPTY_COMPONENT);
            this.tabEmpty = true;
        }
    }

    protected void sendTab() {
        TabText tt;
        if (this.header == null && this.footer == null) {
            return;
        }
        Player player2 = this.user.getPlayer();
        if (player2 == null) {
            return;
        }
        if (TabToggleBase.isDisabled(this.user) || TabConfigValues.isHideTabWhenPlayerVanished() && PluginUtils.isVanished(player2)) {
            this.sendEmptyTab(player2);
            return;
        }
        TabText he = this.linedHeader;
        TabText fo = this.linedFooter;
        if (TabConfigValues.isRandom()) {
            if (this.random == null) {
                this.random = new Random();
            }
            if (this.header != null) {
                he = this.header[this.header.length == 1 ? 0 : this.random.nextInt(this.header.length)];
            }
            if (this.footer != null) {
                fo = this.footer[this.footer.length == 1 ? 0 : this.random.nextInt(this.footer.length)];
            }
        }
        Object head = ComponentParser.EMPTY_COMPONENT;
        Object foot = ComponentParser.EMPTY_COMPONENT;
        if (he != null) {
            tt = new TabText(he);
            tt.plainText = this.plugin.makeAnim(tt.plainText);
            head = this.toComponentWithVariables(player2, tt);
            this.tabEmpty = false;
        }
        if (fo != null) {
            tt = new TabText(fo);
            tt.plainText = this.plugin.makeAnim(tt.plainText);
            foot = this.toComponentWithVariables(player2, tt);
            this.tabEmpty = false;
        }
        PacketNM.NMS_PACKET.sendTabTitle(player2, head, foot);
    }

    private Object toComponentWithVariables(Player player2, TabText text) {
        if (!text.plainText.isEmpty()) {
            text.updateText(this.plugin.getPlaceholders().replaceVariables(player2, text.plainText));
        }
        return text.toComponent();
    }
}

