/*
 * Decompiled with CFR 0.152.
 */
package hu.montlikadani.tablist.packets;

import com.mojang.authlib.GameProfile;
import hu.montlikadani.api.IPacketNM;
import hu.montlikadani.tablist.utils.Util;
import hu.montlikadani.tablist.utils.reflection.ClazzContainer;
import hu.montlikadani.tablist.utils.reflection.ComponentParser;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.scoreboard.NameTagVisibility;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.Team;

public final class LegacyVersion
implements IPacketNM {
    private Method playerHandleMethod;
    private Method sendPacketMethod;
    private Method getHandleWorldMethod;
    private Method getServerMethod;
    private Method jsonComponentMethod;
    private Method chatSerializerMethodA;
    private Field playerConnectionField;
    private Field headerField;
    private Field footerField;
    private Field listNameField;
    private Field playerTeamNameField;
    private Field networkManager;
    private Field channel;
    private Field recentTpsField;
    private Field pingField;
    private Constructor<?> playerListHeaderFooterConstructor;
    private Constructor<?> entityPlayerConstructor;
    private Constructor<?> interactManagerConstructor;
    private Class<?> minecraftServer;
    private Class<?> interactManager;
    private Class<?> chatSerializer;
    private final List<Object> playerTeams = new ArrayList<Object>();
    private final Set<TagTeam> tagTeams = new HashSet<TagTeam>();

    public LegacyVersion() {
        Class<?> playerListHeaderFooter;
        try {
            Class<?> networkManagerClass;
            try {
                networkManagerClass = ClazzContainer.classByName("net.minecraft.server.network", "NetworkManager");
            }
            catch (ClassNotFoundException ex) {
                networkManagerClass = ClazzContainer.classByName("net.minecraft.network", "NetworkManager");
            }
            this.networkManager = ClazzContainer.fieldByTypeOrName(ClazzContainer.classByName("net.minecraft.server.network", "PlayerConnection"), networkManagerClass, new String[0]);
            this.channel = ClazzContainer.fieldByTypeOrName(networkManagerClass, Channel.class, new String[0]);
            this.playerConnectionField = ClazzContainer.fieldByTypeOrName(ClazzContainer.classByName("net.minecraft.server.level", "EntityPlayer"), null, "b", "playerConnection", "connection", "a");
            this.interactManager = ClazzContainer.classByName("net.minecraft.server.level", "PlayerInteractManager");
            try {
                this.minecraftServer = ClazzContainer.classByName("net.minecraft.server", "MinecraftServer");
            }
            catch (ClassNotFoundException c) {
                try {
                    this.minecraftServer = ClazzContainer.classByName("net.minecraft.server.dedicated", "DedicatedServer");
                }
                catch (ClassNotFoundException classNotFoundException) {}
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        try {
            playerListHeaderFooter = ClazzContainer.classByName("net.minecraft.network.protocol.game", "PacketPlayOutPlayerListHeaderFooter");
        }
        catch (ClassNotFoundException e) {
            return;
        }
        try {
            this.playerListHeaderFooterConstructor = playerListHeaderFooter.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException s) {
            try {
                this.playerListHeaderFooterConstructor = playerListHeaderFooter.getConstructor(ClazzContainer.getIChatBaseComponent(), ClazzContainer.getIChatBaseComponent());
            }
            catch (NoSuchMethodException e) {
                try {
                    this.playerListHeaderFooterConstructor = playerListHeaderFooter.getConstructor(ClazzContainer.getIChatBaseComponent());
                }
                catch (NoSuchMethodException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    @Override
    public Object getPlayerHandle(Player player2) {
        try {
            if (this.playerHandleMethod == null) {
                this.playerHandleMethod = player2.getClass().getDeclaredMethod("getHandle", new Class[0]);
            }
            return this.playerHandleMethod.invoke((Object)player2, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public int playerPing(Player player2) {
        Object entityPlayer = this.getPlayerHandle(player2);
        if (this.pingField == null) {
            this.pingField = ClazzContainer.fieldByTypeOrName(entityPlayer.getClass(), Integer.TYPE, "ping", "latency");
        }
        if (this.pingField != null) {
            try {
                return this.pingField.getInt(entityPlayer);
            }
            catch (IllegalAccessException ex) {
                ex.printStackTrace();
            }
        }
        return 0;
    }

    @Override
    public double[] serverTps() {
        if (this.recentTpsField == null) {
            try {
                this.recentTpsField = this.minecraftServer.getField("recentTps");
                this.recentTpsField.setAccessible(true);
            }
            catch (NoSuchFieldException ex) {
                ex.printStackTrace();
            }
        }
        try {
            return (double[])this.recentTpsField.get(this.getServer());
        }
        catch (IllegalAccessException ex) {
            ex.printStackTrace();
            return new double[0];
        }
    }

    @Override
    public void addPlayerChannelListener(Player player2, List<Class<?>> classesToListen) {
        Channel channel;
        try {
            channel = (Channel)this.channel.get(this.networkManager.get(this.playerConnectionField.get(this.getPlayerHandle(player2))));
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return;
        }
        if (channel.pipeline().get("TLPacketInjector") == null) {
            try {
                channel.pipeline().addBefore("packet_handler", "TLPacketInjector", (ChannelHandler)new PacketReceivingListener(player2.getUniqueId(), classesToListen));
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
        }
    }

    @Override
    public void removePlayerChannelListener(Player player2) {
        Channel channel;
        Object entityPlayer = this.getPlayerHandle(player2);
        try {
            channel = (Channel)this.channel.get(this.networkManager.get(this.playerConnectionField.get(entityPlayer)));
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return;
        }
        if (channel != null) {
            try {
                channel.pipeline().remove("TLPacketInjector");
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
        }
    }

    private Object getServer() {
        if (this.getServerMethod == null) {
            try {
                this.getServerMethod = this.minecraftServer.getMethod("getServer", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                return null;
            }
        }
        try {
            return this.getServerMethod.invoke((Object)Bukkit.getServer(), new Object[0]);
        }
        catch (Exception x) {
            try {
                return this.getServerMethod.invoke(this.minecraftServer, new Object[0]);
            }
            catch (ReflectiveOperationException e) {
                e.printStackTrace();
                return null;
            }
        }
    }

    @Override
    public void sendPacket(Player player2, Object packet) {
        this.sendPacket(this.getPlayerHandle(player2), packet);
    }

    private void sendPacket(Object handle, Object packet) {
        try {
            Object playerConnection = this.playerConnectionField.get(handle);
            if (this.sendPacketMethod == null && (this.sendPacketMethod = ClazzContainer.methodByTypeAndName(playerConnection.getClass(), null, new Class[]{ClazzContainer.getPacket()}, "a", "sendPacket")) == null) {
                return;
            }
            this.sendPacketMethod.invoke(playerConnection, packet);
        }
        catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
            // empty catch block
        }
    }

    @Override
    public Object fromJson(String json) {
        try {
            Class<?>[] declaredClasses;
            if (this.jsonComponentMethod == null && (declaredClasses = ClazzContainer.getIChatBaseComponent().getDeclaredClasses()).length != 0) {
                this.jsonComponentMethod = declaredClasses[0].getMethod("a", String.class);
            }
            if (this.jsonComponentMethod != null) {
                return this.jsonComponentMethod.invoke(ClazzContainer.getIChatBaseComponent(), json);
            }
        }
        catch (ReflectiveOperationException ex) {
            try {
                if (this.chatSerializer == null) {
                    this.chatSerializer = Class.forName("net.minecraft.server." + Util.legacyNmsVersion() + ".ChatSerializer");
                }
                if (this.chatSerializerMethodA == null) {
                    this.chatSerializerMethodA = this.chatSerializer.getMethod("a", String.class);
                }
                return ClazzContainer.getIChatBaseComponent().cast(this.chatSerializerMethodA.invoke(this.chatSerializer, json));
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public void sendTabTitle(Player player2, Object header, Object footer) {
        try {
            Object packet;
            if (this.playerListHeaderFooterConstructor.getParameterCount() == 2) {
                packet = this.playerListHeaderFooterConstructor.newInstance(header, footer);
            } else {
                packet = this.playerListHeaderFooterConstructor.newInstance(new Object[0]);
                if (this.headerField == null && (this.headerField = ClazzContainer.fieldByTypeOrName(packet.getClass(), ClazzContainer.getIChatBaseComponent(), "header", "a")) == null) {
                    return;
                }
                if (this.footerField == null && (this.footerField = ClazzContainer.fieldByTypeOrName(packet.getClass(), ClazzContainer.getIChatBaseComponent(), "footer", "b")) == null) {
                    return;
                }
                this.headerField.set(packet, header);
                this.footerField.set(packet, footer);
            }
            this.sendPacket(player2, packet);
        }
        catch (Exception f) {
            Object packet = null;
            try {
                try {
                    packet = this.playerListHeaderFooterConstructor.newInstance(header);
                }
                catch (IllegalArgumentException e) {
                    try {
                        packet = this.playerListHeaderFooterConstructor.newInstance(new Object[0]);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
                if (packet != null) {
                    if (this.footerField == null && (this.footerField = ClazzContainer.fieldByTypeOrName(packet.getClass(), ClazzContainer.getIChatBaseComponent(), "footer", "b")) == null) {
                        return;
                    }
                    this.footerField.set(packet, footer);
                    this.sendPacket(player2, packet);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public Object getNewEntityPlayer(GameProfile profile) {
        World world = (World)Bukkit.getServer().getWorlds().get(0);
        try {
            if (this.getHandleWorldMethod == null) {
                this.getHandleWorldMethod = world.getClass().getDeclaredMethod("getHandle", new Class[0]);
            }
            Object worldServer = this.getHandleWorldMethod.invoke((Object)world, new Object[0]);
            try {
                if (this.entityPlayerConstructor == null) {
                    try {
                        this.entityPlayerConstructor = ClazzContainer.classByName("net.minecraft.server.level", "EntityPlayer").getConstructor(this.minecraftServer, worldServer.getClass(), profile.getClass(), ClazzContainer.classByName("net.minecraft.world.entity.player", "ProfilePublicKey"));
                    }
                    catch (NoSuchMethodException ex) {
                        this.entityPlayerConstructor = ClazzContainer.classByName("net.minecraft.server.level", "EntityPlayer").getConstructor(this.minecraftServer, worldServer.getClass(), profile.getClass());
                    }
                }
                return this.entityPlayerConstructor.newInstance(this.getServer(), worldServer, profile);
            }
            catch (ClassNotFoundException | IllegalArgumentException | NoSuchMethodException ex) {
                if (this.interactManagerConstructor == null) {
                    try {
                        this.interactManagerConstructor = this.interactManager.getConstructor(worldServer.getClass());
                    }
                    catch (NoSuchMethodException nos) {
                        this.interactManagerConstructor = this.interactManager.getConstructors()[0];
                    }
                }
                if (this.entityPlayerConstructor == null) {
                    this.entityPlayerConstructor = ClazzContainer.classByName("net.minecraft.server.level", "EntityPlayer").getConstructor(this.minecraftServer, worldServer.getClass(), profile.getClass(), this.interactManager);
                }
                return this.entityPlayerConstructor.newInstance(this.getServer(), worldServer, profile, this.interactManagerConstructor.newInstance(worldServer));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Object updateDisplayNamePacket(Object entityPlayer, Object component, boolean listName) {
        try {
            if (listName) {
                this.setListName(entityPlayer, component);
            }
            return ClazzContainer.getPlayOutPlayerInfoConstructor().newInstance(ClazzContainer.getUpdateDisplayName(), this.toArray(entityPlayer));
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void setListName(Object entityPlayer, Object component) {
        try {
            if (this.listNameField == null) {
                this.listNameField = entityPlayer.getClass().getDeclaredField("listName");
                this.listNameField.setAccessible(true);
            }
            this.listNameField.set(entityPlayer, component);
        }
        catch (IllegalAccessException | NoSuchFieldException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public Object newPlayerInfoUpdatePacketAdd(Object ... entityPlayers) {
        try {
            try {
                return ClazzContainer.getPlayOutPlayerInfoConstructor().newInstance(ClazzContainer.getAddPlayer(), this.toArray(entityPlayers));
            }
            catch (IllegalArgumentException ex) {
                return ClazzContainer.getPlayOutPlayerInfoConstructor().newInstance(ClazzContainer.getAddPlayer(), entityPlayers);
            }
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Object updateLatency(Object entityPlayer) {
        try {
            try {
                return ClazzContainer.getPlayOutPlayerInfoConstructor().newInstance(ClazzContainer.getUpdateLatency(), this.toArray(entityPlayer));
            }
            catch (IllegalArgumentException ex) {
                return ClazzContainer.getPlayOutPlayerInfoConstructor().newInstance(ClazzContainer.getUpdateLatency(), entityPlayer);
            }
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Object removeEntityPlayers(Object ... entityPlayers) {
        try {
            return ClazzContainer.getPlayOutPlayerInfoConstructor().newInstance(ClazzContainer.getRemovePlayer(), this.toArray(entityPlayers));
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    private Object toArray(Object ... arr) {
        Object entityPlayerArray = Array.newInstance(arr[0].getClass(), arr.length);
        for (int i = 0; i < arr.length; ++i) {
            Array.set(entityPlayerArray, i, arr[i]);
        }
        return entityPlayerArray;
    }

    @Override
    public void setInfoData(Object info, UUID id, int ping, Object component) {
        try {
            for (Object infoData : (List)ClazzContainer.getInfoList().get(info)) {
                GameProfile profile = ClazzContainer.getPlayerInfoDataProfile(infoData);
                if (profile == null || !profile.getId().equals(id)) continue;
                Constructor<?> playerInfoDataConstr = ClazzContainer.getPlayerInfoDataConstructor();
                Object gameMode = ClazzContainer.getPlayerInfoDataGameMode().get(infoData);
                Object packet = playerInfoDataConstr.getParameterCount() == 5 ? playerInfoDataConstr.newInstance(info, profile, ping, gameMode, component) : playerInfoDataConstr.newInstance(profile, ping, gameMode, component);
                ClazzContainer.getInfoList().set(info, Collections.singletonList(packet));
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void createBoardTeam(String teamName, Player player2, boolean followNameTagVisibility) {
        block26: {
            Object newTeamPacket = null;
            Object scoreTeam = null;
            try {
                if (ClazzContainer.getPacketPlayOutScoreboardTeamConstructor() == null) {
                    scoreTeam = ClazzContainer.getScoreboardTeamConstructor().newInstance(ClazzContainer.getScoreboardConstructor().newInstance(new Object[0]), teamName);
                    Collection playerNameSet = (Collection)ClazzContainer.getPlayerNameSetMethod().invoke(scoreTeam, new Object[0]);
                    playerNameSet.add(player2.getName());
                    ClazzContainer.getScoreboardTeamNames().set(scoreTeam, playerNameSet);
                } else {
                    newTeamPacket = ClazzContainer.getPacketPlayOutScoreboardTeamConstructor().newInstance(new Object[0]);
                    ClazzContainer.getPacketScoreboardTeamName().set(newTeamPacket, teamName);
                    ClazzContainer.getPacketScoreboardTeamMode().set(newTeamPacket, 0);
                    ClazzContainer.getScoreboardTeamNames().set(newTeamPacket, Collections.singletonList(player2.getName()));
                    Field displayName = ClazzContainer.getScoreboardTeamDisplayName();
                    if (displayName.getType() == String.class) {
                        displayName.set(newTeamPacket, teamName);
                    } else {
                        displayName.set(newTeamPacket, ComponentParser.asComponent(teamName));
                    }
                }
                if (followNameTagVisibility) {
                    Object optionName = null;
                    block10: for (Team team : player2.getScoreboard().getTeams()) {
                        if (ClazzContainer.isTeamOptionStatusEnumExist()) {
                            Team.OptionStatus optionStatus = team.getOption(Team.Option.NAME_TAG_VISIBILITY);
                            switch (optionStatus) {
                                case FOR_OTHER_TEAMS: {
                                    optionName = "hideForOtherTeams";
                                    break;
                                }
                                case FOR_OWN_TEAM: {
                                    optionName = "hideForOwnTeam";
                                    break;
                                }
                                default: {
                                    if (optionStatus == Team.OptionStatus.ALWAYS) continue block10;
                                    optionName = optionStatus.name().toLowerCase(Locale.ENGLISH);
                                    break;
                                }
                            }
                            continue;
                        }
                        NameTagVisibility visibility = team.getNameTagVisibility();
                        switch (visibility) {
                            case HIDE_FOR_OTHER_TEAMS: {
                                optionName = "hideForOtherTeams";
                                continue block10;
                            }
                            case HIDE_FOR_OWN_TEAM: {
                                optionName = "hideForOwnTeam";
                                continue block10;
                            }
                        }
                        if (visibility == NameTagVisibility.ALWAYS) continue;
                        optionName = visibility.name().toLowerCase(Locale.ENGLISH);
                    }
                    if (optionName != null) {
                        if (scoreTeam != null) {
                            Object visibility = ClazzContainer.getNameTagVisibilityByNameMethod().invoke(null, optionName);
                            if (visibility != null) {
                                ClazzContainer.getScoreboardTeamSetNameTagVisibility().invoke(scoreTeam, visibility);
                            }
                        } else {
                            ClazzContainer.getNameTagVisibility().set(newTeamPacket, optionName);
                        }
                    }
                }
                if (newTeamPacket == null) {
                    newTeamPacket = ClazzContainer.scoreboardTeamPacketByAction(scoreTeam, 0);
                }
                this.playerTeams.add(scoreTeam == null ? newTeamPacket : scoreTeam);
                if (this.tagTeams.isEmpty()) {
                    for (Player one : Bukkit.getOnlinePlayers()) {
                        this.sendPacket(this.getPlayerHandle(one), newTeamPacket);
                    }
                    break block26;
                }
                for (TagTeam tagTeam : this.tagTeams) {
                    if (!tagTeam.playerName.equals(player2.getName())) continue;
                    ClazzContainer.getScoreboardTeamSetDisplayName().invoke(tagTeam.scoreboardTeam, tagTeam.scoreboardTeamDisplayNameMethod.invoke(tagTeam.scoreboardTeam, new Object[0]));
                    ClazzContainer.getScoreboardTeamSetNameTagVisibility().invoke(tagTeam.scoreboardTeam, tagTeam.scoreboardTeamNameTagVisibilityMethod.invoke(tagTeam.scoreboardTeam, new Object[0]));
                    for (Player one : Bukkit.getOnlinePlayers()) {
                        Object handle = this.getPlayerHandle(one);
                        this.sendPacket(handle, newTeamPacket);
                        this.sendPacket(handle, ClazzContainer.scoreboardTeamPacketByAction(tagTeam.scoreboardTeam, 0));
                    }
                    break;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public Object unregisterBoardTeamPacket(String teamName) {
        try {
            for (int i = 0; i < this.playerTeams.size(); ++i) {
                Object team = this.playerTeams.get(i);
                Object playerTeamName = this.playerTeamName(team);
                if (!teamName.equals(playerTeamName)) continue;
                try {
                    return ClazzContainer.scoreboardTeamPacketByAction(team, 1);
                }
                catch (Exception ex) {
                    Object oldTeamPacket = ClazzContainer.getPacketPlayOutScoreboardTeamConstructor().newInstance(new Object[0]);
                    ClazzContainer.getPacketScoreboardTeamName().set(oldTeamPacket, playerTeamName);
                    ClazzContainer.getPacketScoreboardTeamMode().set(oldTeamPacket, 1);
                    return oldTeamPacket;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private Object playerTeamName(Object team) throws IllegalAccessException {
        if (this.playerTeamNameField == null) {
            this.playerTeamNameField = ClazzContainer.fieldByTypeOrName(team.getClass(), String.class, "d", "a", "e", "i");
        }
        return this.playerTeamNameField == null ? null : this.playerTeamNameField.get(team);
    }

    @Override
    public Object createObjectivePacket(String objectiveName, Object nameComponent, IPacketNM.ObjectiveFormat objectiveFormat, Object formatComponent) {
        try {
            if (ClazzContainer.getFirstScoreboardObjectiveConstructor().getParameterCount() == 3) {
                return ClazzContainer.getFirstScoreboardObjectiveConstructor().newInstance(null, objectiveName, ClazzContainer.getiScoreboardCriteriaDummy());
            }
            return ClazzContainer.getFirstScoreboardObjectiveConstructor().newInstance(null, objectiveName, ClazzContainer.getiScoreboardCriteriaDummy(), nameComponent, ClazzContainer.getEnumScoreboardHealthDisplayInteger());
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Object scoreboardObjectivePacket(Object objective, int mode) {
        try {
            return ClazzContainer.getPacketPlayOutScoreboardObjectiveConstructor().newInstance(objective, mode);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Object scoreboardDisplayObjectivePacket(Object objective, int slot) {
        try {
            return ClazzContainer.getPacketPlayOutScoreboardDisplayObjectiveConstructor().newInstance(slot, objective);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Object changeScoreboardScorePacket(String objectiveName, String scoreName, int score) {
        return ClazzContainer.newInstanceOfPacketPlayOutScoreboardScore(ClazzContainer.getEnumScoreboardActionChange(), objectiveName, scoreName, score);
    }

    @Override
    public Object removeScoreboardScorePacket(String objectiveName, String scoreName, int score) {
        return ClazzContainer.newInstanceOfPacketPlayOutScoreboardScore(ClazzContainer.getEnumScoreboardActionRemove(), objectiveName, scoreName, score);
    }

    @Override
    public Object createScoreboardHealthObjectivePacket(String objectiveName, Object nameComponent) {
        try {
            Constructor<?> constructor = ClazzContainer.getFirstScoreboardObjectiveConstructor();
            if (constructor.getParameterCount() == 3) {
                return constructor.newInstance(null, objectiveName, ClazzContainer.getiScoreboardCriteriaDummy());
            }
            return constructor.newInstance(null, objectiveName, ClazzContainer.getiScoreboardCriteriaDummy(), nameComponent, ClazzContainer.getEnumScoreboardHealthDisplayInteger());
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    private final class PacketReceivingListener
    extends ChannelDuplexHandler {
        private final UUID listenerPlayerId;
        private final List<Class<?>> classesToListen;
        private Method scoreboardHandle;

        public PacketReceivingListener(UUID listenerPlayerId, List<Class<?>> classesToListen) {
            this.listenerPlayerId = listenerPlayerId;
            this.classesToListen = classesToListen;
        }

        public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
            Class<?> receivingClass = msg.getClass();
            if (!this.classesToListen.contains(receivingClass)) {
                super.write(ctx, msg, promise);
                return;
            }
            if (receivingClass == ClazzContainer.packetPlayOutScoreboardTeam()) {
                this.scoreboardTeamPacket(msg);
            } else {
                this.playerInfoUpdatePacket(msg);
            }
            super.write(ctx, msg, promise);
        }

        private void playerInfoUpdatePacket(Object msg) throws Exception {
            if (ClazzContainer.getActionField().get(msg) != ClazzContainer.getEnumUpdateGameMode()) {
                return;
            }
            Player player2 = Bukkit.getPlayer((UUID)this.listenerPlayerId);
            if (player2 == null) {
                return;
            }
            for (Object entry : (List)ClazzContainer.getInfoList().get(msg)) {
                GameProfile profile;
                if (ClazzContainer.getPlayerInfoDataGameMode().get(entry) != ClazzContainer.getGameModeSpectator() || (profile = ClazzContainer.getPlayerInfoDataProfile(entry)) == null || profile.getId().equals(this.listenerPlayerId)) continue;
                Object updatePacket = ClazzContainer.getPlayOutPlayerInfoConstructor().newInstance(ClazzContainer.getUpdateLatency(), new Object[0]);
                ArrayList players = new ArrayList();
                int ping = ClazzContainer.getPlayerInfoDataPing().getInt(entry);
                Object component = ClazzContainer.getPlayerInfoDisplayName().get(entry);
                if (ClazzContainer.getPlayerInfoDataConstructor().getParameterCount() == 5) {
                    players.add(ClazzContainer.getPlayerInfoDataConstructor().newInstance(msg, profile, ping, ClazzContainer.getGameModeSurvival(), component));
                } else {
                    players.add(ClazzContainer.getPlayerInfoDataConstructor().newInstance(profile, ping, ClazzContainer.getGameModeSurvival(), component));
                }
                ClazzContainer.getInfoList().set(updatePacket, players);
                LegacyVersion.this.sendPacket(player2, updatePacket);
            }
        }

        private void scoreboardTeamPacket(Object msg) throws Exception {
            Collection players = (Collection)ClazzContainer.getScoreboardTeamNames().get(msg);
            if (players == null || players.isEmpty()) {
                return;
            }
            if (ClazzContainer.getPacketScoreboardTeamParametersMethod() == null) {
                String suffix;
                String prefix;
                Object nameTagVisibility = ClazzContainer.getNameTagVisibility().get(msg);
                if (nameTagVisibility == null) {
                    nameTagVisibility = ClazzContainer.getNameTagVisibilityAlways();
                } else if (nameTagVisibility == ClazzContainer.getNameTagVisibilityNever()) {
                    return;
                }
                try {
                    prefix = (String)ClazzContainer.getPacketScoreboardTeamPrefix().get(msg);
                    suffix = (String)ClazzContainer.getPacketScoreboardTeamSuffix().get(msg);
                }
                catch (ClassCastException ex) {
                    prefix = (String)ClazzContainer.getiChatBaseComponentGetStringMethod().invoke(ClazzContainer.getPacketScoreboardTeamPrefix().get(msg), new Object[0]);
                    suffix = (String)ClazzContainer.getiChatBaseComponentGetStringMethod().invoke(ClazzContainer.getPacketScoreboardTeamSuffix().get(msg), new Object[0]);
                }
                if (prefix.isEmpty() && suffix.isEmpty()) {
                    return;
                }
                String playerName = (String)players.iterator().next();
                for (TagTeam team : LegacyVersion.this.tagTeams) {
                    if (!team.playerName.equals(playerName)) continue;
                    return;
                }
                Player player2 = Bukkit.getPlayer((String)playerName);
                if (player2 == null) {
                    return;
                }
                Object chatFormat = ClazzContainer.getPacketScoreboardTeamChatFormatColorField().get(msg);
                try {
                    chatFormat = ClazzContainer.getEnumChatFormatByIntMethod().invoke(null, chatFormat);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                Scoreboard scoreboard = player2.getScoreboard();
                if (this.scoreboardHandle == null) {
                    this.scoreboardHandle = scoreboard.getClass().getDeclaredMethod("getHandle", new Class[0]);
                }
                Object scoreboardTeam = ClazzContainer.getScoreboardTeamConstructor().newInstance(this.scoreboardHandle.invoke((Object)scoreboard, new Object[0]), ClazzContainer.getPacketScoreboardTeamName().get(msg));
                ClazzContainer.getScoreboardTeamSetPrefix().invoke(scoreboardTeam, prefix);
                ClazzContainer.getScoreboardTeamSetSuffix().invoke(scoreboardTeam, suffix);
                ClazzContainer.getScoreboardTeamSetNameTagVisibility().invoke(scoreboardTeam, nameTagVisibility);
                ClazzContainer.getScoreboardTeamSetChatFormat().invoke(scoreboardTeam, chatFormat);
                ((Collection)ClazzContainer.getPlayerNameSetMethod().invoke(scoreboardTeam, new Object[0])).add(playerName);
                LegacyVersion.this.tagTeams.add(new TagTeam(playerName, scoreboardTeam));
                return;
            }
            ((Optional)ClazzContainer.getPacketScoreboardTeamParametersMethod().invoke(msg, new Object[0])).ifPresent(packetTeam -> {
                try {
                    Object nameTagVisibility = ClazzContainer.getNameTagVisibilityByNameMethod().invoke(packetTeam, ClazzContainer.getParametersNameTagVisibility().invoke(packetTeam, new Object[0]));
                    if (nameTagVisibility == null) {
                        nameTagVisibility = ClazzContainer.getNameTagVisibilityAlways();
                    } else if (nameTagVisibility == ClazzContainer.getNameTagVisibilityNever()) {
                        return;
                    }
                    String prefix = (String)ClazzContainer.getiChatBaseComponentGetStringMethod().invoke(ClazzContainer.getParametersTeamPrefix().invoke(packetTeam, new Object[0]), new Object[0]);
                    String suffix = (String)ClazzContainer.getiChatBaseComponentGetStringMethod().invoke(ClazzContainer.getParametersTeamSuffix().invoke(packetTeam, new Object[0]), new Object[0]);
                    if (!prefix.isEmpty() || !suffix.isEmpty()) {
                        String playerName = (String)players.iterator().next();
                        for (TagTeam team : LegacyVersion.this.tagTeams) {
                            if (!team.playerName.equals(playerName)) continue;
                            return;
                        }
                        Player player2 = Bukkit.getPlayer((String)playerName);
                        if (player2 == null) {
                            return;
                        }
                        Scoreboard scoreboard = player2.getScoreboard();
                        if (this.scoreboardHandle == null) {
                            this.scoreboardHandle = scoreboard.getClass().getDeclaredMethod("getHandle", new Class[0]);
                        }
                        Object scoreboardTeam = ClazzContainer.getScoreboardTeamConstructor().newInstance(this.scoreboardHandle.invoke((Object)scoreboard, new Object[0]), ClazzContainer.getScoreboardTeamName().invoke(packetTeam, new Object[0]));
                        ClazzContainer.getScoreboardTeamSetPrefix().invoke(scoreboardTeam, prefix);
                        ClazzContainer.getScoreboardTeamSetSuffix().invoke(scoreboardTeam, suffix);
                        ClazzContainer.getScoreboardTeamSetNameTagVisibility().invoke(scoreboardTeam, nameTagVisibility);
                        ClazzContainer.getScoreboardTeamSetChatFormat().invoke(scoreboardTeam, ClazzContainer.getScoreboardTeamColor().invoke(packetTeam, new Object[0]));
                        ((Collection)ClazzContainer.getPlayerNameSetMethod().invoke(scoreboardTeam, new Object[0])).add(playerName);
                        LegacyVersion.this.tagTeams.add(new TagTeam(playerName, scoreboardTeam));
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            });
        }
    }

    private static class TagTeam {
        public final String playerName;
        public final Object scoreboardTeam;
        protected Method scoreboardTeamDisplayNameMethod;
        protected Method scoreboardTeamNameTagVisibilityMethod;

        public TagTeam(String playerName, Object scoreboardTeam) {
            this.playerName = playerName;
            this.scoreboardTeam = scoreboardTeam;
            Class<?> clazz = scoreboardTeam.getClass();
            try {
                this.scoreboardTeamDisplayNameMethod = clazz.getDeclaredMethod("c", new Class[0]);
                this.scoreboardTeamNameTagVisibilityMethod = clazz.getDeclaredMethod("j", new Class[0]);
            }
            catch (NoSuchMethodException ex) {
                ex.printStackTrace();
            }
        }

        public boolean equals(Object other) {
            return other != null && this.getClass() == other.getClass() && this.playerName.equals(((TagTeam)other).playerName);
        }

        public int hashCode() {
            return Objects.hash(this.playerName);
        }
    }
}

