/*
 * Decompiled with CFR 0.152.
 */
package hu.montlikadani.tablist.logicalOperators;

import hu.montlikadani.tablist.logicalOperators.Condition;
import hu.montlikadani.tablist.logicalOperators.LogicalNode;

public class OperatorNodes
implements LogicalNode {
    protected final LogicalNode.NodeType type;
    protected transient Condition condition;

    public OperatorNodes(LogicalNode.NodeType type) {
        this.type = type;
    }

    @Override
    public LogicalNode.NodeType getType() {
        return this.type;
    }

    @Override
    public LogicalNode parseInput(String input) {
        Condition.RelationalOperators[] values;
        Condition.RelationalOperators chosen = null;
        for (Condition.RelationalOperators logicalOperator : values = Condition.RelationalOperators.values()) {
            if (!input.replaceAll("[^" + logicalOperator.operator + "]", "").equals(logicalOperator.operator)) continue;
            chosen = logicalOperator;
        }
        if (chosen != null) {
            for (Condition.RelationalOperators one : values) {
                if (one != chosen) continue;
                String[] arr = input.trim().replace(one.operator, ";").split(";", 2);
                if (arr.length <= 1) break;
                this.condition = new Condition(one, arr);
                break;
            }
        }
        return this;
    }

    @Override
    public Condition getCondition() {
        return this.condition;
    }

    @Override
    public boolean parse(double receivedValue) {
        if (this.type != LogicalNode.NodeType.PING) {
            return false;
        }
        int firstValue = (int)receivedValue;
        if (firstValue < 0) {
            return false;
        }
        int secondValue = (int)this.condition.getValue();
        if (secondValue < 0) {
            return false;
        }
        switch (this.condition.operator) {
            case GREATER_THAN: {
                return firstValue > secondValue;
            }
            case GREATER_THAN_OR_EQUAL: {
                return firstValue >= secondValue;
            }
            case LESS_THAN: {
                return firstValue < secondValue;
            }
            case LESS_THAN_OR_EQUAL: {
                return firstValue <= secondValue;
            }
            case EQUAL: {
                return firstValue == secondValue;
            }
            case NOT_EQUAL: {
                return firstValue != secondValue;
            }
        }
        return false;
    }
}

