/*
 * Decompiled with CFR 0.152.
 */
package hu.montlikadani.tablist.logicalOperators;

import hu.montlikadani.tablist.logicalOperators.Condition;
import hu.montlikadani.tablist.logicalOperators.OperatorNodes;
import java.util.List;

public interface LogicalNode {
    public static LogicalNode newNode(NodeType type) {
        return new OperatorNodes(type);
    }

    public LogicalNode parseInput(String var1);

    public NodeType getType();

    public Condition getCondition();

    public boolean parse(double var1);

    public static StringBuilder parseCondition(double value, NodeType type, List<LogicalNode> nodes) {
        String color = "";
        for (LogicalNode node : nodes) {
            if (node.getType() != type || !node.parse(value)) continue;
            color = node.getCondition().color;
            break;
        }
        StringBuilder builder = new StringBuilder(color);
        return type == NodeType.PING ? builder.append((int)value) : builder.append(value);
    }

    public static void reverseOrderOfArray(List<LogicalNode> nodes) {
        nodes.sort((node, node2) -> {
            if (node.getType() == NodeType.PING && node2.getType() == NodeType.PING) {
                return Double.compare(node.getCondition().getValue(), node2.getCondition().getValue());
            }
            if (node.getType() == NodeType.TPS && node2.getType() == NodeType.TPS) {
                return -Double.compare(node.getCondition().getValue(), node2.getCondition().getValue());
            }
            return -1;
        });
    }

    public static enum NodeType {
        PING,
        TPS;

    }
}

