/*
 * Decompiled with CFR 0.152.
 */
package hu.montlikadani.tablist.config.constantsLoader;

import hu.montlikadani.api.Pair;
import hu.montlikadani.tablist.TabList;
import hu.montlikadani.tablist.tablist.TabText;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;

public final class TabConfigValues {
    private static boolean enabled;
    private static boolean rememberToggledTablistToFile;
    private static boolean hideTabWhenPlayerVanished;
    private static boolean random;
    private static int updateInterval;
    private static List<String> disabledWorlds;
    private static List<String> blackListedPlayers;
    private static TabText[] defaultHeader;
    private static TabText[] defaultFooter;
    public static final Map<String, OptionSeparator> SEPARATOR_MAP;
    public static final Map<Permission, Pair<TabText[], TabText[]>> PERMISSION_MAP;

    public static void loadValues(TabList tl, FileConfiguration c) {
        String[] split;
        SEPARATOR_MAP.clear();
        PERMISSION_MAP.clear();
        enabled = c.getBoolean("enabled", true);
        rememberToggledTablistToFile = c.getBoolean("remember-toggled-tablist-to-file", true);
        hideTabWhenPlayerVanished = c.getBoolean("hide-tab-when-player-vanished", false);
        random = c.getBoolean("random", false);
        disabledWorlds = c.getStringList("disabled-worlds");
        blackListedPlayers = c.getStringList("blacklisted-players");
        updateInterval = c.getInt("interval", 4);
        if (updateInterval > 10000) {
            updateInterval = 10000;
        }
        defaultHeader = TabConfigValues.objectToArrayConversion(tl, c.get("header", null));
        defaultFooter = TabConfigValues.objectToArrayConversion(tl, c.get("footer", null));
        ConfigurationSection section = c.getConfigurationSection("per-world");
        if (section != null) {
            for (String one : section.getKeys(false)) {
                split = one.split(", ");
                if (split.length == 0) {
                    SEPARATOR_MAP.put(one, new OptionSeparator(tl, one, one, section, true));
                    continue;
                }
                for (String worldName : split) {
                    SEPARATOR_MAP.put(worldName, new OptionSeparator(tl, one, worldName, section, true));
                }
            }
        }
        if ((section = c.getConfigurationSection("permissions")) != null) {
            for (String key : section.getKeys(false)) {
                Object header = section.get(key + ".header", null);
                Object footer = section.get(key + ".footer", null);
                if (header == null && footer == null) continue;
                String permission = section.getString(key + ".name", "tablist.permissionName");
                Permission perm = Bukkit.getServer().getPluginManager().getPermission(permission);
                if (perm != null) {
                    perm.setDefault(PermissionDefault.FALSE);
                } else {
                    perm = new Permission(permission, PermissionDefault.NOT_OP);
                    Bukkit.getServer().getPluginManager().addPermission(perm);
                }
                PERMISSION_MAP.put(perm, new Pair<TabText[], TabText[]>(TabConfigValues.objectToArrayConversion(tl, header), TabConfigValues.objectToArrayConversion(tl, footer)));
            }
        }
        if ((section = c.getConfigurationSection("per-player")) != null) {
            for (String key : section.getKeys(false)) {
                split = key.split(", ");
                if (split.length == 0) {
                    SEPARATOR_MAP.put(key, new OptionSeparator(tl, key, key, section, false));
                    continue;
                }
                for (String playerName : split) {
                    SEPARATOR_MAP.put(playerName, new OptionSeparator(tl, key, playerName, section, false));
                }
            }
        }
        if ((section = c.getConfigurationSection("per-group")) != null) {
            for (String key : section.getKeys(false)) {
                split = key.split(", ");
                if (split.length == 0) {
                    SEPARATOR_MAP.put(key, new OptionSeparator(tl, key, key, section, false));
                    continue;
                }
                for (String groupName : split) {
                    SEPARATOR_MAP.put(groupName, new OptionSeparator(tl, key, groupName, section, false));
                }
            }
        }
    }

    private static TabText[] objectToArrayConversion(TabList tl, Object obj) {
        if (obj instanceof List) {
            String[] array = ((List)obj).toArray(new String[0]);
            TabText[] tt = new TabText[array.length];
            for (int i = 0; i < array.length; ++i) {
                TabText text = new TabText();
                text.setPlainText(tl.getPlaceholders().replaceMiscVariables(array[i]));
                tt[i] = text;
            }
            return tt;
        }
        if (obj instanceof String) {
            TabText text = new TabText();
            text.setPlainText(tl.getPlaceholders().replaceMiscVariables((String)obj));
            return new TabText[]{text};
        }
        return null;
    }

    public static boolean isEnabled() {
        return enabled;
    }

    public static boolean isRememberToggledTablistToFile() {
        return rememberToggledTablistToFile;
    }

    public static boolean isHideTabWhenPlayerVanished() {
        return hideTabWhenPlayerVanished;
    }

    public static boolean isRandom() {
        return random;
    }

    public static int getUpdateInterval() {
        return updateInterval;
    }

    public static List<String> getDisabledWorlds() {
        return disabledWorlds;
    }

    public static List<String> getBlackListedPlayers() {
        return blackListedPlayers;
    }

    public static TabText[] getDefaultHeader() {
        return defaultHeader;
    }

    public static TabText[] getDefaultFooter() {
        return defaultFooter;
    }

    static {
        SEPARATOR_MAP = new HashMap<String, OptionSeparator>();
        PERMISSION_MAP = new HashMap<Permission, Pair<TabText[], TabText[]>>();
    }

    public static final class OptionSeparator {
        private Map<String, Pair<TabText[], TabText[]>> configKeyMap;
        public Pair<TabText[], TabText[]> pair;

        OptionSeparator(TabList tl, String configPath, String name, ConfigurationSection section, boolean extraContent) {
            TabText[] key = TabConfigValues.objectToArrayConversion(tl, section.get(configPath + ".header", null));
            TabText[] value = TabConfigValues.objectToArrayConversion(tl, section.get(configPath + ".footer", null));
            if (key != null || value != null) {
                this.pair = new Pair<TabText[], TabText[]>(key, value);
            }
            if (!extraContent) {
                return;
            }
            this.configKeyMap = new HashMap<String, Pair<TabText[], TabText[]>>(1);
            this.configKeyMap.put(name, this.pair);
            this.readFromConfig(tl, section.getConfigurationSection(configPath + ".per-player"));
            this.readFromConfig(tl, section.getConfigurationSection(configPath + ".per-group"));
        }

        public Map<String, Pair<TabText[], TabText[]>> getConfigKeyMap() {
            return this.configKeyMap;
        }

        private void readFromConfig(TabList tl, ConfigurationSection configSection) {
            if (configSection == null) {
                return;
            }
            for (String one : configSection.getKeys(false)) {
                String[] split = one.split(", ");
                if (split.length == 0) {
                    this.configKeyMap.put(one, new Pair<TabText[], TabText[]>(TabConfigValues.objectToArrayConversion(tl, configSection.get(one + ".header", null)), TabConfigValues.objectToArrayConversion(tl, configSection.get(one + ".footer", null))));
                    continue;
                }
                for (String name : split) {
                    this.configKeyMap.put(name, new Pair<TabText[], TabText[]>(TabConfigValues.objectToArrayConversion(tl, configSection.get(one + ".header", null)), TabConfigValues.objectToArrayConversion(tl, configSection.get(one + ".footer", null))));
                }
            }
        }
    }
}

