/*
 * Decompiled with CFR 0.152.
 */
package hu.montlikadani.tablist.config;

import hu.montlikadani.tablist.TabList;
import hu.montlikadani.tablist.config.CommentedConfig;
import hu.montlikadani.tablist.config.ConfigMessages;
import hu.montlikadani.tablist.config.constantsLoader.ConfigValues;
import hu.montlikadani.tablist.config.constantsLoader.TabConfigValues;
import hu.montlikadani.tablist.utils.Util;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;

public class Configuration {
    private final transient TabList plugin;
    private transient FileConfiguration tablist;
    private transient FileConfiguration groups;
    private transient FileConfiguration fakePlayers;
    private transient FileConfiguration animCreator;
    private transient CommentedConfig config;
    private final transient ConfigMessages messages;
    private final File configFile;
    private final File animationFile;
    private final File tablistFile;
    private final File groupsFile;
    private final File fakePlayersFile;

    public Configuration(TabList plugin) {
        this.plugin = plugin;
        File folder = plugin.getDataFolder();
        this.messages = new ConfigMessages(folder);
        this.configFile = new File(folder, "config.yml");
        this.animationFile = new File(folder, "animcreator.yml");
        this.tablistFile = new File(folder, "tablist.yml");
        this.groupsFile = new File(folder, "groups.yml");
        this.fakePlayersFile = new File(folder, "fakeplayers.yml");
    }

    public void loadFiles() {
        File names = new File(this.plugin.getDataFolder(), "names.yml");
        if (names.exists() && !names.delete()) {
            throw new RuntimeException("Failed to delete names.yml file");
        }
        if (!this.configFile.exists()) {
            this.plugin.saveResource(this.configFile.getName(), false);
        }
        this.config = new CommentedConfig(this.configFile, this.plugin);
        this.tablist = this.createFile(this.tablistFile, this.tablistFile.getName(), false);
        ConfigValues.loadValues(this.config);
        TabConfigValues.loadValues(this.plugin, this.tablist);
        this.messages.createAndLoad();
        this.animCreator = this.createFile(this.animationFile, this.animationFile.getName(), false);
        if (ConfigValues.isPrefixSuffixEnabled()) {
            this.groups = this.createFile(this.groupsFile, this.groupsFile.getName(), false);
        }
        if (ConfigValues.isFakePlayers()) {
            this.fakePlayers = this.createFile(this.fakePlayersFile, this.fakePlayersFile.getName(), true);
        }
    }

    FileConfiguration createFile(File file, String name, boolean newFile) {
        if (!file.exists()) {
            if (newFile) {
                try {
                    if (!file.createNewFile()) {
                        throw new RuntimeException("Failed to create " + name + " file");
                    }
                }
                catch (IOException ex) {
                    Util.printTrace(Level.SEVERE, (Plugin)this.plugin, ex.getMessage(), ex);
                }
            } else {
                this.plugin.saveResource(name, false);
            }
        }
        return YamlConfiguration.loadConfiguration((File)file);
    }

    public CommentedConfig getConfig() {
        return this.config;
    }

    public FileConfiguration getGroups() {
        if (this.groups == null || !this.groupsFile.exists()) {
            this.groups = this.createFile(this.groupsFile, this.groupsFile.getName(), false);
        }
        return this.groups;
    }

    public FileConfiguration getFakeplayers() {
        if (this.fakePlayers == null || !this.fakePlayersFile.exists()) {
            this.fakePlayers = this.createFile(this.fakePlayersFile, this.fakePlayersFile.getName(), true);
        }
        return this.fakePlayers;
    }

    public FileConfiguration getAnimCreator() {
        return this.animCreator;
    }

    public FileConfiguration getTablist() {
        return this.tablist;
    }

    public File getGroupsFile() {
        return this.groupsFile;
    }

    public File getFakeplayersFile() {
        return this.fakePlayersFile;
    }
}

