/*
 * Decompiled with CFR 0.152.
 */
package hu.montlikadani.tablist.config;

import hu.montlikadani.tablist.TabList;
import hu.montlikadani.tablist.utils.Util;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;

public class CommentedConfig
extends YamlConfiguration {
    private final Map<String, String> comments = new HashMap<String, String>();
    private final File file;

    public CommentedConfig(File file, TabList plugin) {
        this.file = file;
        this.loadFile(plugin);
    }

    public File getFile() {
        return this.file;
    }

    private void loadFile(TabList plugin) {
        try (InputStreamReader reader2 = new InputStreamReader(new FileInputStream(this.file));){
            this.load(reader2);
        }
        catch (FileNotFoundException reader2) {
        }
        catch (IOException | InvalidConfigurationException ex) {
            Util.printTrace(Level.WARNING, (Plugin)plugin, ex.getMessage(), ex);
        }
    }

    public void save() {
        try {
            this.save(this.file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void save(File file) throws IOException {
        try (PrintWriter writer = new PrintWriter(file, StandardCharsets.UTF_8.name());){
            writer.write(this.insertComments(this.saveToString()));
            writer.flush();
        }
    }

    private String insertComments(String content) {
        if (this.comments.isEmpty()) {
            return content;
        }
        StringBuilder newContents = new StringBuilder();
        StringBuilder currentPath = new StringBuilder();
        boolean commentedPath = false;
        int depth = 0;
        for (String line : content.split("[" + System.lineSeparator() + "]")) {
            boolean node;
            int whiteSpace;
            if (line.isEmpty() || line.charAt(0) == '#') continue;
            int length = line.length();
            boolean keyOk = true;
            int index = line.indexOf(": ");
            if (index != -1) {
                whiteSpace = 0;
                for (int n = 0; n < length && line.charAt(n) == ' '; ++n) {
                    ++whiteSpace;
                }
                String key = line.substring(whiteSpace, index);
                if (key.indexOf(32) != -1 || key.indexOf(38) != -1 || key.indexOf(46) != -1 || key.indexOf("'") != -1 || key.indexOf(39) != -1) {
                    keyOk = false;
                }
            }
            if (keyOk && index != -1 || length > 1 && line.charAt(length - 1) == ':') {
                commentedPath = false;
                node = true;
                if (index == -1 && (index = line.indexOf(": ")) == -1) {
                    index = length - 1;
                }
                if (currentPath.length() == 0) {
                    currentPath = new StringBuilder(line.substring(0, index));
                } else {
                    whiteSpace = 0;
                    for (int n = 0; n < length && line.charAt(n) == ' '; ++n) {
                        ++whiteSpace;
                    }
                    int newDepth = whiteSpace / 2;
                    if (newDepth > depth) {
                        currentPath.append("." + line.substring(whiteSpace, index));
                        ++depth;
                    } else if (newDepth < depth) {
                        int d = depth - newDepth;
                        for (int i = 0; i < d; ++i) {
                            currentPath.replace(currentPath.lastIndexOf("."), currentPath.length(), "");
                        }
                        int lastIndex = currentPath.lastIndexOf(".");
                        if (lastIndex == -1) {
                            currentPath = new StringBuilder();
                        } else {
                            currentPath.replace(lastIndex, currentPath.length(), "").append('.');
                        }
                        currentPath.append(line.substring(whiteSpace, index));
                        depth = newDepth;
                    } else {
                        int lastIndex = currentPath.lastIndexOf(".");
                        if (lastIndex == -1) {
                            currentPath = new StringBuilder();
                        } else {
                            currentPath.replace(lastIndex, currentPath.length(), "").append('.');
                        }
                        currentPath.append(line.substring(whiteSpace, index));
                    }
                }
            } else {
                node = false;
            }
            StringBuilder newLine = new StringBuilder(line);
            if (node) {
                String comment;
                String string = comment = !commentedPath ? this.comments.getOrDefault(currentPath.toString(), "") : "";
                if (!comment.isEmpty()) {
                    newLine.insert(0, System.lineSeparator()).insert(0, comment);
                    commentedPath = true;
                }
            }
            newLine.append(System.lineSeparator());
            newContents.append((CharSequence)newLine);
        }
        return newContents.toString();
    }

    /*
     * WARNING - void declaration
     */
    public void addComment(String path, String ... commentLines) {
        if (commentLines.length == 0) {
            return;
        }
        StringBuilder leadingSpaces = new StringBuilder();
        int length = path.length();
        for (int n = 0; n < length; ++n) {
            if (path.charAt(n) != '.') continue;
            leadingSpaces.append("  ");
        }
        String leadSpaces = leadingSpaces.toString();
        StringBuilder comment = new StringBuilder();
        for (String string : commentLines) {
            void var10_11;
            if (!string.isEmpty()) {
                String string2 = leadSpaces + "# " + string;
            }
            comment.append(System.lineSeparator()).append((String)var10_11);
        }
        this.comments.put(path, comment.toString());
    }

    public boolean get(String path, boolean def) {
        boolean value = this.getBoolean(path, def);
        this.set(path, value);
        return value;
    }

    public int get(String path, int def) {
        int value = this.getInt(path, def);
        this.set(path, value);
        return value;
    }

    public double get(String path, double def) {
        double value = this.getDouble(path, def);
        this.set(path, value);
        return value;
    }

    public List<String> get(String path, List<String> def) {
        this.addDefault(path, def);
        List value = this.getStringList(path);
        this.set(path, value);
        return value;
    }

    public String get(String path, String def) {
        String value = this.getString(path, def);
        this.set(path, value);
        return value;
    }
}

