/*
 * Decompiled with CFR 0.152.
 */
package hu.montlikadani.tablist.commands.list;

import hu.montlikadani.tablist.Perm;
import hu.montlikadani.tablist.TabList;
import hu.montlikadani.tablist.commands.CommandProcessor;
import hu.montlikadani.tablist.commands.ICommand;
import hu.montlikadani.tablist.config.ConfigMessages;
import hu.montlikadani.tablist.tablist.TabToggleBase;
import hu.montlikadani.tablist.user.TabListUser;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

@CommandProcessor(name="toggle", params="[player/all]", desc="Toggles the tab visibility for player(s)", permission=Perm.TOGGLE)
public final class toggle
implements ICommand {
    @Override
    public void run(TabList plugin, CommandSender sender, Command cmd, String label, String[] args) {
        if (args.length == 1) {
            if (!(sender instanceof Player)) {
                plugin.getComplement().sendMessage(sender, ConfigMessages.get(ConfigMessages.MessageKeys.TOGGLE_CONSOLE_USAGE, "%command%", label));
                return;
            }
            Player player2 = (Player)sender;
            plugin.getUser(player2).ifPresent(user -> plugin.getComplement().sendMessage((CommandSender)player2, ConfigMessages.get(this.toggleTab((TabListUser)user, player2) ? ConfigMessages.MessageKeys.TOGGLE_ENABLED : ConfigMessages.MessageKeys.TOGGLE_DISABLED, new Object[0])));
            return;
        }
        String first = args[1];
        if (first.equalsIgnoreCase("all")) {
            if (sender instanceof Player && !sender.hasPermission(Perm.TOGGLEALL.value)) {
                plugin.getComplement().sendMessage(sender, ConfigMessages.get(ConfigMessages.MessageKeys.NO_PERMISSION, "%perm%", Perm.TOGGLEALL.value));
                return;
            }
            if (!(TabToggleBase.globallySwitched = !TabToggleBase.globallySwitched)) {
                for (TabListUser user2 : plugin.getUsers()) {
                    user2.getTabHandler().loadTabComponents();
                }
            } else {
                TabToggleBase.TEMPORAL_PLAYER_CACHE.clear();
            }
            return;
        }
        Player player3 = plugin.getServer().getPlayer(first);
        if (player3 == null) {
            plugin.getComplement().sendMessage(sender, ConfigMessages.get(ConfigMessages.MessageKeys.TOGGLE_PLAYER_NOT_FOUND, "%player%", first));
            return;
        }
        plugin.getUser(player3).ifPresent(user -> plugin.getComplement().sendMessage((CommandSender)player3, ConfigMessages.get(this.toggleTab((TabListUser)user, player3) ? ConfigMessages.MessageKeys.TOGGLE_ENABLED : ConfigMessages.MessageKeys.TOGGLE_DISABLED, new Object[0])));
    }

    private boolean toggleTab(TabListUser user, Player player2) {
        if (user.isTabVisible()) {
            user.setTabVisibility(false);
            TabToggleBase.TEMPORAL_PLAYER_CACHE.add(user.getUniqueId());
            user.getTabHandler().sendEmptyTab(player2);
            return false;
        }
        user.setTabVisibility(true);
        TabToggleBase.TEMPORAL_PLAYER_CACHE.remove(user.getUniqueId());
        user.getTabHandler().loadTabComponents();
        return true;
    }
}

