/*
 * Decompiled with CFR 0.152.
 */
package hu.montlikadani.tablist.commands.list;

import hu.montlikadani.tablist.Perm;
import hu.montlikadani.tablist.TabList;
import hu.montlikadani.tablist.commands.CommandProcessor;
import hu.montlikadani.tablist.commands.ICommand;
import hu.montlikadani.tablist.config.ConfigMessages;
import hu.montlikadani.tablist.config.constantsLoader.ConfigValues;
import hu.montlikadani.tablist.tablist.fakeplayers.FakePlayerHandler;
import hu.montlikadani.tablist.tablist.fakeplayers.IFakePlayer;
import hu.montlikadani.tablist.utils.PlayerSkinProperties;
import hu.montlikadani.tablist.utils.Util;
import hu.montlikadani.tablist.utils.datafetcher.URLDataFetcher;
import java.util.Collections;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;

@CommandProcessor(name="fakeplayers", desc="General commands for setting fake players", params="add/remove/list/rename/setdisplayname/setskin/setping", permission=Perm.FAKEPLAYERS, playerOnly=true)
public final class fakeplayers
implements ICommand {
    private void sendList(TabList tl, String label, CommandSender sender) {
        tl.getComplement().sendMessage(sender, Util.applyTextFormat("&6/" + label + " fakeplayers\n          &6add <name> [ping] -&7 Adds a new fake player with a name.\n          &6remove <name> -&7 Removes the given fake player.\n          &6list -&7 Lists all the available fake players.\n          &6rename <oldName> <newName> -&7 Renames the already existing fake player.\n          &6setdisplayname <name> \"displayName...\" -&7 Sets the display name of the given fake player.\n          &6setskin <name> <uuid/playerName> -&7 Sets a skin of the given fake player.\n          &6setskin <name> <playerName> --force -&7 Sets a skin for the given fake player forcing a web request from mojang (server can hang).\n          &6setping <name> <amount> -&7 Sets the ping of the given fake player."));
    }

    @Override
    public void run(TabList plugin, CommandSender sender, Command cmd, String label, String[] args) {
        Actions action;
        if (!ConfigValues.isFakePlayers()) {
            plugin.getComplement().sendMessage(sender, ConfigMessages.get(ConfigMessages.MessageKeys.FAKE_PLAYER_DISABLED, new Object[0]));
            return;
        }
        if (args.length == 1) {
            this.sendList(plugin, label, sender);
            return;
        }
        try {
            action = Actions.valueOf(args[1].toUpperCase(Locale.ENGLISH));
        }
        catch (IllegalArgumentException e) {
            action = Actions.ADD;
        }
        if (action != Actions.LIST && args.length < 3) {
            this.sendList(plugin, label, sender);
            return;
        }
        FakePlayerHandler handler = plugin.getFakePlayerHandler();
        switch (action.ordinal()) {
            case 0: {
                String name = args[2];
                FakePlayerHandler.EditingResult output = handler.createPlayer(name, name, "", -1);
                if (output == FakePlayerHandler.EditingResult.ALREADY_EXIST) {
                    plugin.getComplement().sendMessage(sender, ConfigMessages.get(ConfigMessages.MessageKeys.FAKE_PLAYER_ALREADY_ADDED, "%name%", name));
                    return;
                }
                if (output != FakePlayerHandler.EditingResult.OK) break;
                plugin.getComplement().sendMessage(sender, ConfigMessages.get(ConfigMessages.MessageKeys.FAKE_PLAYER_ADDED, "%name%", name));
                break;
            }
            case 5: {
                FakePlayerHandler.EditingResult output = handler.removePlayer(args[2]);
                if (output == FakePlayerHandler.EditingResult.NOT_EXIST) {
                    plugin.getComplement().sendMessage(sender, ConfigMessages.get(ConfigMessages.MessageKeys.FAKE_PLAYER_NOT_EXISTS, new Object[0]));
                    return;
                }
                if (output != FakePlayerHandler.EditingResult.OK) break;
                plugin.getComplement().sendMessage(sender, ConfigMessages.get(ConfigMessages.MessageKeys.FAKE_PLAYER_REMOVED, "%name%", args[2]));
                break;
            }
            case 1: {
                if (args.length < 4) {
                    this.sendList(plugin, label, sender);
                    return;
                }
                String oldName = args[2];
                String newName = args[3];
                FakePlayerHandler.EditingResult output = handler.renamePlayer(oldName, newName);
                if (output == FakePlayerHandler.EditingResult.NOT_EXIST) {
                    plugin.getComplement().sendMessage(sender, ConfigMessages.get(ConfigMessages.MessageKeys.FAKE_PLAYER_NOT_EXISTS, new Object[0]));
                    return;
                }
                if (output != FakePlayerHandler.EditingResult.OK) break;
                plugin.getComplement().sendMessage(sender, Util.applyTextFormat("&2Old name: &e" + oldName + "&2, new name: &e" + newName));
                break;
            }
            case 6: {
                Set<IFakePlayer> list = handler.fakePlayers;
                if (list.isEmpty()) {
                    plugin.getComplement().sendMessage(sender, ConfigMessages.get(ConfigMessages.MessageKeys.FAKE_PLAYER_NO_FAKE_PLAYER, new Object[0]));
                    return;
                }
                Collections.sort(list.stream().map(IFakePlayer::getName).collect(Collectors.toList()));
                StringBuilder res = new StringBuilder();
                for (IFakePlayer one : list) {
                    if (res.length() != 0) {
                        res.append("&r, ");
                    }
                    res.append(one.getName());
                }
                ConfigMessages.getList(ConfigMessages.MessageKeys.FAKE_PLAYER_LIST, "%amount%", list.size(), "%fake-players%", res.toString()).forEach(line -> plugin.getComplement().sendMessage(sender, Util.applyTextFormat(line)));
                break;
            }
            case 3: {
                if (args.length < 4) {
                    this.sendList(plugin, label, sender);
                    return;
                }
                String nameOrId = args[3];
                Optional<UUID> optional = Util.tryParseId(nameOrId);
                if (optional.isPresent()) {
                    PlayerSkinProperties skinProperties2 = PlayerSkinProperties.findPlayerProperty(null, optional.get());
                    if (skinProperties2 == null) {
                        skinProperties2 = new PlayerSkinProperties(null, optional.get());
                    }
                    if (handler.setSkin(args[2], skinProperties2) != FakePlayerHandler.EditingResult.NOT_EXIST) break;
                    plugin.getComplement().sendMessage(sender, ConfigMessages.get(ConfigMessages.MessageKeys.FAKE_PLAYER_NOT_EXISTS, new Object[0]));
                    break;
                }
                this.fetchPlayerProfile(nameOrId).whenComplete((skinProperties, t) -> {
                    if (skinProperties == null && args.length > 4 && "--force".equalsIgnoreCase(args[4])) {
                        for (OfflinePlayer pl : Bukkit.getOfflinePlayers()) {
                            if (!nameOrId.equals(pl.getName())) continue;
                            skinProperties = new PlayerSkinProperties(nameOrId, pl.getUniqueId());
                            break;
                        }
                        if (skinProperties == null) {
                            skinProperties = new PlayerSkinProperties(nameOrId, Bukkit.getOfflinePlayer((String)nameOrId).getUniqueId());
                        }
                    }
                    if (skinProperties == null && PlayerSkinProperties.cacheSize() > 100) {
                        plugin.getComplement().sendMessage(sender, "You've reached the maximum requests, you can not make any more requests.");
                        return;
                    }
                    if (skinProperties == null) {
                        plugin.getComplement().sendMessage(sender, "There is no player existing with this name or id.");
                        return;
                    }
                    if (handler.setSkin(args[2], (PlayerSkinProperties)skinProperties) == FakePlayerHandler.EditingResult.NOT_EXIST) {
                        plugin.getComplement().sendMessage(sender, ConfigMessages.get(ConfigMessages.MessageKeys.FAKE_PLAYER_NOT_EXISTS, new Object[0]));
                    }
                });
                break;
            }
            case 4: {
                int amount;
                if (args.length < 4) {
                    this.sendList(plugin, label, sender);
                    return;
                }
                try {
                    amount = Integer.parseInt(args[3]);
                }
                catch (NumberFormatException ex) {
                    amount = -1;
                }
                FakePlayerHandler.EditingResult output = handler.setPing(args[2], amount);
                if (output == FakePlayerHandler.EditingResult.NOT_EXIST) {
                    plugin.getComplement().sendMessage(sender, ConfigMessages.get(ConfigMessages.MessageKeys.FAKE_PLAYER_NOT_EXISTS, new Object[0]));
                    return;
                }
                if (output != FakePlayerHandler.EditingResult.PING_AMOUNT) break;
                plugin.getComplement().sendMessage(sender, ConfigMessages.get(ConfigMessages.MessageKeys.FAKE_PLAYER_PING_CAN_NOT_BE_LESS, "%amount%", amount));
                break;
            }
            case 2: {
                StringBuilder builder = new StringBuilder();
                for (int i = 3; i < args.length; ++i) {
                    builder.append(args[i] + (i + 1 < args.length ? " " : ""));
                }
                FakePlayerHandler.EditingResult output = handler.setDisplayName(args[2], builder.toString().replace("\"", ""));
                if (output != FakePlayerHandler.EditingResult.NOT_EXIST) break;
                plugin.getComplement().sendMessage(sender, ConfigMessages.get(ConfigMessages.MessageKeys.FAKE_PLAYER_NOT_EXISTS, new Object[0]));
                break;
            }
        }
    }

    private CompletableFuture<PlayerSkinProperties> fetchPlayerProfile(String playerName) {
        PlayerSkinProperties prop = PlayerSkinProperties.findPlayerProperty(playerName, null);
        if (prop != null) {
            CompletableFuture<PlayerSkinProperties> future = new CompletableFuture<PlayerSkinProperties>();
            future.complete(prop);
            return future;
        }
        try {
            OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayerIfCached((String)playerName);
            if (offlinePlayer != null) {
                CompletableFuture<PlayerSkinProperties> future = new CompletableFuture<PlayerSkinProperties>();
                future.complete(new PlayerSkinProperties(offlinePlayer.getName(), offlinePlayer.getUniqueId()));
                return future;
            }
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        return URLDataFetcher.fetchProfile(playerName);
    }

    private static enum Actions {
        ADD,
        RENAME,
        SETDISPLAYNAME,
        SETSKIN,
        SETPING,
        REMOVE,
        LIST;

    }
}

