/*
 * Decompiled with CFR 0.152.
 */
package hu.montlikadani.tablist.commands;

import hu.montlikadani.tablist.TabList;
import hu.montlikadani.tablist.commands.CommandProcessor;
import hu.montlikadani.tablist.commands.ICommand;
import hu.montlikadani.tablist.config.ConfigMessages;
import hu.montlikadani.tablist.config.constantsLoader.ConfigValues;
import hu.montlikadani.tablist.tablist.fakeplayers.IFakePlayer;
import hu.montlikadani.tablist.utils.Util;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public final class Commands
implements CommandExecutor,
TabCompleter {
    private final TabList plugin;
    private final ICommand[] commands = new ICommand[5];

    public Commands(TabList plugin) {
        this.plugin = plugin;
        int i = 0;
        for (String s : new String[]{"reload", "fakeplayers", "player", "group", "toggle"}) {
            try {
                Class<?> clazz;
                try {
                    clazz = TabList.class.getClassLoader().loadClass("hu.montlikadani.tablist.commands.list." + s);
                }
                catch (ClassNotFoundException ex) {
                    Util.printTrace(Level.SEVERE, (Plugin)plugin, ex.getMessage(), ex);
                    continue;
                }
                this.commands[i] = (ICommand)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                ++i;
            }
            catch (ReflectiveOperationException e) {
                Util.printTrace(Level.SEVERE, (Plugin)plugin, e.getMessage(), e);
            }
        }
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        CommandProcessor processor;
        if (args.length == 0) {
            this.plugin.getComplement().sendMessage(sender, Util.applyTextFormat("&9&lTab&4&lList"));
            this.plugin.getComplement().sendMessage(sender, Util.applyTextFormat("&5Version:&a " + this.plugin.getDescription().getVersion()));
            this.plugin.getComplement().sendMessage(sender, Util.applyTextFormat("&5Author, created by:&a montlikadani"));
            this.plugin.getComplement().sendMessage(sender, Util.applyTextFormat("&5List of commands:&7 /" + label + " help"));
            this.plugin.getComplement().sendMessage(sender, Util.applyTextFormat("&4Report bugs/features here:&e &nhttps://github.com/montlikadani/TabList/issues"));
            return true;
        }
        boolean isPlayer = sender instanceof Player;
        String first = args[0];
        for (ICommand command : this.commands) {
            processor = command.getClass().getAnnotation(CommandProcessor.class);
            if (processor == null || !processor.name().equalsIgnoreCase(first)) continue;
            if (isPlayer) {
                if (!sender.hasPermission(processor.permission().value)) {
                    this.plugin.getComplement().sendMessage(sender, ConfigMessages.get(ConfigMessages.MessageKeys.NO_PERMISSION, "%perm%", processor.permission().value));
                    return true;
                }
            } else if (processor.playerOnly()) {
                this.plugin.getComplement().sendMessage(sender, ConfigMessages.get(ConfigMessages.MessageKeys.NO_CONSOLE, "%command%", label + " " + first));
                return true;
            }
            command.run(this.plugin, sender, cmd, label, args);
            return true;
        }
        for (ICommand command : this.commands) {
            processor = command.getClass().getAnnotation(CommandProcessor.class);
            if (processor == null || isPlayer && !sender.hasPermission(processor.permission().value)) continue;
            String params = processor.params().isEmpty() ? "" : " " + processor.params();
            this.plugin.getComplement().sendMessage(sender, Util.applyTextFormat("&7/" + label + " " + processor.name() + params + " -&6 " + processor.desc()));
        }
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command cmd, String commandLabel, String[] args) {
        ArrayList<String> list = new ArrayList<String>(this.commands.length);
        switch (args.length) {
            case 1: {
                list.addAll(this.availableSubCommands(sender));
                break;
            }
            case 2: {
                if (ConfigValues.isFakePlayers() && args[0].equalsIgnoreCase("fakeplayers")) {
                    for (String c : new String[]{"add", "remove", "list", "setskin", "setping", "setdisplayname", "rename"}) {
                        list.add(c);
                    }
                    break;
                }
                if (!args[0].equalsIgnoreCase("toggle")) break;
                list.add("all");
                break;
            }
            case 3: {
                String first = args[0];
                if (ConfigValues.isFakePlayers() && first.equalsIgnoreCase("fakeplayers") && !args[1].equalsIgnoreCase("add") && !args[1].equalsIgnoreCase("list")) {
                    for (IFakePlayer fp : this.plugin.getFakePlayerHandler().fakePlayers) {
                        list.add(fp.getName());
                    }
                } else {
                    if (!first.equalsIgnoreCase("group") && !first.equalsIgnoreCase("player")) break;
                    for (String ca : new String[]{"prefix", "suffix", "priority", "tabname", "remove"}) {
                        list.add(ca);
                    }
                }
                break;
            }
        }
        return list.isEmpty() ? null : list;
    }

    private Set<String> availableSubCommands(CommandSender sender) {
        HashSet<String> set = new HashSet<String>(this.commands.length);
        boolean isPlayer = sender instanceof Player;
        for (ICommand cmd : this.commands) {
            CommandProcessor proc = cmd.getClass().getAnnotation(CommandProcessor.class);
            if (proc == null || isPlayer && !sender.hasPermission(proc.permission().value)) continue;
            set.add(proc.name());
        }
        return set;
    }
}

